/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.utils;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;

public class LogManager {
    private static LogManager instance;
    private final List<LogEntry> logEntries = new CopyOnWriteArrayList<LogEntry>();
    private final List<LogListener> listeners = new CopyOnWriteArrayList<LogListener>();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    private LogManager() {
        this.log(LogLevel.INFO, "\u65e5\u5fd7\u7ba1\u7406\u5668\u5df2\u521d\u59cb\u5316", "LogManager");
    }

    public static synchronized LogManager getInstance() {
        if (instance == null) {
            instance = new LogManager();
        }
        return instance;
    }

    public void log(LogLevel level, String message, String source) {
        LogEntry entry = new LogEntry(level, message, source);
        this.logEntries.add(entry);
        System.out.println(entry.toString());
        SwingUtilities.invokeLater(() -> {
            for (LogListener listener : this.listeners) {
                try {
                    listener.onLogAdded(entry);
                }
                catch (Exception e) {
                    System.err.println("\u65e5\u5fd7\u76d1\u542c\u5668\u51fa\u9519: " + e.getMessage());
                }
            }
        });
        if (this.logEntries.size() > 10000) {
            this.logEntries.remove(0);
        }
    }

    public void info(String message, String source) {
        this.log(LogLevel.INFO, message, source);
    }

    public void debug(String message, String source) {
        this.log(LogLevel.DEBUG, message, source);
    }

    public void warn(String message, String source) {
        this.log(LogLevel.WARN, message, source);
    }

    public void error(String message, String source) {
        this.log(LogLevel.ERROR, message, source);
    }

    public void error(String message, String source, Throwable throwable) {
        StringBuilder sb = new StringBuilder(message);
        if (throwable != null) {
            sb.append(" - ").append(throwable.getClass().getSimpleName()).append(": ").append(throwable.getMessage());
        }
        this.log(LogLevel.ERROR, sb.toString(), source);
    }

    public List<LogEntry> getAllLogs() {
        return new ArrayList<LogEntry>(this.logEntries);
    }

    public List<LogEntry> getLogsByLevel(LogLevel level) {
        ArrayList<LogEntry> filtered = new ArrayList<LogEntry>();
        for (LogEntry entry : this.logEntries) {
            if (entry.getLevel() != level) continue;
            filtered.add(entry);
        }
        return filtered;
    }

    public void clearLogs() {
        this.logEntries.clear();
        this.log(LogLevel.INFO, "\u65e5\u5fd7\u5df2\u6e05\u7a7a", "LogManager");
    }

    public void exportToFile(String filePath) throws IOException {
        try (PrintWriter writer = new PrintWriter(new FileWriter(filePath));){
            writer.println("# Minecraft Map Selector \u65e5\u5fd7\u6587\u4ef6");
            writer.println("# \u5bfc\u51fa\u65f6\u95f4: " + this.dateFormat.format(new Date()));
            writer.println("# \u603b\u6761\u76ee\u6570: " + this.logEntries.size());
            writer.println();
            for (LogEntry entry : this.logEntries) {
                writer.println(entry.toString());
            }
        }
        this.log(LogLevel.INFO, "\u65e5\u5fd7\u5df2\u5bfc\u51fa\u5230: " + filePath, "LogManager");
    }

    public void addLogListener(LogListener listener) {
        this.listeners.add(listener);
    }

    public void removeLogListener(LogListener listener) {
        this.listeners.remove(listener);
    }

    public String getLogStats() {
        int total = this.logEntries.size();
        int debug = this.getLogsByLevel(LogLevel.DEBUG).size();
        int info = this.getLogsByLevel(LogLevel.INFO).size();
        int warn = this.getLogsByLevel(LogLevel.WARN).size();
        int error = this.getLogsByLevel(LogLevel.ERROR).size();
        return String.format("\u603b\u8ba1: %d | DEBUG: %d | INFO: %d | WARN: %d | ERROR: %d", total, debug, info, warn, error);
    }

    public static enum LogLevel {
        DEBUG("DEBUG"),
        INFO("INFO"),
        WARN("WARN"),
        ERROR("ERROR");

        private final String name;

        private LogLevel(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class LogEntry {
        private final Date timestamp = new Date();
        private final LogLevel level;
        private final String message;
        private final String source;

        public LogEntry(LogLevel level, String message, String source) {
            this.level = level;
            this.message = message;
            this.source = source;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public LogLevel getLevel() {
            return this.level;
        }

        public String getMessage() {
            return this.message;
        }

        public String getSource() {
            return this.source;
        }

        public String toString() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            return String.format("[%s] [%s] [%s] %s", new Object[]{sdf.format(this.timestamp), this.level, this.source, this.message});
        }
    }

    public static interface LogListener {
        public void onLogAdded(LogEntry var1);
    }
}

