/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.utils;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    private final int maxSize;
    private volatile long hits = 0L;
    private volatile long misses = 0L;

    public LRUCache(int maxSize) {
        super(16, 0.75f, true);
        this.maxSize = maxSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxSize;
    }

    @Override
    public V get(Object key) {
        Object value = super.get(key);
        if (value != null) {
            ++this.hits;
        } else {
            ++this.misses;
        }
        return value;
    }

    public double getHitRate() {
        long total = this.hits + this.misses;
        return total == 0L ? 0.0 : (double)this.hits / (double)total;
    }

    public String getStats() {
        long total = this.hits + this.misses;
        return String.format("Cache Stats: Size=%d/%d, Hits=%d, Misses=%d, Hit Rate=%.2f%%", this.size(), this.maxSize, this.hits, this.misses, this.getHitRate() * 100.0);
    }

    public void resetStats() {
        this.hits = 0L;
        this.misses = 0L;
    }

    public synchronized V putSafe(K key, V value) {
        return super.put(key, value);
    }

    public synchronized V getSafe(Object key) {
        return this.get(key);
    }
}

