/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;

public class FileUtils {
    public static boolean fileExists(String filePath) {
        return Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0]);
    }

    public static boolean createDirectories(String dirPath) {
        try {
            Files.createDirectories(Paths.get(dirPath, new String[0]), new FileAttribute[0]);
            return true;
        }
        catch (IOException e) {
            System.err.println("\u521b\u5efa\u76ee\u5f55\u5931\u8d25: " + e.getMessage());
            return false;
        }
    }

    public static long getFileSize(String filePath) {
        try {
            return Files.size(Paths.get(filePath, new String[0]));
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public static String getFileExtension(String fileName) {
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex > 0 && lastDotIndex < fileName.length() - 1) {
            return fileName.substring(lastDotIndex + 1).toLowerCase();
        }
        return "";
    }

    public static String getFileNameWithoutExtension(String fileName) {
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex > 0) {
            return fileName.substring(0, lastDotIndex);
        }
        return fileName;
    }

    public static byte[] readAllBytes(String filePath) throws IOException {
        try (FileInputStream fis = new FileInputStream(filePath);){
            byte[] byArray = FileUtils.readAllBytes(fis);
            return byArray;
        }
    }

    private static byte[] readAllBytes(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    public static void writeBytes(String filePath, byte[] data) throws IOException {
        Files.write(Paths.get(filePath, new String[0]), data, new OpenOption[0]);
    }

    public static void saveImageAsPng(BufferedImage image, String filePath) throws IOException {
        File outputFile = new File(filePath);
        File parentDir = outputFile.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            parentDir.mkdirs();
        }
        ImageIO.write((RenderedImage)image, "PNG", outputFile);
    }

    public static void saveImageAsJpeg(BufferedImage image, String filePath) throws IOException {
        File outputFile = new File(filePath);
        File parentDir = outputFile.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            parentDir.mkdirs();
        }
        BufferedImage rgbImage = image;
        if (image.getType() == 2) {
            rgbImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
            rgbImage.getGraphics().drawImage(image, 0, 0, null);
        }
        ImageIO.write((RenderedImage)rgbImage, "JPEG", outputFile);
    }

    public static List<String> getFilesWithExtension(String dirPath, String extension) throws IOException {
        Path dir = Paths.get(dirPath, new String[0]);
        if (!Files.exists(dir, new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException("\u76ee\u5f55\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u6709\u6548\u76ee\u5f55: " + dirPath);
        }
        return Files.list(dir).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).filter(name -> name.toLowerCase().endsWith("." + extension.toLowerCase())).collect(Collectors.toList());
    }

    public static List<String> getMcaFiles(String regionDirPath) throws IOException {
        return FileUtils.getFilesWithExtension(regionDirPath, "mca");
    }

    public static int[] parseRegionCoordinates(String mcaFileName) {
        if (!mcaFileName.startsWith("r.") || !mcaFileName.endsWith(".mca")) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684MCA\u6587\u4ef6\u540d: " + mcaFileName);
        }
        String coordPart = mcaFileName.substring(2, mcaFileName.length() - 4);
        String[] parts = coordPart.split("\\.");
        if (parts.length != 2) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684MCA\u6587\u4ef6\u540d\u683c\u5f0f: " + mcaFileName);
        }
        try {
            int x = Integer.parseInt(parts[0]);
            int z = Integer.parseInt(parts[1]);
            return new int[]{x, z};
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790MCA\u6587\u4ef6\u5750\u6807: " + mcaFileName, e);
        }
    }

    public static String generateMcaFileName(int regionX, int regionZ) {
        return String.format("r.%d.%d.mca", regionX, regionZ);
    }

    public static String getTempFilePath(String fileName) {
        String tempDir = System.getProperty("java.io.tmpdir");
        return Paths.get(tempDir, "minecraft-map-selector", fileName).toString();
    }

    public static void cleanupTempFiles() {
        String tempDir = FileUtils.getTempFilePath("");
        try {
            Path tempPath = Paths.get(tempDir, new String[0]);
            if (Files.exists(tempPath, new LinkOption[0])) {
                Files.walk(tempPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException e) {
                        System.err.println("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25: " + file + " - " + e.getMessage());
                    }
                });
            }
        }
        catch (IOException e) {
            System.err.println("\u6e05\u7406\u4e34\u65f6\u6587\u4ef6\u65f6\u51fa\u9519: " + e.getMessage());
        }
    }

    public static CacheCleanupResult cleanupPngCache(String programDir) {
        CacheCleanupResult result = new CacheCleanupResult();
        try {
            Path programPath = Paths.get(programDir, new String[0]);
            if (!Files.exists(programPath, new LinkOption[0])) {
                result.errorMessage = "\u7a0b\u5e8f\u76ee\u5f55\u4e0d\u5b58\u5728: " + programDir;
                return result;
            }
            Files.walk(programPath, 1, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> {
                String fileName = file.getFileName().toString().toLowerCase();
                return fileName.endsWith(".png") && (fileName.contains("_map_") || fileName.contains("_thumbnail") || fileName.startsWith("region_") || fileName.startsWith("r."));
            }).forEach(file -> {
                try {
                    long fileSize = Files.size(file);
                    Files.delete(file);
                    ++result.deletedFiles;
                    result.freedSpace += fileSize;
                    System.out.println("\u5220\u9664PNG\u7f13\u5b58\u6587\u4ef6: " + file.getFileName());
                }
                catch (IOException e) {
                    ++result.failedFiles;
                    System.err.println("\u5220\u9664PNG\u6587\u4ef6\u5931\u8d25: " + file + " - " + e.getMessage());
                }
            });
        }
        catch (IOException e) {
            result.errorMessage = "\u6e05\u7406PNG\u7f13\u5b58\u65f6\u51fa\u9519: " + e.getMessage();
        }
        return result;
    }

    public static String formatFileSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1f KB", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.1f MB", (double)bytes / 1048576.0);
        }
        return String.format("%.1f GB", (double)bytes / 1.073741824E9);
    }

    public static boolean isValidMinecraftSave(String savePath) {
        Path saveDir = Paths.get(savePath, new String[0]);
        return Files.exists(saveDir.resolve("level.dat"), new LinkOption[0]) && Files.exists(saveDir.resolve("region"), new LinkOption[0]) && Files.isDirectory(saveDir.resolve("region"), new LinkOption[0]);
    }

    public static String getDefaultMinecraftSavesPath() {
        String os = System.getProperty("os.name").toLowerCase();
        String userHome = System.getProperty("user.home");
        if (os.contains("win")) {
            String appData = System.getenv("APPDATA");
            if (appData != null) {
                return Paths.get(appData, ".minecraft", "saves").toString();
            }
        } else {
            if (os.contains("mac")) {
                return Paths.get(userHome, "Library", "Application Support", "minecraft", "saves").toString();
            }
            return Paths.get(userHome, ".minecraft", "saves").toString();
        }
        return null;
    }

    public static class CacheCleanupResult {
        public int deletedFiles = 0;
        public int failedFiles = 0;
        public long freedSpace = 0L;
        public String errorMessage = null;

        public boolean isSuccess() {
            return this.errorMessage == null;
        }

        public String getSummary() {
            if (!this.isSuccess()) {
                return "\u6e05\u7406\u5931\u8d25: " + this.errorMessage;
            }
            if (this.deletedFiles == 0) {
                return "\u6ca1\u6709\u627e\u5230\u9700\u8981\u6e05\u7406\u7684PNG\u7f13\u5b58\u6587\u4ef6";
            }
            String summary = String.format("\u6210\u529f\u5220\u9664 %d \u4e2aPNG\u7f13\u5b58\u6587\u4ef6\uff0c\u91ca\u653e\u7a7a\u95f4 %s", this.deletedFiles, FileUtils.formatFileSize(this.freedSpace));
            if (this.failedFiles > 0) {
                summary = summary + String.format("\uff0c%d \u4e2a\u6587\u4ef6\u5220\u9664\u5931\u8d25", this.failedFiles);
            }
            return summary;
        }
    }
}

