/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.test;

import com.minecraft.selector.core.MapRenderer;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Set;

public class PerformanceTest {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("\u7528\u6cd5: java PerformanceTest <mca\u6587\u4ef6\u8def\u5f84>");
            System.out.println("\u793a\u4f8b: java PerformanceTest /path/to/region/r.0.0.mca");
            return;
        }
        String mcaFilePath = args[0];
        File mcaFile = new File(mcaFilePath);
        if (!mcaFile.exists()) {
            System.err.println("\u6587\u4ef6\u4e0d\u5b58\u5728: " + mcaFilePath);
            return;
        }
        System.out.println("=== Minecraft\u5730\u56fe\u6e32\u67d3\u6027\u80fd\u6d4b\u8bd5 ===");
        System.out.println("\u6d4b\u8bd5\u6587\u4ef6: " + mcaFilePath);
        System.out.println("\u6587\u4ef6\u5927\u5c0f: " + mcaFile.length() / 1024L / 1024L + " MB");
        PerformanceTest.runPerformanceTest(mcaFilePath);
    }

    private static void runPerformanceTest(String mcaFilePath) {
        int[] sampleIntervals;
        MapRenderer.ProgressCallback callback = new MapRenderer.ProgressCallback(){
            private long lastTime = System.currentTimeMillis();

            @Override
            public void onProgress(int processed, int total, double speed, Set<String> foundBlocks) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastTime > 1000L) {
                    System.out.printf("\u8fdb\u5ea6: %d/%d (%.1f%%) - \u901f\u5ea6: %.1f\u533a\u5757/\u79d2 - \u53d1\u73b0\u65b9\u5757: %d\u79cd\n", processed, total, (double)processed * 100.0 / (double)total, speed, foundBlocks.size());
                    this.lastTime = currentTime;
                }
            }

            @Override
            public void onProgressiveRender(BufferedImage partialImage, int completedChunks, int totalChunks) {
                System.out.printf("\u6e10\u8fdb\u5f0f\u6e32\u67d3: %d/%d\u533a\u5757\u5b8c\u6210 (%.1f%%)\n", completedChunks, totalChunks, (double)completedChunks * 100.0 / (double)totalChunks);
            }
        };
        for (int sampleInterval : sampleIntervals = new int[]{1, 2, 4}) {
            System.out.println("\n--- \u6d4b\u8bd5\u91c7\u6837\u95f4\u9694: " + sampleInterval + " ---");
            PerformanceTest.testRenderingPerformance(mcaFilePath, sampleInterval, callback);
        }
        System.out.println("\n--- \u6d4b\u8bd5\u6e10\u8fdb\u5f0f\u6e32\u67d3 ---");
        PerformanceTest.testProgressiveRendering(mcaFilePath, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testRenderingPerformance(String mcaFilePath, int sampleInterval, MapRenderer.ProgressCallback callback) {
        MapRenderer renderer = new MapRenderer(0, callback);
        try {
            long startTime = System.currentTimeMillis();
            MapRenderer.BlockInfo[][] topBlocks = renderer.getTopBlocks(mcaFilePath, 32, sampleInterval);
            long renderTime = System.currentTimeMillis() - startTime;
            if (topBlocks != null) {
                long imageStartTime = System.currentTimeMillis();
                BufferedImage image = renderer.renderToPng(topBlocks, sampleInterval);
                long imageTime = System.currentTimeMillis() - imageStartTime;
                long totalTime = System.currentTimeMillis() - startTime;
                System.out.println("\u6e32\u67d3\u7ed3\u679c:");
                System.out.println("  \u6570\u636e\u63d0\u53d6\u65f6\u95f4: " + renderTime + "ms");
                System.out.println("  \u56fe\u50cf\u751f\u6210\u65f6\u95f4: " + imageTime + "ms");
                System.out.println("  \u603b\u65f6\u95f4: " + totalTime + "ms");
                System.out.println("  \u56fe\u50cf\u5c3a\u5bf8: " + image.getWidth() + "x" + image.getHeight());
                System.out.println(renderer.getPerformanceReport());
            } else {
                System.out.println("\u6e32\u67d3\u5931\u8d25");
            }
        }
        catch (Exception e) {
            System.err.println("\u6e32\u67d3\u51fa\u9519: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            renderer.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testProgressiveRendering(String mcaFilePath, MapRenderer.ProgressCallback callback) {
        MapRenderer renderer = new MapRenderer(0, callback);
        try {
            long startTime = System.currentTimeMillis();
            BufferedImage image = renderer.renderProgressively(mcaFilePath, 32, 1);
            long totalTime = System.currentTimeMillis() - startTime;
            if (image != null) {
                System.out.println("\u6e10\u8fdb\u5f0f\u6e32\u67d3\u7ed3\u679c:");
                System.out.println("  \u603b\u65f6\u95f4: " + totalTime + "ms");
                System.out.println("  \u56fe\u50cf\u5c3a\u5bf8: " + image.getWidth() + "x" + image.getHeight());
                System.out.println(renderer.getPerformanceReport());
            } else {
                System.out.println("\u6e10\u8fdb\u5f0f\u6e32\u67d3\u5931\u8d25");
            }
        }
        catch (Exception e) {
            System.err.println("\u6e10\u8fdb\u5f0f\u6e32\u67d3\u51fa\u9519: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            renderer.shutdown();
        }
    }

    private static void printMemoryUsage(String phase) {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        long maxMemory = runtime.maxMemory();
        System.out.printf("[%s] \u5185\u5b58\u4f7f\u7528: %d MB / %d MB (%.1f%%), \u6700\u5927: %d MB\n", phase, usedMemory / 1024L / 1024L, totalMemory / 1024L / 1024L, (double)usedMemory / (double)totalMemory * 100.0, maxMemory / 1024L / 1024L);
    }

    private static void runGC() {
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

