/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.region;

import com.minecraft.selector.nbt.NBTReader;
import com.minecraft.selector.region.Chunk;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.InflaterInputStream;

public class Region {
    private byte[] data;

    public Region(byte[] data) {
        this.data = data;
    }

    public static Region fromFile(String filePath) throws IOException {
        try (FileInputStream fis = new FileInputStream(filePath);){
            byte[] data = Region.readAllBytes(fis);
            Region region = new Region(data);
            return region;
        }
    }

    private static byte[] readAllBytes(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    public static int headerOffset(int chunkX, int chunkZ) {
        return 4 * (chunkX % 32 + chunkZ % 32 * 32);
    }

    public int[] getChunkLocation(int chunkX, int chunkZ) {
        int byteOffset = Region.headerOffset(chunkX, chunkZ);
        int offset = (this.data[byteOffset] & 0xFF) << 16 | (this.data[byteOffset + 1] & 0xFF) << 8 | this.data[byteOffset + 2] & 0xFF;
        int sectors = this.data[byteOffset + 3] & 0xFF;
        return new int[]{offset, sectors};
    }

    public boolean chunkExists(int chunkX, int chunkZ) {
        int[] location = this.getChunkLocation(chunkX, chunkZ);
        return location[0] != 0 && location[1] != 0;
    }

    public NBTReader.NBTCompound getChunkData(int chunkX, int chunkZ) throws IOException {
        int[] location = this.getChunkLocation(chunkX, chunkZ);
        if (location[0] == 0 && location[1] == 0) {
            return null;
        }
        int offset = location[0] * 4096;
        int length = ByteBuffer.wrap(this.data, offset, 4).order(ByteOrder.BIG_ENDIAN).getInt();
        int compression = this.data[offset + 4] & 0xFF;
        if (compression == 1) {
            throw new IOException("GZip compression is not supported");
        }
        if (compression != 2) {
            throw new IOException("Unknown compression type: " + compression);
        }
        byte[] compressedData = new byte[length - 1];
        System.arraycopy(this.data, offset + 5, compressedData, 0, length - 1);
        try (ByteArrayInputStream bis = new ByteArrayInputStream(compressedData);){
            NBTReader.NBTCompound nBTCompound;
            try (InflaterInputStream iis = new InflaterInputStream(bis);){
                nBTCompound = NBTReader.readFromBytes(Region.readAllBytes(iis));
            }
            return nBTCompound;
        }
    }

    public Chunk getChunk(int chunkX, int chunkZ) throws IOException {
        NBTReader.NBTCompound chunkData = this.getChunkData(chunkX, chunkZ);
        if (chunkData == null) {
            return null;
        }
        return new Chunk(chunkData);
    }

    public List<int[]> getChunkCoordinates() {
        ArrayList<int[]> coordinates = new ArrayList<int[]>();
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                if (!this.chunkExists(x, z)) continue;
                coordinates.add(new int[]{x, z});
            }
        }
        return coordinates;
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }

    public int getSize() {
        return this.data.length;
    }
}

