/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.region;

import com.minecraft.selector.nbt.NBTReader;
import com.minecraft.selector.region.Block;
import com.minecraft.selector.region.Region;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Chunk {
    private NBTReader.NBTCompound nbtData;
    private int x;
    private int z;
    private List<Section> sections;

    public Chunk(NBTReader.NBTCompound nbtData) {
        this.nbtData = nbtData;
        this.x = nbtData.getInt("xPos");
        this.z = nbtData.getInt("zPos");
        this.sections = new ArrayList<Section>();
        if (nbtData.contains("sections")) {
            NBTReader.NBTList sectionsList = nbtData.getList("sections");
            for (int i = 0; i < sectionsList.size(); ++i) {
                NBTReader.NBTCompound sectionData = (NBTReader.NBTCompound)sectionsList.get(i);
                this.sections.add(new Section(sectionData));
            }
        }
    }

    public static Chunk fromRegion(Region region, int chunkX, int chunkZ) throws Exception {
        NBTReader.NBTCompound chunkData = region.getChunkData(chunkX, chunkZ);
        if (chunkData == null) {
            return null;
        }
        return new Chunk(chunkData);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public Section getSection(int y) {
        for (Section section : this.sections) {
            if (section.getY() != y) continue;
            return section;
        }
        return null;
    }

    public List<Section> getSections() {
        return new ArrayList<Section>(this.sections);
    }

    public boolean hasSections() {
        return !this.sections.isEmpty();
    }

    public Block getBlock(int x, int y, int z) {
        int sectionY = y >> 4;
        Section section = this.getSection(sectionY);
        if (section == null) {
            return new Block("air");
        }
        return section.getBlock(x, y & 0xF, z);
    }

    public NBTReader.NBTCompound getNbtData() {
        return this.nbtData;
    }

    public static class Section {
        private int y;
        private List<Block> palette;
        private long[] blockStates;
        private int bitsPerBlock;

        public Section(NBTReader.NBTCompound sectionData) {
            this.y = ((NBTReader.NBTByte)sectionData.get("Y")).getValue().byteValue();
            if (sectionData.contains("block_states")) {
                NBTReader.NBTCompound blockStates = sectionData.getCompound("block_states");
                this.palette = new ArrayList<Block>();
                if (blockStates.contains("palette")) {
                    NBTReader.NBTList paletteList = blockStates.getList("palette");
                    for (int i = 0; i < paletteList.size(); ++i) {
                        NBTReader.NBTCompound paletteEntry = (NBTReader.NBTCompound)paletteList.get(i);
                        this.palette.add(Block.fromPalette(paletteEntry));
                    }
                }
                if (blockStates.contains("data")) {
                    NBTReader.NBTLongArray dataArray = (NBTReader.NBTLongArray)blockStates.get("data");
                    this.blockStates = dataArray.getValue();
                    this.bitsPerBlock = this.palette.size() <= 1 ? 0 : Math.max(4, 32 - Integer.numberOfLeadingZeros(this.palette.size() - 1));
                } else {
                    this.blockStates = new long[0];
                    this.bitsPerBlock = 0;
                }
            } else {
                this.palette = Arrays.asList(new Block("air"));
                this.blockStates = new long[0];
                this.bitsPerBlock = 0;
            }
        }

        public int getY() {
            return this.y;
        }

        public List<Block> getPalette() {
            return new ArrayList<Block>(this.palette);
        }

        public Block getBlock(int x, int y, int z) {
            if (this.palette.isEmpty() || this.bitsPerBlock == 0) {
                return this.palette.isEmpty() ? new Block("air") : this.palette.get(0);
            }
            int blockIndex = y * 256 + z * 16 + x;
            int paletteIndex = this.extractBlockState(blockIndex);
            if (paletteIndex >= 0 && paletteIndex < this.palette.size()) {
                return this.palette.get(paletteIndex);
            }
            return new Block("air");
        }

        private int extractBlockState(int blockIndex) {
            if (this.bitsPerBlock == 0 || this.blockStates.length == 0) {
                return 0;
            }
            int blocksPerLong = 64 / this.bitsPerBlock;
            int longIndex = blockIndex / blocksPerLong;
            if (longIndex >= this.blockStates.length) {
                return 0;
            }
            long data = this.blockStates[longIndex];
            int offsetInLong = blockIndex % blocksPerLong * this.bitsPerBlock;
            long shiftedData = data >>> offsetInLong;
            long mask = (1L << this.bitsPerBlock) - 1L;
            return (int)(shiftedData & mask);
        }
    }
}

