/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.region;

import com.minecraft.selector.nbt.NBTReader;
import java.util.HashMap;
import java.util.Map;

public class Block {
    private String id;
    private Map<String, String> properties;

    public Block(String id) {
        this.id = id;
        this.properties = new HashMap<String, String>();
    }

    public Block(String id, Map<String, String> properties) {
        this.id = id;
        this.properties = properties != null ? new HashMap<String, String>(properties) : new HashMap();
    }

    public static Block fromPalette(NBTReader.NBTCompound paletteEntry) {
        String name = paletteEntry.getString("Name");
        if (name.startsWith("minecraft:")) {
            name = name.substring("minecraft:".length());
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (paletteEntry.contains("Properties")) {
            NBTReader.NBTCompound props = paletteEntry.getCompound("Properties");
            for (String key : props.keySet()) {
                NBTReader.NBTTag tag = props.get(key);
                if (!(tag instanceof NBTReader.NBTString)) continue;
                properties.put(key, ((NBTReader.NBTString)tag).getValue());
            }
        }
        return new Block(name, properties);
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    public boolean isAir() {
        return "air".equals(this.id) || "cave_air".equals(this.id) || "void_air".equals(this.id);
    }

    public String toString() {
        if (this.properties.isEmpty()) {
            return this.id;
        }
        StringBuilder sb = new StringBuilder(this.id);
        sb.append("[");
        boolean first = true;
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (!first) {
                sb.append(",");
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue());
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Block block = (Block)obj;
        return this.id.equals(block.id) && this.properties.equals(block.properties);
    }

    public int hashCode() {
        return this.id.hashCode() * 31 + this.properties.hashCode();
    }
}

