/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.nbt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class NBTReader {
    private DataInputStream input;

    public NBTReader(InputStream input) {
        this.input = new DataInputStream(input);
    }

    public static NBTCompound readFromFile(String filePath) throws IOException {
        byte[] fileData;
        try (FileInputStream fis = new FileInputStream(filePath);){
            fileData = NBTReader.readAllBytes(fis);
        }
        return NBTReader.readFromBytes(fileData);
    }

    private static byte[] readAllBytes(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NBTCompound readFromBytes(byte[] data) throws IOException {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(data);){
            if (data.length >= 2) {
                if (data[0] == 31 && data[1] == -117) {
                    try (GZIPInputStream gis = new GZIPInputStream(bis);){
                        NBTReader reader = new NBTReader(gis);
                        NBTCompound nBTCompound = reader.readCompound();
                        return nBTCompound;
                    }
                }
                if (data[0] == 120) {
                    try (InflaterInputStream iis = new InflaterInputStream(bis);){
                        NBTReader reader = new NBTReader(iis);
                        NBTCompound nBTCompound = reader.readCompound();
                        return nBTCompound;
                    }
                }
            }
            NBTReader reader = new NBTReader(bis);
            NBTCompound nBTCompound = reader.readCompound();
            return nBTCompound;
        }
    }

    public NBTCompound readCompound() throws IOException {
        TagType type = TagType.fromId(this.input.readByte());
        if (type != TagType.TAG_Compound) {
            throw new IOException("Expected compound tag, got " + (Object)((Object)type));
        }
        String name = this.readString();
        return this.readCompoundPayload(name);
    }

    private NBTCompound readCompoundPayload(String name) throws IOException {
        TagType type;
        NBTCompound compound = new NBTCompound(name);
        while ((type = TagType.fromId(this.input.readByte())) != TagType.TAG_End) {
            String tagName = this.readString();
            NBTTag tag = this.readTagPayload(type, tagName);
            compound.put(tagName, tag);
        }
        return compound;
    }

    private NBTTag readTagPayload(TagType type, String name) throws IOException {
        switch (type.ordinal()) {
            case 1: {
                return new NBTByte(name, this.input.readByte());
            }
            case 2: {
                return new NBTShort(name, this.input.readShort());
            }
            case 3: {
                return new NBTInt(name, this.input.readInt());
            }
            case 4: {
                return new NBTLong(name, this.input.readLong());
            }
            case 5: {
                return new NBTFloat(name, this.input.readFloat());
            }
            case 6: {
                return new NBTDouble(name, this.input.readDouble());
            }
            case 7: {
                int byteLength = this.input.readInt();
                byte[] bytes = new byte[byteLength];
                this.input.readFully(bytes);
                return new NBTByteArray(name, bytes);
            }
            case 8: {
                return new NBTString(name, this.readString());
            }
            case 9: {
                return this.readListPayload(name);
            }
            case 10: {
                return this.readCompoundPayload(name);
            }
            case 11: {
                int intLength = this.input.readInt();
                int[] ints = new int[intLength];
                for (int i = 0; i < intLength; ++i) {
                    ints[i] = this.input.readInt();
                }
                return new NBTIntArray(name, ints);
            }
            case 12: {
                int longLength = this.input.readInt();
                long[] longs = new long[longLength];
                for (int i = 0; i < longLength; ++i) {
                    longs[i] = this.input.readLong();
                }
                return new NBTLongArray(name, longs);
            }
        }
        throw new IOException("Unknown tag type: " + (Object)((Object)type));
    }

    private NBTList readListPayload(String name) throws IOException {
        TagType listType = TagType.fromId(this.input.readByte());
        int length = this.input.readInt();
        NBTList list = new NBTList(name, listType);
        for (int i = 0; i < length; ++i) {
            NBTTag tag = this.readTagPayload(listType, "");
            list.add(tag);
        }
        return list;
    }

    private String readString() throws IOException {
        int length = this.input.readUnsignedShort();
        byte[] bytes = new byte[length];
        this.input.readFully(bytes);
        return new String(bytes, "UTF-8");
    }

    public static class NBTCompound
    extends NBTTag {
        private Map<String, NBTTag> tags = new HashMap<String, NBTTag>();

        public NBTCompound(String name) {
            super(name);
        }

        public void put(String key, NBTTag tag) {
            this.tags.put(key, tag);
        }

        public NBTTag get(String key) {
            return this.tags.get(key);
        }

        public boolean contains(String key) {
            return this.tags.containsKey(key);
        }

        public Set<String> keySet() {
            return this.tags.keySet();
        }

        @Override
        public Object getValue() {
            return this.tags;
        }

        @Override
        public TagType getType() {
            return TagType.TAG_Compound;
        }

        public int getInt(String key) {
            NBTTag tag = this.get(key);
            if (tag instanceof NBTInt) {
                return ((NBTInt)tag).getValue();
            }
            throw new IllegalArgumentException("Tag " + key + " is not an integer");
        }

        public String getString(String key) {
            NBTTag tag = this.get(key);
            if (tag instanceof NBTString) {
                return ((NBTString)tag).getValue();
            }
            throw new IllegalArgumentException("Tag " + key + " is not a string");
        }

        public NBTCompound getCompound(String key) {
            NBTTag tag = this.get(key);
            if (tag instanceof NBTCompound) {
                return (NBTCompound)tag;
            }
            throw new IllegalArgumentException("Tag " + key + " is not a compound");
        }

        public NBTList getList(String key) {
            NBTTag tag = this.get(key);
            if (tag instanceof NBTList) {
                return (NBTList)tag;
            }
            throw new IllegalArgumentException("Tag " + key + " is not a list");
        }
    }

    public static enum TagType {
        TAG_End(0),
        TAG_Byte(1),
        TAG_Short(2),
        TAG_Int(3),
        TAG_Long(4),
        TAG_Float(5),
        TAG_Double(6),
        TAG_Byte_Array(7),
        TAG_String(8),
        TAG_List(9),
        TAG_Compound(10),
        TAG_Int_Array(11),
        TAG_Long_Array(12);

        private final int id;

        private TagType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static TagType fromId(int id) {
            for (TagType type : TagType.values()) {
                if (type.id != id) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown NBT tag type: " + id);
        }
    }

    public static abstract class NBTTag {
        protected String name;

        public NBTTag(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public abstract Object getValue();

        public abstract TagType getType();
    }

    public static class NBTByte
    extends NBTTag {
        private byte value;

        public NBTByte(String name, byte value) {
            super(name);
            this.value = value;
        }

        @Override
        public Byte getValue() {
            return this.value;
        }

        @Override
        public TagType getType() {
            return TagType.TAG_Byte;
        }
    }

    public static class NBTShort
    extends NBTTag {
        private short value;

        public NBTShort(String name, short value) {
            super(name);
            this.value = value;
        }

        @Override
        public Short getValue() {
            return this.value;
        }

        @Override
        public TagType getType() {
            return TagType.TAG_Short;
        }
    }

    public static class NBTInt
    extends NBTTag {
        private int value;

        public NBTInt(String name, int value) {
            super(name);
            this.value = value;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        @Override
        public TagType getType() {
            return TagType.TAG_Int;
        }
    }

    public static class NBTLong
    extends NBTTag {
        private long value;

        public NBTLong(String name, long value) {
            super(name);
            this.value = value;
        }

        @Override
        public Long getValue() {
            return this.value;
        }

        @Override
        public TagType getType() {
            return TagType.TAG_Long;
        }
    }

    public static class NBTFloat
    extends NBTTag {
        private float value;

        public NBTFloat(String name, float value) {
            super(name);
            this.value = value;
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this.value);
        }

        @Override
        public TagType getType() {
            return TagType.TAG_Float;
        }
    }

    public static class NBTDouble
    extends NBTTag {
        private double value;

        public NBTDouble(String name, double value) {
            super(name);
            this.value = value;
        }

        @Override
        public Double getValue() {
            return this.value;
        }

        @Override
        public TagType getType() {
            return TagType.TAG_Double;
        }
    }

    public static class NBTByteArray
    extends NBTTag {
        private byte[] value;

        public NBTByteArray(String name, byte[] value) {
            super(name);
            this.value = value;
        }

        public byte[] getValue() {
            return this.value;
        }

        @Override
        public TagType getType() {
            return TagType.TAG_Byte_Array;
        }
    }

    public static class NBTString
    extends NBTTag {
        private String value;

        public NBTString(String name, String value) {
            super(name);
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public TagType getType() {
            return TagType.TAG_String;
        }
    }

    public static class NBTList
    extends NBTTag {
        private List<NBTTag> tags = new ArrayList<NBTTag>();
        private TagType listType;

        public NBTList(String name, TagType listType) {
            super(name);
            this.listType = listType;
        }

        public void add(NBTTag tag) {
            this.tags.add(tag);
        }

        public NBTTag get(int index) {
            return this.tags.get(index);
        }

        public int size() {
            return this.tags.size();
        }

        public TagType getListType() {
            return this.listType;
        }

        @Override
        public Object getValue() {
            return this.tags;
        }

        @Override
        public TagType getType() {
            return TagType.TAG_List;
        }
    }

    public static class NBTIntArray
    extends NBTTag {
        private int[] value;

        public NBTIntArray(String name, int[] value) {
            super(name);
            this.value = value;
        }

        public int[] getValue() {
            return this.value;
        }

        @Override
        public TagType getType() {
            return TagType.TAG_Int_Array;
        }
    }

    public static class NBTLongArray
    extends NBTTag {
        private long[] value;

        public NBTLongArray(String name, long[] value) {
            super(name);
            this.value = value;
        }

        public long[] getValue() {
            return this.value;
        }

        @Override
        public TagType getType() {
            return TagType.TAG_Long_Array;
        }
    }
}

