/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.nbt;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FastNBTReader {
    private final DataInputStream input;
    private final ByteBuffer buffer;
    private static final Map<String, String> STRING_CACHE = new HashMap<String, String>();
    private static final int MAX_CACHE_SIZE = 1000;

    public FastNBTReader(InputStream input) {
        this.input = new DataInputStream(input);
        this.buffer = ByteBuffer.allocate(8192).order(ByteOrder.BIG_ENDIAN);
    }

    public ChunkData readChunkData() throws IOException {
        this.skipTag();
        ChunkData chunkData = new ChunkData();
        this.readCompoundForChunk(chunkData);
        return chunkData;
    }

    private void readCompoundForChunk(ChunkData chunkData) throws IOException {
        byte tagType;
        block10: while ((tagType = this.input.readByte()) != 0) {
            String name;
            switch (name = this.readString()) {
                case "xPos": {
                    chunkData.xPos = this.readInt();
                    continue block10;
                }
                case "zPos": {
                    chunkData.zPos = this.readInt();
                    continue block10;
                }
                case "sections": {
                    chunkData.sections = this.readSectionsList();
                    continue block10;
                }
            }
            this.skipTagValue(tagType);
        }
    }

    private List<SectionData> readSectionsList() throws IOException {
        byte listType = this.input.readByte();
        int length = this.input.readInt();
        ArrayList<SectionData> sections = new ArrayList<SectionData>(length);
        for (int i = 0; i < length; ++i) {
            SectionData section = this.readSection();
            if (section == null) continue;
            sections.add(section);
        }
        return sections;
    }

    private SectionData readSection() throws IOException {
        byte tagType;
        SectionData section = new SectionData();
        block8: while ((tagType = this.input.readByte()) != 0) {
            String name;
            switch (name = this.readString()) {
                case "Y": {
                    section.y = this.readByte();
                    continue block8;
                }
                case "block_states": {
                    section.blockStates = this.readBlockStates();
                    continue block8;
                }
            }
            this.skipTagValue(tagType);
        }
        return section.blockStates != null ? section : null;
    }

    private BlockStatesData readBlockStates() throws IOException {
        byte tagType;
        BlockStatesData blockStates = new BlockStatesData();
        block8: while ((tagType = this.input.readByte()) != 0) {
            String name;
            switch (name = this.readString()) {
                case "palette": {
                    blockStates.palette = this.readPalette();
                    continue block8;
                }
                case "data": {
                    blockStates.data = this.readLongArray();
                    continue block8;
                }
            }
            this.skipTagValue(tagType);
        }
        return blockStates;
    }

    private List<String> readPalette() throws IOException {
        byte listType = this.input.readByte();
        int length = this.input.readInt();
        ArrayList<String> palette = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            byte tagType;
            String blockName = null;
            while ((tagType = this.input.readByte()) != 0) {
                String name = this.readString();
                if ("Name".equals(name)) {
                    blockName = this.readString();
                    continue;
                }
                this.skipTagValue(tagType);
            }
            palette.add(blockName != null ? blockName : "minecraft:air");
        }
        return palette;
    }

    private long[] readLongArray() throws IOException {
        int length = this.input.readInt();
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.input.readLong();
        }
        return array;
    }

    private String readString() throws IOException {
        int length = this.input.readUnsignedShort();
        if (length == 0) {
            return "";
        }
        byte[] bytes = new byte[length];
        this.input.readFully(bytes);
        String str = new String(bytes, "UTF-8");
        if (STRING_CACHE.size() < 1000) {
            String cached = STRING_CACHE.get(str);
            if (cached != null) {
                return cached;
            }
            STRING_CACHE.put(str, str);
        }
        return str;
    }

    private void skipTagValue(byte tagType) throws IOException {
        switch (tagType) {
            case 1: {
                this.input.readByte();
                break;
            }
            case 2: {
                this.input.readShort();
                break;
            }
            case 3: {
                this.input.readInt();
                break;
            }
            case 4: {
                this.input.readLong();
                break;
            }
            case 5: {
                this.input.readFloat();
                break;
            }
            case 6: {
                this.input.readDouble();
                break;
            }
            case 7: {
                this.skipByteArray();
                break;
            }
            case 8: {
                this.skipString();
                break;
            }
            case 9: {
                this.skipList();
                break;
            }
            case 10: {
                this.skipCompound();
                break;
            }
            case 11: {
                this.skipIntArray();
                break;
            }
            case 12: {
                this.skipLongArray();
            }
        }
    }

    private void skipTag() throws IOException {
        byte tagType = this.input.readByte();
        if (tagType != 0) {
            this.skipString();
        }
    }

    private void skipString() throws IOException {
        int length = this.input.readUnsignedShort();
        this.input.skipBytes(length);
    }

    private void skipByteArray() throws IOException {
        int length = this.input.readInt();
        this.input.skipBytes(length);
    }

    private void skipIntArray() throws IOException {
        int length = this.input.readInt();
        this.input.skipBytes(length * 4);
    }

    private void skipLongArray() throws IOException {
        int length = this.input.readInt();
        this.input.skipBytes(length * 8);
    }

    private void skipList() throws IOException {
        byte listType = this.input.readByte();
        int length = this.input.readInt();
        for (int i = 0; i < length; ++i) {
            this.skipTagValue(listType);
        }
    }

    private void skipCompound() throws IOException {
        byte tagType;
        while ((tagType = this.input.readByte()) != 0) {
            this.skipString();
            this.skipTagValue(tagType);
        }
    }

    private byte readByte() throws IOException {
        return this.input.readByte();
    }

    private int readInt() throws IOException {
        return this.input.readInt();
    }

    public static class ChunkData {
        public int xPos;
        public int zPos;
        public List<SectionData> sections = new ArrayList<SectionData>();
    }

    public static class SectionData {
        public byte y;
        public BlockStatesData blockStates;
    }

    public static class BlockStatesData {
        public List<String> palette;
        public long[] data;
    }
}

