/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.gui;

import com.minecraft.selector.gui.MapCanvas;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ViewportManager {
    private final Set<RegionCoord> loadedRegions = ConcurrentHashMap.newKeySet();
    private final int bufferSize;
    private final MapCanvas.ViewportCallback callback;

    public ViewportManager(MapCanvas.ViewportCallback callback, int bufferSize) {
        this.callback = callback;
        this.bufferSize = bufferSize;
    }

    public void updateViewport(int minWorldX, int minWorldZ, int maxWorldX, int maxWorldZ) {
        int minRegionX = (minWorldX - this.bufferSize * 512) / 512;
        int maxRegionX = (maxWorldX + this.bufferSize * 512) / 512;
        int minRegionZ = (minWorldZ - this.bufferSize * 512) / 512;
        int maxRegionZ = (maxWorldZ + this.bufferSize * 512) / 512;
        HashSet<RegionCoord> requiredRegions = new HashSet<RegionCoord>();
        for (int x = minRegionX; x <= maxRegionX; ++x) {
            for (int z = minRegionZ; z <= maxRegionZ; ++z) {
                requiredRegions.add(new RegionCoord(x, z));
            }
        }
        for (RegionCoord region : requiredRegions) {
            if (this.loadedRegions.contains(region)) continue;
            this.loadedRegions.add(region);
            if (this.callback != null) {
                this.callback.loadRegion(region.x, region.z);
            }
            System.out.printf("\u52a0\u8f7d\u533a\u57df: r.%d.%d.mca\n", region.x, region.z);
        }
        HashSet<RegionCoord> toUnload = new HashSet<RegionCoord>();
        for (RegionCoord region : this.loadedRegions) {
            if (requiredRegions.contains(region)) continue;
            toUnload.add(region);
        }
        for (RegionCoord region : toUnload) {
            this.loadedRegions.remove(region);
            if (this.callback != null) {
                this.callback.unloadRegion(region.x, region.z);
            }
            System.out.printf("\u5378\u8f7d\u533a\u57df: r.%d.%d.mca\n", region.x, region.z);
        }
        if (this.callback != null) {
            this.callback.onViewportChanged(minWorldX, minWorldZ, maxWorldX, maxWorldZ);
        }
    }

    public int getLoadedRegionCount() {
        return this.loadedRegions.size();
    }

    public void clearAll() {
        for (RegionCoord region : new HashSet<RegionCoord>(this.loadedRegions)) {
            this.loadedRegions.remove(region);
            if (this.callback == null) continue;
            this.callback.unloadRegion(region.x, region.z);
        }
    }

    private static class RegionCoord {
        final int x;
        final int z;

        RegionCoord(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RegionCoord that = (RegionCoord)obj;
            return this.x == that.x && this.z == that.z;
        }

        public int hashCode() {
            return this.x * 31 + this.z;
        }

        public String toString() {
            return String.format("Region(%d, %d)", this.x, this.z);
        }
    }
}

