/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.gui;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.extras.FlatAnimatedLafChange;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.UIManager;

public class UIThemeManager {
    private static UIThemeManager instance;
    private ThemeType currentTheme;
    private final Preferences prefs = Preferences.userNodeForPackage(UIThemeManager.class);

    private UIThemeManager() {
        this.loadSavedTheme();
    }

    public static UIThemeManager getInstance() {
        if (instance == null) {
            instance = new UIThemeManager();
        }
        return instance;
    }

    public void initializeTheme() {
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("swing.aatext", "true");
        this.applyTheme(this.currentTheme);
        this.customizeUIComponents();
    }

    public void applyTheme(ThemeType theme) {
        try {
            FlatAnimatedLafChange.showSnapshot();
            switch (theme.ordinal()) {
                case 0: {
                    UIManager.setLookAndFeel(new FlatLightLaf());
                    break;
                }
                case 1: {
                    UIManager.setLookAndFeel(new FlatDarkLaf());
                }
            }
            FlatLaf.updateUI();
            FlatAnimatedLafChange.hideSnapshotWithAnimation();
            this.currentTheme = theme;
            this.saveThemePreference();
        }
        catch (Exception e) {
            System.err.println("Failed to apply theme: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void toggleTheme() {
        ThemeType newTheme = this.currentTheme == ThemeType.LIGHT ? ThemeType.DARK : ThemeType.LIGHT;
        this.applyTheme(newTheme);
    }

    private void customizeUIComponents() {
        UIManager.put("Button.arc", 8);
        UIManager.put("Component.arc", 8);
        UIManager.put("TextComponent.arc", 8);
        UIManager.put("ProgressBar.arc", 8);
        UIManager.put("ProgressBar.selectionBackground", Color.WHITE);
        UIManager.put("ProgressBar.selectionForeground", Color.BLACK);
        UIManager.put("ScrollBar.width", 12);
        UIManager.put("ScrollBar.thumbArc", 6);
        UIManager.put("ScrollBar.thumbInsets", new Insets(2, 2, 2, 2));
        UIManager.put("TitledBorder.titleColor", ThemeColors.PRIMARY_BLUE);
        UIManager.put("ToolTip.background", new Color(255, 255, 225));
        UIManager.put("ToolTip.border", BorderFactory.createLineBorder(Color.GRAY, 1));
        UIManager.put("MenuBar.background", Color.WHITE);
        UIManager.put("PopupMenu.background", Color.WHITE);
        UIManager.put("Table.gridColor", new Color(220, 220, 220));
        UIManager.put("Table.disabled", false);
        UIManager.put("Table.showHorizontalLines", true);
        UIManager.put("Table.showVerticalLines", true);
    }

    public ThemeType getCurrentTheme() {
        return this.currentTheme;
    }

    private void loadSavedTheme() {
        String savedTheme = this.prefs.get("theme", ThemeType.LIGHT.getKey());
        for (ThemeType theme : ThemeType.values()) {
            if (!theme.getKey().equals(savedTheme)) continue;
            this.currentTheme = theme;
            return;
        }
        this.currentTheme = ThemeType.LIGHT;
    }

    private void saveThemePreference() {
        this.prefs.put("theme", this.currentTheme.getKey());
    }

    public static JButton createStyledButton(String text, String iconName) {
        final JButton button = new JButton(text);
        button.setFocusPainted(false);
        button.setFont(button.getFont().deriveFont(1, 12.0f));
        button.setBackground(ThemeColors.PRIMARY_BLUE);
        button.setForeground(Color.WHITE);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                button.setBackground(ThemeColors.PRIMARY_BLUE.brighter());
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                button.setBackground(ThemeColors.PRIMARY_BLUE);
            }
        });
        return button;
    }

    public static enum ThemeType {
        LIGHT("\u6d45\u8272\u4e3b\u9898", "light"),
        DARK("\u6df1\u8272\u4e3b\u9898", "dark");

        private final String displayName;
        private final String key;

        private ThemeType(String displayName, String key) {
            this.displayName = displayName;
            this.key = key;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static class ThemeColors {
        public static final Color PRIMARY_BLUE = new Color(70, 130, 180);
        public static final Color SUCCESS_GREEN = new Color(46, 139, 87);
        public static final Color WARNING_ORANGE = new Color(255, 140, 0);
        public static final Color DANGER_RED = new Color(220, 20, 60);
        public static final Color MINECRAFT_GREEN = new Color(85, 170, 85);
        public static final Color MINECRAFT_BROWN = new Color(139, 69, 19);
        public static final Color MINECRAFT_STONE = new Color(120, 120, 120);
        public static final Color GRADIENT_START = new Color(74, 144, 226);
        public static final Color GRADIENT_END = new Color(80, 170, 221);
        public static final Color DARK_BG = new Color(45, 45, 45);
        public static final Color DARK_PANEL = new Color(50, 50, 50);
        public static final Color DARK_BORDER = new Color(70, 70, 70);
    }
}

