/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.gui;

import com.minecraft.selector.gui.UIThemeManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StyledComponents {
    public static JTextField createStyledTextField(String text, int columns) {
        final JTextField textField = new JTextField(text, columns);
        textField.setFont(textField.getFont().deriveFont(0, 12.0f));
        textField.setBorder(StyledComponents.createRoundedBorder(UIThemeManager.ThemeColors.PRIMARY_BLUE, false));
        textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                textField.setBorder(StyledComponents.createRoundedBorder(UIThemeManager.ThemeColors.PRIMARY_BLUE, true));
            }

            @Override
            public void focusLost(FocusEvent e) {
                textField.setBorder(StyledComponents.createRoundedBorder(UIThemeManager.ThemeColors.PRIMARY_BLUE, false));
            }
        });
        return textField;
    }

    public static <T> JComboBox<T> createStyledComboBox(T[] items) {
        JComboBox<T> comboBox = new JComboBox<T>(items);
        comboBox.setFont(comboBox.getFont().deriveFont(0, 12.0f));
        comboBox.setBorder(StyledComponents.createRoundedBorder(UIThemeManager.ThemeColors.MINECRAFT_GREEN, false));
        comboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (isSelected) {
                    this.setBackground(UIThemeManager.ThemeColors.PRIMARY_BLUE);
                    this.setForeground(Color.WHITE);
                } else {
                    this.setBackground(Color.WHITE);
                    this.setForeground(Color.BLACK);
                }
                this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
                return this;
            }
        });
        return comboBox;
    }

    public static JCheckBox createStyledCheckBox(String text, boolean selected) {
        JCheckBox checkBox = new JCheckBox(text, selected);
        checkBox.setFont(checkBox.getFont().deriveFont(1, 12.0f));
        checkBox.setFocusPainted(false);
        checkBox.setForeground(UIThemeManager.ThemeColors.MINECRAFT_GREEN);
        return checkBox;
    }

    public static JLabel createStyledLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(label.getFont().deriveFont(0, 12.0f));
        return label;
    }

    public static JLabel createTitleLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(label.getFont().deriveFont(1, 14.0f));
        label.setForeground(UIThemeManager.ThemeColors.PRIMARY_BLUE);
        return label;
    }

    public static JLabel createInfoLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(label.getFont().deriveFont(0, 11.0f));
        label.setForeground(Color.GRAY);
        return label;
    }

    public static JLabel createSuccessLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(label.getFont().deriveFont(1, 12.0f));
        label.setForeground(UIThemeManager.ThemeColors.SUCCESS_GREEN);
        return label;
    }

    public static JLabel createWarningLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(label.getFont().deriveFont(1, 12.0f));
        label.setForeground(UIThemeManager.ThemeColors.WARNING_ORANGE);
        return label;
    }

    public static JLabel createErrorLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(label.getFont().deriveFont(1, 12.0f));
        label.setForeground(UIThemeManager.ThemeColors.DANGER_RED);
        return label;
    }

    public static JProgressBar createStyledProgressBar() {
        JProgressBar progressBar = new JProgressBar();
        progressBar.setStringPainted(true);
        progressBar.setFont(progressBar.getFont().deriveFont(1, 11.0f));
        progressBar.setForeground(UIThemeManager.ThemeColors.SUCCESS_GREEN);
        progressBar.setBackground(Color.LIGHT_GRAY);
        progressBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIThemeManager.ThemeColors.PRIMARY_BLUE, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        return progressBar;
    }

    public static JSeparator createStyledSeparator() {
        JSeparator separator = new JSeparator();
        separator.setForeground(UIThemeManager.ThemeColors.PRIMARY_BLUE);
        separator.setBackground(UIThemeManager.ThemeColors.PRIMARY_BLUE);
        return separator;
    }

    private static Border createRoundedBorder(Color color, boolean focused) {
        int thickness = focused ? 2 : 1;
        Color borderColor = focused ? color.brighter() : color;
        return BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(borderColor, thickness, true), BorderFactory.createEmptyBorder(5, 8, 5, 8));
    }

    public static JPanel createShadowPanel() {
        return new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(new Color(0, 0, 0, 30));
                g2d.fillRoundRect(2, 2, this.getWidth() - 2, this.getHeight() - 2, 10, 10);
                g2d.setColor(this.getBackground());
                g2d.fillRoundRect(0, 0, this.getWidth() - 2, this.getHeight() - 2, 8, 8);
                g2d.dispose();
            }
        };
    }

    public static JPanel createCardPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        panel.setBackground(Color.WHITE);
        return panel;
    }

    public static void setStyledToolTip(JComponent component, String text) {
        component.setToolTipText(text);
        UIManager.put("ToolTip.background", new Color(255, 255, 225));
        UIManager.put("ToolTip.foreground", Color.BLACK);
        UIManager.put("ToolTip.border", BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIThemeManager.ThemeColors.PRIMARY_BLUE, 1), BorderFactory.createEmptyBorder(5, 8, 5, 8)));
    }

    public static void addHoverEffect(final JComponent component, final Color normalColor, final Color hoverColor) {
        final Color originalBackground = component.getBackground();
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (component.isEnabled()) {
                    component.setBackground(hoverColor);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (component.isEnabled()) {
                    component.setBackground(originalBackground != null ? originalBackground : normalColor);
                }
            }
        });
    }

    public static JButton createAnimatedButton(String text, Icon icon) {
        final JButton button = new JButton(text, icon);
        button.setFocusPainted(false);
        button.setFont(button.getFont().deriveFont(1, 12.0f));
        button.setIconTextGap(8);
        button.setBackground(UIThemeManager.ThemeColors.PRIMARY_BLUE);
        button.setForeground(Color.WHITE);
        final Timer hoverTimer = new Timer(50, null);
        button.addMouseListener(new MouseAdapter(){
            private float alpha = 1.0f;

            @Override
            public void mouseEntered(MouseEvent e) {
                if (button.isEnabled()) {
                    hoverTimer.stop();
                    hoverTimer.addActionListener(evt -> {
                        this.alpha = Math.min(1.0f, this.alpha + 0.1f);
                        Color hoverColor = new Color((int)((float)UIThemeManager.ThemeColors.PRIMARY_BLUE.getRed() * this.alpha), (int)((float)UIThemeManager.ThemeColors.PRIMARY_BLUE.getGreen() * this.alpha), (int)((float)UIThemeManager.ThemeColors.PRIMARY_BLUE.getBlue() * this.alpha));
                        button.setBackground(hoverColor.brighter());
                        if (this.alpha >= 1.0f) {
                            hoverTimer.stop();
                        }
                    });
                    hoverTimer.start();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (button.isEnabled()) {
                    button.setBackground(UIThemeManager.ThemeColors.PRIMARY_BLUE);
                    hoverTimer.stop();
                    this.alpha = 1.0f;
                }
            }
        });
        return button;
    }

    public static class DualRangeSlider
    extends JPanel {
        private int minValue;
        private int maxValue;
        private int lowerValue;
        private int upperValue;
        private boolean draggingLower = false;
        private boolean draggingUpper = false;
        private final int THUMB_SIZE = 12;
        private final int TRACK_HEIGHT = 6;
        private List<ChangeListener> listeners = new ArrayList<ChangeListener>();

        public DualRangeSlider(int min, int max, int lower, int upper) {
            this.minValue = min;
            this.maxValue = max;
            this.lowerValue = Math.max(min, Math.min(lower, max));
            this.upperValue = Math.max(min, Math.min(upper, max));
            this.setPreferredSize(new Dimension(200, 40));
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.handleMousePressed(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    draggingLower = false;
                    draggingUpper = false;
                    this.setCursor(Cursor.getDefaultCursor());
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    this.handleMouseDragged(e);
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.updateCursor(e);
                }
            });
        }

        public void addChangeListener(ChangeListener listener) {
            this.listeners.add(listener);
        }

        private void fireChangeEvent() {
            ChangeEvent event = new ChangeEvent(this);
            for (ChangeListener listener : this.listeners) {
                listener.stateChanged(event);
            }
        }

        private void handleMousePressed(MouseEvent e) {
            int thumbY;
            boolean inThumbArea;
            int trackStart = 6;
            int trackWidth = this.getWidth() - 12;
            int trackY = (this.getHeight() - 6) / 2 - 5;
            int lowerPos = trackStart + (int)((double)(this.lowerValue - this.minValue) / (double)(this.maxValue - this.minValue) * (double)trackWidth);
            int upperPos = trackStart + (int)((double)(this.upperValue - this.minValue) / (double)(this.maxValue - this.minValue) * (double)trackWidth);
            int mouseX = e.getX();
            int mouseY = e.getY();
            boolean bl = inThumbArea = mouseY >= (thumbY = trackY - 3) && mouseY <= thumbY + 12;
            if (inThumbArea) {
                if (Math.abs(mouseX - lowerPos) <= 6) {
                    this.draggingLower = true;
                } else if (Math.abs(mouseX - upperPos) <= 6) {
                    this.draggingUpper = true;
                } else if (Math.abs(mouseX - lowerPos) < Math.abs(mouseX - upperPos)) {
                    this.draggingLower = true;
                    this.updateLowerValue(mouseX);
                } else {
                    this.draggingUpper = true;
                    this.updateUpperValue(mouseX);
                }
            }
        }

        private void handleMouseDragged(MouseEvent e) {
            if (this.draggingLower) {
                this.updateLowerValue(e.getX());
            } else if (this.draggingUpper) {
                this.updateUpperValue(e.getX());
            }
        }

        private void updateLowerValue(int mouseX) {
            int trackStart = 6;
            int trackWidth = this.getWidth() - 12;
            double ratio = Math.max(0.0, Math.min(1.0, (double)(mouseX - trackStart) / (double)trackWidth));
            int newValue = (int)((double)this.minValue + ratio * (double)(this.maxValue - this.minValue));
            if (newValue != this.lowerValue && newValue <= this.upperValue) {
                this.lowerValue = newValue;
                this.repaint();
                this.fireChangeEvent();
            }
        }

        private void updateUpperValue(int mouseX) {
            int trackStart = 6;
            int trackWidth = this.getWidth() - 12;
            double ratio = Math.max(0.0, Math.min(1.0, (double)(mouseX - trackStart) / (double)trackWidth));
            int newValue = (int)((double)this.minValue + ratio * (double)(this.maxValue - this.minValue));
            if (newValue != this.upperValue && newValue >= this.lowerValue) {
                this.upperValue = newValue;
                this.repaint();
                this.fireChangeEvent();
            }
        }

        private void updateCursor(MouseEvent e) {
            int thumbY;
            boolean inThumbArea;
            int trackStart = 6;
            int trackWidth = this.getWidth() - 12;
            int trackY = (this.getHeight() - 6) / 2 - 5;
            int lowerPos = trackStart + (int)((double)(this.lowerValue - this.minValue) / (double)(this.maxValue - this.minValue) * (double)trackWidth);
            int upperPos = trackStart + (int)((double)(this.upperValue - this.minValue) / (double)(this.maxValue - this.minValue) * (double)trackWidth);
            int mouseX = e.getX();
            int mouseY = e.getY();
            boolean bl = inThumbArea = mouseY >= (thumbY = trackY - 3) && mouseY <= thumbY + 12;
            if (inThumbArea && (Math.abs(mouseX - lowerPos) <= 6 || Math.abs(mouseX - upperPos) <= 6)) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Container parent = this.getParent();
            Color bgColor = parent != null ? parent.getBackground() : Color.WHITE;
            g2d.setColor(bgColor);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            int trackStart = 6;
            int trackWidth = this.getWidth() - 12;
            int trackY = (this.getHeight() - 6) / 2 - 5;
            g2d.setColor(Color.LIGHT_GRAY);
            g2d.fillRoundRect(trackStart, trackY, trackWidth, 6, 6, 6);
            int lowerPos = trackStart + (int)((double)(this.lowerValue - this.minValue) / (double)(this.maxValue - this.minValue) * (double)trackWidth);
            int upperPos = trackStart + (int)((double)(this.upperValue - this.minValue) / (double)(this.maxValue - this.minValue) * (double)trackWidth);
            g2d.setColor(UIThemeManager.ThemeColors.PRIMARY_BLUE);
            g2d.fillRoundRect(lowerPos, trackY, upperPos - lowerPos, 6, 6, 6);
            g2d.setColor(UIThemeManager.ThemeColors.MINECRAFT_GREEN);
            g2d.fillOval(lowerPos - 6, trackY - 3, 12, 12);
            g2d.setColor(Color.WHITE);
            g2d.drawOval(lowerPos - 6, trackY - 3, 12, 12);
            g2d.setColor(UIThemeManager.ThemeColors.WARNING_ORANGE);
            g2d.fillOval(upperPos - 6, trackY - 3, 12, 12);
            g2d.setColor(Color.WHITE);
            g2d.drawOval(upperPos - 6, trackY - 3, 12, 12);
            g2d.setColor(Color.BLACK);
            g2d.setFont(new Font("SansSerif", 0, 10));
            FontMetrics fm = g2d.getFontMetrics();
            String lowerText = String.valueOf(this.lowerValue);
            int lowerTextWidth = fm.stringWidth(lowerText);
            int lowerTextX = Math.max(0, Math.min(this.getWidth() - lowerTextWidth, lowerPos - lowerTextWidth / 2));
            g2d.drawString(lowerText, lowerTextX, trackY - 8);
            String upperText = String.valueOf(this.upperValue);
            int upperTextWidth = fm.stringWidth(upperText);
            int upperTextX = Math.max(0, Math.min(this.getWidth() - upperTextWidth, upperPos - upperTextWidth / 2));
            g2d.drawString(upperText, upperTextX, trackY - 8);
            g2d.dispose();
        }

        public int getLowerValue() {
            return this.lowerValue;
        }

        public int getUpperValue() {
            return this.upperValue;
        }

        public void setLowerValue(int value) {
            int newValue = Math.max(this.minValue, Math.min(value, this.upperValue));
            if (newValue != this.lowerValue) {
                this.lowerValue = newValue;
                this.repaint();
                this.fireChangeEvent();
            }
        }

        public void setUpperValue(int value) {
            int newValue = Math.max(this.lowerValue, Math.min(value, this.maxValue));
            if (newValue != this.upperValue) {
                this.upperValue = newValue;
                this.repaint();
                this.fireChangeEvent();
            }
        }

        public void setRange(int min, int max) {
            this.minValue = min;
            this.maxValue = max;
            this.lowerValue = Math.max(min, Math.min(this.lowerValue, max));
            this.upperValue = Math.max(min, Math.min(this.upperValue, max));
            this.repaint();
        }
    }
}

