/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.gui;

import com.minecraft.selector.core.BlockColors;
import com.minecraft.selector.core.DynamicRegionManager;
import com.minecraft.selector.core.MapRenderer;
import com.minecraft.selector.core.MinecraftResourceExtractor;
import com.minecraft.selector.gui.DynamicMapCanvas;
import com.minecraft.selector.gui.DynamicMapManager;
import com.minecraft.selector.gui.IconManager;
import com.minecraft.selector.gui.LoadingAnimationPanel;
import com.minecraft.selector.gui.LogWindow;
import com.minecraft.selector.gui.MapCanvas;
import com.minecraft.selector.gui.StyledComponents;
import com.minecraft.selector.gui.UIThemeManager;
import com.minecraft.selector.nbt.NBTReader;
import com.minecraft.selector.utils.FileUtils;
import com.minecraft.selector.utils.LogManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class MinecraftMapGUI
extends JFrame {
    private JLabel saveInfoLabel;
    private JLabel playerPosLabel;
    private JLabel regionLabel;
    private JLabel coordDisplayLabel;
    private JLabel fileInfoLabel;
    private JTextField minYEntry;
    private JTextField maxYEntry;
    private StyledComponents.DualRangeSlider heightRangeSlider;
    private JComboBox<String> lodDropdown;
    private JTextField xCoordEntry;
    private JTextField zCoordEntry;
    private JComboBox<String> mcaRangeDropdown;
    private JCheckBox autoLoadCheckbox;
    private DynamicMapManager dynamicMapManager;
    private int lastMultiRenderMinRegionX = 0;
    private int lastMultiRenderMinRegionZ = 0;
    private JButton renderAroundPlayerButton;
    private JButton jumpButton;
    private JButton confirmSelectionButton;
    private JButton reRenderButton;
    private MapCanvas mapCanvas;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private String savePath;
    private double[] playerPos;
    private Rectangle selectedRegion;
    private BufferedImage mapImage;
    private double customScale = 1.0;
    private Point currentRegion;
    private String currentOutputFile;
    private String currentJsonFile;
    private MinecraftResourceExtractor resourceExtractor;
    private String programDir;
    private LogWindow logWindow;
    private LogManager logManager;
    private int lastFullRenderMinWorldX = 0;
    private int lastFullRenderMinWorldZ = 0;
    private DynamicRegionManager dynamicRegionManager;
    private DynamicMapCanvas dynamicMapCanvas;
    private boolean isDynamicMode = false;
    private JButton dynamicModeButton;
    private String outputFilePath = null;
    private String jarFilePath = null;
    private boolean isBlenderMode = false;
    private int blenderMinY = 0;
    private int blenderMaxY = 255;
    private ExecutorService renderingExecutor;
    private ExecutorService backgroundExecutor;
    private final int RENDERING_THREADS = Math.max(2, Runtime.getRuntime().availableProcessors() - 1);
    private final int BACKGROUND_THREADS = Math.min(4, Runtime.getRuntime().availableProcessors());
    private UIThemeManager themeManager;
    private LoadingAnimationPanel.StatusIndicator statusIndicator;

    public MinecraftMapGUI() {
        this(null, null, null, 0, 255);
    }

    public MinecraftMapGUI(String worldPath, String outputFile) {
        this(worldPath, outputFile, null, 0, 255);
    }

    public MinecraftMapGUI(String worldPath, String outputFile, int minY, int maxY) {
        this(worldPath, outputFile, null, minY, maxY);
    }

    public MinecraftMapGUI(String worldPath, String outputFile, String jarPath, int minY, int maxY) {
        this.programDir = System.getProperty("user.dir");
        this.resourceExtractor = new MinecraftResourceExtractor();
        this.logManager = LogManager.getInstance();
        this.logManager.info("Minecraft Map Selector GUI \u542f\u52a8", "MinecraftMapGUI");
        this.outputFilePath = outputFile;
        this.jarFilePath = jarPath;
        this.isBlenderMode = outputFile != null;
        this.blenderMinY = minY;
        this.blenderMaxY = maxY;
        this.initializeThreadPools();
        this.initializeGUI();
        this.loadSavedColors();
        if (this.isBlenderMode) {
            SwingUtilities.invokeLater(() -> {
                this.progressLabel.setText("Blender\u96c6\u6210\u6a21\u5f0f\u5df2\u542f\u52a8");
                if (this.heightRangeSlider != null) {
                    this.heightRangeSlider.setLowerValue(this.blenderMinY);
                    this.heightRangeSlider.setUpperValue(this.blenderMaxY);
                    this.minYEntry.setText(String.valueOf(this.blenderMinY));
                    this.maxYEntry.setText(String.valueOf(this.blenderMaxY));
                }
                if (worldPath != null) {
                    if (new File(worldPath).exists()) {
                        this.loadWorldFromPath(worldPath);
                    } else {
                        this.progressLabel.setText("Blender\u6a21\u5f0f\uff1a\u4e16\u754c\u8def\u5f84\u4e0d\u5b58\u5728 - " + worldPath);
                        System.err.println("Blender\u6a21\u5f0f\uff1a\u4e16\u754c\u8def\u5f84\u4e0d\u5b58\u5728: " + worldPath);
                    }
                }
            });
        }
    }

    private void loadSavedColors() {
        if (this.jarFilePath != null && new File(this.jarFilePath).exists()) {
            System.out.println("\u4f7f\u7528\u63d0\u4f9b\u7684JAR\u8def\u5f84\u63d0\u53d6\u989c\u8272: " + this.jarFilePath);
            this.extractColorsFromJar(this.jarFilePath);
            return;
        }
        String jsonColorFile = new File(this.programDir, "block_colors.json").getAbsolutePath();
        if (new File(jsonColorFile).exists() && this.resourceExtractor.loadExtractedColorsFromJson(jsonColorFile)) {
            BlockColors.setResourceExtractor(this.resourceExtractor);
            System.out.println("\u5df2\u52a0\u8f7d\u4fdd\u5b58\u7684\u65b9\u5757\u989c\u8272\u4fe1\u606f (JSON\u683c\u5f0f)");
            return;
        }
        String propsColorFile = new File(this.programDir, "extracted_colors.properties").getAbsolutePath();
        if (new File(propsColorFile).exists() && this.resourceExtractor.loadExtractedColors(propsColorFile)) {
            BlockColors.setResourceExtractor(this.resourceExtractor);
            System.out.println("\u5df2\u52a0\u8f7d\u4fdd\u5b58\u7684\u65b9\u5757\u989c\u8272\u4fe1\u606f (Properties\u683c\u5f0f)");
        }
    }

    private void initializeThreadPools() {
        this.renderingExecutor = Executors.newFixedThreadPool(this.RENDERING_THREADS, r -> {
            Thread t = new Thread(r, "RenderingThread");
            t.setDaemon(true);
            t.setPriority(6);
            return t;
        });
        this.backgroundExecutor = Executors.newFixedThreadPool(this.BACKGROUND_THREADS, r -> {
            Thread t = new Thread(r, "BackgroundThread");
            t.setDaemon(true);
            t.setPriority(4);
            return t;
        });
        System.out.printf("\u7ebf\u7a0b\u6c60\u521d\u59cb\u5316\u5b8c\u6210 - \u6e32\u67d3\u7ebf\u7a0b: %d, \u540e\u53f0\u7ebf\u7a0b: %d\n", this.RENDERING_THREADS, this.BACKGROUND_THREADS);
    }

    private void shutdownThreadPools() {
        if (this.renderingExecutor != null && !this.renderingExecutor.isShutdown()) {
            this.renderingExecutor.shutdown();
            try {
                if (!this.renderingExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.renderingExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.renderingExecutor.shutdownNow();
            }
        }
        if (this.backgroundExecutor != null && !this.backgroundExecutor.isShutdown()) {
            this.backgroundExecutor.shutdown();
            try {
                if (!this.backgroundExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.backgroundExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.backgroundExecutor.shutdownNow();
            }
        }
        if (this.isDynamicMode) {
            this.disableDynamicMode();
        }
        System.out.println("\u7ebf\u7a0b\u6c60\u5df2\u5173\u95ed");
    }

    private void initializeGUI() {
        this.setTitle("Minecraft \u5730\u56fe\u9009\u62e9\u5668");
        this.setDefaultCloseOperation(0);
        this.setSize(1600, 1000);
        this.setLocationRelativeTo(null);
        this.setMinimumSize(new Dimension(1200, 800));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MinecraftMapGUI.this.shutdownThreadPools();
                System.exit(0);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SwingUtilities.invokeLater(() -> {
                    MinecraftMapGUI.this.revalidate();
                    MinecraftMapGUI.this.repaint();
                });
            }
        });
        this.themeManager = UIThemeManager.getInstance();
        this.themeManager.initializeTheme();
        this.createComponents();
        this.layoutComponents();
        this.setupEventHandlers();
    }

    private void createComponents() {
        this.saveInfoLabel = StyledComponents.createInfoLabel("\u672a\u9009\u62e9\u5b58\u6863");
        this.playerPosLabel = StyledComponents.createInfoLabel("\u73a9\u5bb6\u4f4d\u7f6e: \u672a\u77e5");
        this.regionLabel = StyledComponents.createInfoLabel("\u9009\u62e9\u533a\u57df: \u672a\u9009\u62e9");
        this.coordDisplayLabel = StyledComponents.createInfoLabel("X: 0, Z: 0");
        this.fileInfoLabel = StyledComponents.createInfoLabel("");
        this.minYEntry = StyledComponents.createStyledTextField("-64", 6);
        this.maxYEntry = StyledComponents.createStyledTextField("320", 6);
        this.xCoordEntry = StyledComponents.createStyledTextField("", 8);
        this.zCoordEntry = StyledComponents.createStyledTextField("", 8);
        this.heightRangeSlider = new StyledComponents.DualRangeSlider(-64, 320, -64, 320);
        this.heightRangeSlider.addChangeListener(e -> {
            this.minYEntry.setText(String.valueOf(this.heightRangeSlider.getLowerValue()));
            this.maxYEntry.setText(String.valueOf(this.heightRangeSlider.getUpperValue()));
        });
        String[] lodOptions = new String[]{"\u81ea\u52a8 (\u6839\u636e\u6587\u4ef6\u6570\u91cf)", "1 (\u539f\u59cb\u7cbe\u5ea6)", "2 (1/2\u7cbe\u5ea6)", "4 (1/4\u7cbe\u5ea6)", "8 (1/8\u7cbe\u5ea6)"};
        this.lodDropdown = StyledComponents.createStyledComboBox(lodOptions);
        this.lodDropdown.setSelectedIndex(0);
        this.mcaRangeDropdown = StyledComponents.createStyledComboBox(new String[]{"1x1 (\u5355\u4e2a\u6587\u4ef6)", "3x3 (9\u4e2a\u6587\u4ef6)", "5x5 (25\u4e2a\u6587\u4ef6)", "7x7 (49\u4e2a\u6587\u4ef6)"});
        this.mcaRangeDropdown.setSelectedItem("1x1 (\u5355\u4e2a\u6587\u4ef6)");
        this.autoLoadCheckbox = StyledComponents.createStyledCheckBox("\u542f\u7528\u81ea\u52a8\u52a0\u8f7d", true);
        this.renderAroundPlayerButton = this.createStyledButton("\u6e32\u67d3\u73a9\u5bb6\u5468\u56f4", IconManager.getPlayerIcon(16));
        this.renderAroundPlayerButton.setEnabled(false);
        this.jumpButton = this.createStyledButton("\u8df3\u8f6c\u5230\u5750\u6807", IconManager.getJumpIcon(16));
        this.confirmSelectionButton = this.createStyledButton("\u786e\u8ba4\u9009\u62e9\u533a\u57df", IconManager.getConfirmIcon(16));
        this.confirmSelectionButton.setEnabled(false);
        this.reRenderButton = this.createStyledButton("\u91cd\u65b0\u6e32\u67d3", IconManager.getRefreshIcon(16));
        this.reRenderButton.setEnabled(false);
        this.mapCanvas = new MapCanvas();
        this.dynamicMapManager = new DynamicMapManager();
        this.mapCanvas.setSelectionCallback(new MapCanvas.SelectionCallback(){

            @Override
            public void onSelectionComplete(int minX, int minZ, int maxX, int maxZ) {
                SwingUtilities.invokeLater(() -> {
                    MinecraftMapGUI.this.confirmSelectionButton.setEnabled(true);
                    MinecraftMapGUI.this.progressLabel.setText(String.format("\u5df2\u9009\u62e9\u533a\u57df: (%d,%d) \u5230 (%d,%d) - \u70b9\u51fb\u786e\u8ba4\u6309\u94ae", minX, minZ, maxX, maxZ));
                });
            }

            @Override
            public void onSelectionConfirmed(int minX, int minZ, int maxX, int maxZ) {
                SwingUtilities.invokeLater(() -> {
                    int centerX = (minX + maxX) / 2;
                    int centerZ = (minZ + maxZ) / 2;
                    int sizeX = maxX - minX;
                    int sizeZ = maxZ - minZ;
                    int size = Math.max(sizeX, sizeZ);
                    MinecraftMapGUI.this.progressLabel.setText(String.format("\u786e\u8ba4\u9009\u62e9\u533a\u57df: (%d,%d) \u5230 (%d,%d)", minX, minZ, maxX, maxZ));
                    System.out.printf("=== \u786e\u8ba4\u7684\u9009\u62e9\u533a\u57df ===\n", new Object[0]);
                    System.out.printf("\u5de6\u4e0a\u89d2\u5750\u6807: (%d, %d)\n", minX, minZ);
                    System.out.printf("\u53f3\u4e0b\u89d2\u5750\u6807: (%d, %d)\n", maxX, maxZ);
                    System.out.printf("\u4e2d\u5fc3\u5750\u6807: (%d, %d)\n", centerX, centerZ);
                    System.out.printf("\u533a\u57df\u5927\u5c0f: %dx%d\n", sizeX, sizeZ);
                    if (MinecraftMapGUI.this.isBlenderMode && MinecraftMapGUI.this.outputFilePath != null) {
                        MinecraftMapGUI.this.outputCoordinatesToFile(minX, minZ, maxX, maxZ);
                    }
                });
            }
        });
        this.mapCanvas.setViewportCallback(new MapCanvas.ViewportCallback(){

            @Override
            public void onViewportChanged(int minWorldX, int minWorldZ, int maxWorldX, int maxWorldZ) {
                SwingUtilities.invokeLater(() -> {});
            }

            @Override
            public void loadRegion(int regionX, int regionZ) {
                MinecraftMapGUI.this.loadRegionInBackground(regionX, regionZ);
            }

            @Override
            public void unloadRegion(int regionX, int regionZ) {
                MinecraftMapGUI.this.unloadRegionInBackground(regionX, regionZ);
            }
        });
        this.progressBar = StyledComponents.createStyledProgressBar();
        this.progressLabel = StyledComponents.createInfoLabel("\u5c31\u7eea");
        this.statusIndicator = new LoadingAnimationPanel.StatusIndicator();
        this.statusIndicator.setStatus(LoadingAnimationPanel.StatusIndicator.StatusType.IDLE);
    }

    private JButton createStyledButton(String text, Icon icon) {
        final JButton button = new JButton(text, icon);
        button.setFocusPainted(false);
        button.setFont(button.getFont().deriveFont(1, 11.0f));
        button.setIconTextGap(6);
        button.setMargin(new Insets(4, 8, 4, 8));
        button.setBackground(UIThemeManager.ThemeColors.PRIMARY_BLUE);
        button.setForeground(Color.WHITE);
        button.setMaximumSize(new Dimension(280, 32));
        button.setPreferredSize(new Dimension(280, 32));
        button.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ MinecraftMapGUI this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (button.isEnabled()) {
                    button.setBackground(UIThemeManager.ThemeColors.PRIMARY_BLUE.brighter());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (button.isEnabled()) {
                    button.setBackground(UIThemeManager.ThemeColors.PRIMARY_BLUE);
                }
            }
        });
        return button;
    }

    private JPanel createGroupPanel(String title, Color borderColor) {
        JPanel groupPanel = new JPanel();
        groupPanel.setLayout(new BoxLayout(groupPanel, 1));
        groupPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(borderColor, 1, true), title, 1, 2, new Font("SansSerif", 1, 11), borderColor), BorderFactory.createEmptyBorder(6, 8, 6, 8)));
        groupPanel.setBackground(new Color(borderColor.getRed(), borderColor.getGreen(), borderColor.getBlue(), 20));
        return groupPanel;
    }

    private void showLoadingState(String message) {
        SwingUtilities.invokeLater(() -> {
            this.statusIndicator.setStatus(LoadingAnimationPanel.StatusIndicator.StatusType.WORKING);
            this.progressLabel.setText(message);
        });
    }

    private void hideLoadingState() {
        SwingUtilities.invokeLater(() -> this.statusIndicator.setStatus(LoadingAnimationPanel.StatusIndicator.StatusType.IDLE));
    }

    private void showSuccessState(String message) {
        SwingUtilities.invokeLater(() -> {
            this.statusIndicator.setStatus(LoadingAnimationPanel.StatusIndicator.StatusType.SUCCESS);
            this.progressLabel.setText(message);
        });
    }

    private void showErrorState(String message) {
        SwingUtilities.invokeLater(() -> {
            this.statusIndicator.setStatus(LoadingAnimationPanel.StatusIndicator.StatusType.ERROR);
            this.progressLabel.setText(message);
        });
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        JPanel controlPanel = this.createControlPanel();
        JScrollPane controlScrollPane = new JScrollPane(controlPanel);
        controlScrollPane.setPreferredSize(new Dimension(320, 0));
        controlScrollPane.setMinimumSize(new Dimension(320, 0));
        controlScrollPane.setMaximumSize(new Dimension(320, Integer.MAX_VALUE));
        controlScrollPane.setVerticalScrollBarPolicy(20);
        controlScrollPane.setHorizontalScrollBarPolicy(31);
        controlScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        controlScrollPane.getVerticalScrollBar().setBlockIncrement(64);
        controlScrollPane.setWheelScrollingEnabled(true);
        this.add((Component)controlScrollPane, "West");
        JPanel mapPanel = new JPanel(new BorderLayout());
        mapPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIThemeManager.ThemeColors.MINECRAFT_STONE, 2, true), "\u5730\u56fe\u9884\u89c8", 2, 2, new Font("SansSerif", 1, 14), UIThemeManager.ThemeColors.MINECRAFT_STONE), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JScrollPane mapScrollPane = new JScrollPane(this.mapCanvas);
        mapScrollPane.setMinimumSize(new Dimension(400, 300));
        mapScrollPane.setHorizontalScrollBarPolicy(30);
        mapScrollPane.setVerticalScrollBarPolicy(20);
        mapPanel.add((Component)mapScrollPane, "Center");
        mapPanel.setMinimumSize(new Dimension(400, 300));
        this.add((Component)mapPanel, "Center");
        JPanel statusPanel = new JPanel(new BorderLayout());
        JPanel leftStatusPanel = new JPanel(new FlowLayout(0, 5, 0));
        leftStatusPanel.add(this.statusIndicator);
        leftStatusPanel.add(this.progressLabel);
        statusPanel.add((Component)leftStatusPanel, "West");
        statusPanel.add((Component)this.coordDisplayLabel, "East");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)this.progressBar, "North");
        bottomPanel.add((Component)statusPanel, "South");
        this.add((Component)bottomPanel, "South");
    }

    private JPanel createControlPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIThemeManager.ThemeColors.PRIMARY_BLUE, 1, true), BorderFactory.createEmptyBorder(15, 15, 15, 15)));
        panel.setBackground(Color.WHITE);
        panel.setPreferredSize(new Dimension(300, 0));
        panel.setMinimumSize(new Dimension(300, 0));
        panel.setMaximumSize(new Dimension(300, Integer.MAX_VALUE));
        JPanel fileOperationsGroup = this.createGroupPanel("\u6587\u4ef6\u64cd\u4f5c", UIThemeManager.ThemeColors.PRIMARY_BLUE);
        JButton selectSaveButton = this.createStyledButton("\u9009\u62e9MC\u5b58\u6863", IconManager.getFolderIcon(16));
        selectSaveButton.addActionListener(e -> this.selectSave());
        selectSaveButton.setToolTipText("\u9009\u62e9Minecraft\u5b58\u6863\u6587\u4ef6\u5939");
        fileOperationsGroup.add(selectSaveButton);
        fileOperationsGroup.add(Box.createVerticalStrut(3));
        JButton selectMcaButton = this.createStyledButton("\u9009\u62e9MCA\u6587\u4ef6", IconManager.getFileIcon(16));
        selectMcaButton.addActionListener(e -> this.selectMcaFile());
        selectMcaButton.setToolTipText("\u624b\u52a8\u9009\u62e9MCA\u533a\u57df\u6587\u4ef6");
        fileOperationsGroup.add(selectMcaButton);
        fileOperationsGroup.add(Box.createVerticalStrut(3));
        JButton selectJarButton = this.createStyledButton("\u9009\u62e9MC\u5ba2\u6237\u7aef", IconManager.getFileIcon(16));
        selectJarButton.addActionListener(e -> this.selectMinecraftJar());
        selectJarButton.setToolTipText("\u9009\u62e9Minecraft\u5ba2\u6237\u7aefJAR\u6587\u4ef6");
        fileOperationsGroup.add(selectJarButton);
        fileOperationsGroup.add(Box.createVerticalStrut(3));
        JButton clearCacheButton = this.createStyledButton("\u6e05\u9664\u7f13\u5b58", IconManager.getClearIcon(16));
        clearCacheButton.addActionListener(e -> this.clearPngCache());
        clearCacheButton.setToolTipText("\u5220\u9664\u7a0b\u5e8f\u76ee\u5f55\u4e0b\u7684PNG\u5730\u56fe\u6587\u4ef6\u548c\u7f29\u7565\u56fe");
        clearCacheButton.setBackground(UIThemeManager.ThemeColors.WARNING_ORANGE);
        fileOperationsGroup.add(clearCacheButton);
        fileOperationsGroup.add(Box.createVerticalStrut(3));
        JButton logButton = this.createStyledButton("\u65e5\u5fd7", IconManager.getFileIcon(16));
        logButton.addActionListener(e -> this.openLogWindow());
        logButton.setToolTipText("\u6253\u5f00\u65e5\u5fd7\u7a97\u53e3\u67e5\u770b\u5b9e\u65f6\u65e5\u5fd7\u548c\u5386\u53f2\u8bb0\u5f55");
        logButton.setBackground(UIThemeManager.ThemeColors.PRIMARY_BLUE);
        fileOperationsGroup.add(logButton);
        fileOperationsGroup.add(Box.createVerticalStrut(3));
        JButton renderAllButton = this.createStyledButton("\u6e32\u67d3\u5168\u90e8\u533a\u57df", IconManager.getRefreshIcon(16));
        renderAllButton.addActionListener(e -> this.renderAllAvailableRegions());
        renderAllButton.setToolTipText("\u626b\u63cf\u5e76\u6e32\u67d3\u5b58\u6863\u4e2d\u6240\u6709\u53ef\u7528\u7684\u533a\u57df\u6587\u4ef6");
        renderAllButton.setBackground(UIThemeManager.ThemeColors.SUCCESS_GREEN);
        renderAllButton.setVisible(false);
        fileOperationsGroup.add(renderAllButton);
        this.dynamicModeButton = this.createStyledButton("\u52a8\u6001\u6a21\u5f0f", IconManager.getRefreshIcon(16));
        this.dynamicModeButton.addActionListener(e -> this.toggleDynamicMode());
        this.dynamicModeButton.setToolTipText("\u542f\u7528\u52a8\u6001\u52a0\u8f7d\u6a21\u5f0f\uff0c\u53ea\u6e32\u67d3\u89c6\u53e3\u5185\u7684\u533a\u57df");
        this.dynamicModeButton.setBackground(UIThemeManager.ThemeColors.PRIMARY_BLUE);
        this.dynamicModeButton.setVisible(false);
        fileOperationsGroup.add(this.dynamicModeButton);
        JButton clearMemoryButton = this.createStyledButton("\u6e05\u7406\u5185\u5b58", IconManager.getRefreshIcon(16));
        clearMemoryButton.addActionListener(e -> this.clearDynamicMemory());
        clearMemoryButton.setToolTipText("\u6e05\u7406\u52a8\u6001\u6a21\u5f0f\u4e2d\u5df2\u52a0\u8f7d\u7684\u533a\u57df\uff0c\u91ca\u653e\u5185\u5b58");
        clearMemoryButton.setBackground(UIThemeManager.ThemeColors.WARNING_ORANGE);
        clearMemoryButton.setVisible(false);
        fileOperationsGroup.add(clearMemoryButton);
        panel.add(fileOperationsGroup);
        panel.add(Box.createVerticalStrut(8));
        JPanel saveInfoGroup = this.createGroupPanel("\u5b58\u6863\u4fe1\u606f", UIThemeManager.ThemeColors.SUCCESS_GREEN);
        saveInfoGroup.add(this.saveInfoLabel);
        saveInfoGroup.add(Box.createVerticalStrut(3));
        saveInfoGroup.add(this.playerPosLabel);
        saveInfoGroup.add(Box.createVerticalStrut(3));
        saveInfoGroup.add(this.regionLabel);
        panel.add(saveInfoGroup);
        panel.add(Box.createVerticalStrut(8));
        JPanel renderSettingsGroup = this.createGroupPanel("\u6e32\u67d3\u8bbe\u7f6e", UIThemeManager.ThemeColors.MINECRAFT_BROWN);
        JPanel heightPanel = new JPanel(new BorderLayout());
        heightPanel.setBorder(BorderFactory.createTitledBorder("\u533a\u57df\u9ad8\u5ea6\u8bbe\u7f6e"));
        heightPanel.setOpaque(false);
        JPanel sliderPanel = new JPanel(new BorderLayout());
        sliderPanel.setOpaque(false);
        JLabel sliderLabel = StyledComponents.createStyledLabel("\u9ad8\u5ea6\u8303\u56f4:");
        sliderLabel.setFont(sliderLabel.getFont().deriveFont(1, 12.0f));
        sliderPanel.add((Component)sliderLabel, "North");
        sliderPanel.add((Component)this.heightRangeSlider, "Center");
        JPanel valuePanel = new JPanel(new FlowLayout(1, 10, 5));
        valuePanel.setOpaque(false);
        JPanel minYPanel = new JPanel(new FlowLayout(0, 5, 0));
        minYPanel.setOpaque(false);
        minYPanel.add(StyledComponents.createStyledLabel("\u6700\u5c0fY:"));
        minYPanel.add(this.minYEntry);
        JPanel maxYPanel = new JPanel(new FlowLayout(0, 5, 0));
        maxYPanel.setOpaque(false);
        maxYPanel.add(StyledComponents.createStyledLabel("\u6700\u5927Y:"));
        maxYPanel.add(this.maxYEntry);
        valuePanel.add(minYPanel);
        valuePanel.add(maxYPanel);
        sliderPanel.add((Component)valuePanel, "South");
        heightPanel.add((Component)sliderPanel, "Center");
        this.minYEntry.addActionListener(e -> {
            try {
                int value = Integer.parseInt(this.minYEntry.getText());
                this.heightRangeSlider.setLowerValue(value);
            }
            catch (NumberFormatException ex) {
                this.minYEntry.setText(String.valueOf(this.heightRangeSlider.getLowerValue()));
            }
        });
        this.maxYEntry.addActionListener(e -> {
            try {
                int value = Integer.parseInt(this.maxYEntry.getText());
                this.heightRangeSlider.setUpperValue(value);
            }
            catch (NumberFormatException ex) {
                this.maxYEntry.setText(String.valueOf(this.heightRangeSlider.getUpperValue()));
            }
        });
        renderSettingsGroup.add(heightPanel);
        renderSettingsGroup.add(Box.createVerticalStrut(6));
        JPanel lodPanel = new JPanel(new BorderLayout());
        lodPanel.setBorder(BorderFactory.createTitledBorder("LOD\u91c7\u6837\u7cbe\u5ea6\u8bbe\u7f6e"));
        lodPanel.setOpaque(false);
        JPanel lodSelectPanel = new JPanel(new FlowLayout(0));
        lodSelectPanel.add(new JLabel("\u91c7\u6837\u95f4\u9694:"));
        lodSelectPanel.add(this.lodDropdown);
        lodPanel.add((Component)lodSelectPanel, "North");
        JLabel lodDesc = new JLabel("<html>\u8f83\u5927\u7684\u91c7\u6837\u95f4\u9694\u4f1a\u52a0\u5feb\u6e32\u67d3\u901f\u5ea6\uff0c<br>\u4f46\u964d\u4f4e\u56fe\u50cf\u8d28\u91cf</html>");
        lodDesc.setFont(lodDesc.getFont().deriveFont(10.0f));
        lodPanel.add((Component)lodDesc, "South");
        lodPanel.setVisible(false);
        renderSettingsGroup.add(lodPanel);
        JPanel mcaRangePanel = new JPanel(new BorderLayout());
        mcaRangePanel.setBorder(BorderFactory.createTitledBorder("MCA\u6587\u4ef6\u8303\u56f4"));
        mcaRangePanel.setOpaque(false);
        JPanel mcaSelectPanel = new JPanel(new FlowLayout(0));
        mcaSelectPanel.add(new JLabel("\u6e32\u67d3\u8303\u56f4:"));
        mcaSelectPanel.add(this.mcaRangeDropdown);
        mcaRangePanel.add((Component)mcaSelectPanel, "North");
        JPanel mcaBottomPanel = new JPanel();
        mcaBottomPanel.setLayout(new BoxLayout(mcaBottomPanel, 1));
        JLabel mcaDesc = new JLabel("<html>\u9009\u62e9\u6e32\u67d3\u5468\u56f4\u591a\u5c11\u4e2aMCA\u6587\u4ef6<br>\u66f4\u5927\u8303\u56f4\u9700\u8981\u66f4\u591a\u65f6\u95f4</html>");
        mcaDesc.setFont(mcaDesc.getFont().deriveFont(10.0f));
        mcaBottomPanel.add(mcaDesc);
        this.autoLoadCheckbox.addActionListener(e -> this.toggleAutoLoad());
        mcaBottomPanel.add(this.autoLoadCheckbox);
        mcaRangePanel.add((Component)mcaBottomPanel, "South");
        mcaRangePanel.setVisible(false);
        renderSettingsGroup.add(mcaRangePanel);
        panel.add(renderSettingsGroup);
        panel.add(Box.createVerticalStrut(8));
        JPanel mapOperationsGroup = this.createGroupPanel("\u5730\u56fe\u64cd\u4f5c", UIThemeManager.ThemeColors.WARNING_ORANGE);
        JPanel coordPanel = new JPanel(new BorderLayout());
        coordPanel.setBorder(BorderFactory.createTitledBorder("\u8df3\u8f6c\u5230\u5750\u6807"));
        coordPanel.setOpaque(false);
        JPanel coordInputPanel = new JPanel(new FlowLayout());
        coordInputPanel.add(new JLabel("X:"));
        coordInputPanel.add(this.xCoordEntry);
        coordInputPanel.add(new JLabel("Z:"));
        coordInputPanel.add(this.zCoordEntry);
        coordPanel.add((Component)coordInputPanel, "North");
        JButton gotoButton = this.createStyledButton("\u8df3\u8f6c\u5230\u5750\u6807", IconManager.getJumpIcon(16));
        gotoButton.addActionListener(e -> this.gotoCoords());
        coordPanel.add((Component)gotoButton, "South");
        mapOperationsGroup.add(coordPanel);
        panel.add(mapOperationsGroup);
        panel.add(Box.createVerticalStrut(8));
        JPanel actionsGroup = this.createGroupPanel("\u64cd\u4f5c", UIThemeManager.ThemeColors.DANGER_RED);
        this.confirmSelectionButton.addActionListener(e -> this.confirmSelection());
        actionsGroup.add(this.confirmSelectionButton);
        actionsGroup.add(Box.createVerticalStrut(4));
        this.renderAroundPlayerButton.addActionListener(e -> this.renderAroundPlayer());
        actionsGroup.add(this.renderAroundPlayerButton);
        actionsGroup.add(Box.createVerticalStrut(3));
        this.reRenderButton.addActionListener(e -> this.reRenderCurrentView());
        actionsGroup.add(this.reRenderButton);
        panel.add(actionsGroup);
        panel.add(Box.createVerticalStrut(8));
        this.fileInfoLabel.setFont(this.fileInfoLabel.getFont().deriveFont(10.0f));
        panel.add(this.fileInfoLabel);
        panel.add(Box.createVerticalStrut(20));
        return panel;
    }

    private void setupEventHandlers() {
    }

    private void renderRegion(final int minX, final int maxX, final int minZ, final int maxZ) {
        this.showLoadingState("\u6b63\u5728\u6e32\u67d3\u5730\u56fe\u533a\u57df...");
        this.renderAroundPlayerButton.setEnabled(false);
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(this){
            final /* synthetic */ MinecraftMapGUI this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    int lodLevel = this.this$0.getLodLevel();
                    String regionPath = new File(this.this$0.savePath, "region").getAbsolutePath();
                    BufferedImage image = MapRenderer.renderRegion(regionPath, minX, maxX, minZ, maxZ, lodLevel);
                    if (image != null) {
                        SwingUtilities.invokeLater(() -> {
                            this.this$0.mapImage = image;
                            this.this$0.mapCanvas.setImage(image);
                            double pixelsPerBlock = (double)image.getWidth() / (double)(maxX - minX);
                            this.this$0.mapCanvas.setWorldCoordinateMapping(minX, minZ, pixelsPerBlock);
                            this.this$0.mapCanvas.repaint();
                            this.this$0.saveRenderedData(image, minX, maxX, minZ, maxZ);
                            this.this$0.showSuccessState(String.format("\u6e32\u67d3\u5b8c\u6210 - \u533a\u57df: (%d,%d) \u5230 (%d,%d)", minX, minZ, maxX, maxZ));
                        });
                    } else {
                        SwingUtilities.invokeLater(() -> this.this$0.showErrorState("\u6e32\u67d3\u5931\u8d25"));
                    }
                }
                catch (Exception e) {
                    SwingUtilities.invokeLater(() -> {
                        this.this$0.showErrorState("\u6e32\u67d3\u51fa\u9519: " + e.getMessage());
                        JOptionPane.showMessageDialog(this.this$0, "\u6e32\u67d3\u5931\u8d25: " + e.getMessage(), "\u9519\u8bef", 0);
                    });
                }
                return null;
            }

            @Override
            protected void done() {
                this.this$0.renderAroundPlayerButton.setEnabled(true);
                this.this$0.hideLoadingState();
            }
        };
        worker.execute();
    }

    private int getLodLevel() {
        String selected = (String)this.lodDropdown.getSelectedItem();
        if (selected.contains("1 (")) {
            return 1;
        }
        if (selected.contains("2 (")) {
            return 2;
        }
        if (selected.contains("4 (")) {
            return 4;
        }
        if (selected.contains("8 (")) {
            return 8;
        }
        return 1;
    }

    private void selectSave() {
        int result;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        fileChooser.setDialogTitle("\u9009\u62e9Minecraft\u5b58\u6863\u6587\u4ef6\u5939");
        String defaultPath = this.getDefaultSavesPath();
        if (defaultPath != null) {
            fileChooser.setCurrentDirectory(new File(defaultPath));
        }
        if ((result = fileChooser.showOpenDialog(this)) == 0) {
            File selectedDir = fileChooser.getSelectedFile();
            this.savePath = selectedDir.getAbsolutePath();
            this.saveInfoLabel.setText("\u5f53\u524d\u5b58\u6863: " + selectedDir.getName());
            this.showLoadingState("\u6b63\u5728\u8bfb\u53d6\u5b58\u6863\u4fe1\u606f...");
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    MinecraftMapGUI.this.loadSaveData();
                    return null;
                }

                @Override
                protected void done() {
                    MinecraftMapGUI.this.showSuccessState("\u5b58\u6863\u52a0\u8f7d\u5b8c\u6210");
                    MinecraftMapGUI.this.renderAroundPlayerButton.setEnabled(true);
                    MinecraftMapGUI.this.reRenderButton.setEnabled(true);
                    MinecraftMapGUI.this.toggleAutoLoad();
                    SwingUtilities.invokeLater(() -> {
                        if (!MinecraftMapGUI.this.isDynamicMode) {
                            MinecraftMapGUI.this.enableDynamicMode();
                        }
                    });
                }
            };
            worker.execute();
        }
    }

    private void selectMcaFile() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setDialogTitle("\u9009\u62e9MCA\u533a\u57df\u6587\u4ef6");
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Minecraft\u533a\u57df\u6587\u4ef6 (*.mca)", "mca");
        fileChooser.setFileFilter(filter);
        int result = fileChooser.showOpenDialog(this);
        if (result == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            this.renderSingleMcaFile(selectedFile.getAbsolutePath());
        }
    }

    private String getDefaultSavesPath() {
        String os = System.getProperty("os.name").toLowerCase();
        String userHome = System.getProperty("user.home");
        if (os.contains("win")) {
            return System.getenv("APPDATA") + "\\.minecraft\\saves";
        }
        if (os.contains("mac")) {
            return userHome + "/Library/Application Support/minecraft/saves";
        }
        return userHome + "/.minecraft/saves";
    }

    private void loadSaveData() {
        try {
            this.autoExtractColorsFromSavePath();
            File levelDat = new File(this.savePath, "level.dat");
            this.logManager.info("\u68c0\u67e5level.dat\u6587\u4ef6: " + levelDat.getAbsolutePath(), "MinecraftMapGUI");
            this.logManager.info("level.dat\u662f\u5426\u5b58\u5728: " + levelDat.exists(), "MinecraftMapGUI");
            if (levelDat.exists()) {
                this.playerPos = this.readPlayerPos(levelDat.getAbsolutePath());
                this.logManager.info("\u8bfb\u53d6\u5230\u7684\u73a9\u5bb6\u4f4d\u7f6e: " + (this.playerPos != null ? String.format("X=%.1f, Y=%.1f, Z=%.1f", this.playerPos[0], this.playerPos[1], this.playerPos[2]) : "null"), "MinecraftMapGUI");
                if (this.playerPos != null) {
                    SwingUtilities.invokeLater(() -> this.playerPosLabel.setText(String.format("\u73a9\u5bb6\u4f4d\u7f6e: X:%.1f, Y:%.1f, Z:%.1f", this.playerPos[0], this.playerPos[1], this.playerPos[2])));
                    this.renderAroundPlayer();
                } else {
                    this.logManager.warn("\u65e0\u6cd5\u8bfb\u53d6\u73a9\u5bb6\u4f4d\u7f6e\uff0c\u8df3\u8fc7\u5730\u56fe\u6e32\u67d3", "MinecraftMapGUI");
                }
            } else {
                this.logManager.warn("level.dat\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u83b7\u53d6\u73a9\u5bb6\u4f4d\u7f6e", "MinecraftMapGUI");
            }
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(() -> {
                JOptionPane.showMessageDialog(this, "\u52a0\u8f7d\u5b58\u6863\u65f6\u51fa\u9519: " + e.getMessage(), "\u9519\u8bef", 0);
                this.progressLabel.setText("\u52a0\u8f7d\u5b58\u6863\u5931\u8d25");
            });
        }
    }

    private void autoExtractColorsFromSavePath() {
        SwingUtilities.invokeLater(() -> this.progressLabel.setText("\u6b63\u5728\u4ece\u5b58\u6863\u8def\u5f84\u67e5\u627eMinecraft JAR\u6587\u4ef6\u548cmods..."));
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                boolean success = BlockColors.initializeColorsFromSavePath(MinecraftMapGUI.this.savePath);
                if (success) {
                    SwingUtilities.invokeLater(() -> MinecraftMapGUI.this.progressLabel.setText("\u6210\u529f\u52a0\u8f7dMinecraft\u548cmods\u65b9\u5757\u989c\u8272"));
                    if (MinecraftMapGUI.this.resourceExtractor != null && MinecraftMapGUI.this.resourceExtractor.isExtractionCompleted()) {
                        try {
                            String jsonFile = new File(MinecraftMapGUI.this.programDir, "block_colors.json").getAbsolutePath();
                            String propsFile = new File(MinecraftMapGUI.this.programDir, "extracted_colors.properties").getAbsolutePath();
                            MinecraftMapGUI.this.resourceExtractor.saveExtractedColorsAsJson(jsonFile);
                            MinecraftMapGUI.this.resourceExtractor.saveExtractedColors(propsFile);
                            System.out.println("\u5df2\u4fdd\u5b58\u989c\u8272\u4fe1\u606f\u5230\u6587\u4ef6");
                        }
                        catch (Exception e) {
                            System.err.println("\u4fdd\u5b58\u989c\u8272\u4fe1\u606f\u5931\u8d25: " + e.getMessage());
                        }
                    }
                } else {
                    SwingUtilities.invokeLater(() -> MinecraftMapGUI.this.progressLabel.setText("\u672a\u627e\u5230JAR\u6587\u4ef6\u6216mods\uff0c\u4f7f\u7528\u9ed8\u8ba4\u989c\u8272"));
                }
                return null;
            }

            @Override
            protected void done() {
            }
        };
        worker.execute();
    }

    private void selectMinecraftJar() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".jar");
            }

            @Override
            public String getDescription() {
                return "Minecraft JAR\u6587\u4ef6 (*.jar)";
            }
        });
        int result = fileChooser.showOpenDialog(this);
        if (result == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            this.extractColorsFromJar(selectedFile.getAbsolutePath());
        }
    }

    private void extractColorsFromJar(final String jarPath) {
        this.progressLabel.setText("\u6b63\u5728\u4eceJAR\u6587\u4ef6\u63d0\u53d6\u65b9\u5757\u989c\u8272...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(this){
            final /* synthetic */ MinecraftMapGUI this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected Void doInBackground() throws Exception {
                if (this.this$0.resourceExtractor.extractColorsFromMinecraftJar(jarPath)) {
                    BlockColors.setResourceExtractor(this.this$0.resourceExtractor);
                    String jsonFile = new File(this.this$0.programDir, "block_colors.json").getAbsolutePath();
                    String propsFile = new File(this.this$0.programDir, "extracted_colors.properties").getAbsolutePath();
                    this.this$0.resourceExtractor.saveExtractedColorsAsJson(jsonFile);
                    this.this$0.resourceExtractor.saveExtractedColors(propsFile);
                    SwingUtilities.invokeLater(() -> this.this$0.progressLabel.setText("\u6210\u529f\u63d0\u53d6\u4e86 " + this.this$0.resourceExtractor.getAllExtractedColors().size() + " \u79cd\u65b9\u5757\u989c\u8272"));
                } else {
                    SwingUtilities.invokeLater(() -> this.this$0.progressLabel.setText("JAR\u6587\u4ef6\u989c\u8272\u63d0\u53d6\u5931\u8d25"));
                }
                return null;
            }
        };
        worker.execute();
    }

    private double[] readPlayerPos(String levelDatPath) {
        try {
            NBTReader.NBTCompound nbtFile = NBTReader.readFromFile(levelDatPath);
            try {
                NBTReader.NBTCompound data = nbtFile.getCompound("Data");
                NBTReader.NBTCompound player = data.getCompound("Player");
                NBTReader.NBTList pos = player.getList("Pos");
                double x = ((NBTReader.NBTDouble)pos.get(0)).getValue();
                double y = ((NBTReader.NBTDouble)pos.get(1)).getValue();
                double z = ((NBTReader.NBTDouble)pos.get(2)).getValue();
                return new double[]{x, y, z};
            }
            catch (Exception e) {
                try {
                    NBTReader.NBTCompound data = nbtFile.getCompound("Data");
                    int spawnX = data.getInt("SpawnX");
                    int spawnY = data.getInt("SpawnY");
                    int spawnZ = data.getInt("SpawnZ");
                    return new double[]{spawnX, spawnY, spawnZ};
                }
                catch (Exception e2) {
                    return null;
                }
            }
        }
        catch (Exception e) {
            System.err.println("\u8bfb\u53d6level.dat\u65f6\u51fa\u9519: " + e.getMessage());
            return null;
        }
    }

    private void renderAroundPlayer() {
        File[] allFiles;
        if (this.playerPos == null) {
            return;
        }
        int centerRegionX = (int)(this.playerPos[0] / 512.0);
        int centerRegionZ = (int)(this.playerPos[2] / 512.0);
        int mcaRange = this.getMcaRange();
        int halfRange = mcaRange / 2;
        ArrayList<String> mcaFiles = new ArrayList<String>();
        File regionDir = new File(this.savePath, "region");
        this.logManager.debug("\u5f00\u59cb\u6e32\u67d3\u73a9\u5bb6\u5468\u56f4\u533a\u57df", "MinecraftMapGUI");
        this.logManager.info("\u5b58\u6863\u8def\u5f84: " + this.savePath, "MinecraftMapGUI");
        this.logManager.info("\u533a\u57df\u76ee\u5f55: " + regionDir.getAbsolutePath(), "MinecraftMapGUI");
        this.logManager.info("\u533a\u57df\u76ee\u5f55\u662f\u5426\u5b58\u5728: " + regionDir.exists(), "MinecraftMapGUI");
        this.logManager.info("\u73a9\u5bb6\u4f4d\u7f6e: X=" + this.playerPos[0] + ", Z=" + this.playerPos[2], "MinecraftMapGUI");
        this.logManager.info("\u4e2d\u5fc3\u533a\u57df: r." + centerRegionX + "." + centerRegionZ + ".mca", "MinecraftMapGUI");
        this.logManager.info("\u641c\u7d22\u8303\u56f4: " + mcaRange + "x" + mcaRange, "MinecraftMapGUI");
        if (regionDir.exists() && (allFiles = regionDir.listFiles()) != null) {
            this.logManager.debug("\u533a\u57df\u76ee\u5f55\u4e2d\u7684\u6587\u4ef6\u6570\u91cf: " + allFiles.length, "MinecraftMapGUI");
            for (File file : allFiles) {
                this.logManager.debug("\u53d1\u73b0\u6587\u4ef6: " + file.getName(), "MinecraftMapGUI");
            }
        }
        for (int x = centerRegionX - halfRange; x <= centerRegionX + halfRange; ++x) {
            for (int z = centerRegionZ - halfRange; z <= centerRegionZ + halfRange; ++z) {
                String regionFile = String.format("r.%d.%d.mca", x, z);
                File regionPath = new File(this.savePath, "region/" + regionFile);
                this.logManager.debug("\u68c0\u67e5\u6587\u4ef6: " + regionFile + " - \u5b58\u5728: " + regionPath.exists(), "MinecraftMapGUI");
                if (!regionPath.exists()) continue;
                mcaFiles.add(regionPath.getAbsolutePath());
            }
        }
        if (!mcaFiles.isEmpty()) {
            SwingUtilities.invokeLater(() -> this.progressLabel.setText(String.format("\u6b63\u5728\u6e32\u67d3 %dx%d \u533a\u57df (%d\u4e2a\u6587\u4ef6)\uff0c\u73a9\u5bb6\u4f4d\u7f6e: X:%.1f, Z:%.1f...", mcaRange, mcaRange, mcaFiles.size(), this.playerPos[0], this.playerPos[2])));
            this.currentRegion = new Point(centerRegionX, centerRegionZ);
            if (mcaFiles.size() == 1) {
                this.renderMap((String)mcaFiles.get(0));
            } else {
                this.renderMultipleMcaFiles(mcaFiles, centerRegionX - halfRange, centerRegionZ - halfRange, mcaRange);
            }
        } else {
            SwingUtilities.invokeLater(() -> this.progressLabel.setText(String.format("\u627e\u4e0d\u5230\u73a9\u5bb6\u5468\u56f4\u7684\u533a\u57df\u6587\u4ef6 (\u4e2d\u5fc3: r.%d.%d.mca)", centerRegionX, centerRegionZ)));
        }
    }

    private int getMcaRange() {
        String selected = (String)this.mcaRangeDropdown.getSelectedItem();
        if (selected.contains("3x3")) {
            return 3;
        }
        if (selected.contains("5x5")) {
            return 5;
        }
        if (selected.contains("7x7")) {
            return 7;
        }
        return 1;
    }

    private void renderMultipleMcaFiles(final List<String> mcaFiles, int startRegionX, int startRegionZ, final int gridSize) {
        SwingWorker<BufferedImage, Void> worker = new SwingWorker<BufferedImage, Void>(this){
            final /* synthetic */ MinecraftMapGUI this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected BufferedImage doInBackground() throws Exception {
                MapRenderer.ProgressCallback progressCallback = new MapRenderer.ProgressCallback(){

                    @Override
                    public void onProgress(int processed, int total, double speed, Set<String> foundBlocks) {
                        if (total == 0) {
                            return;
                        }
                        int percent = Math.min(100, processed * 100 / total);
                        SwingUtilities.invokeLater(() -> {
                            this$0.progressBar.setValue(percent);
                            this$0.progressBar.setString(String.format("%d%% (%d/%d) %.1f\u533a\u5757/\u79d2", percent, processed, total, speed));
                        });
                    }

                    @Override
                    public void onProgressiveRender(BufferedImage partialImage, int completedChunks, int totalChunks) {
                    }
                };
                int maxWorkers = Math.min(Runtime.getRuntime().availableProcessors(), 4);
                MapRenderer renderer = new MapRenderer(maxWorkers, progressCallback);
                try {
                    int minRegionX = Integer.MAX_VALUE;
                    int maxRegionX = Integer.MIN_VALUE;
                    int minRegionZ = Integer.MAX_VALUE;
                    int maxRegionZ = Integer.MIN_VALUE;
                    HashMap<String, int[]> regionCoords = new HashMap<String, int[]>();
                    for (String mcaFile : mcaFiles) {
                        String fileName = new File(mcaFile).getName();
                        String[] parts = fileName.replace("r.", "").replace(".mca", "").split("\\.");
                        if (parts.length != 2) continue;
                        int regionX = Integer.parseInt(parts[0]);
                        int regionZ = Integer.parseInt(parts[1]);
                        regionCoords.put(mcaFile, new int[]{regionX, regionZ});
                        minRegionX = Math.min(minRegionX, regionX);
                        maxRegionX = Math.max(maxRegionX, regionX);
                        minRegionZ = Math.min(minRegionZ, regionZ);
                        maxRegionZ = Math.max(maxRegionZ, regionZ);
                    }
                    int totalWidth = (maxRegionX - minRegionX + 1) * 512;
                    int totalHeight = (maxRegionZ - minRegionZ + 1) * 512;
                    System.out.printf("\u6e32\u67d3\u533a\u57df\u8303\u56f4: (%d,%d) \u5230 (%d,%d), \u603b\u5c3a\u5bf8: %dx%d\n", minRegionX, minRegionZ, maxRegionX, maxRegionZ, totalWidth, totalHeight);
                    BufferedImage combinedImage = new BufferedImage(totalWidth, totalHeight, 1);
                    Graphics2D g2d = combinedImage.createGraphics();
                    g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    g2d.setColor(new Color(32, 32, 32));
                    g2d.fillRect(0, 0, totalWidth, totalHeight);
                    int processedCount = 0;
                    for (String mcaFile : mcaFiles) {
                        BufferedImage regionImage;
                        int[] coords = (int[])regionCoords.get(mcaFile);
                        if (coords == null) continue;
                        int regionX = coords[0];
                        int regionZ = coords[1];
                        System.out.printf("\u6e32\u67d3\u533a\u57df %d/%d: r.%d.%d.mca\n", ++processedCount, mcaFiles.size(), regionX, regionZ);
                        MapRenderer.BlockInfo[][] topBlocks = renderer.getTopBlocks(mcaFile, 32, 1);
                        if (topBlocks == null || (regionImage = renderer.renderToPng(topBlocks, 1)) == null) continue;
                        int offsetX = (regionX - minRegionX) * 512;
                        int offsetY = (regionZ - minRegionZ) * 512;
                        System.out.printf("  -> \u653e\u7f6e\u5728\u4f4d\u7f6e: (%d, %d)\n", offsetX, offsetY);
                        g2d.drawImage((Image)regionImage, offsetX, offsetY, null);
                    }
                    g2d.dispose();
                    this.this$0.lastMultiRenderMinRegionX = minRegionX;
                    this.this$0.lastMultiRenderMinRegionZ = minRegionZ;
                    BufferedImage bufferedImage = combinedImage;
                    return bufferedImage;
                }
                finally {
                    renderer.shutdown();
                }
            }

            @Override
            protected void done() {
                try {
                    BufferedImage image = (BufferedImage)this.get();
                    if (image != null) {
                        this.this$0.mapImage = image;
                        this.this$0.mapCanvas.setImage(image);
                        int worldMinX = this.this$0.lastMultiRenderMinRegionX * 512;
                        int worldMinZ = this.this$0.lastMultiRenderMinRegionZ * 512;
                        double pixelsPerBlock = 1.0;
                        this.this$0.mapCanvas.setWorldCoordinateMapping(worldMinX, worldMinZ, pixelsPerBlock);
                        this.this$0.renderAroundPlayerButton.setEnabled(true);
                        this.this$0.progressLabel.setText(String.format("\u591a\u533a\u57df\u5730\u56fe\u6e32\u67d3\u5b8c\u6210\uff0c\u56fe\u7247\u5c3a\u5bf8: %dx%d", image.getWidth(), image.getHeight()));
                        this.this$0.progressBar.setValue(100);
                        this.this$0.progressBar.setString("\u5b8c\u6210");
                        this.this$0.saveRenderedImage(image, String.format("multi_region_%dx%d", gridSize, gridSize));
                    } else {
                        this.this$0.progressLabel.setText("\u591a\u533a\u57df\u5730\u56fe\u6e32\u67d3\u5931\u8d25\uff1a\u65e0\u6cd5\u83b7\u53d6\u65b9\u5757\u6570\u636e");
                        this.this$0.progressBar.setValue(0);
                        this.this$0.progressBar.setString("\u5931\u8d25");
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this.this$0, "\u6e32\u67d3\u591a\u533a\u57df\u5730\u56fe\u65f6\u51fa\u9519: " + e.getMessage(), "\u9519\u8bef", 0);
                    this.this$0.progressLabel.setText("\u591a\u533a\u57df\u5730\u56fe\u6e32\u67d3\u5931\u8d25");
                    this.this$0.progressBar.setValue(0);
                    this.this$0.progressBar.setString("\u5931\u8d25");
                }
            }
        };
        worker.execute();
    }

    private void renderSingleMcaFile(String mcaFilePath) {
        SwingUtilities.invokeLater(() -> this.progressLabel.setText("\u6b63\u5728\u6e32\u67d3MCA\u6587\u4ef6: " + new File(mcaFilePath).getName()));
        this.renderMap(mcaFilePath);
    }

    private void renderMap(final String regionPath) {
        SwingWorker<BufferedImage, Void> worker = new SwingWorker<BufferedImage, Void>(this){
            final /* synthetic */ MinecraftMapGUI this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected BufferedImage doInBackground() throws Exception {
                MapRenderer.ProgressCallback progressCallback = new MapRenderer.ProgressCallback(){

                    @Override
                    public void onProgress(int processed, int total, double speed, Set<String> foundBlocks) {
                        if (total == 0) {
                            return;
                        }
                        int percent = Math.min(100, processed * 100 / total);
                        SwingUtilities.invokeLater(() -> {
                            this$0.progressBar.setValue(percent);
                            this$0.progressBar.setString(String.format("%d%% (%d/%d) %.1f\u533a\u5757/\u79d2", percent, processed, total, speed));
                        });
                    }

                    @Override
                    public void onProgressiveRender(BufferedImage partialImage, int completedChunks, int totalChunks) {
                    }
                };
                int maxWorkers = Math.min(Runtime.getRuntime().availableProcessors(), 4);
                MapRenderer renderer = new MapRenderer(maxWorkers, progressCallback);
                try {
                    MapRenderer.BlockInfo[][] topBlocks = renderer.getTopBlocks(regionPath, 32, 1);
                    if (topBlocks != null) {
                        BufferedImage image = renderer.renderToPng(topBlocks, 1);
                        if (image != null) {
                            this.this$0.saveRenderedImage(image, regionPath);
                        }
                        BufferedImage bufferedImage = image;
                        return bufferedImage;
                    }
                    BufferedImage bufferedImage = null;
                    return bufferedImage;
                }
                finally {
                    renderer.shutdown();
                }
            }

            @Override
            protected void done() {
                try {
                    BufferedImage image = (BufferedImage)this.get();
                    if (image != null) {
                        this.this$0.mapImage = image;
                        this.this$0.mapCanvas.setImage(image);
                        if (this.this$0.currentRegion != null) {
                            int worldMinX = ((MinecraftMapGUI)this.this$0).currentRegion.x * 512;
                            int worldMinZ = ((MinecraftMapGUI)this.this$0).currentRegion.y * 512;
                            double pixelsPerBlock = (double)image.getWidth() / 512.0;
                            this.this$0.mapCanvas.setWorldCoordinateMapping(worldMinX, worldMinZ, pixelsPerBlock);
                        }
                        this.this$0.progressLabel.setText(String.format("\u5730\u56fe\u6e32\u67d3\u5b8c\u6210\uff0c\u56fe\u7247\u5c3a\u5bf8: %dx%d", image.getWidth(), image.getHeight()));
                        this.this$0.progressBar.setValue(100);
                        this.this$0.progressBar.setString("\u5b8c\u6210");
                    } else {
                        this.this$0.progressLabel.setText("\u5730\u56fe\u6e32\u67d3\u5931\u8d25\uff1a\u65e0\u6cd5\u83b7\u53d6\u65b9\u5757\u6570\u636e");
                        this.this$0.progressBar.setValue(0);
                        this.this$0.progressBar.setString("\u5931\u8d25");
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this.this$0, "\u6e32\u67d3\u5730\u56fe\u65f6\u51fa\u9519: " + e.getMessage(), "\u9519\u8bef", 0);
                    this.this$0.progressLabel.setText("\u5730\u56fe\u6e32\u67d3\u5931\u8d25");
                    this.this$0.progressBar.setValue(0);
                    this.this$0.progressBar.setString("\u5931\u8d25");
                }
            }
        };
        worker.execute();
    }

    private void saveRenderedImage(BufferedImage image, String regionPath) {
        try {
            File regionFile = new File(regionPath);
            String regionFileName = regionFile.getName();
            String baseName = regionFileName.replaceAll("\\.mca$", "");
            long timestamp = System.currentTimeMillis();
            String currentDir = System.getProperty("user.dir");
            String outputFileName = String.format("%s_map_%d.png", baseName, timestamp);
            String outputPath = new File(currentDir, outputFileName).getAbsolutePath();
            ImageIO.write((RenderedImage)image, "PNG", new File(outputPath));
            SwingUtilities.invokeLater(() -> {
                this.fileInfoLabel.setText(String.format("<html>\u6e32\u67d3\u56fe\u50cf\u5df2\u4fdd\u5b58:<br>%s<br><br>\u56fe\u50cf\u5c3a\u5bf8: %dx%d</html>", outputPath, image.getWidth(), image.getHeight()));
                this.progressLabel.setText("\u56fe\u50cf\u5df2\u4fdd\u5b58\u5230: " + outputFileName);
            });
            System.out.println("\u56fe\u50cf\u5df2\u4fdd\u5b58\u5230: " + outputPath);
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, "\u4fdd\u5b58\u56fe\u50cf\u5931\u8d25: " + e.getMessage(), "\u9519\u8bef", 0));
            System.err.println("\u4fdd\u5b58\u56fe\u50cf\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void saveRenderedData(BufferedImage image, int minX, int maxX, int minZ, int maxZ) {
        try {
            long timestamp = System.currentTimeMillis();
            String baseName = String.format("region_%d_%d_%d_%d", minX, minZ, maxX, maxZ);
            String imageFileName = String.format("%s_map_%d.png", baseName, timestamp);
            String imagePath = new File(this.programDir, imageFileName).getAbsolutePath();
            ImageIO.write((RenderedImage)image, "PNG", new File(imagePath));
            SwingUtilities.invokeLater(() -> this.fileInfoLabel.setText(String.format("<html>\u5df2\u4fdd\u5b58:<br>%s<br>\u5c3a\u5bf8: %dx%d</html>", imageFileName, image.getWidth(), image.getHeight())));
            System.out.println("\u5730\u56fe\u5df2\u4fdd\u5b58\u5230: " + imagePath);
        }
        catch (Exception e) {
            System.err.println("\u4fdd\u5b58\u6570\u636e\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void gotoCoords() {
        try {
            int x = Integer.parseInt(this.xCoordEntry.getText().trim());
            int z = Integer.parseInt(this.zCoordEntry.getText().trim());
            if (this.mapCanvas != null && this.mapCanvas.getImage() != null) {
                Point worldCoord = new Point(x, z);
                this.mapCanvas.jumpToWorldCoordinate(worldCoord);
                this.progressLabel.setText(String.format("\u5df2\u8df3\u8f6c\u5230\u5750\u6807 (%d, %d)", x, z));
            } else {
                this.progressLabel.setText("\u8bf7\u5148\u52a0\u8f7d\u5730\u56fe\u540e\u518d\u8df3\u8f6c\u5750\u6807");
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u8f93\u5165\u6709\u6548\u7684\u5750\u6807\u6570\u5b57", "\u9519\u8bef", 0);
        }
    }

    private void confirmSelection() {
        if (this.isDynamicMode && this.dynamicMapCanvas != null) {
            this.dynamicMapCanvas.confirmCurrentSelection();
        } else if (this.mapCanvas != null) {
            this.mapCanvas.confirmCurrentSelection();
        }
        this.confirmSelectionButton.setEnabled(false);
    }

    private void toggleAutoLoad() {
        boolean enabled = this.autoLoadCheckbox.isSelected();
        if (this.mapCanvas != null) {
            this.mapCanvas.enableAutoViewportManagement(enabled);
        }
        if (enabled) {
            this.progressLabel.setText("\u5df2\u542f\u7528\u81ea\u52a8\u52a0\u8f7d\u6a21\u5f0f - \u5730\u56fe\u5c06\u6839\u636e\u89c6\u91ce\u81ea\u52a8\u52a0\u8f7d");
        } else {
            this.progressLabel.setText("\u5df2\u7981\u7528\u81ea\u52a8\u52a0\u8f7d\u6a21\u5f0f");
        }
    }

    private void loadRegionInBackground(int regionX, int regionZ) {
        if (!this.autoLoadCheckbox.isSelected()) {
            return;
        }
        Future<BufferedImage> future = this.backgroundExecutor.submit(() -> {
            String regionFile = String.format("r.%d.%d.mca", regionX, regionZ);
            File regionPath = new File(this.savePath, "region/" + regionFile);
            if (!regionPath.exists()) {
                System.out.printf("\u533a\u57df\u6587\u4ef6\u4e0d\u5b58\u5728: %s\n", regionFile);
                return null;
            }
            System.out.printf("\u5f00\u59cb\u6e32\u67d3\u533a\u57df: %s (\u4e16\u754c\u5750\u6807: %d, %d)\n", regionFile, regionX * 512, regionZ * 512);
            MapRenderer.ProgressCallback progressCallback = new MapRenderer.ProgressCallback(){

                @Override
                public void onProgress(int processed, int total, double speed, Set<String> foundBlocks) {
                }

                @Override
                public void onProgressiveRender(BufferedImage partialImage, int completedChunks, int totalChunks) {
                }
            };
            MapRenderer renderer = new MapRenderer(1, progressCallback);
            try {
                MapRenderer.BlockInfo[][] topBlocks = renderer.getTopBlocks(regionPath.getAbsolutePath(), 32, 1);
                if (topBlocks != null) {
                    BufferedImage regionImage = renderer.renderToPng(topBlocks, 1);
                    if (regionImage != null) {
                        System.out.printf("\u6210\u529f\u6e32\u67d3\u533a\u57df: %s, \u56fe\u50cf\u5c3a\u5bf8: %dx%d\n", regionFile, regionImage.getWidth(), regionImage.getHeight());
                    }
                    BufferedImage bufferedImage = regionImage;
                    return bufferedImage;
                }
                BufferedImage bufferedImage = null;
                return bufferedImage;
            }
            catch (Exception e) {
                System.err.printf("\u6e32\u67d3\u533a\u57df %s \u65f6\u51fa\u9519: %s\n", regionFile, e.getMessage());
                BufferedImage bufferedImage = null;
                return bufferedImage;
            }
            finally {
                renderer.shutdown();
            }
        });
        this.backgroundExecutor.submit(() -> {
            try {
                BufferedImage regionImage = (BufferedImage)future.get();
                if (regionImage != null) {
                    this.dynamicMapManager.addRegion(regionX, regionZ, regionImage);
                    SwingUtilities.invokeLater(() -> {
                        BufferedImage combinedImage = this.dynamicMapManager.getCombinedImage();
                        if (combinedImage != null) {
                            Point worldOrigin = this.dynamicMapManager.getWorldOrigin();
                            this.mapCanvas.setImageKeepWorldCenter(combinedImage, worldOrigin.x, worldOrigin.y);
                            this.revalidate();
                            this.repaint();
                            this.progressLabel.setText(String.format("\u52a8\u6001\u5730\u56fe\u5df2\u66f4\u65b0 - \u5df2\u52a0\u8f7d %d \u4e2a\u533a\u57df", this.dynamicMapManager.getRegionCount()));
                        }
                    });
                    System.out.printf("\u6210\u529f\u52a0\u8f7d\u533a\u57df r.%d.%d.mca\n", regionX, regionZ);
                }
            }
            catch (Exception throwable) {
                System.err.printf("\u52a0\u8f7d\u533a\u57df r.%d.%d.mca \u5931\u8d25: %s\n", regionX, regionZ, throwable.getMessage());
            }
        });
    }

    private void unloadRegionInBackground(int regionX, int regionZ) {
        this.dynamicMapManager.removeRegion(regionX, regionZ);
        SwingUtilities.invokeLater(() -> {
            BufferedImage combinedImage = this.dynamicMapManager.getCombinedImage();
            if (combinedImage != null) {
                Point worldOrigin = this.dynamicMapManager.getWorldOrigin();
                this.mapCanvas.setImageKeepWorldCenter(combinedImage, worldOrigin.x, worldOrigin.y);
                this.revalidate();
                this.repaint();
                this.progressLabel.setText(String.format("\u52a8\u6001\u5730\u56fe\u5df2\u66f4\u65b0 - \u5df2\u52a0\u8f7d %d \u4e2a\u533a\u57df", this.dynamicMapManager.getRegionCount()));
            } else {
                this.mapCanvas.setImage(null);
                this.progressLabel.setText("\u6240\u6709\u533a\u57df\u5df2\u5378\u8f7d");
            }
        });
        System.out.printf("\u5378\u8f7d\u533a\u57df r.%d.%d.mca\n", regionX, regionZ);
    }

    private void reRenderCurrentView() {
        if (this.dynamicMapManager == null) {
            return;
        }
        this.dynamicMapManager.clear();
        this.mapCanvas.setImage(null);
        if (this.autoLoadCheckbox.isSelected()) {
            this.progressLabel.setText("\u6b63\u5728\u91cd\u65b0\u6e32\u67d3\u5f53\u524d\u89c6\u56fe...");
            SwingUtilities.invokeLater(() -> {
                if (this.mapCanvas != null) {
                    this.mapCanvas.forceViewportUpdate();
                }
                this.progressLabel.setText("\u6b63\u5728\u91cd\u65b0\u52a0\u8f7d\u533a\u57df...");
            });
        } else {
            this.progressLabel.setText("\u8bf7\u5148\u542f\u7528\u81ea\u52a8\u52a0\u8f7d\u529f\u80fd");
        }
    }

    private void loadWorldFromPath(final String worldPath) {
        File worldDir = new File(worldPath);
        if (!worldDir.exists() || !worldDir.isDirectory()) {
            System.err.println("Invalid world path: " + worldPath);
            return;
        }
        System.out.println("Blender\u6a21\u5f0f\uff1a\u6b63\u5728\u52a0\u8f7d\u4e16\u754c " + worldPath);
        this.savePath = worldPath;
        SwingUtilities.invokeLater(() -> {
            if (this.saveInfoLabel != null) {
                this.saveInfoLabel.setText("\u5f53\u524d\u5b58\u6863: " + worldDir.getName());
            }
            this.progressLabel.setText("Blender\u6a21\u5f0f\uff1a\u6b63\u5728\u8bfb\u53d6\u5b58\u6863\u4fe1\u606f...");
        });
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(this){
            final /* synthetic */ MinecraftMapGUI this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected Void doInBackground() throws Exception {
                this.this$0.loadSaveData();
                return null;
            }

            @Override
            protected void done() {
                SwingUtilities.invokeLater(() -> {
                    this.this$0.progressLabel.setText("Blender\u6a21\u5f0f\uff1a\u5b58\u6863\u52a0\u8f7d\u5b8c\u6210\uff0c\u542f\u7528\u81ea\u52a8\u52a0\u8f7d");
                    this.this$0.autoLoadCheckbox.setSelected(true);
                    this.this$0.toggleAutoLoad();
                    if (!this.this$0.isDynamicMode) {
                        this.this$0.enableDynamicMode();
                    }
                    System.out.println("Blender\u6a21\u5f0f\uff1a\u6210\u529f\u52a0\u8f7d\u4e16\u754c\u5e76\u542f\u7528\u81ea\u52a8\u52a0\u8f7d\u548c\u52a8\u6001\u6a21\u5f0f " + worldPath);
                });
            }
        };
        worker.execute();
    }

    private void outputCoordinatesToFile(int minX, int minZ, int maxX, int maxZ) {
        try {
            int actualMinY = this.blenderMinY;
            int actualMaxY = this.blenderMaxY;
            try (FileWriter writer = new FileWriter(this.outputFilePath);){
                writer.write("{\n");
                writer.write("  \"minX\": " + minX + ",\n");
                writer.write("  \"minY\": " + actualMinY + ",\n");
                writer.write("  \"minZ\": " + minZ + ",\n");
                writer.write("  \"maxX\": " + maxX + ",\n");
                writer.write("  \"maxY\": " + actualMaxY + ",\n");
                writer.write("  \"maxZ\": " + maxZ + ",\n");
                writer.write("  \"timestamp\": " + System.currentTimeMillis() + "\n");
                writer.write("}\n");
            }
            System.out.printf("Blender\u6a21\u5f0f\uff1a\u5750\u6807\u5df2\u8f93\u51fa\u5230\u6587\u4ef6 %s\n", this.outputFilePath);
            System.out.printf("XYZ\u8303\u56f4: (%d,%d,%d) \u5230 (%d,%d,%d)\n", minX, actualMinY, minZ, maxX, actualMaxY, maxZ);
            SwingUtilities.invokeLater(() -> {
                JOptionPane.showMessageDialog(this, String.format("\u5750\u6807\u5df2\u9009\u62e9\u5e76\u53d1\u9001\u5230Blender:\n\u8d77\u59cb\u5750\u6807: (%d, %d, %d)\n\u7ed3\u675f\u5750\u6807: (%d, %d, %d)", minX, actualMinY, minZ, maxX, actualMaxY, maxZ), "\u5750\u6807\u5df2\u786e\u8ba4", 1);
                System.exit(0);
            });
        }
        catch (Exception e) {
            System.err.println("Blender\u6a21\u5f0f\uff1a\u8f93\u51fa\u5750\u6807\u6587\u4ef6\u5931\u8d25 " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void clearPngCache() {
        int result = JOptionPane.showConfirmDialog(this, "<html>\u786e\u5b9a\u8981\u6e05\u9664PNG\u7f13\u5b58\u5417\uff1f<br><br>\u8fd9\u5c06\u5220\u9664\u7a0b\u5e8f\u76ee\u5f55\u4e0b\u7684\u6240\u6709\u5730\u56fePNG\u6587\u4ef6\u548c\u7f29\u7565\u56fe\uff0c<br>\u5305\u62ec\uff1a<br>\u2022 *_map_*.png (\u5730\u56fe\u6587\u4ef6)<br>\u2022 *_thumbnail.png (\u7f29\u7565\u56fe\u6587\u4ef6)<br>\u2022 region_*.png (\u533a\u57df\u6587\u4ef6)<br>\u2022 r.*.png (MCA\u6587\u4ef6)<br><br>\u6b64\u64cd\u4f5c\u4e0d\u53ef\u64a4\u9500\uff01</html>", "\u786e\u8ba4\u6e05\u9664\u7f13\u5b58", 0, 2);
        if (result != 0) {
            return;
        }
        SwingWorker<FileUtils.CacheCleanupResult, Void> worker = new SwingWorker<FileUtils.CacheCleanupResult, Void>(){

            @Override
            protected FileUtils.CacheCleanupResult doInBackground() throws Exception {
                SwingUtilities.invokeLater(() -> MinecraftMapGUI.this.progressLabel.setText("\u6b63\u5728\u6e05\u7406PNG\u7f13\u5b58\u6587\u4ef6..."));
                return FileUtils.cleanupPngCache(MinecraftMapGUI.this.programDir);
            }

            @Override
            protected void done() {
                try {
                    FileUtils.CacheCleanupResult cleanupResult = (FileUtils.CacheCleanupResult)this.get();
                    String message = cleanupResult.getSummary();
                    MinecraftMapGUI.this.progressLabel.setText(message);
                    int messageType = cleanupResult.isSuccess() ? 1 : 0;
                    JOptionPane.showMessageDialog(MinecraftMapGUI.this, message, "\u7f13\u5b58\u6e05\u7406\u7ed3\u679c", messageType);
                }
                catch (Exception e) {
                    String errorMsg = "\u6e05\u7406\u7f13\u5b58\u65f6\u51fa\u9519: " + e.getMessage();
                    MinecraftMapGUI.this.progressLabel.setText(errorMsg);
                    JOptionPane.showMessageDialog(MinecraftMapGUI.this, errorMsg, "\u9519\u8bef", 0);
                }
            }
        };
        worker.execute();
    }

    private void openLogWindow() {
        if (this.logWindow == null) {
            this.logWindow = new LogWindow();
            this.logManager.info("\u521b\u5efa\u65b0\u7684\u65e5\u5fd7\u7a97\u53e3", "MinecraftMapGUI");
        }
        if (!this.logWindow.isVisible()) {
            this.logWindow.setVisible(true);
            this.logManager.info("\u663e\u793a\u65e5\u5fd7\u7a97\u53e3", "MinecraftMapGUI");
        } else {
            this.logWindow.toFront();
            this.logWindow.requestFocus();
            this.logManager.debug("\u65e5\u5fd7\u7a97\u53e3\u5df2\u7f6e\u4e8e\u524d\u53f0", "MinecraftMapGUI");
        }
    }

    private void renderAllAvailableRegions() {
        if (this.savePath == null || this.savePath.isEmpty()) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u5148\u9009\u62e9\u4e00\u4e2aMinecraft\u5b58\u6863", "\u63d0\u793a", 2);
            return;
        }
        this.logManager.info("\u5f00\u59cb\u626b\u63cf\u6240\u6709\u53ef\u7528\u533a\u57df", "MinecraftMapGUI");
        SwingWorker<BufferedImage, Void> worker = new SwingWorker<BufferedImage, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected BufferedImage doInBackground() throws Exception {
                File regionDir = new File(MinecraftMapGUI.this.savePath, "region");
                if (!regionDir.exists()) {
                    MinecraftMapGUI.this.logManager.error("\u533a\u57df\u76ee\u5f55\u4e0d\u5b58\u5728: " + regionDir.getAbsolutePath(), "MinecraftMapGUI");
                    return null;
                }
                File[] mcaFiles = regionDir.listFiles((dir, name) -> name.endsWith(".mca"));
                if (mcaFiles == null || mcaFiles.length == 0) {
                    MinecraftMapGUI.this.logManager.warn("\u672a\u627e\u5230\u4efb\u4f55.mca\u533a\u57df\u6587\u4ef6", "MinecraftMapGUI");
                    return null;
                }
                MinecraftMapGUI.this.logManager.info("\u53d1\u73b0 " + mcaFiles.length + " \u4e2a\u533a\u57df\u6587\u4ef6", "MinecraftMapGUI");
                int[] regionBounds = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE};
                ArrayList<String> validMcaFiles = new ArrayList<String>();
                HashMap<String, int[]> regionCoords = new HashMap<String, int[]>();
                for (File mcaFile : mcaFiles) {
                    String fileName = mcaFile.getName();
                    if (!fileName.matches("r\\.-?\\d+\\.-?\\d+\\.mca")) continue;
                    String[] parts = fileName.replace(".mca", "").split("\\.");
                    try {
                        int regionX = Integer.parseInt(parts[1]);
                        int regionZ = Integer.parseInt(parts[2]);
                        regionBounds[0] = Math.min(regionBounds[0], regionX);
                        regionBounds[1] = Math.max(regionBounds[1], regionX);
                        regionBounds[2] = Math.min(regionBounds[2], regionZ);
                        regionBounds[3] = Math.max(regionBounds[3], regionZ);
                        validMcaFiles.add(mcaFile.getAbsolutePath());
                        regionCoords.put(mcaFile.getAbsolutePath(), new int[]{regionX, regionZ});
                        MinecraftMapGUI.this.logManager.debug("\u53d1\u73b0\u533a\u57df: r." + regionX + "." + regionZ + ".mca", "MinecraftMapGUI");
                    }
                    catch (NumberFormatException e) {
                        MinecraftMapGUI.this.logManager.warn("\u65e0\u6cd5\u89e3\u6790\u533a\u57df\u6587\u4ef6\u540d: " + fileName, "MinecraftMapGUI");
                    }
                }
                if (validMcaFiles.isEmpty()) {
                    MinecraftMapGUI.this.logManager.error("\u6ca1\u6709\u627e\u5230\u6709\u6548\u7684\u533a\u57df\u6587\u4ef6", "MinecraftMapGUI");
                    return null;
                }
                MinecraftMapGUI.this.logManager.info(String.format("\u533a\u57df\u8303\u56f4: X[%d, %d], Z[%d, %d]", regionBounds[0], regionBounds[1], regionBounds[2], regionBounds[3]), "MinecraftMapGUI");
                int totalWidth = (regionBounds[1] - regionBounds[0] + 1) * 512;
                int totalHeight = (regionBounds[3] - regionBounds[2] + 1) * 512;
                MinecraftMapGUI.this.logManager.info(String.format("\u521b\u5efa\u5927\u56fe\u50cf: %dx%d \u50cf\u7d20", totalWidth, totalHeight), "MinecraftMapGUI");
                SwingUtilities.invokeLater(() -> MinecraftMapGUI.this.progressLabel.setText(String.format("\u6b63\u5728\u6e32\u67d3\u5168\u90e8\u533a\u57df (%d\u4e2a\u6587\u4ef6)\uff0c\u56fe\u50cf\u5927\u5c0f: %dx%d...", validMcaFiles.size(), totalWidth, totalHeight)));
                BufferedImage combinedImage = new BufferedImage(totalWidth, totalHeight, 1);
                Graphics2D g2d = combinedImage.createGraphics();
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2d.setColor(new Color(32, 32, 32));
                g2d.fillRect(0, 0, totalWidth, totalHeight);
                MapRenderer.ProgressCallback progressCallback = new MapRenderer.ProgressCallback(){

                    @Override
                    public void onProgress(int processed, int total, double speed, Set<String> foundBlocks) {
                        SwingUtilities.invokeLater(() -> {
                            int percent = total > 0 ? processed * 100 / total : 0;
                            MinecraftMapGUI.this.progressLabel.setText(String.format("\u6e32\u67d3\u8fdb\u5ea6: %d%% (%d/%d) - %.1f\u533a\u5757/\u79d2", percent, processed, total, speed));
                        });
                    }

                    @Override
                    public void onProgressiveRender(BufferedImage partialImage, int completedChunks, int totalChunks) {
                    }
                };
                int maxWorkers = Math.min(Runtime.getRuntime().availableProcessors(), 4);
                MapRenderer renderer = new MapRenderer(maxWorkers, progressCallback);
                try {
                    int processedCount = 0;
                    for (String mcaFile : validMcaFiles) {
                        int[] coords = (int[])regionCoords.get(mcaFile);
                        if (coords == null) continue;
                        int regionX = coords[0];
                        int regionZ = coords[1];
                        int currentCount = ++processedCount;
                        MinecraftMapGUI.this.logManager.info(String.format("\u6e32\u67d3\u533a\u57df %d/%d: r.%d.%d.mca", currentCount, validMcaFiles.size(), regionX, regionZ), "MinecraftMapGUI");
                        SwingUtilities.invokeLater(() -> MinecraftMapGUI.this.progressLabel.setText(String.format("\u6e32\u67d3\u533a\u57df %d/%d: r.%d.%d.mca", currentCount, validMcaFiles.size(), regionX, regionZ)));
                        MapRenderer.BlockInfo[][] topBlocks = renderer.getTopBlocks(mcaFile, 32, 1);
                        if (topBlocks != null) {
                            BufferedImage regionImage = renderer.renderToPng(topBlocks, 1);
                            if (regionImage != null) {
                                int offsetX = (regionX - regionBounds[0]) * 512;
                                int offsetY = (regionZ - regionBounds[2]) * 512;
                                MinecraftMapGUI.this.logManager.debug(String.format("\u653e\u7f6e\u533a\u57df\u56fe\u50cf\u5728\u4f4d\u7f6e: (%d, %d)", offsetX, offsetY), "MinecraftMapGUI");
                                g2d.drawImage((Image)regionImage, offsetX, offsetY, null);
                                continue;
                            }
                            MinecraftMapGUI.this.logManager.warn("\u533a\u57df\u56fe\u50cf\u6e32\u67d3\u5931\u8d25: r." + regionX + "." + regionZ + ".mca", "MinecraftMapGUI");
                            continue;
                        }
                        MinecraftMapGUI.this.logManager.warn("\u533a\u57df\u6570\u636e\u83b7\u53d6\u5931\u8d25: r." + regionX + "." + regionZ + ".mca", "MinecraftMapGUI");
                    }
                    g2d.dispose();
                    MinecraftMapGUI.this.currentRegion = new Point((regionBounds[0] + regionBounds[1]) / 2, (regionBounds[2] + regionBounds[3]) / 2);
                    MinecraftMapGUI.this.lastFullRenderMinWorldX = regionBounds[0] * 512;
                    MinecraftMapGUI.this.lastFullRenderMinWorldZ = regionBounds[2] * 512;
                    MinecraftMapGUI.this.logManager.info("\u5168\u533a\u57df\u6e32\u67d3\u5b8c\u6210", "MinecraftMapGUI");
                    BufferedImage bufferedImage = combinedImage;
                    return bufferedImage;
                }
                finally {
                    renderer.shutdown();
                }
            }

            @Override
            protected void done() {
                try {
                    BufferedImage result = (BufferedImage)this.get();
                    if (result != null) {
                        MinecraftMapGUI.this.mapImage = result;
                        SwingUtilities.invokeLater(() -> {
                            MinecraftMapGUI.this.mapCanvas.setImage(result);
                            MinecraftMapGUI.this.progressLabel.setText("\u5168\u533a\u57df\u6e32\u67d3\u5b8c\u6210\uff01\u5171\u6e32\u67d3\u4e86\u6240\u6709\u53ef\u7528\u533a\u57df\u3002");
                            MinecraftMapGUI.this.mapCanvas.setWorldCoordinateMapping(MinecraftMapGUI.this.lastFullRenderMinWorldX, MinecraftMapGUI.this.lastFullRenderMinWorldZ, 1.0);
                            MinecraftMapGUI.this.mapCanvas.repaint();
                        });
                        MinecraftMapGUI.this.logManager.info("\u5730\u56fe\u663e\u793a\u5df2\u66f4\u65b0", "MinecraftMapGUI");
                    } else {
                        SwingUtilities.invokeLater(() -> MinecraftMapGUI.this.progressLabel.setText("\u5168\u533a\u57df\u6e32\u67d3\u5931\u8d25"));
                        MinecraftMapGUI.this.logManager.error("\u5168\u533a\u57df\u6e32\u67d3\u5931\u8d25", "MinecraftMapGUI");
                    }
                }
                catch (Exception e) {
                    SwingUtilities.invokeLater(() -> {
                        MinecraftMapGUI.this.progressLabel.setText("\u6e32\u67d3\u51fa\u9519: " + e.getMessage());
                        JOptionPane.showMessageDialog(MinecraftMapGUI.this, "\u6e32\u67d3\u5168\u90e8\u533a\u57df\u65f6\u51fa\u9519: " + e.getMessage(), "\u9519\u8bef", 0);
                    });
                    MinecraftMapGUI.this.logManager.error("\u5168\u533a\u57df\u6e32\u67d3\u51fa\u9519", "MinecraftMapGUI", e);
                }
            }
        };
        worker.execute();
    }

    private void toggleDynamicMode() {
        if (this.savePath == null || this.savePath.isEmpty()) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u5148\u9009\u62e9\u4e00\u4e2aMinecraft\u5b58\u6863", "\u63d0\u793a", 2);
            return;
        }
        if (!this.isDynamicMode) {
            this.enableDynamicMode();
        } else {
            this.disableDynamicMode();
        }
    }

    private void enableDynamicMode() {
        try {
            this.logManager.info("\u542f\u7528\u52a8\u6001\u6a21\u5f0f", "MinecraftMapGUI");
            this.dynamicRegionManager = new DynamicRegionManager(this.savePath);
            this.dynamicMapCanvas = new DynamicMapCanvas();
            this.dynamicMapCanvas.setRegionManager(this.dynamicRegionManager);
            this.dynamicMapCanvas.setSelectionCallback(new DynamicMapCanvas.SelectionCallback(){

                @Override
                public void onSelectionComplete(int minX, int minZ, int maxX, int maxZ) {
                    SwingUtilities.invokeLater(() -> {
                        MinecraftMapGUI.this.confirmSelectionButton.setEnabled(true);
                        MinecraftMapGUI.this.progressLabel.setText(String.format("\u5df2\u9009\u62e9\u533a\u57df: (%d,%d) \u5230 (%d,%d) - \u70b9\u51fb\u786e\u8ba4\u6309\u94ae", minX, minZ, maxX, maxZ));
                    });
                }

                @Override
                public void onSelectionConfirmed(int minX, int minZ, int maxX, int maxZ) {
                    SwingUtilities.invokeLater(() -> {
                        int centerX = (minX + maxX) / 2;
                        int centerZ = (minZ + maxZ) / 2;
                        int sizeX = maxX - minX;
                        int sizeZ = maxZ - minZ;
                        MinecraftMapGUI.this.progressLabel.setText(String.format("\u786e\u8ba4\u9009\u62e9\u533a\u57df: (%d,%d) \u5230 (%d,%d)", minX, minZ, maxX, maxZ));
                        System.out.printf("=== \u786e\u8ba4\u7684\u9009\u62e9\u533a\u57df ===\n", new Object[0]);
                        System.out.printf("\u5de6\u4e0a\u89d2\u5750\u6807: (%d, %d)\n", minX, minZ);
                        System.out.printf("\u53f3\u4e0b\u89d2\u5750\u6807: (%d, %d)\n", maxX, maxZ);
                        System.out.printf("\u4e2d\u5fc3\u5750\u6807: (%d, %d)\n", centerX, centerZ);
                        System.out.printf("\u533a\u57df\u5927\u5c0f: %dx%d\n", sizeX, sizeZ);
                        if (MinecraftMapGUI.this.isBlenderMode && MinecraftMapGUI.this.outputFilePath != null) {
                            MinecraftMapGUI.this.outputCoordinatesToFile(minX, minZ, maxX, maxZ);
                        }
                    });
                }
            });
            Container parent = this.mapCanvas.getParent();
            if (parent != null) {
                parent.remove(this.mapCanvas);
                parent.add((Component)this.dynamicMapCanvas, "Center");
                parent.revalidate();
                parent.repaint();
            }
            SwingUtilities.invokeLater(() -> {
                this.dynamicMapCanvas.fitToWindow();
                this.dynamicMapCanvas.requestFocus();
            });
            this.isDynamicMode = true;
            this.progressLabel.setText("\u52a8\u6001\u6a21\u5f0f\u5df2\u542f\u7528 - \u4f7f\u7528\u9f20\u6807\u62d6\u62fd\u548c\u6eda\u8f6e\u7f29\u653e\u6d4f\u89c8\u5730\u56fe");
            this.logManager.info("\u52a8\u6001\u6a21\u5f0f\u542f\u7528\u6210\u529f", "MinecraftMapGUI");
        }
        catch (Exception e) {
            this.logManager.error("\u542f\u7528\u52a8\u6001\u6a21\u5f0f\u5931\u8d25", "MinecraftMapGUI", e);
            JOptionPane.showMessageDialog(this, "\u542f\u7528\u52a8\u6001\u6a21\u5f0f\u5931\u8d25: " + e.getMessage(), "\u9519\u8bef", 0);
        }
    }

    private void disableDynamicMode() {
        try {
            this.logManager.info("\u7981\u7528\u52a8\u6001\u6a21\u5f0f", "MinecraftMapGUI");
            if (this.dynamicMapCanvas != null) {
                this.dynamicMapCanvas.cleanup();
                Container parent = this.dynamicMapCanvas.getParent();
                if (parent != null) {
                    parent.remove(this.dynamicMapCanvas);
                    parent.add((Component)this.mapCanvas, "Center");
                    parent.revalidate();
                    parent.repaint();
                }
                this.dynamicMapCanvas = null;
            }
            if (this.dynamicRegionManager != null) {
                this.dynamicRegionManager.shutdown();
                this.dynamicRegionManager = null;
            }
            this.isDynamicMode = false;
            this.progressLabel.setText("\u52a8\u6001\u6a21\u5f0f\u5df2\u7981\u7528 - \u8fd4\u56de\u9759\u6001\u5730\u56fe\u6a21\u5f0f");
            this.logManager.info("\u52a8\u6001\u6a21\u5f0f\u7981\u7528\u6210\u529f", "MinecraftMapGUI");
        }
        catch (Exception e) {
            this.logManager.error("\u7981\u7528\u52a8\u6001\u6a21\u5f0f\u5931\u8d25", "MinecraftMapGUI", e);
        }
    }

    private void clearDynamicMemory() {
        if (!this.isDynamicMode || this.dynamicRegionManager == null) {
            JOptionPane.showMessageDialog(this, "\u5f53\u524d\u4e0d\u5728\u52a8\u6001\u6a21\u5f0f\uff0c\u65e0\u9700\u6e05\u7406\u5185\u5b58", "\u63d0\u793a", 1);
            return;
        }
        int result = JOptionPane.showConfirmDialog(this, "\u786e\u5b9a\u8981\u6e05\u7406\u6240\u6709\u5df2\u52a0\u8f7d\u7684\u533a\u57df\u5417\uff1f\n\u8fd9\u5c06\u91ca\u653e\u5185\u5b58\uff0c\u4f46\u9700\u8981\u91cd\u65b0\u52a0\u8f7d\u533a\u57df\u3002", "\u786e\u8ba4\u6e05\u7406\u5185\u5b58", 0, 3);
        if (result == 0) {
            try {
                this.logManager.info("\u5f00\u59cb\u6e05\u7406\u52a8\u6001\u6a21\u5f0f\u5185\u5b58", "MinecraftMapGUI");
                this.dynamicRegionManager.clearAllLoadedRegions();
                this.progressLabel.setText("\u5185\u5b58\u6e05\u7406\u5b8c\u6210 - \u533a\u57df\u5c06\u6839\u636e\u9700\u8981\u91cd\u65b0\u52a0\u8f7d");
                this.logManager.info("\u52a8\u6001\u6a21\u5f0f\u5185\u5b58\u6e05\u7406\u6210\u529f", "MinecraftMapGUI");
                JOptionPane.showMessageDialog(this, "\u5185\u5b58\u6e05\u7406\u5b8c\u6210\uff01\u533a\u57df\u5c06\u6839\u636e\u89c6\u53e3\u9700\u8981\u91cd\u65b0\u52a0\u8f7d\u3002", "\u6e05\u7406\u5b8c\u6210", 1);
            }
            catch (Exception e) {
                this.logManager.error("\u6e05\u7406\u52a8\u6001\u6a21\u5f0f\u5185\u5b58\u5931\u8d25", "MinecraftMapGUI", e);
                JOptionPane.showMessageDialog(this, "\u6e05\u7406\u5185\u5b58\u5931\u8d25: " + e.getMessage(), "\u9519\u8bef", 0);
            }
        }
    }
}

