/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.gui;

import com.minecraft.selector.gui.ViewportManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class MapCanvas
extends JPanel {
    private static final double MIN_SCALE = 0.1;
    private static final double MAX_SCALE = 10.0;
    private BufferedImage image;
    private double scale = 1.0;
    private Point imageOffset = new Point(0, 0);
    private Rectangle selectionRect;
    private Point selectionStart;
    private Point selectionEnd;
    private boolean dragging = false;
    private boolean selecting = false;
    private Point lastMousePos;
    private int currentMinX;
    private int currentMinZ;
    private int currentMaxX;
    private int currentMaxZ;
    private boolean hasValidSelection = false;
    private Point selectionWorldStart;
    private Point selectionWorldEnd;
    private int worldMinX = 0;
    private int worldMinZ = 0;
    private double pixelsPerBlock = 1.0;
    private int lastWorldMinX = 0;
    private int lastWorldMinZ = 0;
    private ViewportManager viewportManager;
    private Timer viewportUpdateTimer;
    private Rectangle lastViewport = new Rectangle();
    private Point lastViewCenter = new Point();
    private double lastScale = 1.0;
    private boolean isZooming = false;
    private Timer zoomEndTimer;
    private ViewportCallback viewportCallback;
    private SelectionCallback selectionCallback;

    public MapCanvas() {
        this.setPreferredSize(new Dimension(800, 600));
        this.setBackground(Color.WHITE);
        this.setupMouseListeners();
    }

    private void setupMouseListeners() {
        MouseAdapter mouseHandler = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    MapCanvas.this.startSelection(e.getPoint());
                } else if (SwingUtilities.isLeftMouseButton(e)) {
                    MapCanvas.this.startDrag(e.getPoint());
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && MapCanvas.this.selecting) {
                    MapCanvas.this.updateSelection(e.getPoint());
                } else if (SwingUtilities.isLeftMouseButton(e) && MapCanvas.this.dragging) {
                    MapCanvas.this.updateDrag(e.getPoint());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && MapCanvas.this.selecting) {
                    MapCanvas.this.finishSelection(e.getPoint());
                } else if (SwingUtilities.isLeftMouseButton(e) && MapCanvas.this.dragging) {
                    MapCanvas.this.finishDrag();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                MapCanvas.this.updateMouseCoordinates(e.getPoint());
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                MapCanvas.this.handleMouseWheel(e);
            }
        };
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.addMouseWheelListener(mouseHandler);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && MapCanvas.this.hasValidSelection) {
                    if (MapCanvas.this.selectionCallback != null) {
                        MapCanvas.this.selectionCallback.onSelectionConfirmed(MapCanvas.this.currentMinX, MapCanvas.this.currentMinZ, MapCanvas.this.currentMaxX, MapCanvas.this.currentMaxZ);
                    }
                } else if (e.getKeyCode() == 27) {
                    MapCanvas.this.clearSelection();
                    MapCanvas.this.hasValidSelection = false;
                }
            }
        });
        this.setFocusable(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MapCanvas.this.requestFocusInWindow();
            }
        });
        this.viewportUpdateTimer = new Timer(500, e -> this.updateViewportIfNeeded());
        this.viewportUpdateTimer.start();
    }

    public void setImage(BufferedImage image) {
        BufferedImage oldImage = this.image;
        this.image = image;
        if (oldImage == null && image != null) {
            System.out.printf("MapCanvas: \u9996\u6b21\u8bbe\u7f6e\u56fe\u50cf %dx%d, \u504f\u79fb\u91cf: (%d,%d), \u7f29\u653e: %.2f\n", image.getWidth(), image.getHeight(), this.imageOffset.x, this.imageOffset.y, this.scale);
        } else if (oldImage != null && image != null) {
            System.out.printf("MapCanvas: \u66f4\u65b0\u56fe\u50cf %dx%d -> %dx%d, \u504f\u79fb\u91cf\u4fdd\u6301: (%d,%d), \u7f29\u653e: %.2f\n", oldImage.getWidth(), oldImage.getHeight(), image.getWidth(), image.getHeight(), this.imageOffset.x, this.imageOffset.y, this.scale);
        }
        this.repaint();
    }

    public void setImageKeepWorldCenter(BufferedImage newImage, int newWorldMinX, int newWorldMinZ) {
        if (newImage == null) {
            this.setImage(null);
            return;
        }
        BufferedImage oldImage = this.image;
        if (oldImage == null) {
            this.image = newImage;
            this.setWorldCoordinateMapping(newWorldMinX, newWorldMinZ, 1.0);
            this.centerImage();
            this.repaint();
            return;
        }
        Point currentViewCenter = this.getViewCenter();
        double currentScale = this.scale;
        int oldWorldMinX = this.worldMinX;
        int oldWorldMinZ = this.worldMinZ;
        double oldPixelsPerBlock = this.pixelsPerBlock;
        boolean coordinateSystemChanged = newWorldMinX != oldWorldMinX || newWorldMinZ != oldWorldMinZ;
        this.image = newImage;
        this.setWorldCoordinateMapping(newWorldMinX, newWorldMinZ, 1.0);
        if (!coordinateSystemChanged && currentViewCenter != null) {
            this.scale = currentScale;
            this.setViewCenter(currentViewCenter);
            System.out.printf("MapCanvas: \u4fdd\u6301\u89c6\u56fe\u4e2d\u5fc3\u4e0d\u53d8\u66f4\u65b0\u56fe\u50cf %dx%d -> %dx%d\n", oldImage.getWidth(), oldImage.getHeight(), newImage.getWidth(), newImage.getHeight());
        } else if (coordinateSystemChanged && currentViewCenter != null) {
            this.scale = currentScale;
            double worldCenterX = (double)oldWorldMinX + (double)currentViewCenter.x / oldPixelsPerBlock;
            double worldCenterZ = (double)oldWorldMinZ + (double)currentViewCenter.y / oldPixelsPerBlock;
            double newImageCenterX = (worldCenterX - (double)newWorldMinX) * this.pixelsPerBlock;
            double newImageCenterY = (worldCenterZ - (double)newWorldMinZ) * this.pixelsPerBlock;
            if (newImageCenterX >= 0.0 && newImageCenterX < (double)newImage.getWidth() && newImageCenterY >= 0.0 && newImageCenterY < (double)newImage.getHeight()) {
                this.setViewCenter(new Point((int)newImageCenterX, (int)newImageCenterY));
                System.out.printf("MapCanvas: \u4fdd\u6301\u4e16\u754c\u4e2d\u5fc3\u70b9(%.1f, %.1f)\u66f4\u65b0\u56fe\u50cf %dx%d -> %dx%d\uff0c\u65b0\u56fe\u50cf\u5750\u6807(%.1f, %.1f) [\u5750\u6807\u7cfb\u7edf\u5df2\u53d8\u5316]\n", worldCenterX, worldCenterZ, oldImage.getWidth(), oldImage.getHeight(), newImage.getWidth(), newImage.getHeight(), newImageCenterX, newImageCenterY);
            } else {
                this.centerImage();
                System.out.printf("MapCanvas: \u4e16\u754c\u4e2d\u5fc3\u70b9(%.1f, %.1f)\u8d85\u51fa\u65b0\u56fe\u50cf\u8303\u56f4\uff0c\u6539\u4e3a\u5c45\u4e2d\u663e\u793a\u3002\u65b0\u56fe\u50cf\u5750\u6807(%.1f, %.1f)\u8d85\u51fa\u8303\u56f4[0,0,%d,%d] [\u5750\u6807\u7cfb\u7edf\u5df2\u53d8\u5316]\n", worldCenterX, worldCenterZ, newImageCenterX, newImageCenterY, newImage.getWidth(), newImage.getHeight());
            }
        } else {
            this.centerImage();
            System.out.printf("MapCanvas: \u5c45\u4e2d\u663e\u793a\u65b0\u56fe\u50cf %dx%d\n", newImage.getWidth(), newImage.getHeight());
        }
        this.repaint();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImageAndResetView(BufferedImage image) {
        this.image = image;
        if (image != null) {
            this.resetView();
        }
        this.repaint();
    }

    public void setScale(double scale) {
        this.scale = Math.max(0.1, Math.min(10.0, scale));
        this.repaint();
    }

    public double getScale() {
        return this.scale;
    }

    public void resetView() {
        this.scale = 1.0;
        this.centerImage();
        this.selectionRect = null;
        this.repaint();
    }

    public void centerImage() {
        if (this.image != null) {
            int panelWidth = this.getWidth();
            int panelHeight = this.getHeight();
            int imageWidth = (int)((double)this.image.getWidth() * this.scale);
            int imageHeight = (int)((double)this.image.getHeight() * this.scale);
            this.imageOffset.x = (panelWidth - imageWidth) / 2;
            this.imageOffset.y = (panelHeight - imageHeight) / 2;
        } else {
            this.imageOffset.setLocation(0, 0);
        }
    }

    private void dragMap(Point point) {
        if (this.dragging && this.lastMousePos != null) {
            int dx = point.x - this.lastMousePos.x;
            int dy = point.y - this.lastMousePos.y;
            this.imageOffset.translate(dx, dy);
            this.lastMousePos = new Point(point);
            this.repaint();
        }
    }

    private void updateMouseCoordinates(Point point) {
        if (this.image != null) {
            Point imagePoint = this.screenToImageCoordinates(point);
            if (imagePoint.x < 0 || imagePoint.x >= this.image.getWidth() || imagePoint.y < 0 || imagePoint.y < this.image.getHeight()) {
                // empty if block
            }
        }
    }

    private void handleMouseWheel(MouseWheelEvent e) {
        if (this.image != null) {
            double oldScale = this.scale;
            this.scale = e.getWheelRotation() < 0 ? Math.min(10.0, this.scale * 1.2) : Math.max(0.1, this.scale / 1.2);
            if (this.scale != oldScale) {
                this.isZooming = true;
                Point mousePos = e.getPoint();
                double scaleRatio = this.scale / oldScale;
                double imageMouseX = (double)(mousePos.x - this.imageOffset.x) / oldScale;
                double imageMouseY = (double)(mousePos.y - this.imageOffset.y) / oldScale;
                this.imageOffset.x = (int)((double)mousePos.x - imageMouseX * this.scale);
                this.imageOffset.y = (int)((double)mousePos.y - imageMouseY * this.scale);
                if (this.zoomEndTimer != null) {
                    this.zoomEndTimer.stop();
                }
                this.zoomEndTimer = new Timer(1000, evt -> {
                    this.isZooming = false;
                    System.out.println("\u7f29\u653e\u64cd\u4f5c\u7ed3\u675f\uff0c\u6062\u590d\u89c6\u91ce\u66f4\u65b0");
                });
                this.zoomEndTimer.setRepeats(false);
                this.zoomEndTimer.start();
                this.repaint();
            }
        }
    }

    private Point screenToImageCoordinates(Point screenPoint) {
        if (this.image == null) {
            return new Point(0, 0);
        }
        int imageX = (int)((double)(screenPoint.x - this.imageOffset.x) / this.scale);
        int imageY = (int)((double)(screenPoint.y - this.imageOffset.y) / this.scale);
        return new Point(imageX, imageY);
    }

    private Point imageToScreenCoordinates(Point imagePoint) {
        if (this.image == null) {
            return new Point(0, 0);
        }
        int screenX = (int)((double)imagePoint.x * this.scale + (double)this.imageOffset.x);
        int screenY = (int)((double)imagePoint.y * this.scale + (double)this.imageOffset.y);
        return new Point(screenX, screenY);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (this.image != null) {
            int scaledWidth = (int)((double)this.image.getWidth() * this.scale);
            int scaledHeight = (int)((double)this.image.getHeight() * this.scale);
            g2d.drawImage(this.image, this.imageOffset.x, this.imageOffset.y, scaledWidth, scaledHeight, null);
            if (this.selecting && this.selectionStart != null && this.selectionEnd != null) {
                int x = Math.min(this.selectionStart.x, this.selectionEnd.x);
                int y = Math.min(this.selectionStart.y, this.selectionEnd.y);
                int width = Math.abs(this.selectionEnd.x - this.selectionStart.x);
                int height = Math.abs(this.selectionEnd.y - this.selectionStart.y);
                g2d.setColor(Color.RED);
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.drawRect(x, y, width, height);
            } else if (this.selectionWorldStart != null && this.selectionWorldEnd != null) {
                Point scaledStart = this.worldToScreenCoordinates(this.selectionWorldStart);
                Point scaledEnd = this.worldToScreenCoordinates(this.selectionWorldEnd);
                if (scaledStart != null && scaledEnd != null) {
                    int x = Math.min(scaledStart.x, scaledEnd.x);
                    int y = Math.min(scaledStart.y, scaledEnd.y);
                    int width = Math.abs(scaledEnd.x - scaledStart.x);
                    int height = Math.abs(scaledEnd.y - scaledStart.y);
                    g2d.setColor(Color.RED);
                    g2d.setStroke(new BasicStroke(2.0f));
                    g2d.drawRect(x, y, width, height);
                }
            }
        } else {
            g2d.setColor(Color.GRAY);
            String message = "\u6ca1\u6709\u52a0\u8f7d\u5730\u56fe\u56fe\u50cf";
            FontMetrics fm = g2d.getFontMetrics();
            int x = (this.getWidth() - fm.stringWidth(message)) / 2;
            int y = this.getHeight() / 2;
            g2d.drawString(message, x, y);
        }
        g2d.dispose();
    }

    public void setSelectionCallback(SelectionCallback callback) {
        this.selectionCallback = callback;
    }

    public void setWorldCoordinateMapping(int worldMinX, int worldMinZ, double pixelsPerBlock) {
        this.worldMinX = worldMinX;
        this.worldMinZ = worldMinZ;
        this.pixelsPerBlock = pixelsPerBlock;
        System.out.printf("\u8bbe\u7f6e\u4e16\u754c\u5750\u6807\u6620\u5c04: \u8d77\u70b9(%d, %d), \u50cf\u7d20/\u65b9\u5757=%.2f\n", worldMinX, worldMinZ, pixelsPerBlock);
    }

    public Point getViewCenter() {
        if (this.image == null) {
            return null;
        }
        int centerX = (int)(((double)this.getWidth() / 2.0 - (double)this.imageOffset.x) / this.scale);
        int centerY = (int)(((double)this.getHeight() / 2.0 - (double)this.imageOffset.y) / this.scale);
        return new Point(centerX, centerY);
    }

    public void setViewCenter(Point center) {
        if (this.image == null || center == null) {
            return;
        }
        this.imageOffset.x = (int)((double)this.getWidth() / 2.0 - (double)center.x * this.scale);
        this.imageOffset.y = (int)((double)this.getHeight() / 2.0 - (double)center.y * this.scale);
        this.clampImageOffset();
        this.repaint();
    }

    private void clampImageOffset() {
        if (this.image == null) {
            return;
        }
        int scaledWidth = (int)((double)this.image.getWidth() * this.scale);
        int scaledHeight = (int)((double)this.image.getHeight() * this.scale);
        int panelWidth = this.getWidth();
        int panelHeight = this.getHeight();
        this.imageOffset.x = scaledWidth > panelWidth ? Math.max(panelWidth - scaledWidth, Math.min(0, this.imageOffset.x)) : (panelWidth - scaledWidth) / 2;
        this.imageOffset.y = scaledHeight > panelHeight ? Math.max(panelHeight - scaledHeight, Math.min(0, this.imageOffset.y)) : (panelHeight - scaledHeight) / 2;
    }

    public double getZoomLevel() {
        return this.scale;
    }

    public void setZoomLevel(double zoom) {
        if (zoom <= 0.0) {
            return;
        }
        Point center = this.getViewCenter();
        this.scale = Math.max(0.1, Math.min(10.0, zoom));
        if (center != null) {
            this.setViewCenter(center);
        } else {
            this.clampImageOffset();
        }
        this.repaint();
    }

    public void setViewportCallback(ViewportCallback callback) {
        this.viewportCallback = callback;
        this.viewportManager = new ViewportManager(callback, 1);
    }

    public void enableAutoViewportManagement(boolean enable) {
        if (enable) {
            if (!this.viewportUpdateTimer.isRunning()) {
                this.viewportUpdateTimer.start();
            }
            this.updateViewportIfNeeded();
        } else {
            this.viewportUpdateTimer.stop();
        }
    }

    public void forceViewportUpdate() {
        this.lastViewport = new Rectangle();
        this.updateViewportIfNeeded();
    }

    private void updateViewportIfNeeded() {
        if (this.viewportManager == null || this.image == null) {
            return;
        }
        if (this.isZooming) {
            return;
        }
        Point currentCenter = this.getViewCenter();
        double currentScale = this.scale;
        boolean isOnlyZoomChange = false;
        if (currentCenter != null && this.lastViewCenter != null) {
            double centerDistance = Math.sqrt(Math.pow(currentCenter.x - this.lastViewCenter.x, 2.0) + Math.pow(currentCenter.y - this.lastViewCenter.y, 2.0));
            boolean bl = isOnlyZoomChange = centerDistance < 50.0 && Math.abs(currentScale - this.lastScale) > 0.01;
        }
        if (isOnlyZoomChange) {
            System.out.println("\u68c0\u6d4b\u5230\u7eaf\u7f29\u653e\u64cd\u4f5c\uff0c\u8df3\u8fc7\u89c6\u91ce\u66f4\u65b0");
            this.lastScale = currentScale;
            return;
        }
        Rectangle currentViewport = this.getCurrentViewportInWorldCoords();
        if (!currentViewport.equals(this.lastViewport)) {
            this.lastViewport = new Rectangle(currentViewport);
            if (currentCenter != null) {
                this.lastViewCenter = new Point(currentCenter);
            }
            this.lastScale = currentScale;
            System.out.printf("\u89c6\u91ce\u66f4\u65b0: \u4e16\u754c\u5750\u6807\u8303\u56f4 (%d,%d) \u5230 (%d,%d)\n", currentViewport.x, currentViewport.y, currentViewport.x + currentViewport.width, currentViewport.y + currentViewport.height);
            this.viewportManager.updateViewport(currentViewport.x, currentViewport.y, currentViewport.x + currentViewport.width, currentViewport.y + currentViewport.height);
        }
    }

    private Rectangle getCurrentViewportInWorldCoords() {
        if (this.image == null) {
            return new Rectangle();
        }
        Rectangle visibleRect = this.getVisibleRect();
        Point topLeft = this.screenToWorldCoordinates(new Point(visibleRect.x, visibleRect.y));
        Point bottomRight = this.screenToWorldCoordinates(new Point(visibleRect.x + visibleRect.width, visibleRect.y + visibleRect.height));
        if (topLeft != null && bottomRight != null) {
            return new Rectangle(topLeft.x, topLeft.y, bottomRight.x - topLeft.x, bottomRight.y - topLeft.y);
        }
        return new Rectangle();
    }

    private void startSelection(Point point) {
        this.selectionStart = new Point(point);
        this.selectionEnd = new Point(point);
        this.selecting = true;
        this.selectionRect = new Rectangle();
        this.repaint();
    }

    private void updateSelection(Point point) {
        if (this.selecting && this.selectionStart != null) {
            this.selectionEnd = new Point(point);
            int x = Math.min(this.selectionStart.x, this.selectionEnd.x);
            int y = Math.min(this.selectionStart.y, this.selectionEnd.y);
            int width = Math.abs(this.selectionEnd.x - this.selectionStart.x);
            int height = Math.abs(this.selectionEnd.y - this.selectionStart.y);
            this.selectionRect = new Rectangle(x, y, width, height);
            this.repaint();
        }
    }

    private void finishSelection(Point point) {
        if (this.selecting && this.selectionStart != null && this.image != null) {
            this.selectionEnd = new Point(point);
            Point worldStart = this.screenToWorldCoordinates(this.selectionStart);
            Point worldEnd = this.screenToWorldCoordinates(this.selectionEnd);
            if (worldStart != null && worldEnd != null) {
                this.selectionWorldStart = new Point(worldStart);
                this.selectionWorldEnd = new Point(worldEnd);
                this.currentMinX = Math.min(worldStart.x, worldEnd.x);
                this.currentMaxX = Math.max(worldStart.x, worldEnd.x);
                this.currentMinZ = Math.min(worldStart.y, worldEnd.y);
                this.currentMaxZ = Math.max(worldStart.y, worldEnd.y);
                this.hasValidSelection = true;
                if (this.selectionCallback != null) {
                    this.selectionCallback.onSelectionComplete(this.currentMinX, this.currentMinZ, this.currentMaxX, this.currentMaxZ);
                }
                System.out.printf("\u9009\u62e9\u533a\u57df: \u4e16\u754c\u5750\u6807 (%d, %d) \u5230 (%d, %d) - \u6309Enter\u786e\u8ba4\n", this.currentMinX, this.currentMinZ, this.currentMaxX, this.currentMaxZ);
            }
        }
        this.selecting = false;
        this.selectionStart = null;
        this.selectionEnd = null;
        this.repaint();
    }

    public void confirmCurrentSelection() {
        if (this.hasValidSelection && this.selectionCallback != null) {
            this.selectionCallback.onSelectionConfirmed(this.currentMinX, this.currentMinZ, this.currentMaxX, this.currentMaxZ);
        }
    }

    public void clearSelection() {
        this.selectionStart = null;
        this.selectionEnd = null;
        this.selectionRect = null;
        this.selectionWorldStart = null;
        this.selectionWorldEnd = null;
        this.selecting = false;
        this.hasValidSelection = false;
        this.repaint();
    }

    private Point screenToWorldCoordinates(Point screenPoint) {
        if (this.image == null) {
            return null;
        }
        double imageX = (double)(screenPoint.x - this.imageOffset.x) / this.scale;
        double imageY = (double)(screenPoint.y - this.imageOffset.y) / this.scale;
        imageX = Math.max(0.0, Math.min((double)(this.image.getWidth() - 1), imageX));
        imageY = Math.max(0.0, Math.min((double)(this.image.getHeight() - 1), imageY));
        int worldX = this.worldMinX + (int)(imageX / this.pixelsPerBlock);
        int worldZ = this.worldMinZ + (int)(imageY / this.pixelsPerBlock);
        return new Point(worldX, worldZ);
    }

    private Point worldToScreenCoordinates(Point worldPoint) {
        if (this.image == null) {
            return null;
        }
        double imageX = (double)(worldPoint.x - this.worldMinX) * this.pixelsPerBlock;
        double imageY = (double)(worldPoint.y - this.worldMinZ) * this.pixelsPerBlock;
        int screenX = (int)(imageX * this.scale + (double)this.imageOffset.x);
        int screenY = (int)(imageY * this.scale + (double)this.imageOffset.y);
        return new Point(screenX, screenY);
    }

    private void startDrag(Point point) {
        this.lastMousePos = new Point(point);
        this.dragging = true;
    }

    private void updateDrag(Point point) {
        if (this.dragging && this.lastMousePos != null) {
            int dx = point.x - this.lastMousePos.x;
            int dy = point.y - this.lastMousePos.y;
            this.imageOffset.x += dx;
            this.imageOffset.y += dy;
            this.lastMousePos = new Point(point);
            this.repaint();
        }
    }

    private void finishDrag() {
        this.dragging = false;
        this.lastMousePos = null;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image != null) {
            int width = (int)((double)this.image.getWidth() * this.scale) + Math.abs(this.imageOffset.x);
            int height = (int)((double)this.image.getHeight() * this.scale) + Math.abs(this.imageOffset.y);
            return new Dimension(Math.max(800, width), Math.max(600, height));
        }
        return new Dimension(800, 600);
    }

    public void jumpToWorldCoordinate(Point worldCoord) {
        if (this.image == null) {
            return;
        }
        Point imageCoord = this.worldToImageCoordinates(worldCoord);
        if (imageCoord != null) {
            this.setViewCenter(imageCoord);
            System.out.printf("\u8df3\u8f6c\u5230\u4e16\u754c\u5750\u6807(%d,%d) -> \u56fe\u50cf\u5750\u6807(%d,%d)\n", worldCoord.x, worldCoord.y, imageCoord.x, imageCoord.y);
        } else {
            System.out.printf("\u65e0\u6cd5\u8df3\u8f6c\u5230\u4e16\u754c\u5750\u6807(%d,%d) - \u5750\u6807\u8f6c\u6362\u5931\u8d25\n", worldCoord.x, worldCoord.y);
        }
    }

    private Point worldToImageCoordinates(Point worldCoord) {
        if (this.worldMinX == 0 && this.worldMinZ == 0 && this.pixelsPerBlock == 0.0) {
            return null;
        }
        int relativeX = worldCoord.x - this.worldMinX;
        int relativeZ = worldCoord.y - this.worldMinZ;
        int imageX = (int)((double)relativeX * this.pixelsPerBlock);
        int imageY = (int)((double)relativeZ * this.pixelsPerBlock);
        if (imageX >= 0 && imageX < this.image.getWidth() && imageY >= 0 && imageY < this.image.getHeight()) {
            return new Point(imageX, imageY);
        }
        return null;
    }

    public static interface SelectionCallback {
        public void onSelectionComplete(int var1, int var2, int var3, int var4);

        public void onSelectionConfirmed(int var1, int var2, int var3, int var4);
    }

    public static interface ViewportCallback {
        public void onViewportChanged(int var1, int var2, int var3, int var4);

        public void loadRegion(int var1, int var2);

        public void unloadRegion(int var1, int var2);
    }
}

