/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.gui;

import com.minecraft.selector.utils.LogManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class LogWindow
extends JFrame
implements LogManager.LogListener {
    private final LogManager logManager = LogManager.getInstance();
    private final LogTableModel tableModel = new LogTableModel();
    private final JTable logTable = new JTable(this.tableModel);
    private JLabel statusLabel;
    private JComboBox<LogManager.LogLevel> levelFilter;
    private JTextField searchField;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");

    public LogWindow() {
        this.initializeComponents();
        this.setupLayout();
        this.setupEventHandlers();
        this.logManager.addLogListener(this);
        this.refreshLogs();
        this.logManager.info("\u65e5\u5fd7\u7a97\u53e3\u5df2\u6253\u5f00", "LogWindow");
    }

    private void initializeComponents() {
        this.setTitle("Minecraft Map Selector - \u65e5\u5fd7\u67e5\u770b\u5668");
        this.setDefaultCloseOperation(1);
        this.setSize(1000, 600);
        this.setLocationRelativeTo(null);
        this.setupTable();
        this.statusLabel = new JLabel(this.logManager.getLogStats());
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.levelFilter = new JComboBox();
        this.levelFilter.addItem(null);
        for (LogManager.LogLevel level : LogManager.LogLevel.values()) {
            this.levelFilter.addItem(level);
        }
        this.levelFilter.setSelectedItem(null);
        this.searchField = new JTextField(20);
        this.searchField.setToolTipText("\u641c\u7d22\u65e5\u5fd7\u5185\u5bb9...");
    }

    private void setupTable() {
        this.logTable.setSelectionMode(0);
        this.logTable.setAutoResizeMode(3);
        this.logTable.getTableHeader().setReorderingAllowed(false);
        TableColumn timeColumn = this.logTable.getColumnModel().getColumn(0);
        timeColumn.setPreferredWidth(100);
        timeColumn.setMaxWidth(120);
        TableColumn levelColumn = this.logTable.getColumnModel().getColumn(1);
        levelColumn.setPreferredWidth(60);
        levelColumn.setMaxWidth(80);
        TableColumn sourceColumn = this.logTable.getColumnModel().getColumn(2);
        sourceColumn.setPreferredWidth(120);
        sourceColumn.setMaxWidth(150);
        this.logTable.setRowHeight(20);
        this.logTable.setDefaultRenderer(Object.class, new LogCellRenderer());
        this.logTable.setAutoCreateRowSorter(false);
    }

    private void setupLayout() {
        this.setLayout(new BorderLayout());
        JPanel toolbarPanel = this.createToolbarPanel();
        this.add((Component)toolbarPanel, "North");
        JScrollPane scrollPane = new JScrollPane(this.logTable);
        scrollPane.setVerticalScrollBarPolicy(22);
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.statusLabel, "South");
    }

    private JPanel createToolbarPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(BorderFactory.createEtchedBorder());
        JButton refreshButton = new JButton("\u5237\u65b0");
        refreshButton.setToolTipText("\u5237\u65b0\u65e5\u5fd7\u5217\u8868");
        panel.add(refreshButton);
        JButton clearButton = new JButton("\u6e05\u7a7a");
        clearButton.setToolTipText("\u6e05\u7a7a\u6240\u6709\u65e5\u5fd7");
        panel.add(clearButton);
        JButton exportButton = new JButton("\u5bfc\u51fa");
        exportButton.setToolTipText("\u5bfc\u51fa\u65e5\u5fd7\u5230\u6587\u4ef6");
        panel.add(exportButton);
        panel.add(new JSeparator(1));
        panel.add(new JLabel("\u7ea7\u522b:"));
        panel.add(this.levelFilter);
        panel.add(new JSeparator(1));
        panel.add(new JLabel("\u641c\u7d22:"));
        panel.add(this.searchField);
        JButton searchButton = new JButton("\u641c\u7d22");
        panel.add(searchButton);
        refreshButton.addActionListener(e -> this.refreshLogs());
        clearButton.addActionListener(e -> this.clearLogs());
        exportButton.addActionListener(e -> this.exportLogs());
        this.levelFilter.addActionListener(e -> this.filterLogs());
        searchButton.addActionListener(e -> this.searchLogs());
        this.searchField.addActionListener(e -> this.searchLogs());
        return panel;
    }

    private void setupEventHandlers() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                LogWindow.this.logManager.removeLogListener(LogWindow.this);
                LogWindow.this.logManager.info("\u65e5\u5fd7\u7a97\u53e3\u5df2\u5173\u95ed", "LogWindow");
            }
        });
    }

    @Override
    public void onLogAdded(LogManager.LogEntry entry) {
        SwingUtilities.invokeLater(() -> {
            this.tableModel.addLogEntry(entry);
            this.updateStatus();
            int lastRow = this.logTable.getRowCount() - 1;
            if (lastRow >= 0) {
                this.logTable.scrollRectToVisible(this.logTable.getCellRect(lastRow, 0, true));
            }
        });
    }

    private void refreshLogs() {
        this.tableModel.setLogEntries(this.logManager.getAllLogs());
        this.updateStatus();
        this.logManager.debug("\u65e5\u5fd7\u5217\u8868\u5df2\u5237\u65b0", "LogWindow");
    }

    private void clearLogs() {
        int result = JOptionPane.showConfirmDialog(this, "\u786e\u5b9a\u8981\u6e05\u7a7a\u6240\u6709\u65e5\u5fd7\u5417\uff1f\u6b64\u64cd\u4f5c\u4e0d\u53ef\u64a4\u9500\u3002", "\u786e\u8ba4\u6e05\u7a7a", 0, 2);
        if (result == 0) {
            this.logManager.clearLogs();
            this.refreshLogs();
        }
    }

    private void exportLogs() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("\u5bfc\u51fa\u65e5\u5fd7\u6587\u4ef6");
        fileChooser.setSelectedFile(new File("log.log"));
        fileChooser.setFileFilter(new FileNameExtensionFilter("\u65e5\u5fd7\u6587\u4ef6 (*.log)", "log"));
        int result = fileChooser.showSaveDialog(this);
        if (result == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                this.logManager.exportToFile(file.getAbsolutePath());
                JOptionPane.showMessageDialog(this, "\u65e5\u5fd7\u5df2\u6210\u529f\u5bfc\u51fa\u5230: " + file.getAbsolutePath(), "\u5bfc\u51fa\u6210\u529f", 1);
            }
            catch (Exception e) {
                this.logManager.error("\u5bfc\u51fa\u65e5\u5fd7\u5931\u8d25", "LogWindow", e);
                JOptionPane.showMessageDialog(this, "\u5bfc\u51fa\u65e5\u5fd7\u5931\u8d25: " + e.getMessage(), "\u5bfc\u51fa\u5931\u8d25", 0);
            }
        }
    }

    private void filterLogs() {
        LogManager.LogLevel selectedLevel = (LogManager.LogLevel)((Object)this.levelFilter.getSelectedItem());
        if (selectedLevel == null) {
            this.tableModel.setLogEntries(this.logManager.getAllLogs());
        } else {
            this.tableModel.setLogEntries(this.logManager.getLogsByLevel(selectedLevel));
        }
        this.updateStatus();
    }

    private void searchLogs() {
        String searchText = this.searchField.getText().trim().toLowerCase();
        if (searchText.isEmpty()) {
            this.refreshLogs();
            return;
        }
        List<LogManager.LogEntry> allLogs = this.logManager.getAllLogs();
        ArrayList<LogManager.LogEntry> filteredLogs = new ArrayList<LogManager.LogEntry>();
        for (LogManager.LogEntry entry : allLogs) {
            if (!entry.getMessage().toLowerCase().contains(searchText) && !entry.getSource().toLowerCase().contains(searchText)) continue;
            filteredLogs.add(entry);
        }
        this.tableModel.setLogEntries(filteredLogs);
        this.updateStatus();
        this.logManager.debug("\u641c\u7d22\u5b8c\u6210\uff0c\u627e\u5230 " + filteredLogs.size() + " \u6761\u5339\u914d\u65e5\u5fd7", "LogWindow");
    }

    private void updateStatus() {
        this.statusLabel.setText(this.logManager.getLogStats() + " | \u663e\u793a: " + this.tableModel.getRowCount() + " \u6761");
    }

    private class LogTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"\u65f6\u95f4", "\u7ea7\u522b", "\u6765\u6e90", "\u6d88\u606f"};
        private List<LogManager.LogEntry> logEntries = new ArrayList<LogManager.LogEntry>();

        private LogTableModel() {
        }

        public void setLogEntries(List<LogManager.LogEntry> entries) {
            this.logEntries = new ArrayList<LogManager.LogEntry>(entries);
            this.fireTableDataChanged();
        }

        public void addLogEntry(LogManager.LogEntry entry) {
            this.logEntries.add(entry);
            int row = this.logEntries.size() - 1;
            this.fireTableRowsInserted(row, row);
        }

        @Override
        public int getRowCount() {
            return this.logEntries.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= this.logEntries.size()) {
                return null;
            }
            LogManager.LogEntry entry = this.logEntries.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return LogWindow.this.dateFormat.format(entry.getTimestamp());
                }
                case 1: {
                    return entry.getLevel();
                }
                case 2: {
                    return entry.getSource();
                }
                case 3: {
                    return entry.getMessage();
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 1: {
                    return LogManager.LogLevel.class;
                }
            }
            return String.class;
        }
    }

    private class LogCellRenderer
    extends DefaultTableCellRenderer {
        private LogCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                LogManager.LogEntry entry = (LogManager.LogEntry)LogWindow.this.tableModel.logEntries.get(row);
                switch (entry.getLevel()) {
                    case ERROR: {
                        c.setBackground(new Color(255, 230, 230));
                        break;
                    }
                    case WARN: {
                        c.setBackground(new Color(255, 245, 230));
                        break;
                    }
                    case DEBUG: {
                        c.setBackground(new Color(240, 240, 240));
                        break;
                    }
                    default: {
                        c.setBackground(Color.WHITE);
                    }
                }
            }
            return c;
        }
    }
}

