/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.gui;

import com.minecraft.selector.gui.UIThemeManager;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Arc2D;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.Timer;

public class LoadingAnimationPanel
extends JPanel {
    private Timer animationTimer;
    private int animationFrame = 0;
    private boolean isAnimating = false;
    private String loadingText = "\u52a0\u8f7d\u4e2d...";
    private AnimationType animationType = AnimationType.SPINNING_CIRCLE;

    public LoadingAnimationPanel() {
        this.setPreferredSize(new Dimension(200, 100));
        this.setOpaque(false);
        this.animationTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadingAnimationPanel.this.animationFrame++;
                LoadingAnimationPanel.this.repaint();
            }
        });
    }

    public void startAnimation() {
        if (!this.isAnimating) {
            this.isAnimating = true;
            this.animationFrame = 0;
            this.animationTimer.start();
            this.setVisible(true);
        }
    }

    public void stopAnimation() {
        if (this.isAnimating) {
            this.isAnimating = false;
            this.animationTimer.stop();
            this.setVisible(false);
        }
    }

    public void setLoadingText(String text) {
        this.loadingText = text;
        this.repaint();
    }

    public void setAnimationType(AnimationType type) {
        this.animationType = type;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.isAnimating) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int centerX = this.getWidth() / 2;
        int centerY = this.getHeight() / 2;
        switch (this.animationType.ordinal()) {
            case 0: {
                this.drawSpinningCircle(g2d, centerX, centerY - 10);
                break;
            }
            case 1: {
                this.drawBouncingDots(g2d, centerX, centerY - 10);
                break;
            }
            case 2: {
                this.drawProgressBar(g2d, centerX, centerY - 10);
                break;
            }
            case 3: {
                this.drawMinecraftBlocks(g2d, centerX, centerY - 10);
            }
        }
        g2d.setFont(g2d.getFont().deriveFont(1, 12.0f));
        g2d.setColor(UIThemeManager.ThemeColors.PRIMARY_BLUE);
        FontMetrics fm = g2d.getFontMetrics();
        int textWidth = fm.stringWidth(this.loadingText);
        g2d.drawString(this.loadingText, centerX - textWidth / 2, centerY + 25);
        g2d.dispose();
    }

    private void drawSpinningCircle(Graphics2D g2d, int centerX, int centerY) {
        int radius = 15;
        int arcLength = 60;
        int startAngle = this.animationFrame * 10 % 360;
        g2d.setStroke(new BasicStroke(3.0f));
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.drawOval(centerX - radius, centerY - radius, radius * 2, radius * 2);
        g2d.setColor(UIThemeManager.ThemeColors.PRIMARY_BLUE);
        Arc2D.Double arc = new Arc2D.Double(centerX - radius, centerY - radius, radius * 2, radius * 2, startAngle, arcLength, 0);
        g2d.draw(arc);
    }

    private void drawBouncingDots(Graphics2D g2d, int centerX, int centerY) {
        int dotRadius = 4;
        int spacing = 15;
        Color[] colors = new Color[]{UIThemeManager.ThemeColors.PRIMARY_BLUE, UIThemeManager.ThemeColors.SUCCESS_GREEN, UIThemeManager.ThemeColors.WARNING_ORANGE};
        for (int i = 0; i < 3; ++i) {
            int x = centerX - spacing + i * spacing;
            int bounceOffset = (int)(Math.sin((double)(this.animationFrame + i * 5) * 0.3) * 8.0);
            int y = centerY + bounceOffset;
            g2d.setColor(colors[i]);
            g2d.fillOval(x - dotRadius, y - dotRadius, dotRadius * 2, dotRadius * 2);
        }
    }

    private void drawProgressBar(Graphics2D g2d, int centerX, int centerY) {
        int barWidth = 100;
        int barHeight = 6;
        int x = centerX - barWidth / 2;
        int y = centerY - barHeight / 2;
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.fillRoundRect(x, y, barWidth, barHeight, barHeight, barHeight);
        int progress = this.animationFrame * 3 % (barWidth + 20);
        int progressWidth = Math.min(progress, barWidth);
        if (progressWidth > 0) {
            g2d.setColor(UIThemeManager.ThemeColors.SUCCESS_GREEN);
            g2d.fillRoundRect(x, y, progressWidth, barHeight, barHeight, barHeight);
        }
    }

    private void drawMinecraftBlocks(Graphics2D g2d, int centerX, int centerY) {
        int blockSize = 8;
        int spacing = 12;
        Color[] blockColors = new Color[]{UIThemeManager.ThemeColors.MINECRAFT_GREEN, UIThemeManager.ThemeColors.MINECRAFT_BROWN, UIThemeManager.ThemeColors.MINECRAFT_STONE};
        for (int i = 0; i < 3; ++i) {
            int x = centerX - spacing + i * spacing;
            int floatOffset = (int)(Math.sin((double)(this.animationFrame + i * 10) * 0.2) * 5.0);
            int y = centerY + floatOffset;
            g2d.setColor(blockColors[i]);
            g2d.fillRect(x - blockSize / 2, y - blockSize / 2, blockSize, blockSize);
            g2d.setColor(blockColors[i].darker());
            g2d.drawRect(x - blockSize / 2, y - blockSize / 2, blockSize, blockSize);
            g2d.setColor(blockColors[i].brighter());
            g2d.drawLine(x - blockSize / 2, y - blockSize / 2, x + blockSize / 2 - 1, y - blockSize / 2);
            g2d.drawLine(x - blockSize / 2, y - blockSize / 2, x - blockSize / 2, y + blockSize / 2 - 1);
        }
    }

    public static JDialog createLoadingDialog(Window parent, String message) {
        JDialog dialog = new JDialog(parent, "\u52a0\u8f7d\u4e2d", Dialog.ModalityType.APPLICATION_MODAL);
        dialog.setDefaultCloseOperation(0);
        dialog.setResizable(false);
        final LoadingAnimationPanel animationPanel = new LoadingAnimationPanel();
        animationPanel.setLoadingText(message);
        animationPanel.setAnimationType(AnimationType.MINECRAFT_BLOCKS);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        contentPanel.add((Component)animationPanel, "Center");
        dialog.setContentPane(contentPanel);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                animationPanel.startAnimation();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                animationPanel.stopAnimation();
            }
        });
        return dialog;
    }

    public static enum AnimationType {
        SPINNING_CIRCLE,
        BOUNCING_DOTS,
        PROGRESS_BAR,
        MINECRAFT_BLOCKS;

    }

    public static class StatusIndicator
    extends JPanel {
        private Color indicatorColor = Color.GRAY;
        private boolean isActive = false;
        private Timer blinkTimer;

        public StatusIndicator() {
            this.setPreferredSize(new Dimension(12, 12));
            this.setOpaque(false);
            this.blinkTimer = new Timer(500, e -> {
                this.isActive = !this.isActive;
                this.repaint();
            });
        }

        public void setStatus(StatusType status) {
            this.blinkTimer.stop();
            this.isActive = true;
            switch (status.ordinal()) {
                case 0: {
                    this.indicatorColor = Color.GRAY;
                    break;
                }
                case 1: {
                    this.indicatorColor = UIThemeManager.ThemeColors.WARNING_ORANGE;
                    this.blinkTimer.start();
                    break;
                }
                case 2: {
                    this.indicatorColor = UIThemeManager.ThemeColors.SUCCESS_GREEN;
                    break;
                }
                case 3: {
                    this.indicatorColor = UIThemeManager.ThemeColors.DANGER_RED;
                }
            }
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.isActive) {
                g2d.setColor(this.indicatorColor);
                g2d.fillOval(2, 2, 8, 8);
                g2d.setColor(this.indicatorColor.brighter());
                g2d.fillOval(3, 3, 3, 3);
            }
            g2d.dispose();
        }

        public static enum StatusType {
            IDLE,
            WORKING,
            SUCCESS,
            ERROR;

        }
    }
}

