/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.gui;

import com.minecraft.selector.gui.UIThemeManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class IconManager {
    private static final Map<String, Icon> iconCache = new HashMap<String, Icon>();
    public static final int SMALL_ICON_SIZE = 16;
    public static final int MEDIUM_ICON_SIZE = 24;
    public static final int LARGE_ICON_SIZE = 32;
    private static final Color PRIMARY_COLOR = UIThemeManager.ThemeColors.PRIMARY_BLUE;
    private static final Color SUCCESS_COLOR = UIThemeManager.ThemeColors.SUCCESS_GREEN;
    private static final Color WARNING_COLOR = UIThemeManager.ThemeColors.WARNING_ORANGE;
    private static final Color DANGER_COLOR = UIThemeManager.ThemeColors.DANGER_RED;

    public static Icon getFolderIcon(int size) {
        String key = "folder_" + size;
        return iconCache.computeIfAbsent(key, k -> IconManager.createFolderIcon(size));
    }

    public static Icon getFileIcon(int size) {
        String key = "file_" + size;
        return iconCache.computeIfAbsent(key, k -> IconManager.createFileIcon(size));
    }

    public static Icon getRenderIcon(int size) {
        String key = "render_" + size;
        return iconCache.computeIfAbsent(key, k -> IconManager.createRenderIcon(size));
    }

    public static Icon getPlayerIcon(int size) {
        String key = "player_" + size;
        return iconCache.computeIfAbsent(key, k -> IconManager.createPlayerIcon(size));
    }

    public static Icon getSettingsIcon(int size) {
        String key = "settings_" + size;
        return iconCache.computeIfAbsent(key, k -> IconManager.createSettingsIcon(size));
    }

    public static Icon getClearIcon(int size) {
        String key = "clear_" + size;
        return iconCache.computeIfAbsent(key, k -> IconManager.createClearIcon(size));
    }

    public static Icon getJumpIcon(int size) {
        String key = "jump_" + size;
        return iconCache.computeIfAbsent(key, k -> IconManager.createJumpIcon(size));
    }

    public static Icon getConfirmIcon(int size) {
        String key = "confirm_" + size;
        return iconCache.computeIfAbsent(key, k -> IconManager.createConfirmIcon(size));
    }

    public static Icon getRefreshIcon(int size) {
        String key = "refresh_" + size;
        return iconCache.computeIfAbsent(key, k -> IconManager.createRefreshIcon(size));
    }

    private static Icon createFolderIcon(final int size) {
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(PRIMARY_COLOR);
                int folderWidth = (int)((double)size * 0.8);
                int folderHeight = (int)((double)size * 0.6);
                int tabWidth = (int)((double)size * 0.4);
                int tabHeight = (int)((double)size * 0.2);
                g2d.fillRoundRect(x, y, tabWidth, tabHeight, 2, 2);
                g2d.fillRoundRect(x, y + tabHeight / 2, folderWidth, folderHeight, 2, 2);
                g2d.dispose();
            }

            @Override
            public int getIconWidth() {
                return 16;
            }

            @Override
            public int getIconHeight() {
                return 16;
            }
        };
    }

    private static Icon createFileIcon(final int size) {
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(PRIMARY_COLOR);
                int fileWidth = (int)((double)size * 0.7);
                int fileHeight = (int)((double)size * 0.9);
                int foldWidth = (int)((double)size * 0.3);
                g2d.fillRoundRect(x, y, fileWidth, fileHeight, 2, 2);
                Path2D.Double fold = new Path2D.Double();
                ((Path2D)fold).moveTo(x + fileWidth - foldWidth, y);
                ((Path2D)fold).lineTo(x + fileWidth, y);
                ((Path2D)fold).lineTo(x + fileWidth, y + foldWidth);
                fold.closePath();
                g2d.setColor(Color.WHITE);
                g2d.fill(fold);
                g2d.setColor(PRIMARY_COLOR);
                g2d.draw(fold);
                g2d.dispose();
            }

            @Override
            public int getIconWidth() {
                return 16;
            }

            @Override
            public int getIconHeight() {
                return 16;
            }
        };
    }

    private static Icon createRenderIcon(final int size) {
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(SUCCESS_COLOR);
                int triangleSize = (int)((double)size * 0.7);
                int centerX = x + size / 2;
                int centerY = y + size / 2;
                Path2D.Double triangle = new Path2D.Double();
                ((Path2D)triangle).moveTo(centerX - triangleSize / 2, centerY - triangleSize / 2);
                ((Path2D)triangle).lineTo(centerX + triangleSize / 2, centerY);
                ((Path2D)triangle).lineTo(centerX - triangleSize / 2, centerY + triangleSize / 2);
                triangle.closePath();
                g2d.fill(triangle);
                g2d.dispose();
            }

            @Override
            public int getIconWidth() {
                return 16;
            }

            @Override
            public int getIconHeight() {
                return 16;
            }
        };
    }

    private static Icon createPlayerIcon(final int size) {
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(PRIMARY_COLOR);
                int headSize = (int)((double)size * 0.7);
                int centerX = x + size / 2;
                int centerY = y + size / 2;
                g2d.fillOval(centerX - headSize / 2, centerY - headSize / 2, headSize, headSize);
                int bodyWidth = (int)((double)size * 0.3);
                int bodyHeight = (int)((double)size * 0.5);
                g2d.fillRect(centerX - bodyWidth / 2, centerY + headSize / 2 - 2, bodyWidth, bodyHeight);
                g2d.dispose();
            }

            @Override
            public int getIconWidth() {
                return 16;
            }

            @Override
            public int getIconHeight() {
                return 16;
            }
        };
    }

    private static Icon createJumpIcon(final int size) {
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(PRIMARY_COLOR);
                int arrowSize = (int)((double)size * 0.7);
                int centerX = x + size / 2;
                int centerY = y + size / 2;
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.drawLine(centerX - arrowSize / 2, centerY, centerX + arrowSize / 2, centerY);
                g2d.drawLine(centerX + arrowSize / 3, centerY - arrowSize / 3, centerX + arrowSize / 2, centerY);
                g2d.drawLine(centerX + arrowSize / 3, centerY + arrowSize / 3, centerX + arrowSize / 2, centerY);
                g2d.dispose();
            }

            @Override
            public int getIconWidth() {
                return 16;
            }

            @Override
            public int getIconHeight() {
                return 16;
            }
        };
    }

    private static Icon createConfirmIcon(final int size) {
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(SUCCESS_COLOR);
                int checkSize = (int)((double)size * 0.8);
                int centerX = x + size / 2;
                int centerY = y + size / 2;
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.drawLine(centerX - checkSize / 3, centerY, centerX, centerY + checkSize / 4);
                g2d.drawLine(centerX, centerY + checkSize / 4, centerX + checkSize / 2, centerY - checkSize / 4);
                g2d.dispose();
            }

            @Override
            public int getIconWidth() {
                return 16;
            }

            @Override
            public int getIconHeight() {
                return 16;
            }
        };
    }

    private static Icon createRefreshIcon(final int size) {
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(PRIMARY_COLOR);
                int refreshSize = (int)((double)size * 0.7);
                int centerX = x + size / 2;
                int centerY = y + size / 2;
                g2d.setStroke(new BasicStroke(1.5f));
                g2d.drawOval(centerX - refreshSize / 2, centerY - refreshSize / 2, refreshSize, refreshSize);
                Path2D.Double arrow = new Path2D.Double();
                ((Path2D)arrow).moveTo(centerX + refreshSize / 2 - 2, centerY - 2);
                ((Path2D)arrow).lineTo(centerX + refreshSize / 2 + 3, centerY);
                ((Path2D)arrow).lineTo(centerX + refreshSize / 2 - 2, centerY + 2);
                arrow.closePath();
                g2d.fill(arrow);
                g2d.dispose();
            }

            @Override
            public int getIconWidth() {
                return 16;
            }

            @Override
            public int getIconHeight() {
                return 16;
            }
        };
    }

    private static Icon createClearIcon(final int size) {
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(DANGER_COLOR);
                int xSize = (int)((double)size * 0.7);
                int centerX = x + size / 2;
                int centerY = y + size / 2;
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.drawLine(centerX - xSize / 2, centerY - xSize / 2, centerX + xSize / 2, centerY + xSize / 2);
                g2d.drawLine(centerX + xSize / 2, centerY - xSize / 2, centerX - xSize / 2, centerY + xSize / 2);
                g2d.dispose();
            }

            @Override
            public int getIconWidth() {
                return 16;
            }

            @Override
            public int getIconHeight() {
                return 16;
            }
        };
    }

    private static Icon createSettingsIcon(final int size) {
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(PRIMARY_COLOR);
                int gearSize = (int)((double)size * 0.7);
                int centerX = x + size / 2;
                int centerY = y + size / 2;
                g2d.fillOval(centerX - gearSize / 6, centerY - gearSize / 6, gearSize / 3, gearSize / 3);
                for (int i = 0; i < 6; ++i) {
                    double angle = Math.toRadians(i * 60);
                    int x1 = (int)((double)centerX + (double)(gearSize / 2) * Math.cos(angle));
                    int y1 = (int)((double)centerY + (double)(gearSize / 2) * Math.sin(angle));
                    int x2 = (int)((double)centerX + (double)(gearSize / 3) * Math.cos(angle));
                    int y2 = (int)((double)centerY + (double)(gearSize / 3) * Math.sin(angle));
                    g2d.setStroke(new BasicStroke(2.0f));
                    g2d.drawLine(x2, y2, x1, y1);
                }
                g2d.dispose();
            }

            @Override
            public int getIconWidth() {
                return 16;
            }

            @Override
            public int getIconHeight() {
                return 16;
            }
        };
    }
}

