/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DynamicMapManager {
    private final Map<RegionCoord, BufferedImage> regionImages = new ConcurrentHashMap<RegionCoord, BufferedImage>();
    private BufferedImage combinedImage;
    private int combinedMinRegionX = Integer.MAX_VALUE;
    private int combinedMinRegionZ = Integer.MAX_VALUE;
    private int combinedMaxRegionX = Integer.MIN_VALUE;
    private int combinedMaxRegionZ = Integer.MIN_VALUE;
    private int stableMinRegionX = Integer.MAX_VALUE;
    private int stableMinRegionZ = Integer.MAX_VALUE;
    private int stableMaxRegionX = Integer.MIN_VALUE;
    private int stableMaxRegionZ = Integer.MIN_VALUE;
    private boolean coordinateSystemInitialized = false;
    private static final int REGION_SIZE_PIXELS = 512;

    public synchronized void addRegion(int regionX, int regionZ, BufferedImage regionImage) {
        if (regionImage == null) {
            return;
        }
        RegionCoord coord = new RegionCoord(regionX, regionZ);
        boolean isNewRegion = !this.regionImages.containsKey(coord);
        this.regionImages.put(coord, regionImage);
        this.combinedMinRegionX = Math.min(this.combinedMinRegionX, regionX);
        this.combinedMinRegionZ = Math.min(this.combinedMinRegionZ, regionZ);
        this.combinedMaxRegionX = Math.max(this.combinedMaxRegionX, regionX);
        this.combinedMaxRegionZ = Math.max(this.combinedMaxRegionZ, regionZ);
        if (!this.coordinateSystemInitialized) {
            this.stableMinRegionX = Math.min(this.combinedMinRegionX, regionX - 2);
            this.stableMinRegionZ = Math.min(this.combinedMinRegionZ, regionZ - 2);
            this.stableMaxRegionX = Math.max(this.combinedMaxRegionX, regionX + 2);
            this.stableMaxRegionZ = Math.max(this.combinedMaxRegionZ, regionZ + 2);
            this.coordinateSystemInitialized = true;
            System.out.printf("\u521d\u59cb\u5316\u7a33\u5b9a\u5750\u6807\u7cfb\u7edf: (%d,%d) \u5230 (%d,%d)\n", this.stableMinRegionX, this.stableMinRegionZ, this.stableMaxRegionX, this.stableMaxRegionZ);
        }
        this.rebuildCombinedImage();
        if (isNewRegion) {
            System.out.printf("\u6dfb\u52a0\u65b0\u533a\u57df r.%d.%d.mca \u5230\u52a8\u6001\u5730\u56fe\n", regionX, regionZ);
        } else {
            System.out.printf("\u66f4\u65b0\u533a\u57df r.%d.%d.mca \u7684\u56fe\u50cf\n", regionX, regionZ);
        }
    }

    public synchronized void removeRegion(int regionX, int regionZ) {
        RegionCoord coord = new RegionCoord(regionX, regionZ);
        BufferedImage removed = this.regionImages.remove(coord);
        if (removed != null) {
            this.recalculateBounds();
            this.rebuildCombinedImage();
            System.out.printf("\u4ece\u52a8\u6001\u5730\u56fe\u79fb\u9664\u533a\u57df r.%d.%d.mca\uff08\u4fdd\u6301\u7a33\u5b9a\u5750\u6807\u7cfb\u7edf\uff09\n", regionX, regionZ);
        }
    }

    public synchronized BufferedImage getCombinedImage() {
        return this.combinedImage;
    }

    public synchronized Point getWorldOrigin() {
        if (!this.coordinateSystemInitialized) {
            return new Point(0, 0);
        }
        return new Point(this.stableMinRegionX * 512, this.stableMinRegionZ * 512);
    }

    private void recalculateBounds() {
        if (this.regionImages.isEmpty()) {
            this.combinedMinRegionX = Integer.MAX_VALUE;
            this.combinedMinRegionZ = Integer.MAX_VALUE;
            this.combinedMaxRegionX = Integer.MIN_VALUE;
            this.combinedMaxRegionZ = Integer.MIN_VALUE;
            return;
        }
        this.combinedMinRegionX = Integer.MAX_VALUE;
        this.combinedMinRegionZ = Integer.MAX_VALUE;
        this.combinedMaxRegionX = Integer.MIN_VALUE;
        this.combinedMaxRegionZ = Integer.MIN_VALUE;
        for (RegionCoord coord : this.regionImages.keySet()) {
            this.combinedMinRegionX = Math.min(this.combinedMinRegionX, coord.x);
            this.combinedMinRegionZ = Math.min(this.combinedMinRegionZ, coord.z);
            this.combinedMaxRegionX = Math.max(this.combinedMaxRegionX, coord.x);
            this.combinedMaxRegionZ = Math.max(this.combinedMaxRegionZ, coord.z);
        }
    }

    private void rebuildCombinedImage() {
        if (this.regionImages.isEmpty()) {
            this.combinedImage = null;
            return;
        }
        int width = (this.stableMaxRegionX - this.stableMinRegionX + 1) * 512;
        int height = (this.stableMaxRegionZ - this.stableMinRegionZ + 1) * 512;
        this.combinedImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = this.combinedImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setComposite(AlphaComposite.Clear);
        g2d.fillRect(0, 0, width, height);
        g2d.setComposite(AlphaComposite.SrcOver);
        g2d.setColor(new Color(32, 32, 32));
        g2d.fillRect(0, 0, width, height);
        for (Map.Entry<RegionCoord, BufferedImage> entry : this.regionImages.entrySet()) {
            RegionCoord coord = entry.getKey();
            BufferedImage regionImage = entry.getValue();
            int pixelX = (coord.x - this.stableMinRegionX) * 512;
            int pixelY = (coord.z - this.stableMinRegionZ) * 512;
            if (regionImage.getWidth() != 512 || regionImage.getHeight() != 512) {
                g2d.drawImage(regionImage, pixelX, pixelY, 512, 512, null);
                continue;
            }
            g2d.drawImage((Image)regionImage, pixelX, pixelY, null);
        }
        g2d.dispose();
        System.out.printf("\u91cd\u5efa\u5408\u6210\u5730\u56fe: %dx%d\u50cf\u7d20, \u5305\u542b%d\u4e2a\u533a\u57df\n", width, height, this.regionImages.size());
    }

    public synchronized void clear() {
        this.regionImages.clear();
        this.combinedImage = null;
        this.combinedMinRegionX = Integer.MAX_VALUE;
        this.combinedMinRegionZ = Integer.MAX_VALUE;
        this.combinedMaxRegionX = Integer.MIN_VALUE;
        this.combinedMaxRegionZ = Integer.MIN_VALUE;
    }

    public synchronized int getRegionCount() {
        return this.regionImages.size();
    }

    private static class RegionCoord {
        final int x;
        final int z;

        RegionCoord(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RegionCoord that = (RegionCoord)obj;
            return this.x == that.x && this.z == that.z;
        }

        public int hashCode() {
            return this.x * 31 + this.z;
        }

        public String toString() {
            return String.format("Region(%d, %d)", this.x, this.z);
        }
    }
}

