/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.gui;

import com.minecraft.selector.core.DynamicRegionManager;
import com.minecraft.selector.utils.LogManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class DynamicMapCanvas
extends JPanel
implements DynamicRegionManager.RegionLoadListener {
    private final LogManager logManager;
    private DynamicRegionManager regionManager;
    private double scale = 1.0;
    private Point viewOffset = new Point(0, 0);
    private Point lastMousePos = new Point();
    private boolean dragging = false;
    private boolean selecting = false;
    private Point selectionStart = null;
    private Point selectionEnd = null;
    private Rectangle selectionRect = new Rectangle();
    private Point selectionWorldStart = null;
    private Point selectionWorldEnd = null;
    private boolean hasValidSelection = false;
    private int currentMinX;
    private int currentMaxX;
    private int currentMinZ;
    private int currentMaxZ;
    private SelectionCallback selectionCallback;
    private static final int REGION_SIZE = 512;
    private static final Color LOADING_COLOR = new Color(64, 64, 64);
    private static final Color UNAVAILABLE_COLOR = new Color(32, 32, 32);
    private static final Color GRID_COLOR = new Color(128, 128, 128, 100);
    private boolean showGrid = false;
    private boolean showLoadingIndicator = true;
    private Rectangle lastViewport = new Rectangle();
    private Timer viewportUpdateTimer;
    private volatile boolean needsViewportUpdate = false;
    private static final int VIEWPORT_UPDATE_DELAY = 200;

    public DynamicMapCanvas() {
        this.logManager = LogManager.getInstance();
        this.setBackground(Color.BLACK);
        this.setPreferredSize(new Dimension(800, 600));
        this.setupMouseListeners();
        this.setupKeyListeners();
        this.viewportUpdateTimer = new Timer(200, e -> {
            if (this.needsViewportUpdate) {
                this.needsViewportUpdate = false;
                this.updateViewportIfNeeded();
            }
        });
        this.viewportUpdateTimer.setRepeats(false);
        this.logManager.info("\u52a8\u6001\u5730\u56fe\u753b\u5e03\u5df2\u521d\u59cb\u5316", "DynamicMapCanvas");
    }

    public void setRegionManager(DynamicRegionManager regionManager) {
        if (this.regionManager != null) {
            this.regionManager.removeRegionLoadListener(this);
        }
        this.regionManager = regionManager;
        if (regionManager != null) {
            regionManager.addRegionLoadListener(this);
            this.updateViewportIfNeeded();
        }
        this.repaint();
    }

    private void setupMouseListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    DynamicMapCanvas.this.lastMousePos = e.getPoint();
                    DynamicMapCanvas.this.dragging = true;
                    DynamicMapCanvas.this.setCursor(Cursor.getPredefinedCursor(13));
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    DynamicMapCanvas.this.startSelection(e.getPoint());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    DynamicMapCanvas.this.dragging = false;
                    DynamicMapCanvas.this.setCursor(Cursor.getDefaultCursor());
                } else if (SwingUtilities.isRightMouseButton(e) && DynamicMapCanvas.this.selecting) {
                    DynamicMapCanvas.this.finishSelection(e.getPoint());
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && DynamicMapCanvas.this.dragging) {
                    Point currentPos = e.getPoint();
                    int deltaX = currentPos.x - ((DynamicMapCanvas)DynamicMapCanvas.this).lastMousePos.x;
                    int deltaY = currentPos.y - ((DynamicMapCanvas)DynamicMapCanvas.this).lastMousePos.y;
                    ((DynamicMapCanvas)DynamicMapCanvas.this).viewOffset.x += deltaX;
                    ((DynamicMapCanvas)DynamicMapCanvas.this).viewOffset.y += deltaY;
                    DynamicMapCanvas.this.lastMousePos = currentPos;
                    DynamicMapCanvas.this.repaint();
                    DynamicMapCanvas.this.requestViewportUpdate();
                } else if (SwingUtilities.isRightMouseButton(e) && DynamicMapCanvas.this.selecting) {
                    DynamicMapCanvas.this.updateSelection(e.getPoint());
                }
            }
        });
        this.addMouseWheelListener(e -> {
            double oldScale = this.scale;
            Point mousePos = e.getPoint();
            double worldX = (double)(mousePos.x - this.viewOffset.x) / this.scale;
            double worldY = (double)(mousePos.y - this.viewOffset.y) / this.scale;
            this.scale = e.getWheelRotation() < 0 ? (this.scale *= 1.1) : (this.scale /= 1.1);
            this.scale = Math.max(0.1, Math.min(10.0, this.scale));
            this.viewOffset.x = (int)((double)mousePos.x - worldX * this.scale);
            this.viewOffset.y = (int)((double)mousePos.y - worldY * this.scale);
            this.repaint();
            this.requestViewportUpdate();
        });
    }

    private void setupKeyListeners() {
        this.setFocusable(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int moveSpeed = (int)(20.0 / DynamicMapCanvas.this.scale);
                switch (e.getKeyCode()) {
                    case 38: 
                    case 87: {
                        ((DynamicMapCanvas)DynamicMapCanvas.this).viewOffset.y += moveSpeed;
                        break;
                    }
                    case 40: 
                    case 83: {
                        ((DynamicMapCanvas)DynamicMapCanvas.this).viewOffset.y -= moveSpeed;
                        break;
                    }
                    case 37: 
                    case 65: {
                        ((DynamicMapCanvas)DynamicMapCanvas.this).viewOffset.x += moveSpeed;
                        break;
                    }
                    case 39: 
                    case 68: {
                        ((DynamicMapCanvas)DynamicMapCanvas.this).viewOffset.x -= moveSpeed;
                        break;
                    }
                    case 71: {
                        DynamicMapCanvas.this.showGrid = !DynamicMapCanvas.this.showGrid;
                        break;
                    }
                    case 76: {
                        DynamicMapCanvas.this.showLoadingIndicator = !DynamicMapCanvas.this.showLoadingIndicator;
                        break;
                    }
                    case 82: {
                        DynamicMapCanvas.this.resetView();
                    }
                }
                DynamicMapCanvas.this.repaint();
                DynamicMapCanvas.this.requestViewportUpdate();
            }
        });
    }

    public void resetView() {
        this.scale = 1.0;
        this.viewOffset = new Point(this.getWidth() / 2, this.getHeight() / 2);
        this.repaint();
    }

    public void fitToWindow() {
        if (this.regionManager == null) {
            return;
        }
        Set<Point> availableRegions = this.regionManager.getAvailableRegions();
        if (availableRegions.isEmpty()) {
            return;
        }
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (Point region : availableRegions) {
            minX = Math.min(minX, region.x);
            maxX = Math.max(maxX, region.x);
            minZ = Math.min(minZ, region.y);
            maxZ = Math.max(maxZ, region.y);
        }
        int totalWidth = (maxX - minX + 1) * 512;
        int totalHeight = (maxZ - minZ + 1) * 512;
        double scaleX = (double)this.getWidth() / (double)totalWidth;
        double scaleY = (double)this.getHeight() / (double)totalHeight;
        this.scale = Math.min(scaleX, scaleY) * 0.9;
        int centerWorldX = (minX + maxX) * 512 / 2;
        int centerWorldZ = (minZ + maxZ) * 512 / 2;
        this.viewOffset.x = this.getWidth() / 2 - (int)((double)centerWorldX * this.scale);
        this.viewOffset.y = this.getHeight() / 2 - (int)((double)centerWorldZ * this.scale);
        this.repaint();
    }

    private void requestViewportUpdate() {
        this.needsViewportUpdate = true;
        this.viewportUpdateTimer.restart();
    }

    private void updateViewportIfNeeded() {
        if (this.regionManager == null) {
            return;
        }
        Rectangle currentViewport = this.calculateWorldViewport();
        if (this.hasSignificantViewportChange(currentViewport, this.lastViewport)) {
            this.lastViewport = new Rectangle(currentViewport);
            this.regionManager.updateViewport(currentViewport);
            this.logManager.debug("\u89c6\u53e3\u66f4\u65b0: " + currentViewport, "DynamicMapCanvas");
        }
    }

    private boolean hasSignificantViewportChange(Rectangle current, Rectangle last) {
        if (last.isEmpty()) {
            return true;
        }
        int threshold = 128;
        return Math.abs(current.x - last.x) > threshold || Math.abs(current.y - last.y) > threshold || Math.abs(current.width - last.width) > threshold || Math.abs(current.height - last.height) > threshold;
    }

    private Rectangle calculateWorldViewport() {
        int worldX = (int)((double)(-this.viewOffset.x) / this.scale);
        int worldY = (int)((double)(-this.viewOffset.y) / this.scale);
        int worldWidth = (int)((double)this.getWidth() / this.scale);
        int worldHeight = (int)((double)this.getHeight() / this.scale);
        return new Rectangle(worldX, worldY, worldWidth, worldHeight);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        try {
            if (this.regionManager != null) {
                this.drawRegions(g2d);
                if (this.showGrid) {
                    this.drawGrid(g2d);
                }
                this.drawSelection(g2d);
                this.drawStatusInfo(g2d);
            } else {
                this.drawNoDataMessage(g2d);
            }
        }
        finally {
            g2d.dispose();
        }
    }

    private void drawRegions(Graphics2D g2d) {
        Rectangle viewport = this.calculateWorldViewport();
        int minRegionX = (int)Math.floor((double)viewport.x / 512.0) - 1;
        int maxRegionX = (int)Math.ceil((double)(viewport.x + viewport.width) / 512.0) + 1;
        int minRegionZ = (int)Math.floor((double)viewport.y / 512.0) - 1;
        int maxRegionZ = (int)Math.ceil((double)(viewport.y + viewport.height) / 512.0) + 1;
        Set<Point> availableRegions = this.regionManager.getAvailableRegions();
        Map<Point, DynamicRegionManager.RegionTile> loadedRegions = this.regionManager.getAllLoadedRegions();
        for (int regionX = minRegionX; regionX <= maxRegionX; ++regionX) {
            for (int regionZ = minRegionZ; regionZ <= maxRegionZ; ++regionZ) {
                Point regionCoord = new Point(regionX, regionZ);
                int screenX = (int)((double)(regionX * 512) * this.scale + (double)this.viewOffset.x);
                int screenY = (int)((double)(regionZ * 512) * this.scale + (double)this.viewOffset.y);
                int screenWidth = (int)(512.0 * this.scale);
                int screenHeight = (int)(512.0 * this.scale);
                if (loadedRegions.containsKey(regionCoord)) {
                    DynamicRegionManager.RegionTile tile = loadedRegions.get(regionCoord);
                    BufferedImage image = tile.getImage();
                    g2d.drawImage(image, screenX, screenY, screenWidth + 1, screenHeight + 1, null);
                    continue;
                }
                if (!availableRegions.contains(regionCoord)) continue;
                if (this.regionManager.isRegionLoading(regionCoord)) {
                    g2d.setColor(LOADING_COLOR);
                    g2d.fillRect(screenX, screenY, screenWidth, screenHeight);
                    if (!this.showLoadingIndicator) continue;
                    g2d.setColor(Color.WHITE);
                    g2d.setFont(new Font("Arial", 1, 12));
                    String text = "\u52a0\u8f7d\u4e2d...";
                    FontMetrics fm = g2d.getFontMetrics();
                    int textX = screenX + (screenWidth - fm.stringWidth(text)) / 2;
                    int textY = screenY + (screenHeight + fm.getAscent()) / 2;
                    g2d.drawString(text, textX, textY);
                    continue;
                }
                g2d.setColor(LOADING_COLOR);
                g2d.fillRect(screenX, screenY, screenWidth, screenHeight);
                g2d.setColor(Color.GRAY);
                g2d.drawRect(screenX, screenY, screenWidth - 1, screenHeight - 1);
            }
        }
    }

    private void drawGrid(Graphics2D g2d) {
        g2d.setColor(GRID_COLOR);
        g2d.setStroke(new BasicStroke(1.0f));
        Rectangle viewport = this.calculateWorldViewport();
        int startRegionX = (int)Math.floor((double)viewport.x / 512.0);
        int endRegionX = (int)Math.ceil((double)(viewport.x + viewport.width) / 512.0);
        for (int regionX = startRegionX; regionX <= endRegionX; ++regionX) {
            int screenX = (int)((double)(regionX * 512) * this.scale + (double)this.viewOffset.x);
            g2d.drawLine(screenX, 0, screenX, this.getHeight());
        }
        int startRegionZ = (int)Math.floor((double)viewport.y / 512.0);
        int endRegionZ = (int)Math.ceil((double)(viewport.y + viewport.height) / 512.0);
        for (int regionZ = startRegionZ; regionZ <= endRegionZ; ++regionZ) {
            int screenY = (int)((double)(regionZ * 512) * this.scale + (double)this.viewOffset.y);
            g2d.drawLine(0, screenY, this.getWidth(), screenY);
        }
    }

    private void drawSelection(Graphics2D g2d) {
        if (this.selecting && this.selectionRect != null && !this.selectionRect.isEmpty()) {
            g2d.setColor(new Color(0, 120, 215, 100));
            g2d.fillRect(this.selectionRect.x, this.selectionRect.y, this.selectionRect.width, this.selectionRect.height);
            g2d.setColor(new Color(0, 120, 215));
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.drawRect(this.selectionRect.x, this.selectionRect.y, this.selectionRect.width, this.selectionRect.height);
        }
        if (this.hasValidSelection && this.selectionWorldStart != null && this.selectionWorldEnd != null) {
            Point screenStart = this.worldToScreenCoordinates(this.selectionWorldStart);
            Point screenEnd = this.worldToScreenCoordinates(this.selectionWorldEnd);
            int x = Math.min(screenStart.x, screenEnd.x);
            int y = Math.min(screenStart.y, screenEnd.y);
            int width = Math.abs(screenEnd.x - screenStart.x);
            int height = Math.abs(screenEnd.y - screenStart.y);
            g2d.setColor(new Color(255, 0, 0, 150));
            g2d.fillRect(x, y, width, height);
            g2d.setColor(Color.RED);
            g2d.setStroke(new BasicStroke(3.0f));
            g2d.drawRect(x, y, width, height);
            g2d.setColor(Color.WHITE);
            g2d.setFont(new Font("Arial", 1, 12));
            String selectionInfo = String.format("\u9009\u533a: (%d,%d) \u5230 (%d,%d)", this.currentMinX, this.currentMinZ, this.currentMaxX, this.currentMaxZ);
            g2d.drawString(selectionInfo, x + 5, y + 20);
        }
    }

    private void drawStatusInfo(Graphics2D g2d) {
        g2d.setColor(Color.WHITE);
        g2d.setFont(new Font("Arial", 0, 12));
        String statusText = String.format("\u7f29\u653e: %.2f | %s", this.scale, this.regionManager.getStatusInfo());
        g2d.drawString(statusText, 10, 20);
        String controlsText = "\u63a7\u5236: \u62d6\u62fd\u79fb\u52a8 | \u6eda\u8f6e\u7f29\u653e | WASD\u79fb\u52a8 | G\u663e\u793a\u7f51\u683c | R\u91cd\u7f6e\u89c6\u56fe";
        g2d.drawString(controlsText, 10, this.getHeight() - 10);
    }

    private void drawNoDataMessage(Graphics2D g2d) {
        g2d.setColor(Color.WHITE);
        g2d.setFont(new Font("Arial", 1, 16));
        String message = "\u8bf7\u5148\u9009\u62e9Minecraft\u5b58\u6863";
        FontMetrics fm = g2d.getFontMetrics();
        int x = (this.getWidth() - fm.stringWidth(message)) / 2;
        int y = this.getHeight() / 2;
        g2d.drawString(message, x, y);
    }

    @Override
    public void onRegionLoaded(Point regionCoord, DynamicRegionManager.RegionTile tile) {
        SwingUtilities.invokeLater(this::repaint);
    }

    @Override
    public void onRegionUnloaded(Point regionCoord) {
        SwingUtilities.invokeLater(this::repaint);
    }

    @Override
    public void onLoadingStarted(Point regionCoord) {
        SwingUtilities.invokeLater(this::repaint);
    }

    @Override
    public void onLoadingFailed(Point regionCoord, Exception error) {
        SwingUtilities.invokeLater(this::repaint);
        this.logManager.error("\u533a\u57df\u52a0\u8f7d\u5931\u8d25: r." + regionCoord.x + "." + regionCoord.y + ".mca", "DynamicMapCanvas", error);
    }

    public void setSelectionCallback(SelectionCallback callback) {
        this.selectionCallback = callback;
    }

    private void startSelection(Point point) {
        this.selectionStart = new Point(point);
        this.selectionEnd = new Point(point);
        this.selecting = true;
        this.selectionRect = new Rectangle();
        this.repaint();
    }

    private void updateSelection(Point point) {
        if (this.selecting && this.selectionStart != null) {
            this.selectionEnd = new Point(point);
            int x = Math.min(this.selectionStart.x, this.selectionEnd.x);
            int y = Math.min(this.selectionStart.y, this.selectionEnd.y);
            int width = Math.abs(this.selectionEnd.x - this.selectionStart.x);
            int height = Math.abs(this.selectionEnd.y - this.selectionStart.y);
            this.selectionRect = new Rectangle(x, y, width, height);
            this.repaint();
        }
    }

    private void finishSelection(Point point) {
        if (this.selecting && this.selectionStart != null) {
            this.selectionEnd = new Point(point);
            Point worldStart = this.screenToWorldCoordinates(this.selectionStart);
            Point worldEnd = this.screenToWorldCoordinates(this.selectionEnd);
            if (worldStart != null && worldEnd != null) {
                this.selectionWorldStart = new Point(worldStart);
                this.selectionWorldEnd = new Point(worldEnd);
                this.currentMinX = Math.min(worldStart.x, worldEnd.x);
                this.currentMaxX = Math.max(worldStart.x, worldEnd.x);
                this.currentMinZ = Math.min(worldStart.y, worldEnd.y);
                this.currentMaxZ = Math.max(worldStart.y, worldEnd.y);
                this.hasValidSelection = true;
                if (this.selectionCallback != null) {
                    this.selectionCallback.onSelectionComplete(this.currentMinX, this.currentMinZ, this.currentMaxX, this.currentMaxZ);
                }
                System.out.printf("\u9009\u62e9\u533a\u57df: \u4e16\u754c\u5750\u6807 (%d, %d) \u5230 (%d, %d) - \u6309Enter\u786e\u8ba4\n", this.currentMinX, this.currentMinZ, this.currentMaxX, this.currentMaxZ);
            }
        }
        this.selecting = false;
        this.repaint();
    }

    private Point screenToWorldCoordinates(Point screenPoint) {
        int worldX = (int)((double)(screenPoint.x - this.viewOffset.x) / this.scale);
        int worldY = (int)((double)(screenPoint.y - this.viewOffset.y) / this.scale);
        return new Point(worldX, worldY);
    }

    private Point worldToScreenCoordinates(Point worldPoint) {
        int screenX = (int)((double)worldPoint.x * this.scale + (double)this.viewOffset.x);
        int screenY = (int)((double)worldPoint.y * this.scale + (double)this.viewOffset.y);
        return new Point(screenX, screenY);
    }

    public Rectangle getSelection() {
        if (this.hasValidSelection) {
            return new Rectangle(this.currentMinX, this.currentMinZ, this.currentMaxX - this.currentMinX, this.currentMaxZ - this.currentMinZ);
        }
        return null;
    }

    public void confirmCurrentSelection() {
        if (this.hasValidSelection && this.selectionCallback != null) {
            this.selectionCallback.onSelectionConfirmed(this.currentMinX, this.currentMinZ, this.currentMaxX, this.currentMaxZ);
        }
    }

    public void clearSelection() {
        this.hasValidSelection = false;
        this.selecting = false;
        this.selectionStart = null;
        this.selectionEnd = null;
        this.selectionWorldStart = null;
        this.selectionWorldEnd = null;
        this.selectionRect = new Rectangle();
        this.repaint();
    }

    public void cleanup() {
        if (this.regionManager != null) {
            this.regionManager.removeRegionLoadListener(this);
        }
        if (this.viewportUpdateTimer != null) {
            this.viewportUpdateTimer.stop();
        }
    }

    public static interface SelectionCallback {
        public void onSelectionComplete(int var1, int var2, int var3, int var4);

        public void onSelectionConfirmed(int var1, int var2, int var3, int var4);
    }
}

