/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.core;

import com.minecraft.selector.core.PerformanceMonitor;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SmartThreadPoolManager {
    private static final int MIN_THREADS = 2;
    private static final int MAX_THREADS = 16;
    private final ThreadPoolExecutor executor;
    private final int optimalThreadCount;
    private final PerformanceMonitor performanceMonitor = PerformanceMonitor.getInstance();

    public SmartThreadPoolManager() {
        this.optimalThreadCount = this.calculateOptimalThreadCount();
        this.executor = this.createOptimizedThreadPool();
    }

    private int calculateOptimalThreadCount() {
        int cpuCores = Runtime.getRuntime().availableProcessors();
        long maxMemory = Runtime.getRuntime().maxMemory();
        int memoryBasedThreads = (int)Math.min(16L, maxMemory / 0x20000000L);
        int cpuBasedThreads = Math.min(16, cpuCores * 2);
        int optimalThreads = Math.min(memoryBasedThreads, cpuBasedThreads);
        optimalThreads = Math.max(2, optimalThreads);
        System.out.println(String.format("\u7cfb\u7edf\u914d\u7f6e: CPU\u6838\u5fc3=%d, \u6700\u5927\u5185\u5b58=%dMB", cpuCores, maxMemory / 1024L / 1024L));
        System.out.println(String.format("\u7ebf\u7a0b\u6570\u8ba1\u7b97: \u57fa\u4e8e\u5185\u5b58=%d, \u57fa\u4e8eCPU=%d, \u6700\u7ec8\u9009\u62e9=%d", memoryBasedThreads, cpuBasedThreads, optimalThreads));
        return optimalThreads;
    }

    private ThreadPoolExecutor createOptimizedThreadPool() {
        ThreadFactory threadFactory = new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "MapRenderer-Worker-" + this.threadNumber.getAndIncrement());
                t.setDaemon(false);
                t.setPriority(5);
                return t;
            }
        };
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(this.optimalThreadCount * 4);
        ThreadPoolExecutor pool = new ThreadPoolExecutor(this.optimalThreadCount, this.optimalThreadCount, 60L, TimeUnit.SECONDS, workQueue, threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(task);
    }

    public Future<?> submit(Runnable task) {
        return this.executor.submit(task);
    }

    public int calculateOptimalBatchSize(int totalTasks) {
        if (totalTasks <= this.optimalThreadCount) {
            return 1;
        }
        int baseBatchSize = totalTasks / this.optimalThreadCount;
        int adjustedBatchSize = Math.max(1, baseBatchSize / 2);
        int maxBatches = this.optimalThreadCount * 4;
        int minBatchSize = Math.max(1, totalTasks / maxBatches);
        return Math.max(minBatchSize, adjustedBatchSize);
    }

    public String getThreadPoolStatus() {
        return String.format("\u7ebf\u7a0b\u6c60\u72b6\u6001: \u6d3b\u8dc3=%d/%d, \u961f\u5217=%d, \u5df2\u5b8c\u6210=%d", this.executor.getActiveCount(), this.executor.getPoolSize(), this.executor.getQueue().size(), this.executor.getCompletedTaskCount());
    }

    public int getOptimalThreadCount() {
        return this.optimalThreadCount;
    }

    public void shutdown() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    System.err.println("\u7ebf\u7a0b\u6c60\u672a\u80fd\u6b63\u5e38\u5173\u95ed");
                }
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }
}

