/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.core;

import com.minecraft.selector.core.MapRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ProgressiveRenderer {
    private final int imageWidth;
    private final int imageHeight;
    private final ProgressiveCallback callback;
    private final BufferedImage canvas;
    private final Graphics2D graphics;
    private final Map<String, Boolean> completedChunks;
    private final AtomicInteger completedCount;
    private final int totalChunks;
    private final Object renderLock = new Object();
    private final int updateInterval;
    private long lastUpdateTime = 0L;
    private final long minUpdateInterval = 500L;

    public ProgressiveRenderer(int imageWidth, int imageHeight, int totalChunks, ProgressiveCallback callback) {
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.totalChunks = totalChunks;
        this.callback = callback;
        this.completedChunks = new ConcurrentHashMap<String, Boolean>();
        this.completedCount = new AtomicInteger(0);
        this.updateInterval = Math.max(1, totalChunks / 20);
        this.canvas = new BufferedImage(imageWidth, imageHeight, 1);
        this.graphics = this.canvas.createGraphics();
        this.graphics.setColor(new Color(128, 128, 128));
        this.graphics.fillRect(0, 0, imageWidth, imageHeight);
        System.out.println(String.format("\u6e10\u8fdb\u5f0f\u6e32\u67d3\u521d\u59cb\u5316: %dx%d\u50cf\u7d20, %d\u4e2a\u533a\u5757, \u6bcf%d\u4e2a\u533a\u5757\u66f4\u65b0\u4e00\u6b21", imageWidth, imageHeight, totalChunks, this.updateInterval));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateChunk(int chunkX, int chunkZ, MapRenderer.BlockInfo[][] chunkBlocks) {
        if (chunkBlocks == null) {
            return;
        }
        String chunkKey = chunkX + "," + chunkZ;
        Object object = this.renderLock;
        synchronized (object) {
            if (this.completedChunks.containsKey(chunkKey)) {
                return;
            }
            this.renderChunkToCanvas(chunkX, chunkZ, chunkBlocks);
            this.completedChunks.put(chunkKey, true);
            int completed = this.completedCount.incrementAndGet();
            boolean shouldUpdate = false;
            long currentTime = System.currentTimeMillis();
            if (completed % this.updateInterval == 0 || completed == this.totalChunks || currentTime - this.lastUpdateTime > 500L) {
                shouldUpdate = true;
                this.lastUpdateTime = currentTime;
            }
            if (shouldUpdate && this.callback != null) {
                BufferedImage snapshot = this.createSnapshot();
                if (completed == this.totalChunks) {
                    this.callback.onRenderComplete(snapshot);
                } else {
                    this.callback.onPartialRender(snapshot, completed, this.totalChunks);
                }
            }
        }
    }

    private void renderChunkToCanvas(int chunkX, int chunkZ, MapRenderer.BlockInfo[][] chunkBlocks) {
        int startX = chunkX * 16;
        int startZ = chunkZ * 16;
        for (int localZ = 0; localZ < 16; ++localZ) {
            for (int localX = 0; localX < 16; ++localX) {
                int pixelX = startX + localX;
                int pixelZ = startZ + localZ;
                if (pixelX < 0 || pixelX >= this.imageWidth || pixelZ < 0 || pixelZ >= this.imageHeight) continue;
                MapRenderer.BlockInfo blockInfo = chunkBlocks[localZ][localX];
                Color color = this.getBlockColor(blockInfo);
                this.canvas.setRGB(pixelX, pixelZ, color.getRGB());
            }
        }
    }

    private Color getBlockColor(MapRenderer.BlockInfo blockInfo) {
        String blockId;
        if (blockInfo == null) {
            return new Color(128, 128, 128);
        }
        switch (blockId = blockInfo.getBlockId()) {
            case "grass_block": {
                return new Color(124, 189, 107);
            }
            case "stone": {
                return new Color(125, 125, 125);
            }
            case "dirt": {
                return new Color(134, 96, 67);
            }
            case "sand": {
                return new Color(237, 201, 175);
            }
            case "water": {
                return new Color(64, 164, 223);
            }
            case "oak_log": {
                return new Color(102, 81, 51);
            }
            case "oak_leaves": {
                return new Color(79, 111, 82);
            }
            case "air": {
                return new Color(135, 206, 235);
            }
        }
        return new Color(200, 200, 200);
    }

    private BufferedImage createSnapshot() {
        BufferedImage snapshot = new BufferedImage(this.imageWidth, this.imageHeight, 1);
        Graphics2D g = snapshot.createGraphics();
        g.drawImage((Image)this.canvas, 0, 0, null);
        g.dispose();
        return snapshot;
    }

    public double getProgress() {
        return (double)this.completedCount.get() / (double)this.totalChunks;
    }

    public int getCompletedChunks() {
        return this.completedCount.get();
    }

    public int getTotalChunks() {
        return this.totalChunks;
    }

    public boolean isComplete() {
        return this.completedCount.get() >= this.totalChunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getFinalImage() {
        Object object = this.renderLock;
        synchronized (object) {
            return this.createSnapshot();
        }
    }

    public void dispose() {
        if (this.graphics != null) {
            this.graphics.dispose();
        }
    }

    public static interface ProgressiveCallback {
        public void onPartialRender(BufferedImage var1, int var2, int var3);

        public void onRenderComplete(BufferedImage var1);
    }
}

