/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class PerformanceMonitor {
    private static final PerformanceMonitor INSTANCE = new PerformanceMonitor();
    private final Map<String, AtomicLong> counters = new ConcurrentHashMap<String, AtomicLong>();
    private final Map<String, AtomicLong> timers = new ConcurrentHashMap<String, AtomicLong>();
    private final Map<String, Long> startTimes = new ConcurrentHashMap<String, Long>();

    private PerformanceMonitor() {
    }

    public static PerformanceMonitor getInstance() {
        return INSTANCE;
    }

    public void incrementCounter(String name) {
        this.counters.computeIfAbsent(name, k -> new AtomicLong(0L)).incrementAndGet();
    }

    public void addToCounter(String name, long value) {
        this.counters.computeIfAbsent(name, k -> new AtomicLong(0L)).addAndGet(value);
    }

    public void startTimer(String name) {
        this.startTimes.put(name, System.nanoTime());
    }

    public long endTimer(String name) {
        Long startTime = this.startTimes.remove(name);
        if (startTime != null) {
            long duration = System.nanoTime() - startTime;
            this.timers.computeIfAbsent(name, k -> new AtomicLong(0L)).addAndGet(duration);
            return duration;
        }
        return 0L;
    }

    public void recordTime(String name, long nanos) {
        this.timers.computeIfAbsent(name, k -> new AtomicLong(0L)).addAndGet(nanos);
    }

    public long getCounter(String name) {
        AtomicLong counter = this.counters.get(name);
        return counter != null ? counter.get() : 0L;
    }

    public double getTotalTimeMs(String name) {
        AtomicLong timer = this.timers.get(name);
        return timer != null ? (double)timer.get() / 1000000.0 : 0.0;
    }

    public double getAverageTimeMs(String name) {
        long count = this.getCounter(name + "_count");
        if (count == 0L) {
            return 0.0;
        }
        return this.getTotalTimeMs(name) / (double)count;
    }

    public void reset() {
        this.counters.clear();
        this.timers.clear();
        this.startTimes.clear();
    }

    public String getPerformanceReport() {
        StringBuilder sb = new StringBuilder();
        sb.append("=== \u6027\u80fd\u76d1\u63a7\u62a5\u544a ===\n");
        sb.append("\n\u8ba1\u6570\u5668:\n");
        this.counters.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> sb.append(String.format("  %s: %d\n", entry.getKey(), ((AtomicLong)entry.getValue()).get())));
        sb.append("\n\u8ba1\u65f6\u5668 (\u6beb\u79d2):\n");
        this.timers.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            String name = (String)entry.getKey();
            double totalMs = (double)((AtomicLong)entry.getValue()).get() / 1000000.0;
            long count = this.getCounter(name + "_count");
            double avgMs = count > 0L ? totalMs / (double)count : 0.0;
            sb.append(String.format("  %s: \u603b\u8ba1=%.2fms, \u6b21\u6570=%d, \u5e73\u5747=%.2fms\n", name, totalMs, count, avgMs));
        });
        return sb.toString();
    }

    public String getKeyMetrics() {
        long chunksProcessed = this.getCounter("chunks_processed");
        long blocksProcessed = this.getCounter("blocks_processed");
        double chunkProcessTime = this.getTotalTimeMs("chunk_processing");
        double blockLookupTime = this.getTotalTimeMs("block_lookup");
        StringBuilder sb = new StringBuilder();
        sb.append("\u5173\u952e\u6027\u80fd\u6307\u6807:\n");
        sb.append(String.format("  \u5904\u7406\u533a\u5757\u6570: %d\n", chunksProcessed));
        sb.append(String.format("  \u5904\u7406\u65b9\u5757\u6570: %d\n", blocksProcessed));
        if (chunksProcessed > 0L) {
            sb.append(String.format("  \u5e73\u5747\u533a\u5757\u5904\u7406\u65f6\u95f4: %.2fms\n", chunkProcessTime / (double)chunksProcessed));
        }
        if (blocksProcessed > 0L) {
            sb.append(String.format("  \u5e73\u5747\u65b9\u5757\u67e5\u627e\u65f6\u95f4: %.3fms\n", blockLookupTime / (double)blocksProcessed));
        }
        return sb.toString();
    }
}

