/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.imageio.ImageIO;

public class MinecraftResourceExtractor {
    private static final String ASSETS_PATH = "assets/minecraft/";
    private static final String TEXTURES_PATH = "assets/minecraft/textures/block/";
    private static final String BLOCKSTATES_PATH = "assets/minecraft/blockstates/";
    private static final String MODELS_PATH = "assets/minecraft/models/block/";
    private Map<String, Color> extractedColors = new HashMap<String, Color>();
    private Map<String, Color> modColors = new HashMap<String, Color>();
    private boolean extractionCompleted = false;

    public boolean extractColorsFromMinecraftJar(String jarPath) {
        boolean bl;
        System.out.println("\u6b63\u5728\u4eceMinecraft JAR\u6587\u4ef6\u63d0\u53d6\u65b9\u5757\u989c\u8272: " + jarPath);
        JarFile jarFile = new JarFile(jarPath);
        try {
            Map<String, BufferedImage> textures = this.extractBlockTextures(jarFile);
            System.out.println("\u63d0\u53d6\u4e86 " + textures.size() + " \u4e2a\u65b9\u5757\u7eb9\u7406");
            for (Map.Entry<String, BufferedImage> entry : textures.entrySet()) {
                String blockName = entry.getKey();
                BufferedImage texture = entry.getValue();
                Color avgColor = this.calculateAverageColor(blockName, texture);
                this.extractedColors.put(blockName, avgColor);
            }
            this.extractionCompleted = true;
            System.out.println("\u6210\u529f\u63d0\u53d6\u4e86 " + this.extractedColors.size() + " \u4e2a\u65b9\u5757\u7684\u989c\u8272\u4fe1\u606f");
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                System.err.println("\u63d0\u53d6\u65b9\u5757\u989c\u8272\u5931\u8d25: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
        jarFile.close();
        return bl;
    }

    public boolean extractColorsFromModsDirectory(String modsPath) {
        System.out.println("\u6b63\u5728\u4ecemods\u76ee\u5f55\u63d0\u53d6\u65b9\u5757\u989c\u8272: " + modsPath);
        File modsDir = new File(modsPath);
        if (!modsDir.exists() || !modsDir.isDirectory()) {
            System.err.println("mods\u76ee\u5f55\u4e0d\u5b58\u5728: " + modsPath);
            return false;
        }
        File[] modFiles = modsDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".jar"));
        if (modFiles == null || modFiles.length == 0) {
            System.out.println("\u5728mods\u76ee\u5f55\u4e2d\u6ca1\u6709\u627e\u5230jar\u6587\u4ef6");
            return false;
        }
        int totalExtracted = 0;
        for (File modFile : modFiles) {
            try {
                int extracted = this.extractColorsFromModJar(modFile.getAbsolutePath());
                totalExtracted += extracted;
                System.out.println("\u4ece " + modFile.getName() + " \u63d0\u53d6\u4e86 " + extracted + " \u4e2a\u65b9\u5757\u989c\u8272");
            }
            catch (Exception e) {
                System.err.println("\u5904\u7406mod\u6587\u4ef6\u5931\u8d25: " + modFile.getName() + " - " + e.getMessage());
            }
        }
        System.out.println("\u4ecemods\u76ee\u5f55\u603b\u5171\u63d0\u53d6\u4e86 " + totalExtracted + " \u4e2a\u65b9\u5757\u989c\u8272");
        return totalExtracted > 0;
    }

    private int extractColorsFromModJar(String jarPath) throws Exception {
        try (JarFile jarFile = new JarFile(jarPath);){
            Map<String, BufferedImage> textures = this.extractModBlockTextures(jarFile);
            for (Map.Entry<String, BufferedImage> entry : textures.entrySet()) {
                String blockName = entry.getKey();
                BufferedImage texture = entry.getValue();
                Color avgColor = this.calculateAverageColor(blockName, texture);
                this.modColors.put(blockName, avgColor);
            }
            int n = textures.size();
            return n;
        }
    }

    private Map<String, BufferedImage> extractBlockTextures(JarFile jarFile) throws IOException {
        HashMap<String, BufferedImage> textures = new HashMap<String, BufferedImage>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String fileName;
            String blockName;
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.startsWith(TEXTURES_PATH) || !entryName.endsWith(".png") || this.shouldSkipTexture(blockName = (fileName = entryName.substring(TEXTURES_PATH.length())).replaceAll("\\.png$", ""))) continue;
            try {
                InputStream is = jarFile.getInputStream(entry);
                try {
                    BufferedImage image = ImageIO.read(is);
                    if (image == null) continue;
                    textures.put(blockName, image);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception e) {
                System.err.println("\u8bfb\u53d6\u7eb9\u7406\u5931\u8d25: " + entryName + " - " + e.getMessage());
            }
        }
        return textures;
    }

    private Map<String, BufferedImage> extractModBlockTextures(JarFile jarFile) throws IOException {
        HashMap<String, BufferedImage> textures = new HashMap<String, BufferedImage>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String[] pathParts;
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.startsWith("assets/") || !entryName.contains("/textures/block/") || !entryName.endsWith(".png") || (pathParts = entryName.split("/")).length < 5) continue;
            String modId = pathParts[1];
            String fileName = pathParts[pathParts.length - 1];
            String blockName = fileName.replaceAll("\\.png$", "");
            if (this.shouldSkipTexture(blockName)) continue;
            try {
                InputStream is = jarFile.getInputStream(entry);
                try {
                    BufferedImage image = ImageIO.read(is);
                    if (image == null) continue;
                    String fullBlockName = modId + ":" + blockName;
                    textures.put(fullBlockName, image);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception e) {
                System.err.println("\u8bfb\u53d6mod\u7eb9\u7406\u5931\u8d25: " + entryName + " - " + e.getMessage());
            }
        }
        return textures;
    }

    private boolean shouldSkipTexture(String blockName) {
        return blockName.contains("_overlay") || blockName.contains("_flow") || blockName.contains("_still") || blockName.endsWith("_top") || blockName.endsWith("_bottom") || blockName.endsWith("_side") || blockName.endsWith("_front") || blockName.endsWith("_back") || blockName.endsWith("_left") || blockName.endsWith("_right");
    }

    private Color calculateAverageColor(String blockName, BufferedImage image) {
        long totalRed = 0L;
        long totalGreen = 0L;
        long totalBlue = 0L;
        int pixelCount = 0;
        int width = image.getWidth();
        int height = image.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb = image.getRGB(x, y);
                int alpha = rgb >> 24 & 0xFF;
                if (alpha < 128) continue;
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                totalRed += (long)red;
                totalGreen += (long)green;
                totalBlue += (long)blue;
                ++pixelCount;
            }
        }
        if (pixelCount == 0) {
            return Color.MAGENTA;
        }
        int avgRed = (int)(totalRed / (long)pixelCount);
        int avgGreen = (int)(totalGreen / (long)pixelCount);
        int avgBlue = (int)(totalBlue / (long)pixelCount);
        Color originalColor = new Color(avgRed, avgGreen, avgBlue);
        return this.applyColorCorrections(blockName, originalColor);
    }

    private Color applyColorCorrections(String blockName, Color originalColor) {
        if (blockName.endsWith("_leaves") && this.isGrayish(originalColor)) {
            return this.applyFoliageColor(blockName, originalColor);
        }
        if ((blockName.equals("grass_block") || blockName.equals("grass")) && this.isGrayish(originalColor)) {
            return this.applyGrassColor(originalColor);
        }
        return originalColor;
    }

    private boolean isGrayish(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int maxDiff = Math.max(Math.max(Math.abs(r - g), Math.abs(g - b)), Math.abs(r - b));
        return maxDiff < 30 && r > 80 && r < 180;
    }

    private Color applyFoliageColor(String blockName, Color grayColor) {
        switch (blockName) {
            case "oak_leaves": {
                return new Color(42, 132, 39);
            }
            case "spruce_leaves": {
                return new Color(23, 89, 44);
            }
            case "birch_leaves": {
                return new Color(115, 197, 72);
            }
            case "jungle_leaves": {
                return new Color(34, 130, 31);
            }
            case "acacia_leaves": {
                return new Color(95, 175, 53);
            }
            case "dark_oak_leaves": {
                return new Color(32, 92, 22);
            }
            case "pale_oak_leaves": {
                return new Color(85, 140, 75);
            }
            case "azalea_leaves": {
                return new Color(60, 150, 55);
            }
            case "flowering_azalea_leaves": {
                return new Color(70, 160, 65);
            }
            case "mangrove_leaves": {
                return new Color(45, 120, 40);
            }
            case "cherry_leaves": {
                return new Color(90, 170, 80);
            }
        }
        return new Color(60, 150, 50);
    }

    private Color applyGrassColor(Color grayColor) {
        return new Color(85, 174, 58);
    }

    public Color getExtractedColor(String blockName) {
        String[] parts;
        Color modColor = this.modColors.get(blockName);
        if (modColor != null) {
            return modColor;
        }
        Color vanillaColor = this.extractedColors.get(blockName);
        if (vanillaColor != null) {
            return vanillaColor;
        }
        if (blockName.contains(":") && (parts = blockName.split(":", 2)).length == 2) {
            String simpleBlockName = parts[1];
            modColor = this.modColors.get(simpleBlockName);
            if (modColor != null) {
                return modColor;
            }
            vanillaColor = this.extractedColors.get(simpleBlockName);
            if (vanillaColor != null) {
                return vanillaColor;
            }
        }
        return null;
    }

    public Map<String, Color> getAllExtractedColors() {
        return new HashMap<String, Color>(this.extractedColors);
    }

    public boolean isExtractionCompleted() {
        return this.extractionCompleted;
    }

    public void saveExtractedColors(String filePath) throws IOException {
        Properties props = new Properties();
        for (Map.Entry<String, Color> entry : this.extractedColors.entrySet()) {
            String blockName = entry.getKey();
            Color color = entry.getValue();
            String colorString = String.format("%d,%d,%d", color.getRed(), color.getGreen(), color.getBlue());
            props.setProperty(blockName, colorString);
        }
        try (FileOutputStream fos = new FileOutputStream(filePath);){
            props.store(fos, "Extracted block colors from Minecraft JAR");
        }
        System.out.println("\u989c\u8272\u4fe1\u606f\u5df2\u4fdd\u5b58\u5230: " + filePath);
    }

    public void saveExtractedColorsAsJson(String filePath) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode root = mapper.createObjectNode();
        ObjectNode metadata = mapper.createObjectNode();
        metadata.put("extractedAt", System.currentTimeMillis());
        metadata.put("totalColors", this.extractedColors.size());
        metadata.put("version", "1.0");
        root.set("metadata", metadata);
        ObjectNode colors = mapper.createObjectNode();
        for (Map.Entry<String, Color> entry : this.extractedColors.entrySet()) {
            String blockName = entry.getKey();
            Color color = entry.getValue();
            ObjectNode colorNode = mapper.createObjectNode();
            colorNode.put("r", color.getRed());
            colorNode.put("g", color.getGreen());
            colorNode.put("b", color.getBlue());
            colorNode.put("hex", String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue()));
            colors.set(blockName, colorNode);
        }
        root.set("colors", colors);
        mapper.writerWithDefaultPrettyPrinter().writeValue(new File(filePath), (Object)root);
        System.out.println("\u989c\u8272\u4fe1\u606f\u5df2\u4fdd\u5b58\u4e3aJSON: " + filePath);
    }

    public boolean loadExtractedColors(String filePath) {
        try {
            Properties props = new Properties();
            try (FileInputStream fis = new FileInputStream(filePath);){
                props.load(fis);
            }
            this.extractedColors.clear();
            for (String blockName : props.stringPropertyNames()) {
                String colorString = props.getProperty(blockName);
                String[] rgb = colorString.split(",");
                if (rgb.length != 3) continue;
                int r = Integer.parseInt(rgb[0]);
                int g = Integer.parseInt(rgb[1]);
                int b = Integer.parseInt(rgb[2]);
                this.extractedColors.put(blockName, new Color(r, g, b));
            }
            this.extractionCompleted = true;
            System.out.println("\u4eceProperties\u6587\u4ef6\u52a0\u8f7d\u4e86 " + this.extractedColors.size() + " \u4e2a\u65b9\u5757\u989c\u8272");
            return true;
        }
        catch (Exception e) {
            System.err.println("\u52a0\u8f7dProperties\u989c\u8272\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
            return false;
        }
    }

    public boolean loadExtractedColorsFromJson(String filePath) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = mapper.readTree(new File(filePath));
            this.extractedColors.clear();
            JsonNode colorsNode = root.get("colors");
            if (colorsNode != null) {
                colorsNode.fields().forEachRemaining(entry -> {
                    String blockName = (String)entry.getKey();
                    JsonNode colorNode = (JsonNode)entry.getValue();
                    int r = colorNode.get("r").asInt();
                    int g = colorNode.get("g").asInt();
                    int b = colorNode.get("b").asInt();
                    this.extractedColors.put(blockName, new Color(r, g, b));
                });
            }
            this.extractionCompleted = true;
            System.out.println("\u4eceJSON\u6587\u4ef6\u52a0\u8f7d\u4e86 " + this.extractedColors.size() + " \u4e2a\u65b9\u5757\u989c\u8272");
            return true;
        }
        catch (Exception e) {
            System.err.println("\u52a0\u8f7dJSON\u989c\u8272\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
            return false;
        }
    }

    public static String findModsDirectoryFromSavePath(String savePath) {
        try {
            File modsDir;
            File saveDir = new File(savePath);
            File minecraftDir = saveDir.getParentFile().getParentFile();
            if (minecraftDir != null && minecraftDir.exists() && (modsDir = new File(minecraftDir, "mods")).exists() && modsDir.isDirectory()) {
                System.out.println("\u627e\u5230mods\u76ee\u5f55: " + modsDir.getAbsolutePath());
                return modsDir.getAbsolutePath();
            }
        }
        catch (Exception e) {
            System.err.println("\u67e5\u627emods\u76ee\u5f55\u65f6\u51fa\u9519: " + e.getMessage());
        }
        return null;
    }

    public static List<String> findMinecraftJarsFromSavePath(String savePath) {
        ArrayList<String> jarPaths = new ArrayList<String>();
        try {
            File saveDir = new File(savePath);
            File minecraftDir = saveDir.getParentFile().getParentFile();
            if (minecraftDir != null && minecraftDir.exists()) {
                File versionsDir;
                System.out.println("\u4ece\u5b58\u6863\u8def\u5f84\u67e5\u627eJAR\u6587\u4ef6\uff0cMinecraft\u76ee\u5f55: " + minecraftDir.getAbsolutePath());
                File[] rootJarFiles = minecraftDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".jar") && (name.toLowerCase().contains("minecraft") || name.toLowerCase().contains("fabric") || name.toLowerCase().contains("forge") || name.toLowerCase().contains("optimized") || name.toLowerCase().contains("client")));
                if (rootJarFiles != null) {
                    for (File jarFile : rootJarFiles) {
                        jarPaths.add(jarFile.getAbsolutePath());
                        System.out.println("\u627e\u5230JAR\u6587\u4ef6: " + jarFile.getAbsolutePath());
                    }
                }
                if ((versionsDir = new File(minecraftDir, "versions")).exists() && versionsDir.isDirectory()) {
                    System.out.println("\u627e\u5230versions\u76ee\u5f55: " + versionsDir.getAbsolutePath());
                    File[] versionDirs = versionsDir.listFiles(File::isDirectory);
                    if (versionDirs != null) {
                        for (File versionDir : versionDirs) {
                            File jarFile = new File(versionDir, versionDir.getName() + ".jar");
                            if (!jarFile.exists()) continue;
                            jarPaths.add(jarFile.getAbsolutePath());
                            System.out.println("\u627e\u5230JAR\u6587\u4ef6: " + jarFile.getAbsolutePath());
                        }
                    }
                }
                if (jarPaths.isEmpty()) {
                    System.out.println("\u5728\u6839\u76ee\u5f55\u548cversions\u76ee\u5f55\u672a\u627e\u5230JAR\u6587\u4ef6\uff0c\u5f00\u59cb\u9012\u5f52\u641c\u7d22...");
                    MinecraftResourceExtractor.searchJarFilesRecursively(minecraftDir, jarPaths, 2);
                }
            }
        }
        catch (Exception e) {
            System.err.println("\u4ece\u5b58\u6863\u8def\u5f84\u67e5\u627eJAR\u6587\u4ef6\u65f6\u51fa\u9519: " + e.getMessage());
        }
        return jarPaths;
    }

    private static void searchJarFilesRecursively(File dir, List<String> jarPaths, int maxDepth) {
        if (maxDepth <= 0 || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isFile() && file.getName().toLowerCase().endsWith(".jar")) {
                String fileName = file.getName().toLowerCase();
                if (!fileName.contains("minecraft") && !fileName.contains("fabric") && !fileName.contains("forge") && !fileName.contains("optimized") && !fileName.contains("client") && !fileName.matches(".*\\d+\\.\\d+.*\\.jar")) continue;
                jarPaths.add(file.getAbsolutePath());
                System.out.println("\u9012\u5f52\u627e\u5230JAR\u6587\u4ef6: " + file.getAbsolutePath());
                continue;
            }
            if (!file.isDirectory() || file.getName().startsWith(".")) continue;
            MinecraftResourceExtractor.searchJarFilesRecursively(file, jarPaths, maxDepth - 1);
        }
    }

    public static List<String> findMinecraftJars() {
        String[] possiblePaths;
        ArrayList<String> jarPaths = new ArrayList<String>();
        for (String basePath : possiblePaths = new String[]{System.getProperty("user.home") + "/.minecraft/versions", System.getenv("APPDATA") + "\\.minecraft\\versions", System.getProperty("user.home") + "/Library/Application Support/minecraft/versions", "/Applications/Minecraft.app/Contents/Resources/versions"}) {
            File[] versionDirs;
            File baseDir;
            if (basePath == null || !(baseDir = new File(basePath)).exists() || !baseDir.isDirectory() || (versionDirs = baseDir.listFiles(File::isDirectory)) == null) continue;
            for (File versionDir : versionDirs) {
                File jarFile = new File(versionDir, versionDir.getName() + ".jar");
                if (!jarFile.exists()) continue;
                jarPaths.add(jarFile.getAbsolutePath());
            }
        }
        return jarPaths;
    }
}

