/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.core;

import com.minecraft.selector.core.BlockColors;
import com.minecraft.selector.region.Block;
import com.minecraft.selector.region.Chunk;
import com.minecraft.selector.region.Region;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MapRenderer {
    private final ExecutorService executorService;
    private final int maxWorkers;
    private final ProgressCallback progressCallback;
    private final AtomicInteger processedChunks = new AtomicInteger(0);
    private final AtomicInteger totalChunks = new AtomicInteger(0);
    private final AtomicLong startTime = new AtomicLong(0L);
    private final Set<String> foundBlocks = ConcurrentHashMap.newKeySet();
    private final AtomicLong totalRenderTime = new AtomicLong(0L);
    private final AtomicLong totalImageTime = new AtomicLong(0L);
    private final AtomicInteger totalRenderedChunks = new AtomicInteger(0);

    public MapRenderer(int maxWorkers, ProgressCallback progressCallback) {
        this.maxWorkers = maxWorkers;
        this.progressCallback = progressCallback;
        this.executorService = Executors.newFixedThreadPool(maxWorkers);
    }

    public static BufferedImage renderRegion(String regionPath, int minX, int maxX, int minZ, int maxZ, int lodLevel) {
        try {
            String mcaPath;
            BlockInfo[][] topBlocks;
            ProgressCallback callback = new ProgressCallback(){

                @Override
                public void onProgress(int processed, int total, double speed, Set<String> foundBlocks) {
                    System.out.printf("\u6e32\u67d3\u8fdb\u5ea6: %d/%d (%.1f%%) - \u901f\u5ea6: %.1f\u533a\u5757/\u79d2\n", processed, total, (double)processed * 100.0 / (double)total, speed);
                }

                @Override
                public void onProgressiveRender(BufferedImage partialImage, int completedChunks, int totalChunks) {
                }
            };
            MapRenderer renderer = new MapRenderer(4, callback);
            int width = maxX - minX;
            int height = maxZ - minZ;
            File regionDir = new File(regionPath);
            File[] mcaFiles = regionDir.listFiles((dir, name) -> name.endsWith(".mca"));
            if (mcaFiles != null && mcaFiles.length > 0 && (topBlocks = renderer.getTopBlocks(mcaPath = mcaFiles[0].getAbsolutePath(), Math.max(width / 16, height / 16), lodLevel)) != null) {
                return renderer.renderToPng(topBlocks, lodLevel);
            }
        }
        catch (Exception e) {
            System.err.println("\u6e32\u67d3\u533a\u57df\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public BlockInfo[][] getTopBlocks(String mcaFilePath, int regionSize, int sampleInterval) throws IOException {
        System.out.println("\u6b63\u5728\u5904\u7406\u533a\u57df\u6587\u4ef6: " + mcaFilePath);
        System.out.println("\u533a\u57df\u5927\u5c0f: " + regionSize + "x" + regionSize + " \u533a\u5757");
        System.out.println("\u91c7\u6837\u95f4\u9694: " + sampleInterval);
        this.processedChunks.set(0);
        this.foundBlocks.clear();
        this.startTime.set(System.currentTimeMillis());
        Region region = Region.fromFile(mcaFilePath);
        ArrayList<int[]> populatedChunks = new ArrayList<int[]>();
        for (int x = 0; x < regionSize; ++x) {
            for (int z = 0; z < regionSize; ++z) {
                if (!region.chunkExists(x, z)) continue;
                populatedChunks.add(new int[]{x, z});
            }
        }
        this.totalChunks.set(populatedChunks.size());
        System.out.println("\u53d1\u73b0 " + populatedChunks.size() + " \u4e2a\u6709\u6548\u533a\u5757");
        if (populatedChunks.isEmpty()) {
            System.out.println("\u6ca1\u6709\u627e\u5230\u6709\u6548\u533a\u5757");
            return new BlockInfo[regionSize * 16][regionSize * 16];
        }
        int arraySize = regionSize * 16;
        BlockInfo[][] topBlocks = new BlockInfo[arraySize][arraySize];
        for (int i = 0; i < arraySize; ++i) {
            for (int j = 0; j < arraySize; ++j) {
                topBlocks[i][j] = new BlockInfo("none", -64);
            }
        }
        int batchSize = Math.max(1, populatedChunks.size() / this.maxWorkers);
        ArrayList batches = new ArrayList();
        for (int i = 0; i < populatedChunks.size(); i += batchSize) {
            int end = Math.min(i + batchSize, populatedChunks.size());
            batches.add(populatedChunks.subList(i, end));
        }
        System.out.println("\u4f7f\u7528 " + batches.size() + " \u4e2a\u6279\u6b21\u5904\u7406");
        ArrayList<Future<Map>> futures = new ArrayList<Future<Map>>();
        for (int i = 0; i < batches.size(); ++i) {
            int n = i;
            List batch = (List)batches.get(i);
            Future<Map> future = this.executorService.submit(() -> this.processChunkBatch(region, batch, batchIndex, sampleInterval));
            futures.add(future);
        }
        for (Future future : futures) {
            try {
                Map batchResults = (Map)future.get();
                for (Map.Entry entry : batchResults.entrySet()) {
                    String[] coords = ((String)entry.getKey()).split(",");
                    int chunkX = Integer.parseInt(coords[0]);
                    int chunkZ = Integer.parseInt(coords[1]);
                    BlockInfo[][] chunkBlocks = (BlockInfo[][])entry.getValue();
                    if (chunkBlocks == null) continue;
                    int startX = chunkX * 16;
                    int startZ = chunkZ * 16;
                    for (int localZ = 0; localZ < 16; ++localZ) {
                        for (int localX = 0; localX < 16; ++localX) {
                            int globalX = startX + localX;
                            int globalZ = startZ + localZ;
                            if (globalX >= arraySize || globalZ >= arraySize) continue;
                            topBlocks[globalZ][globalX] = chunkBlocks[localZ][localX];
                        }
                    }
                }
            }
            catch (Exception e) {
                System.err.println("\u5904\u7406\u6279\u6b21\u7ed3\u679c\u65f6\u51fa\u9519: " + e.getMessage());
                e.printStackTrace();
            }
        }
        long totalTime = System.currentTimeMillis() - this.startTime.get();
        System.out.println("\n\u5904\u7406\u5b8c\u6210!");
        System.out.println("\u603b\u8017\u65f6: " + (double)totalTime / 1000.0 + "\u79d2");
        System.out.println("\u5904\u7406\u533a\u5757: " + populatedChunks.size());
        System.out.println("\u5e73\u5747\u901f\u5ea6: " + (double)populatedChunks.size() / ((double)totalTime / 1000.0) + " \u533a\u5757/\u79d2");
        System.out.println("\u53d1\u73b0\u7684\u65b9\u5757\u7c7b\u578b\u6570\u91cf: " + this.foundBlocks.size());
        return topBlocks;
    }

    private Map<String, BlockInfo[][]> processChunkBatch(Region region, List<int[]> chunkCoords, int threadId, int sampleInterval) {
        HashMap<String, BlockInfo[][]> results = new HashMap<String, BlockInfo[][]>();
        HashSet<String> localFoundBlocks = new HashSet<String>();
        for (int[] coord : chunkCoords) {
            int chunkX = coord[0];
            int chunkZ = coord[1];
            try {
                int processed;
                Chunk chunk = region.getChunk(chunkX, chunkZ);
                if (chunk != null) {
                    BlockInfo[][] chunkBlocks = this.processChunk(chunk, localFoundBlocks, sampleInterval);
                    results.put(chunkX + "," + chunkZ, chunkBlocks);
                } else {
                    results.put(chunkX + "," + chunkZ, null);
                }
                if ((processed = this.processedChunks.incrementAndGet()) % 8 != 0) continue;
                this.updateProgress();
            }
            catch (Exception e) {
                System.err.println("\u5904\u7406\u533a\u5757 (" + chunkX + ", " + chunkZ + ") \u65f6\u51fa\u9519: " + e.getMessage());
                results.put(chunkX + "," + chunkZ, null);
            }
        }
        this.foundBlocks.addAll(localFoundBlocks);
        return results;
    }

    private BlockInfo[][] processChunk(Chunk chunk, Set<String> localFoundBlocks, int sampleInterval) {
        BlockInfo[][] chunkBlocks = new BlockInfo[16][16];
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                chunkBlocks[i][j] = new BlockInfo("air", -64);
            }
        }
        ArrayList<int[]> sampleCoords = new ArrayList<int[]>();
        for (int localZ = 0; localZ < 16; ++localZ) {
            for (int localX = 0; localX < 16; ++localX) {
                if (sampleInterval != 1 && (localX % sampleInterval != 0 || localZ % sampleInterval != 0)) continue;
                sampleCoords.add(new int[]{localX, localZ});
            }
        }
        boolean[][] foundBlocks = new boolean[16][16];
        boolean hasSections = chunk.hasSections();
        if (hasSections) {
            for (int[] coord : sampleCoords) {
                int localX = coord[0];
                int localZ = coord[1];
                String resultBlockId = "air";
                int topY = -1;
                for (int y = 319; y >= -64; --y) {
                    try {
                        Block block = chunk.getBlock(localX, y, localZ);
                        if (block == null || BlockColors.isAirBlock(block.getId())) continue;
                        resultBlockId = block.getId();
                        topY = y;
                        break;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (!"air".equals(resultBlockId) && topY >= -64) {
                    String blockId = resultBlockId;
                    if (blockId.startsWith("minecraft:")) {
                        blockId = blockId.substring("minecraft:".length());
                    }
                    chunkBlocks[localZ][localX] = new BlockInfo(blockId, topY);
                    localFoundBlocks.add(blockId);
                    foundBlocks[localZ][localX] = true;
                    continue;
                }
                chunkBlocks[localZ][localX] = new BlockInfo("air", -64);
            }
            if (sampleInterval > 1) {
                this.fillUnsampledBlocks(chunkBlocks, foundBlocks, sampleInterval);
            }
        }
        return chunkBlocks;
    }

    private void fillUnsampledBlocks(BlockInfo[][] chunkBlocks, boolean[][] foundBlocks, int sampleInterval) {
        for (int localZ = 0; localZ < 16; ++localZ) {
            for (int localX = 0; localX < 16; ++localX) {
                if (foundBlocks[localZ][localX]) continue;
                int sampleX = localX / sampleInterval * sampleInterval;
                int sampleZ = localZ / sampleInterval * sampleInterval;
                if (sampleX >= 16) {
                    sampleX = 16 - sampleInterval;
                }
                if (sampleZ >= 16) {
                    sampleZ = 16 - sampleInterval;
                }
                chunkBlocks[localZ][localX] = foundBlocks[sampleZ][sampleX] ? chunkBlocks[sampleZ][sampleX] : new BlockInfo("air", -64);
            }
        }
    }

    private void updateProgress() {
        if (this.progressCallback != null) {
            int processed = this.processedChunks.get();
            int total = this.totalChunks.get();
            long elapsed = System.currentTimeMillis() - this.startTime.get();
            double speed = (double)processed / Math.max(0.1, (double)elapsed / 1000.0);
            this.progressCallback.onProgress(processed, total, speed, new HashSet<String>(this.foundBlocks));
        }
    }

    public BufferedImage renderToPng(BlockInfo[][] topBlocks, int sampleInterval) {
        if (topBlocks == null) {
            System.err.println("\u65e0\u6cd5\u6e32\u67d3\uff1a\u9876\u90e8\u65b9\u5757\u6570\u636e\u4e3a\u7a7a");
            return null;
        }
        System.out.println("\u6b63\u5728\u6e32\u67d3PNG\u56fe\u50cf...");
        long startTime = System.currentTimeMillis();
        int height = topBlocks.length;
        int width = topBlocks[0].length;
        if (height <= 0 || width <= 0) {
            System.err.println("\u65e0\u6548\u7684\u6570\u7ec4\u5927\u5c0f: " + width + "x" + height);
            return null;
        }
        if (sampleInterval > 1) {
            System.out.println("\u6ce8\u610f\uff1a\u4f7f\u7528\u4e86\u4f18\u5316\u91c7\u6837\uff08\u6bcf" + sampleInterval + "\u4e2a\u65b9\u5757\u91c7\u68371\u6b21\uff09\uff0c\u56fe\u50cf\u8d28\u91cf\u53ef\u80fd\u7565\u6709\u964d\u4f4e");
        }
        System.out.println("\u56fe\u50cf\u5927\u5c0f: " + width + "x" + height + "\u50cf\u7d20");
        BufferedImage image = new BufferedImage(width, height, 2);
        int[] pixels = new int[width * height];
        System.out.println("\u6b63\u5728\u9884\u5904\u7406\u65b9\u5757\u989c\u8272...");
        HashSet<String> uniqueBlocks = new HashSet<String>();
        BlockInfo[][] blockInfoArray = topBlocks;
        int n = blockInfoArray.length;
        for (int i = 0; i < n; ++i) {
            BlockInfo[] row;
            for (BlockInfo blockInfo : row = blockInfoArray[i]) {
                if (blockInfo == null || blockInfo.getBlockId() == null) continue;
                uniqueBlocks.add(blockInfo.getBlockId());
            }
        }
        HashMap<String, Color> blockColorMap = new HashMap<String, Color>();
        for (String blockId : uniqueBlocks) {
            if (blockId == null) continue;
            blockColorMap.put(blockId, BlockColors.getBlockColor(blockId));
        }
        System.out.println("\u6b63\u5728\u586b\u5145\u50cf\u7d20\u6570\u7ec4\u5e76\u5904\u7406\u9ad8\u5ea6\u5dee\u6548\u679c...");
        int errorCount = 0;
        int updateInterval = Math.max(1, height / 10);
        int HEIGHT_DIFF_THRESHOLD = 3;
        int MAX_HEIGHT_DIFF = 50;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                try {
                    int[][] directions;
                    Color baseColor;
                    int currentHeight;
                    BlockInfo currentBlock = topBlocks[i][j];
                    String blockId = currentBlock != null ? currentBlock.getBlockId() : null;
                    int n2 = currentHeight = currentBlock != null ? currentBlock.getHeight() : -64;
                    if (blockId == null || !blockColorMap.containsKey(blockId)) {
                        baseColor = new Color(255, 0, 255, 255);
                        ++errorCount;
                    } else {
                        baseColor = (Color)blockColorMap.get(blockId);
                    }
                    boolean shouldDrawEdge = false;
                    int maxHeightDiff = 0;
                    for (int[] dir : directions = new int[][]{{-1, 0}, {1, 0}, {0, -1}, {0, 1}}) {
                        BlockInfo neighborBlock;
                        int neighborHeight;
                        int heightDiff;
                        int ni = i + dir[0];
                        int nj = j + dir[1];
                        if (ni < 0 || ni >= height || nj < 0 || nj >= width || (heightDiff = Math.abs(currentHeight - (neighborHeight = (neighborBlock = topBlocks[ni][nj]) != null ? neighborBlock.getHeight() : -64))) <= 3) continue;
                        shouldDrawEdge = true;
                        maxHeightDiff = Math.max(maxHeightDiff, heightDiff);
                    }
                    Color finalColor = baseColor;
                    if (shouldDrawEdge) {
                        float intensity = Math.min(1.0f, (float)maxHeightDiff / 50.0f);
                        int r = (int)((float)baseColor.getRed() * (1.0f - intensity * 0.7f));
                        int g = (int)((float)baseColor.getGreen() * (1.0f - intensity * 0.7f));
                        int b = (int)((float)baseColor.getBlue() * (1.0f - intensity * 0.7f));
                        finalColor = new Color(r, g, b, baseColor.getAlpha());
                    }
                    pixels[i * width + j] = finalColor.getRGB();
                    continue;
                }
                catch (Exception e) {
                    image.setRGB(j, i, new Color(128, 0, 128, 255).getRGB());
                    ++errorCount;
                }
            }
            if (i % updateInterval != 0) continue;
            int percent = i * 100 / height;
            System.out.print("\r\u56fe\u50cf\u6e32\u67d3: " + percent + "% \u5b8c\u6210");
            System.out.flush();
        }
        image.setRGB(0, 0, width, height, pixels, 0, width);
        if (errorCount > 0) {
            System.out.println("\n\u6ce8\u610f\uff1a\u5904\u7406\u8fc7\u7a0b\u4e2d\u6709 " + errorCount + " \u4e2a\u50cf\u7d20\u51fa\u73b0\u9519\u8bef (" + String.format("%.2f", (double)errorCount * 100.0 / (double)(width * height)) + "%)");
        }
        long totalTime = System.currentTimeMillis() - startTime;
        System.out.println("\n\u6e32\u67d3\u5b8c\u6210\uff0c\u8017\u65f6: " + (double)totalTime / 1000.0 + "\u79d2");
        return image;
    }

    public String getPerformanceReport() {
        StringBuilder report = new StringBuilder();
        report.append("=== \u6027\u80fd\u62a5\u544a ===\n");
        report.append("\u603b\u6e32\u67d3\u65f6\u95f4: ").append(this.totalRenderTime.get()).append("ms\n");
        report.append("\u603b\u56fe\u50cf\u751f\u6210\u65f6\u95f4: ").append(this.totalImageTime.get()).append("ms\n");
        report.append("\u5904\u7406\u7684\u533a\u5757\u6570: ").append(this.totalRenderedChunks.get()).append("\n");
        report.append("\u53d1\u73b0\u7684\u65b9\u5757\u7c7b\u578b: ").append(this.foundBlocks.size()).append("\n");
        if (this.totalRenderedChunks.get() > 0) {
            double avgRenderTime = (double)this.totalRenderTime.get() / (double)this.totalRenderedChunks.get();
            report.append("\u5e73\u5747\u6bcf\u533a\u5757\u6e32\u67d3\u65f6\u95f4: ").append(String.format("%.2f", avgRenderTime)).append("ms\n");
        }
        return report.toString();
    }

    public BufferedImage renderProgressively(String mcaFilePath, int regionSize, int sampleInterval) {
        try {
            System.out.println("\u5f00\u59cb\u6e10\u8fdb\u5f0f\u6e32\u67d3: " + mcaFilePath);
            long renderStartTime = System.currentTimeMillis();
            BlockInfo[][] topBlocks = this.getTopBlocks(mcaFilePath, regionSize, sampleInterval);
            long renderTime = System.currentTimeMillis() - renderStartTime;
            this.totalRenderTime.addAndGet(renderTime);
            if (topBlocks != null) {
                long imageStartTime = System.currentTimeMillis();
                BufferedImage result = this.renderToPng(topBlocks, sampleInterval);
                long imageTime = System.currentTimeMillis() - imageStartTime;
                this.totalImageTime.addAndGet(imageTime);
                this.totalRenderedChunks.addAndGet(this.processedChunks.get());
                if (this.progressCallback != null && result != null) {
                    this.progressCallback.onProgressiveRender(result, this.processedChunks.get(), this.totalChunks.get());
                }
                return result;
            }
        }
        catch (Exception e) {
            System.err.println("\u6e10\u8fdb\u5f0f\u6e32\u67d3\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public void shutdown() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static interface ProgressCallback {
        public void onProgress(int var1, int var2, double var3, Set<String> var5);

        public void onProgressiveRender(BufferedImage var1, int var2, int var3);
    }

    public static class BlockInfo {
        private final String blockId;
        private final int height;

        public BlockInfo(String blockId, int height) {
            this.blockId = blockId;
            this.height = height;
        }

        public String getBlockId() {
            return this.blockId;
        }

        public int getHeight() {
            return this.height;
        }

        public String toString() {
            return this.blockId + "@" + this.height;
        }
    }
}

