/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.core;

import com.minecraft.selector.region.Chunk;
import com.minecraft.selector.region.Region;
import com.minecraft.selector.utils.LRUCache;
import java.util.concurrent.ConcurrentHashMap;

public class CacheManager {
    private static final CacheManager INSTANCE = new CacheManager();
    private static final int REGION_CACHE_SIZE = 16;
    private static final int CHUNK_CACHE_SIZE = 256;
    private final LRUCache<String, Region> regionCache = new LRUCache(16);
    private final LRUCache<String, Chunk> chunkCache = new LRUCache(256);
    private final ConcurrentHashMap<String, Object> locks = new ConcurrentHashMap();

    private CacheManager() {
    }

    public static CacheManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region getRegion(String regionPath) {
        Object lock;
        Region region = this.regionCache.getSafe(regionPath);
        if (region != null) {
            return region;
        }
        Object object = lock = this.locks.computeIfAbsent(regionPath, k -> new Object());
        synchronized (object) {
            Region region2;
            region = this.regionCache.getSafe(regionPath);
            if (region != null) {
                return region;
            }
            try {
                region = Region.fromFile(regionPath);
                if (region != null) {
                    this.regionCache.putSafe(regionPath, region);
                }
                region2 = region;
                this.locks.remove(regionPath);
            }
            catch (Exception e) {
                Region region3;
                try {
                    System.err.println("\u52a0\u8f7dRegion\u6587\u4ef6\u5931\u8d25: " + regionPath + " - " + e.getMessage());
                    region3 = null;
                    this.locks.remove(regionPath);
                }
                catch (Throwable throwable) {
                    this.locks.remove(regionPath);
                    throw throwable;
                }
                return region3;
            }
            return region2;
        }
    }

    public Chunk getChunk(Region region, int chunkX, int chunkZ) {
        String chunkKey = chunkX + "," + chunkZ;
        Chunk chunk = this.chunkCache.getSafe(chunkKey);
        if (chunk != null) {
            return chunk;
        }
        try {
            chunk = Chunk.fromRegion(region, chunkX, chunkZ);
            if (chunk != null) {
                this.chunkCache.putSafe(chunkKey, chunk);
            }
            return chunk;
        }
        catch (Exception e) {
            System.err.println("\u52a0\u8f7dChunk\u5931\u8d25: " + chunkKey + " - " + e.getMessage());
            return null;
        }
    }

    public void preloadChunks(Region region, int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ) {
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                if (!region.chunkExists(chunkX, chunkZ)) continue;
                this.getChunk(region, chunkX, chunkZ);
            }
        }
    }

    public void clearCache() {
        this.regionCache.clear();
        this.chunkCache.clear();
        this.regionCache.resetStats();
        this.chunkCache.resetStats();
    }

    public String getCacheStats() {
        return "Region " + this.regionCache.getStats() + "\nChunk " + this.chunkCache.getStats();
    }

    public String getMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        long maxMemory = runtime.maxMemory();
        return String.format("\u5185\u5b58\u4f7f\u7528: %d MB / %d MB (%.1f%%), \u7f13\u5b58: Region=%d, Chunk=%d", usedMemory / 1024L / 1024L, maxMemory / 1024L / 1024L, (double)usedMemory / (double)maxMemory * 100.0, this.regionCache.size(), this.chunkCache.size());
    }
}

