/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.core;

import com.minecraft.selector.core.MinecraftResourceExtractor;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class BlockColors {
    private static final Map<String, Color> BLOCK_COLORS = new HashMap<String, Color>();
    private static final Map<String, Color> COLOR_CACHE = new ConcurrentHashMap<String, Color>();
    private static MinecraftResourceExtractor resourceExtractor = null;

    public static Color getBlockColor(String blockId) {
        if (COLOR_CACHE.containsKey(blockId)) {
            return COLOR_CACHE.get(blockId);
        }
        Color color = BlockColors.calculateBlockColor(blockId);
        COLOR_CACHE.put(blockId, color);
        return color;
    }

    public static void setResourceExtractor(MinecraftResourceExtractor extractor) {
        resourceExtractor = extractor;
        COLOR_CACHE.clear();
    }

    public static boolean initializeColorsFromSavePath(String savePath) {
        String modsPath;
        MinecraftResourceExtractor extractor = new MinecraftResourceExtractor();
        boolean success = false;
        List<String> jarPaths = MinecraftResourceExtractor.findMinecraftJarsFromSavePath(savePath);
        if (!jarPaths.isEmpty()) {
            for (String jarPath : jarPaths) {
                if (!extractor.extractColorsFromMinecraftJar(jarPath)) continue;
                System.out.println("\u6210\u529f\u4eceMinecraft JAR\u52a0\u8f7d\u989c\u8272: " + jarPath);
                success = true;
                break;
            }
        }
        if ((modsPath = MinecraftResourceExtractor.findModsDirectoryFromSavePath(savePath)) != null) {
            if (extractor.extractColorsFromModsDirectory(modsPath)) {
                System.out.println("\u6210\u529f\u4ecemods\u76ee\u5f55\u52a0\u8f7d\u989c\u8272: " + modsPath);
                success = true;
            }
        } else {
            System.out.println("\u672a\u627e\u5230mods\u76ee\u5f55\uff0c\u8df3\u8fc7mod\u989c\u8272\u52a0\u8f7d");
        }
        if (success) {
            BlockColors.setResourceExtractor(extractor);
            System.out.println("\u989c\u8272\u63d0\u53d6\u5668\u521d\u59cb\u5316\u5b8c\u6210");
        } else {
            System.out.println("\u989c\u8272\u63d0\u53d6\u5668\u521d\u59cb\u5316\u5931\u8d25\uff0c\u5c06\u4f7f\u7528\u9ed8\u8ba4\u989c\u8272");
        }
        return success;
    }

    private static Color calculateBlockColor(String blockId) {
        Color extractedColor;
        if (blockId == null || blockId.isEmpty()) {
            return new Color(255, 0, 255, 128);
        }
        if (resourceExtractor != null && resourceExtractor.isExtractionCompleted() && (extractedColor = resourceExtractor.getExtractedColor(blockId)) != null) {
            return extractedColor;
        }
        String processedId = blockId;
        if (blockId.contains(":")) {
            String[] parts = blockId.split(":", 2);
            processedId = "minecraft".equals(parts[0]) ? parts[1] : blockId;
        }
        if (BLOCK_COLORS.containsKey(processedId)) {
            return BLOCK_COLORS.get(processedId);
        }
        Color variantColor = BlockColors.matchVariantBlock(processedId);
        if (variantColor != null) {
            return variantColor;
        }
        for (String key : BLOCK_COLORS.keySet()) {
            if (!processedId.contains(key)) continue;
            return BLOCK_COLORS.get(key);
        }
        int hash = blockId.hashCode();
        Random random = new Random(hash);
        int r = random.nextInt(200) + 55;
        int g = random.nextInt(200) + 55;
        int b = random.nextInt(200) + 55;
        return new Color(r, g, b, 255);
    }

    private static Color matchVariantBlock(String blockId) {
        String colorName;
        String baseBlock;
        if (blockId.endsWith("_stairs")) {
            baseBlock = blockId.replace("_stairs", "");
            if (BLOCK_COLORS.containsKey(baseBlock)) {
                return BLOCK_COLORS.get(baseBlock);
            }
            if (baseBlock.equals("oak")) {
                return BLOCK_COLORS.get("oak_planks");
            }
            if (baseBlock.equals("spruce")) {
                return BLOCK_COLORS.get("spruce_planks");
            }
            if (baseBlock.equals("birch")) {
                return BLOCK_COLORS.get("birch_planks");
            }
            if (baseBlock.equals("jungle")) {
                return BLOCK_COLORS.get("jungle_planks");
            }
            if (baseBlock.equals("acacia")) {
                return BLOCK_COLORS.get("acacia_planks");
            }
            if (baseBlock.equals("dark_oak")) {
                return BLOCK_COLORS.get("dark_oak_planks");
            }
        }
        if (blockId.endsWith("_slab")) {
            baseBlock = blockId.replace("_slab", "");
            if (BLOCK_COLORS.containsKey(baseBlock)) {
                return BLOCK_COLORS.get(baseBlock);
            }
            if (baseBlock.equals("oak")) {
                return BLOCK_COLORS.get("oak_planks");
            }
            if (baseBlock.equals("spruce")) {
                return BLOCK_COLORS.get("spruce_planks");
            }
            if (baseBlock.equals("birch")) {
                return BLOCK_COLORS.get("birch_planks");
            }
            if (baseBlock.equals("jungle")) {
                return BLOCK_COLORS.get("jungle_planks");
            }
            if (baseBlock.equals("acacia")) {
                return BLOCK_COLORS.get("acacia_planks");
            }
            if (baseBlock.equals("dark_oak")) {
                return BLOCK_COLORS.get("dark_oak_planks");
            }
        }
        if (blockId.endsWith("_fence") || blockId.endsWith("_fence_gate")) {
            baseBlock = blockId.replace("_fence_gate", "").replace("_fence", "");
            if (baseBlock.equals("oak")) {
                return BLOCK_COLORS.get("oak_planks");
            }
            if (baseBlock.equals("spruce")) {
                return BLOCK_COLORS.get("spruce_planks");
            }
            if (baseBlock.equals("birch")) {
                return BLOCK_COLORS.get("birch_planks");
            }
            if (baseBlock.equals("jungle")) {
                return BLOCK_COLORS.get("jungle_planks");
            }
            if (baseBlock.equals("acacia")) {
                return BLOCK_COLORS.get("acacia_planks");
            }
            if (baseBlock.equals("dark_oak")) {
                return BLOCK_COLORS.get("dark_oak_planks");
            }
            if (baseBlock.equals("nether_brick")) {
                return BLOCK_COLORS.get("nether_bricks");
            }
        }
        if (blockId.endsWith("_door") || blockId.endsWith("_trapdoor")) {
            baseBlock = blockId.replace("_trapdoor", "").replace("_door", "");
            if (baseBlock.equals("oak")) {
                return BLOCK_COLORS.get("oak_planks");
            }
            if (baseBlock.equals("spruce")) {
                return BLOCK_COLORS.get("spruce_planks");
            }
            if (baseBlock.equals("birch")) {
                return BLOCK_COLORS.get("birch_planks");
            }
            if (baseBlock.equals("jungle")) {
                return BLOCK_COLORS.get("jungle_planks");
            }
            if (baseBlock.equals("acacia")) {
                return BLOCK_COLORS.get("acacia_planks");
            }
            if (baseBlock.equals("dark_oak")) {
                return BLOCK_COLORS.get("dark_oak_planks");
            }
            if (baseBlock.equals("iron")) {
                return new Color(191, 191, 191);
            }
        }
        if (blockId.endsWith("_pressure_plate") || blockId.endsWith("_button")) {
            baseBlock = blockId.replace("_pressure_plate", "").replace("_button", "");
            if (baseBlock.equals("oak")) {
                return BLOCK_COLORS.get("oak_planks");
            }
            if (baseBlock.equals("spruce")) {
                return BLOCK_COLORS.get("spruce_planks");
            }
            if (baseBlock.equals("birch")) {
                return BLOCK_COLORS.get("birch_planks");
            }
            if (baseBlock.equals("jungle")) {
                return BLOCK_COLORS.get("jungle_planks");
            }
            if (baseBlock.equals("acacia")) {
                return BLOCK_COLORS.get("acacia_planks");
            }
            if (baseBlock.equals("dark_oak")) {
                return BLOCK_COLORS.get("dark_oak_planks");
            }
            if (baseBlock.equals("stone")) {
                return BLOCK_COLORS.get("stone");
            }
        }
        if (blockId.endsWith("_carpet") && BLOCK_COLORS.containsKey((colorName = blockId.replace("_carpet", "")) + "_wool")) {
            return BLOCK_COLORS.get(colorName + "_wool");
        }
        return null;
    }

    public static void clearCache() {
        COLOR_CACHE.clear();
    }

    public static int getCacheSize() {
        return COLOR_CACHE.size();
    }

    public static boolean isAirBlock(String blockId) {
        return "air".equals(blockId) || "cave_air".equals(blockId) || "void_air".equals(blockId) || "none".equals(blockId);
    }

    static {
        BLOCK_COLORS.put("stone", new Color(127, 127, 127));
        BLOCK_COLORS.put("cobblestone", new Color(110, 110, 110));
        BLOCK_COLORS.put("granite", new Color(154, 123, 100));
        BLOCK_COLORS.put("diorite", new Color(207, 207, 207));
        BLOCK_COLORS.put("andesite", new Color(138, 138, 138));
        BLOCK_COLORS.put("coal_ore", new Color(46, 46, 46));
        BLOCK_COLORS.put("iron_ore", new Color(197, 145, 106));
        BLOCK_COLORS.put("gold_ore", new Color(252, 222, 112));
        BLOCK_COLORS.put("diamond_ore", new Color(93, 236, 245));
        BLOCK_COLORS.put("emerald_ore", new Color(23, 221, 98));
        BLOCK_COLORS.put("lapis_ore", new Color(22, 64, 201));
        BLOCK_COLORS.put("redstone_ore", new Color(255, 0, 0));
        BLOCK_COLORS.put("dirt", new Color(139, 111, 63));
        BLOCK_COLORS.put("grass_block", new Color(85, 174, 58));
        BLOCK_COLORS.put("podzol", new Color(106, 67, 27));
        BLOCK_COLORS.put("mycelium", new Color(126, 108, 140));
        BLOCK_COLORS.put("sand", new Color(219, 207, 142));
        BLOCK_COLORS.put("red_sand", new Color(189, 106, 55));
        BLOCK_COLORS.put("gravel", new Color(150, 141, 125));
        BLOCK_COLORS.put("oak_log", new Color(188, 152, 98));
        BLOCK_COLORS.put("spruce_log", new Color(109, 84, 59));
        BLOCK_COLORS.put("birch_log", new Color(215, 203, 143));
        BLOCK_COLORS.put("jungle_log", new Color(151, 114, 80));
        BLOCK_COLORS.put("acacia_log", new Color(169, 88, 33));
        BLOCK_COLORS.put("dark_oak_log", new Color(76, 51, 25));
        BLOCK_COLORS.put("oak_leaves", new Color(42, 132, 39));
        BLOCK_COLORS.put("spruce_leaves", new Color(23, 89, 44));
        BLOCK_COLORS.put("birch_leaves", new Color(115, 197, 72));
        BLOCK_COLORS.put("jungle_leaves", new Color(34, 130, 31));
        BLOCK_COLORS.put("acacia_leaves", new Color(95, 175, 53));
        BLOCK_COLORS.put("dark_oak_leaves", new Color(32, 92, 22));
        BLOCK_COLORS.put("pale_oak_leaves", new Color(85, 140, 75));
        BLOCK_COLORS.put("water", new Color(60, 68, 170));
        BLOCK_COLORS.put("lava", new Color(234, 92, 15));
        BLOCK_COLORS.put("ice", new Color(160, 233, 255));
        BLOCK_COLORS.put("snow", new Color(255, 255, 255));
        BLOCK_COLORS.put("snow_block", new Color(243, 244, 251));
        BLOCK_COLORS.put("grass", new Color(88, 169, 47));
        BLOCK_COLORS.put("tall_grass", new Color(94, 174, 49));
        BLOCK_COLORS.put("fern", new Color(82, 139, 62));
        BLOCK_COLORS.put("large_fern", new Color(82, 139, 62));
        BLOCK_COLORS.put("dandelion", new Color(255, 236, 79));
        BLOCK_COLORS.put("poppy", new Color(237, 48, 44));
        BLOCK_COLORS.put("bedrock", new Color(10, 10, 10));
        BLOCK_COLORS.put("obsidian", new Color(21, 18, 30));
        BLOCK_COLORS.put("netherrack", new Color(114, 58, 57));
        BLOCK_COLORS.put("soul_sand", new Color(85, 67, 54));
        BLOCK_COLORS.put("glowstone", new Color(254, 217, 63));
        BLOCK_COLORS.put("end_stone", new Color(219, 222, 158));
        BLOCK_COLORS.put("oak_stairs", new Color(162, 130, 78));
        BLOCK_COLORS.put("stone_stairs", new Color(127, 127, 127));
        BLOCK_COLORS.put("cobblestone_stairs", new Color(110, 110, 110));
        BLOCK_COLORS.put("brick_stairs", new Color(150, 97, 83));
        BLOCK_COLORS.put("stone_brick_stairs", new Color(122, 122, 122));
        BLOCK_COLORS.put("nether_brick_stairs", new Color(44, 21, 26));
        BLOCK_COLORS.put("sandstone_stairs", new Color(219, 207, 142));
        BLOCK_COLORS.put("spruce_stairs", new Color(114, 84, 48));
        BLOCK_COLORS.put("birch_stairs", new Color(196, 177, 123));
        BLOCK_COLORS.put("jungle_stairs", new Color(160, 115, 80));
        BLOCK_COLORS.put("acacia_stairs", new Color(168, 90, 50));
        BLOCK_COLORS.put("dark_oak_stairs", new Color(66, 43, 20));
        BLOCK_COLORS.put("quartz_stairs", new Color(235, 229, 222));
        BLOCK_COLORS.put("red_sandstone_stairs", new Color(189, 106, 55));
        BLOCK_COLORS.put("purpur_stairs", new Color(169, 125, 169));
        BLOCK_COLORS.put("oak_slab", new Color(162, 130, 78));
        BLOCK_COLORS.put("stone_slab", new Color(127, 127, 127));
        BLOCK_COLORS.put("cobblestone_slab", new Color(110, 110, 110));
        BLOCK_COLORS.put("brick_slab", new Color(150, 97, 83));
        BLOCK_COLORS.put("stone_brick_slab", new Color(122, 122, 122));
        BLOCK_COLORS.put("nether_brick_slab", new Color(44, 21, 26));
        BLOCK_COLORS.put("sandstone_slab", new Color(219, 207, 142));
        BLOCK_COLORS.put("spruce_slab", new Color(114, 84, 48));
        BLOCK_COLORS.put("birch_slab", new Color(196, 177, 123));
        BLOCK_COLORS.put("jungle_slab", new Color(160, 115, 80));
        BLOCK_COLORS.put("acacia_slab", new Color(168, 90, 50));
        BLOCK_COLORS.put("dark_oak_slab", new Color(66, 43, 20));
        BLOCK_COLORS.put("quartz_slab", new Color(235, 229, 222));
        BLOCK_COLORS.put("red_sandstone_slab", new Color(189, 106, 55));
        BLOCK_COLORS.put("purpur_slab", new Color(169, 125, 169));
        BLOCK_COLORS.put("oak_fence", new Color(142, 110, 68));
        BLOCK_COLORS.put("spruce_fence", new Color(94, 64, 38));
        BLOCK_COLORS.put("birch_fence", new Color(176, 157, 103));
        BLOCK_COLORS.put("jungle_fence", new Color(140, 95, 60));
        BLOCK_COLORS.put("acacia_fence", new Color(148, 70, 30));
        BLOCK_COLORS.put("dark_oak_fence", new Color(46, 23, 10));
        BLOCK_COLORS.put("nether_brick_fence", new Color(44, 21, 26));
        BLOCK_COLORS.put("oak_fence_gate", new Color(142, 110, 68));
        BLOCK_COLORS.put("spruce_fence_gate", new Color(94, 64, 38));
        BLOCK_COLORS.put("birch_fence_gate", new Color(176, 157, 103));
        BLOCK_COLORS.put("jungle_fence_gate", new Color(140, 95, 60));
        BLOCK_COLORS.put("acacia_fence_gate", new Color(148, 70, 30));
        BLOCK_COLORS.put("dark_oak_fence_gate", new Color(46, 23, 10));
        BLOCK_COLORS.put("oak_door", new Color(162, 130, 78));
        BLOCK_COLORS.put("spruce_door", new Color(114, 84, 48));
        BLOCK_COLORS.put("birch_door", new Color(196, 177, 123));
        BLOCK_COLORS.put("jungle_door", new Color(160, 115, 80));
        BLOCK_COLORS.put("acacia_door", new Color(168, 90, 50));
        BLOCK_COLORS.put("dark_oak_door", new Color(66, 43, 20));
        BLOCK_COLORS.put("iron_door", new Color(191, 191, 191));
        BLOCK_COLORS.put("oak_trapdoor", new Color(162, 130, 78));
        BLOCK_COLORS.put("spruce_trapdoor", new Color(114, 84, 48));
        BLOCK_COLORS.put("birch_trapdoor", new Color(196, 177, 123));
        BLOCK_COLORS.put("jungle_trapdoor", new Color(160, 115, 80));
        BLOCK_COLORS.put("acacia_trapdoor", new Color(168, 90, 50));
        BLOCK_COLORS.put("dark_oak_trapdoor", new Color(66, 43, 20));
        BLOCK_COLORS.put("iron_trapdoor", new Color(191, 191, 191));
        BLOCK_COLORS.put("chest", new Color(162, 130, 78));
        BLOCK_COLORS.put("trapped_chest", new Color(162, 130, 78));
        BLOCK_COLORS.put("ender_chest", new Color(21, 18, 30));
        BLOCK_COLORS.put("shulker_box", new Color(139, 90, 181));
        BLOCK_COLORS.put("barrel", new Color(114, 84, 48));
        BLOCK_COLORS.put("furnace", new Color(127, 127, 127));
        BLOCK_COLORS.put("blast_furnace", new Color(107, 107, 107));
        BLOCK_COLORS.put("smoker", new Color(97, 97, 97));
        BLOCK_COLORS.put("crafting_table", new Color(162, 130, 78));
        BLOCK_COLORS.put("cartography_table", new Color(162, 130, 78));
        BLOCK_COLORS.put("fletching_table", new Color(162, 130, 78));
        BLOCK_COLORS.put("smithing_table", new Color(162, 130, 78));
        BLOCK_COLORS.put("loom", new Color(162, 130, 78));
        BLOCK_COLORS.put("composter", new Color(162, 130, 78));
        BLOCK_COLORS.put("oak_pressure_plate", new Color(162, 130, 78));
        BLOCK_COLORS.put("spruce_pressure_plate", new Color(114, 84, 48));
        BLOCK_COLORS.put("birch_pressure_plate", new Color(196, 177, 123));
        BLOCK_COLORS.put("jungle_pressure_plate", new Color(160, 115, 80));
        BLOCK_COLORS.put("acacia_pressure_plate", new Color(168, 90, 50));
        BLOCK_COLORS.put("dark_oak_pressure_plate", new Color(66, 43, 20));
        BLOCK_COLORS.put("stone_pressure_plate", new Color(127, 127, 127));
        BLOCK_COLORS.put("light_weighted_pressure_plate", new Color(255, 215, 0));
        BLOCK_COLORS.put("heavy_weighted_pressure_plate", new Color(191, 191, 191));
        BLOCK_COLORS.put("oak_button", new Color(162, 130, 78));
        BLOCK_COLORS.put("spruce_button", new Color(114, 84, 48));
        BLOCK_COLORS.put("birch_button", new Color(196, 177, 123));
        BLOCK_COLORS.put("jungle_button", new Color(160, 115, 80));
        BLOCK_COLORS.put("acacia_button", new Color(168, 90, 50));
        BLOCK_COLORS.put("dark_oak_button", new Color(66, 43, 20));
        BLOCK_COLORS.put("stone_button", new Color(127, 127, 127));
        BLOCK_COLORS.put("redstone_wire", new Color(255, 0, 0));
        BLOCK_COLORS.put("redstone_torch", new Color(255, 0, 0));
        BLOCK_COLORS.put("redstone_block", new Color(255, 0, 0));
        BLOCK_COLORS.put("repeater", new Color(127, 127, 127));
        BLOCK_COLORS.put("comparator", new Color(127, 127, 127));
        BLOCK_COLORS.put("lever", new Color(127, 127, 127));
        BLOCK_COLORS.put("flower_pot", new Color(139, 111, 63));
        BLOCK_COLORS.put("potted_oak_sapling", new Color(139, 111, 63));
        BLOCK_COLORS.put("potted_spruce_sapling", new Color(139, 111, 63));
        BLOCK_COLORS.put("potted_birch_sapling", new Color(139, 111, 63));
        BLOCK_COLORS.put("potted_jungle_sapling", new Color(139, 111, 63));
        BLOCK_COLORS.put("potted_acacia_sapling", new Color(139, 111, 63));
        BLOCK_COLORS.put("potted_dark_oak_sapling", new Color(139, 111, 63));
        BLOCK_COLORS.put("white_carpet", new Color(249, 255, 254));
        BLOCK_COLORS.put("orange_carpet", new Color(249, 128, 29));
        BLOCK_COLORS.put("magenta_carpet", new Color(199, 78, 189));
        BLOCK_COLORS.put("light_blue_carpet", new Color(58, 179, 218));
        BLOCK_COLORS.put("yellow_carpet", new Color(254, 216, 61));
        BLOCK_COLORS.put("lime_carpet", new Color(128, 199, 31));
        BLOCK_COLORS.put("pink_carpet", new Color(243, 139, 170));
        BLOCK_COLORS.put("gray_carpet", new Color(71, 79, 82));
        BLOCK_COLORS.put("light_gray_carpet", new Color(157, 157, 151));
        BLOCK_COLORS.put("cyan_carpet", new Color(22, 156, 156));
        BLOCK_COLORS.put("purple_carpet", new Color(137, 50, 184));
        BLOCK_COLORS.put("blue_carpet", new Color(60, 68, 170));
        BLOCK_COLORS.put("brown_carpet", new Color(131, 84, 50));
        BLOCK_COLORS.put("green_carpet", new Color(94, 124, 22));
        BLOCK_COLORS.put("red_carpet", new Color(176, 46, 38));
        BLOCK_COLORS.put("black_carpet", new Color(29, 29, 33));
        BLOCK_COLORS.put("air", new Color(255, 255, 255, 0));
        BLOCK_COLORS.put("cave_air", new Color(255, 255, 255, 0));
        BLOCK_COLORS.put("void_air", new Color(255, 255, 255, 0));
        BLOCK_COLORS.put("none", new Color(255, 255, 255, 0));
    }
}

