/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.minecraft.selector.core.MapRenderer;
import com.minecraft.selector.gui.MinecraftMapGUI;
import com.minecraft.selector.gui.UIThemeManager;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;

public class MinecraftMapSelector {
    public static void main(String[] args) {
        UIThemeManager.getInstance().initializeTheme();
        System.out.println("Minecraft\u5730\u56fe\u9009\u62e9\u5668 - Java\u7248\u672c");
        System.out.println("\u63a5\u6536\u5230\u7684\u53c2\u6570\u6570\u91cf: " + args.length);
        for (int i = 0; i < args.length; ++i) {
            System.out.println("\u53c2\u6570[" + i + "]: " + args[i]);
        }
        String tempWorldPath = null;
        String tempOutputFile = null;
        String tempJarPath = null;
        int tempMinY = 0;
        int tempMaxY = 255;
        for (int i = 0; i < args.length - 1; ++i) {
            if ("--world-path".equals(args[i])) {
                tempWorldPath = args[i + 1];
                continue;
            }
            if ("--output-file".equals(args[i])) {
                tempOutputFile = args[i + 1];
                continue;
            }
            if ("--jar-path".equals(args[i])) {
                tempJarPath = args[i + 1];
                continue;
            }
            if ("--min-y".equals(args[i])) {
                try {
                    tempMinY = Integer.parseInt(args[i + 1]);
                }
                catch (NumberFormatException e) {
                    System.err.println("Invalid min-y value: " + args[i + 1]);
                }
                continue;
            }
            if (!"--max-y".equals(args[i])) continue;
            try {
                tempMaxY = Integer.parseInt(args[i + 1]);
                continue;
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid max-y value: " + args[i + 1]);
            }
        }
        String worldPath = tempWorldPath;
        String outputFile = tempOutputFile;
        String jarPath = tempJarPath;
        int minY = tempMinY;
        int maxY = tempMaxY;
        if (args.length == 0) {
            System.out.println("\u542f\u52a8\u56fe\u5f62\u754c\u9762...");
            SwingUtilities.invokeLater(() -> {
                try {
                    new MinecraftMapGUI().setVisible(true);
                }
                catch (Exception e) {
                    System.err.println("\u542f\u52a8GUI\u5931\u8d25: " + e.getMessage());
                    e.printStackTrace();
                    MinecraftMapSelector.showUsage();
                }
            });
        } else if (worldPath != null && outputFile != null) {
            System.out.println("\u542f\u52a8Blender\u96c6\u6210\u6a21\u5f0f...");
            System.out.printf("\u4e16\u754c\u8def\u5f84: %s\n", worldPath);
            System.out.printf("\u8f93\u51fa\u6587\u4ef6: %s\n", outputFile);
            if (jarPath != null) {
                System.out.printf("JAR\u8def\u5f84: %s\n", jarPath);
            }
            System.out.printf("Y\u5750\u6807\u8303\u56f4: %d \u5230 %d\n", minY, maxY);
            SwingUtilities.invokeLater(() -> {
                try {
                    MinecraftMapGUI gui = new MinecraftMapGUI(worldPath, outputFile, jarPath, minY, maxY);
                    gui.setVisible(true);
                }
                catch (Exception e) {
                    System.err.println("\u542f\u52a8Blender\u96c6\u6210\u6a21\u5f0f\u5931\u8d25: " + e.getMessage());
                    e.printStackTrace();
                }
            });
        } else if (args.length >= 1 && !args[0].startsWith("--")) {
            MinecraftMapSelector.runCommandLine(args);
        } else {
            MinecraftMapSelector.showUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runCommandLine(String[] args) {
        long overallStartTime = System.currentTimeMillis();
        String mcaFilePath = args[0];
        String defaultBaseName = MinecraftMapSelector.generateDefaultOutputName(mcaFilePath);
        String jsonOutput = args.length > 1 ? args[1] : defaultBaseName + ".json";
        String imageOutput = args.length > 2 ? args[2] : defaultBaseName + ".png";
        int maxWorkers = args.length > 3 ? Integer.parseInt(args[3]) : Math.min(Runtime.getRuntime().availableProcessors(), 8);
        int regionSize = args.length > 4 ? Integer.parseInt(args[4]) : 32;
        int sampleInterval = args.length > 5 ? Integer.parseInt(args[5]) : 1;
        System.out.println("\u6b63\u5728\u5904\u7406\u533a\u57df\u6587\u4ef6: " + mcaFilePath);
        System.out.println("JSON\u8f93\u51fa\u8def\u5f84: " + jsonOutput);
        System.out.println("\u56fe\u50cf\u8f93\u51fa\u8def\u5f84: " + imageOutput);
        System.out.println("\u4f7f\u7528\u7ebf\u7a0b\u6570: " + maxWorkers);
        System.out.println("\u5904\u7406\u533a\u57df\u5927\u5c0f: " + regionSize + "x" + regionSize + " \u533a\u5757");
        System.out.println("\u91c7\u6837\u95f4\u9694: " + sampleInterval);
        MapRenderer.ProgressCallback progressCallback = new MapRenderer.ProgressCallback(){

            @Override
            public void onProgress(int processed, int total, double speed, Set<String> foundBlocks) {
                int i;
                if (total == 0) {
                    return;
                }
                int percent = Math.min(100, processed * 100 / total);
                double remaining = (double)(total - processed) / Math.max(0.1, speed);
                int barLength = 50;
                int filledLength = barLength * percent / 100;
                StringBuilder bar = new StringBuilder();
                for (i = 0; i < filledLength; ++i) {
                    bar.append("\u2588");
                }
                for (i = filledLength; i < barLength; ++i) {
                    bar.append("\u2591");
                }
                System.out.print("\r\u5904\u7406\u8fdb\u5ea6: [" + bar + "] " + percent + "% (" + processed + "/" + total + ") \u901f\u5ea6: " + String.format("%.1f", speed) + "\u533a\u5757/\u79d2 \u5269\u4f59: " + String.format("%.1f", remaining) + "\u79d2 \u53d1\u73b0\u65b9\u5757: " + foundBlocks.size() + "\u79cd");
                System.out.flush();
            }

            @Override
            public void onProgressiveRender(BufferedImage partialImage, int completedChunks, int totalChunks) {
            }
        };
        MapRenderer renderer = new MapRenderer(maxWorkers, progressCallback);
        try {
            MapRenderer.BlockInfo[][] topBlocks = renderer.getTopBlocks(mcaFilePath, regionSize, sampleInterval);
            if (topBlocks != null) {
                System.out.println("\n\n\u533a\u57df\u6587\u4ef6\u8bfb\u53d6\u6210\u529f!");
                MinecraftMapSelector.saveBlocksToJson(topBlocks, jsonOutput);
                BufferedImage image = renderer.renderToPng(topBlocks, sampleInterval);
                if (image != null) {
                    MinecraftMapSelector.saveImageToPng(image, imageOutput);
                }
                long totalTime = System.currentTimeMillis() - overallStartTime;
                System.out.println("\n\u6240\u6709\u5904\u7406\u5b8c\u6210!");
                System.out.println("\u603b\u8017\u65f6: " + (double)totalTime / 1000.0 + "\u79d2");
            } else {
                System.err.println("\u533a\u57df\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25");
            }
        }
        catch (Exception e) {
            System.err.println("\u5904\u7406\u8fc7\u7a0b\u4e2d\u51fa\u9519: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            renderer.shutdown();
        }
    }

    private static void saveBlocksToJson(MapRenderer.BlockInfo[][] topBlocks, String outputFile) {
        System.out.println("\u6b63\u5728\u5c06\u6570\u636e\u4fdd\u5b58\u4e3aJSON: " + outputFile);
        long startTime = System.currentTimeMillis();
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            String[][] blockIds = new String[topBlocks.length][];
            int[][] heights = new int[topBlocks.length][];
            for (int i = 0; i < topBlocks.length; ++i) {
                blockIds[i] = new String[topBlocks[i].length];
                heights[i] = new int[topBlocks[i].length];
                for (int j = 0; j < topBlocks[i].length; ++j) {
                    MapRenderer.BlockInfo blockInfo = topBlocks[i][j];
                    if (blockInfo != null) {
                        blockIds[i][j] = blockInfo.getBlockId();
                        heights[i][j] = blockInfo.getHeight();
                        continue;
                    }
                    blockIds[i][j] = "air";
                    heights[i][j] = -64;
                }
            }
            data.put("blocks", blockIds);
            data.put("heights", heights);
            data.put("width", topBlocks[0].length);
            data.put("height", topBlocks.length);
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(new File(outputFile), data);
            long fileSize = new File(outputFile).length();
            long totalTime = System.currentTimeMillis() - startTime;
            System.out.println("JSON\u6570\u636e\u5df2\u4fdd\u5b58\uff0c\u6587\u4ef6\u5927\u5c0f: " + (double)fileSize / 1024.0 + " KB\uff0c\u8017\u65f6: " + (double)totalTime / 1000.0 + "\u79d2");
        }
        catch (IOException e) {
            System.err.println("\u4fdd\u5b58JSON\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void saveImageToPng(BufferedImage image, String outputFile) {
        System.out.println("\u6b63\u5728\u4fdd\u5b58\u56fe\u50cf: " + outputFile);
        long startTime = System.currentTimeMillis();
        try {
            ImageIO.write((RenderedImage)image, "PNG", new File(outputFile));
            int maxSize = 2048;
            if (image.getWidth() > maxSize || image.getHeight() > maxSize) {
                int newHeight;
                int newWidth;
                if (image.getWidth() > image.getHeight()) {
                    newWidth = maxSize;
                    newHeight = maxSize * image.getHeight() / image.getWidth();
                } else {
                    newHeight = maxSize;
                    newWidth = maxSize * image.getWidth() / image.getHeight();
                }
                System.out.println("\u8c03\u6574\u56fe\u50cf\u5927\u5c0f\u81f3 " + newWidth + "x" + newHeight);
                BufferedImage resized = new BufferedImage(newWidth, newHeight, 2);
                Graphics2D g2d = resized.createGraphics();
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2d.drawImage(image, 0, 0, newWidth, newHeight, null);
                g2d.dispose();
                String thumbnailFile = outputFile.replaceAll("\\.(png|jpg|jpeg)$", "_thumbnail.$1");
                ImageIO.write((RenderedImage)resized, "PNG", new File(thumbnailFile));
                System.out.println("\u7f29\u7565\u56fe\u5df2\u4fdd\u5b58\u5230: " + thumbnailFile);
            }
            long totalTime = System.currentTimeMillis() - startTime;
            System.out.println("\u56fe\u50cf\u5df2\u4fdd\u5b58\uff0c\u8017\u65f6: " + (double)totalTime / 1000.0 + "\u79d2");
        }
        catch (IOException e) {
            System.err.println("\u4fdd\u5b58\u56fe\u50cf\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static String generateDefaultOutputName(String mcaFilePath) {
        File mcaFile = new File(mcaFilePath);
        String baseName = mcaFile.getName().replaceAll("\\.mca$", "");
        long timestamp = System.currentTimeMillis();
        return String.format("%s_map_%d", baseName, timestamp);
    }

    private static void showUsage() {
        System.out.println("\u7528\u6cd5:");
        System.out.println("  java -jar minecraft-map-selector.jar                                    # \u542f\u52a8GUI");
        System.out.println("  java -jar minecraft-map-selector.jar <mca\u6587\u4ef6\u8def\u5f84> [\u9009\u9879...]              # \u547d\u4ee4\u884c\u6a21\u5f0f");
        System.out.println();
        System.out.println("\u547d\u4ee4\u884c\u9009\u9879:");
        System.out.println("  <mca\u6587\u4ef6\u8def\u5f84>        \u5fc5\u9700\uff0c.mca\u533a\u57df\u6587\u4ef6\u8def\u5f84");
        System.out.println("  [\u8f93\u51faJSON\u6587\u4ef6\u8def\u5f84]   \u53ef\u9009\uff0c\u9ed8\u8ba4\u4e3a<\u533a\u57df\u540d>_map_<\u65f6\u95f4\u6233>.json");
        System.out.println("  [\u8f93\u51fa\u56fe\u50cf\u6587\u4ef6\u8def\u5f84]   \u53ef\u9009\uff0c\u9ed8\u8ba4\u4e3a<\u533a\u57df\u540d>_map_<\u65f6\u95f4\u6233>.png");
        System.out.println("  [\u7ebf\u7a0b\u6570]            \u53ef\u9009\uff0c\u9ed8\u8ba4\u4e3aCPU\u6838\u5fc3\u6570\u62168\uff08\u53d6\u8f83\u5c0f\u503c\uff09");
        System.out.println("  [\u533a\u57df\u5927\u5c0f]          \u53ef\u9009\uff0c\u4ee5\u533a\u5757\u4e3a\u5355\u4f4d\uff0c\u9ed8\u8ba432\uff08\u537332x32\u533a\u5757\uff09");
        System.out.println("  [\u91c7\u6837\u95f4\u9694]          \u53ef\u9009\uff0c\u6bcf\u9694\u591a\u5c11\u4e2a\u65b9\u5757\u91c7\u6837\u4e00\u6b21\uff0c\u9ed8\u8ba41\uff08\u5168\u91c7\u6837\uff09");
        System.out.println();
        System.out.println("\u793a\u4f8b:");
        System.out.println("  java -jar minecraft-map-selector.jar /path/to/r.0.0.mca");
        System.out.println("  java -jar minecraft-map-selector.jar /path/to/r.0.0.mca blocks.json map.png 8 32 1");
        System.out.println();
        System.out.println("\u6ce8\u610f: \u8f93\u51fa\u6587\u4ef6\u5c06\u4fdd\u5b58\u5230\u5f53\u524d\u5de5\u4f5c\u76ee\u5f55");
    }
}

