/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj.java;

import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.java.helper.DTFJJavaFieldHelper;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.pointer.I32Pointer;
import com.ibm.j9ddr.vm29.pointer.I64Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaClass;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaField;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaObject;

public class DTFJJavaFieldStatic
extends DTFJJavaField {
    public DTFJJavaFieldStatic(DTFJJavaClass dTFJJavaClass, J9ObjectFieldOffset j9ObjectFieldOffset) throws CorruptDataException {
        super(dTFJJavaClass, j9ObjectFieldOffset);
    }

    public Object get(JavaObject javaObject) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        try {
            switch (this.getSigFlag()) {
                case 'Z': {
                    return this.getBoolean(javaObject);
                }
                case 'B': {
                    return this.getByte(javaObject);
                }
                case 'C': {
                    return Character.valueOf(this.getChar(javaObject));
                }
                case 'S': {
                    return this.getShort(javaObject);
                }
                case 'I': {
                    return this.getInt(javaObject);
                }
                case 'F': {
                    return Float.valueOf(this.getFloat(javaObject));
                }
                case 'J': {
                    return this.getLong(javaObject);
                }
                case 'D': {
                    return this.getDouble(javaObject);
                }
                case 'L': 
                case '[': {
                    J9ObjectPointer j9ObjectPointer = this.getObject();
                    if (j9ObjectPointer.isNull()) {
                        return null;
                    }
                    return new DTFJJavaObject(null, j9ObjectPointer);
                }
            }
            throw new IllegalArgumentException("Cannot determine the correct data type");
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), throwable, allowlist);
        }
    }

    public boolean getBoolean(JavaObject javaObject) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        try {
            int n = this.getIntField();
            return n == 1;
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), throwable, allowlist);
        }
    }

    public byte getByte(JavaObject javaObject) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        try {
            byte by = (byte)(this.getIntField() & 0xFF);
            return by;
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), throwable, allowlist);
        }
    }

    public char getChar(JavaObject javaObject) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        try {
            char c = (char)(this.getIntField() & 0xFFFF);
            return c;
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), throwable, allowlist);
        }
    }

    public double getDouble(JavaObject javaObject) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        try {
            long l = this.getLongField();
            return Double.longBitsToDouble(l);
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), throwable, allowlist);
        }
    }

    public float getFloat(JavaObject javaObject) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        try {
            int n = this.getIntField();
            return Float.intBitsToFloat(n);
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), throwable, allowlist);
        }
    }

    public int getInt(JavaObject javaObject) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        try {
            int n = this.getIntField();
            return n;
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), throwable, allowlist);
        }
    }

    public long getLong(JavaObject javaObject) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        try {
            long l = this.getLongField();
            return l;
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), throwable, allowlist);
        }
    }

    public short getShort(JavaObject javaObject) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        try {
            int n = this.getIntField();
            return (short)(n & 0xFFFF);
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), throwable, allowlist);
        }
    }

    public String getString(JavaObject javaObject) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (!DTFJJavaFieldHelper.fieldIsString(this)) {
            throw new IllegalArgumentException("JavaField.getString() called on non-String field.");
        }
        try {
            J9ObjectPointer j9ObjectPointer = this.getObject();
            return J9ObjectHelper.stringValue(j9ObjectPointer);
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), throwable, allowlist);
        }
    }

    private J9ObjectPointer getObject() throws CorruptDataException {
        UDATAPointer uDATAPointer = this.clazz.getJ9Class().ramStatics().addOffset(this.fieldOffset.getOffsetOrAddress());
        return J9ObjectPointer.cast(uDATAPointer.at(0L));
    }

    private int getIntField() throws CorruptDataException {
        I32Pointer i32Pointer = I32Pointer.cast(this.clazz.getJ9Class().ramStatics().addOffset(this.fieldOffset.getOffsetOrAddress()));
        return i32Pointer.at(0L).intValue();
    }

    private long getLongField() throws CorruptDataException {
        I64Pointer i64Pointer = I64Pointer.cast(this.clazz.getJ9Class().ramStatics().addOffset(this.fieldOffset.getOffsetOrAddress()));
        return i64Pointer.at(0L).longValue();
    }

    public boolean isNestedPacked() {
        return false;
    }

    public boolean isNestedPackedArray() {
        return false;
    }

    public int getPackedLengthAnnotationValue() {
        return 0;
    }
}

