/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.types;

import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.I64;
import com.ibm.j9ddr.vm29.types.U64;
import com.ibm.j9ddr.vm29.types.UDATA;

public abstract class Scalar
extends DataType {
    protected long data;
    protected static final int bitsPerBytes = 8;
    protected static final int bitsPerLong = 64;
    protected String toStringPattern;

    public Scalar(long l) {
        this.data = l;
    }

    public Scalar(Scalar scalar) {
        this(scalar.data);
        if (scalar.sizeof() > this.sizeof()) {
            this.trimExcessBytes();
        } else if (scalar.sizeof() < this.sizeof()) {
            this.signExtend(scalar);
        }
    }

    public Scalar() {
    }

    public byte byteValue() {
        return (byte)this.data;
    }

    public short shortValue() {
        return (short)this.data;
    }

    public int intValue() {
        return (int)this.data;
    }

    @Override
    public long longValue() {
        return this.data;
    }

    public String getHexValue() {
        return String.format("0x%0" + this.sizeof() * 2 + "X", this.data);
    }

    public String toString() {
        if (null == this.toStringPattern) {
            this.toStringPattern = this.getClass().getSimpleName() + "(0x%0" + this.sizeof() * 2 + "X)";
        }
        return String.format(this.toStringPattern, this.data);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!object.getClass().isInstance(this)) {
            return false;
        }
        return this.data == ((Scalar)object).data;
    }

    public boolean eq(Scalar scalar) {
        if (scalar instanceof U64) {
            return scalar.eq(this);
        }
        return scalar.longValue() == this.longValue();
    }

    public boolean eq(long l) {
        return l == this.longValue();
    }

    public int hashCode() {
        return (int)this.data;
    }

    protected void checkComparisonValid(Scalar scalar) {
        if (this.isSigned() ^ scalar.isSigned()) {
            throw new UnsupportedOperationException("Can't compare signed and unsigned Scalars");
        }
    }

    public boolean gt(int n) {
        return this.gt(new I32(n));
    }

    public boolean gt(long l) {
        return this.gt(new I64(l));
    }

    public boolean lt(int n) {
        return this.lt(new I32(n));
    }

    public boolean lt(long l) {
        return this.lt(new I64(l));
    }

    public boolean isZero() {
        return this.eq(0L);
    }

    public boolean gt(Scalar scalar) {
        this.checkComparisonValid(scalar);
        return this.longValue() > scalar.longValue();
    }

    public boolean gte(Scalar scalar) {
        return this.eq(scalar) || this.gt(scalar);
    }

    public boolean lt(Scalar scalar) {
        this.checkComparisonValid(scalar);
        return this.longValue() < scalar.longValue();
    }

    public boolean lte(Scalar scalar) {
        return this.eq(scalar) || this.lt(scalar);
    }

    public static UDATA convertBytesToSlots(UDATA uDATA) {
        if (4 == UDATA.SIZEOF) {
            return uDATA.rightShift(2);
        }
        return uDATA.rightShift(3);
    }

    public static UDATA convertSlotsToBytes(UDATA uDATA) {
        if (4 == UDATA.SIZEOF) {
            return uDATA.leftShift(2);
        }
        return uDATA.leftShift(3);
    }

    public static UDATA roundToSizeofUDATA(UDATA uDATA) {
        return Scalar.roundTo(uDATA, UDATA.SIZEOF);
    }

    public static UDATA roundToSizeToObjectReference(UDATA uDATA) {
        return Scalar.roundTo(uDATA, ObjectReferencePointer.SIZEOF);
    }

    public static UDATA roundToSizeofU32(UDATA uDATA) {
        return Scalar.roundTo(uDATA, 4L);
    }

    public static UDATA roundToSizeofU64(UDATA uDATA) {
        return Scalar.roundTo(uDATA, 8L);
    }

    public static UDATA roundToSizeToFJ9object(UDATA uDATA) {
        int n = J9ObjectHelper.compressObjectReferences ? 4 : UDATA.SIZEOF;
        return Scalar.roundTo(uDATA, n);
    }

    protected static UDATA roundTo(UDATA uDATA, long l) {
        long l2 = uDATA.longValue() + (l - 1L) & (l - 1L ^ 0xFFFFFFFFFFFFFFFFL);
        return new UDATA(l2);
    }

    public final boolean allBitsIn(long l) {
        if (0L == l) {
            return false;
        }
        return l == (this.data & l);
    }

    public boolean anyBitsIn(long l) {
        return 0L != (this.data & l);
    }

    public boolean maskAndCompare(long l, long l2) {
        return l2 == (this.data & l);
    }

    private void trimExcessBytes() {
        int n = 8 - this.sizeof();
        int n2 = 8 * n;
        this.data = this.data << n2 >>> n2;
    }

    private void signExtend(Scalar scalar) {
        if (scalar.isSigned() && scalar.signBitSet()) {
            int n = 8 - scalar.sizeof();
            int n2 = this.sizeof() - scalar.sizeof();
            this.data <<= 8 * n;
            this.data >>= 8 * n2;
            this.data >>>= 8 * (n - n2);
        }
    }

    protected boolean signBitSet() {
        return this.data >>> this.sizeof() * 8 - 1 != 0L;
    }

    public abstract int sizeof();

    public abstract boolean isSigned();
}

