/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.gc.GCJNIGlobalReferenceIterator;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckJNIGlobalReferences
extends Check {
    CheckJNIGlobalReferences() {
    }

    @Override
    public void check() {
        try {
            VoidPointer voidPointer = VoidPointer.cast(this.getJavaVM().jniGlobalReferences());
            GCJNIGlobalReferenceIterator gCJNIGlobalReferenceIterator = GCJNIGlobalReferenceIterator.from();
            while (gCJNIGlobalReferenceIterator.hasNext()) {
                PointerPointer pointerPointer = PointerPointer.cast(gCJNIGlobalReferenceIterator.nextAddress());
                if (!pointerPointer.notNull() || this._engine.checkSlotPool(pointerPointer, voidPointer) == 0) continue;
                return;
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    @Override
    public String getCheckName() {
        return "JNI GLOBAL REFS";
    }

    @Override
    public void print() {
        try {
            VoidPointer voidPointer = VoidPointer.cast(this.getJavaVM().jniGlobalReferences());
            GCJNIGlobalReferenceIterator gCJNIGlobalReferenceIterator = GCJNIGlobalReferenceIterator.from();
            ScanFormatter scanFormatter = new ScanFormatter(this, "jniGlobalReferences", voidPointer);
            while (gCJNIGlobalReferenceIterator.hasNext()) {
                J9ObjectPointer j9ObjectPointer = gCJNIGlobalReferenceIterator.next();
                if (!j9ObjectPointer.notNull()) continue;
                scanFormatter.entry(j9ObjectPointer);
            }
            scanFormatter.end("jniGlobalReferences", voidPointer);
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

