/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm29.pointer.DoublePointer;
import com.ibm.j9ddr.vm29.pointer.FloatPointer;
import com.ibm.j9ddr.vm29.pointer.I32Pointer;
import com.ibm.j9ddr.vm29.pointer.I64Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMFieldShapeHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm29.types.U32;
import java.io.PrintStream;
import java.util.Iterator;

public class J9StaticsCommand
extends Command {
    public J9StaticsCommand() {
        this.addCommand("j9statics", "<ramclass>", "Display static fields of a ram class");
    }

    long staticFieldAddress(J9VMThreadPointer j9VMThreadPointer, J9ROMClassPointer j9ROMClassPointer, String string, String string2, long l) {
        return 0L;
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            if (stringArray.length != 1) {
                CommandUtils.dbgPrint(printStream, "Usage: !j9statics <classAddress>\n");
                return;
            }
            long l = CommandUtils.parsePointer(stringArray[0], J9BuildFlags.J9VM_ENV_DATA64);
            J9ClassPointer j9ClassPointer = J9ClassPointer.cast(l);
            J9ROMClassPointer j9ROMClassPointer = j9ClassPointer.romClass();
            J9UTF8Pointer j9UTF8Pointer = j9ROMClassPointer.className();
            CommandUtils.dbgPrint(printStream, "Static fields in %s:\n", J9UTF8Helper.stringValue(j9UTF8Pointer));
            Iterator<J9ObjectFieldOffset> iterator = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(j9ClassPointer, J9ClassHelper.superclass(j9ClassPointer), new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_STATIC));
            block9: while (iterator.hasNext()) {
                J9ObjectFieldOffset j9ObjectFieldOffset = iterator.next();
                J9ROMFieldShapePointer j9ROMFieldShapePointer = j9ObjectFieldOffset.getField();
                String string2 = J9ROMFieldShapeHelper.getName(j9ROMFieldShapePointer);
                String string3 = J9ROMFieldShapeHelper.getSignature(j9ROMFieldShapePointer);
                UDATAPointer uDATAPointer = j9ClassPointer.ramStatics().addOffset(j9ObjectFieldOffset.getOffsetOrAddress());
                switch (string3.charAt(0)) {
                    case 'L': 
                    case '[': {
                        CommandUtils.dbgPrint(printStream, "\t%s %s %s (!j9romstaticfieldshape %s) = !j9object %s\n", uDATAPointer.getHexAddress(), string2, string3, j9ROMFieldShapePointer.getHexAddress(), uDATAPointer.at(0L).getHexValue());
                        continue block9;
                    }
                    case 'D': {
                        DoublePointer doublePointer = DoublePointer.cast(uDATAPointer);
                        CommandUtils.dbgPrint(printStream, "\t%s %s %s (!j9romstaticfieldshape %s) = %s (%s)\n", uDATAPointer.getHexAddress(), string2, string3, j9ROMFieldShapePointer.getHexAddress(), doublePointer.getHexValue(), Double.toString(doublePointer.doubleAt(0L)));
                        continue block9;
                    }
                    case 'F': {
                        FloatPointer floatPointer = FloatPointer.cast(uDATAPointer);
                        CommandUtils.dbgPrint(printStream, "\t%s %s %s (!j9romstaticfieldshape %s) = %s (%s)\n", uDATAPointer.getHexAddress(), string2, string3, j9ROMFieldShapePointer.getHexAddress(), floatPointer.getHexValue(), Float.toString(floatPointer.floatAt(0L)));
                        continue block9;
                    }
                    case 'J': {
                        I64Pointer i64Pointer = I64Pointer.cast(uDATAPointer);
                        CommandUtils.dbgPrint(printStream, "\t%s %s %s (!j9romstaticfieldshape %s) = %s (%d)\n", uDATAPointer.getHexAddress(), string2, string3, j9ROMFieldShapePointer.getHexAddress(), i64Pointer.getHexValue(), i64Pointer.at(0L).longValue());
                        continue block9;
                    }
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        I32Pointer i32Pointer = I32Pointer.cast(uDATAPointer);
                        CommandUtils.dbgPrint(printStream, "\t%s %s %s (!j9romstaticfieldshape %s) = %s (%d)\n", uDATAPointer.getHexAddress(), string2, string3, j9ROMFieldShapePointer.getHexAddress(), i32Pointer.getHexValue(), i32Pointer.at(0L).intValue());
                        continue block9;
                    }
                }
                CommandUtils.dbgPrint(printStream, "\t%s %s %s (!j9romstaticfieldshape %s) = %s\n", uDATAPointer.getHexAddress(), string2, string3, j9ROMFieldShapePointer.getHexAddress(), uDATAPointer.at(0L).getHexValue());
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

