/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.J9JavaStackIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaStackPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class FindStackValueCommand
extends Command {
    public FindStackValueCommand() {
        this.addCommand("findstackvalue", "<stackvalue>", "search stacks for a specific value");
    }

    private void printUsage(PrintStream printStream) {
        printStream.println("\tUSAGE: ");
        printStream.println("\t!findstackvalue <stackvalue>");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (0 == stringArray.length) {
            printStream.println("Usage error: Missing stackvalue to search for. See usage.");
            this.printUsage(printStream);
            return;
        }
        if (1 < stringArray.length) {
            printStream.println("Usage error: Too many stackvalues to search for. See usage.");
            this.printUsage(printStream);
            return;
        }
        try {
            long l = CommandUtils.parsePointer(stringArray[0], J9BuildFlags.J9VM_ENV_DATA64);
            UDATA uDATA = new UDATA(l);
            GCVMThreadListIterator gCVMThreadListIterator = GCVMThreadListIterator.from();
            while (gCVMThreadListIterator.hasNext()) {
                J9VMThreadPointer j9VMThreadPointer = gCVMThreadListIterator.next();
                J9JavaStackPointer j9JavaStackPointer = j9VMThreadPointer.stackObject();
                J9JavaStackIterator j9JavaStackIterator = J9JavaStackIterator.fromJ9JavaStack(j9JavaStackPointer);
                boolean bl = false;
                UDATA uDATA2 = new UDATA(j9JavaStackPointer.end().sub(j9VMThreadPointer.sp()));
                while (j9JavaStackIterator.hasNext()) {
                    J9JavaStackPointer j9JavaStackPointer2 = j9JavaStackIterator.next();
                    UDATAPointer uDATAPointer = j9JavaStackPointer2.end();
                    UDATAPointer uDATAPointer2 = uDATAPointer.sub(uDATA2);
                    while (!uDATAPointer2.eq(uDATAPointer)) {
                        if (uDATA.eq(uDATAPointer2.at(0L))) {
                            if (!bl) {
                                printStream.append(String.format("!j9vmthread %s\n", Long.toHexString(j9VMThreadPointer.getAddress())));
                                bl = true;
                            }
                            printStream.append(String.format("\tFound at %s\n", Long.toHexString(uDATAPointer2.getAddress())));
                        }
                        uDATAPointer2 = uDATAPointer2.add(1L);
                    }
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

