/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.util.PatternString;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9BCTranslationData;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.commands.J9BCUtil;
import java.io.PrintStream;

public class DumpRomClassCommand
extends Command {
    public DumpRomClassCommand() {
        this.addCommand("dumpromclass", "<address|name:<classname>> [maps]", "cfdump the specified J9ROMClass. Wild cards are allowed in class name. (maps is optional)");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            long l = 0L;
            if (stringArray.length != 1 && stringArray.length != 2) {
                this.printUsage(printStream);
                return;
            }
            if (stringArray.length == 2 && stringArray[1].equals("maps")) {
                l |= J9BCTranslationData.BCT_DumpMaps;
            }
            l = J9BuildFlags.J9VM_ENV_LITTLE_ENDIAN ? (l |= J9BCTranslationData.BCT_LittleEndianOutput) : (l |= J9BCTranslationData.BCT_BigEndianOutput);
            if (stringArray[0].startsWith("name:")) {
                long l2 = 0L;
                String string2 = stringArray[0].substring(stringArray[0].indexOf(58) + 1);
                PatternString patternString = new PatternString(string2);
                J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
                ClassSegmentIterator classSegmentIterator = new ClassSegmentIterator(j9JavaVMPointer.classMemorySegments());
                while (classSegmentIterator.hasNext()) {
                    J9ClassPointer j9ClassPointer = (J9ClassPointer)classSegmentIterator.next();
                    String string3 = J9ClassHelper.getJavaName(j9ClassPointer);
                    if (!patternString.isMatch(string3)) continue;
                    ++l2;
                    J9ROMClassPointer j9ROMClassPointer = j9ClassPointer.romClass();
                    String string4 = j9ROMClassPointer.getHexAddress();
                    printStream.println(String.format("ROMClass %1$s named %2$s\n", string4, string3));
                    J9BCUtil.j9bcutil_dumpRomClass(printStream, j9ROMClassPointer, l);
                }
                printStream.println(String.format("Found %1$d class(es) with name %2$s\n", l2, string2));
            } else {
                long l3 = CommandUtils.parsePointer(stringArray[0], J9BuildFlags.J9VM_ENV_DATA64);
                J9ROMClassPointer j9ROMClassPointer = J9ROMClassPointer.cast(l3);
                J9BCUtil.j9bcutil_dumpRomClass(printStream, j9ROMClassPointer, l);
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void printUsage(PrintStream printStream) {
        printStream.println("dumpromclass <address|name:<classname>> [map] - cfdump the specified J9ROMClass. Wild cards are allowed in class name. (maps is optional)");
    }
}

