/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.j9.walkers.ClassIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

public class WhatIsCommand
extends Command {
    private static final int DEFAULT_MAXIMUM_DEPTH = 6;
    public static final String WHATIS_COMMAND = "!whatis";
    public static final String WHATIS_SET_DEPTH_COMMAND = "!whatissetdepth";
    private int maxDepth = 6;
    private UDATA searchValue;
    private int skipCount = 0;
    private int foundCount = 0;
    private long fieldCount = 0L;
    private static final Map<Class<?>, Method[]> fieldAccessorMap = new HashMap();
    private UDATA closestBelow;
    private SearchStack closestBelowStack;
    private UDATA closestAbove;
    private SearchStack closestAboveStack;
    private UDATA shortestHammingDistance;
    private SearchStack shortestHammingDistanceStack;
    private int hammingDistance;
    private PrintStream out;

    public WhatIsCommand() {
        this.addCommand("whatis", "<address>", "Recursively searches fields for UDATA value");
        this.addCommand("whatissetdepth", "<n>", "Sets the maximum depth of the whatis search");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        this.out = printStream;
        if (string.equals(WHATIS_COMMAND)) {
            this.runWhatIs(stringArray, context, printStream);
        } else if (string.equals(WHATIS_SET_DEPTH_COMMAND)) {
            this.runWhatIsSetDepth(stringArray, context, printStream);
        } else {
            throw new DDRInteractiveCommandException("WhatIsCommand plugin does not recogise command: " + string);
        }
    }

    private void runWhatIsSetDepth(String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        int n;
        if (stringArray.length == 0) {
            printStream.println("No argument supplied.");
            return;
        }
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            printStream.println("Could not format " + stringArray[0] + " as an integer");
            return;
        }
        if (n <= 0) {
            printStream.println("Depth must be > 0");
            return;
        }
        this.maxDepth = n;
        printStream.println("Max depth set to " + this.maxDepth);
    }

    private void runWhatIs(String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        boolean bl;
        long l;
        block24: {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (stringArray.length == 0) {
                this.badOrMissingSearchValue(printStream);
                return;
            }
            long l2 = CommandUtils.parsePointer(stringArray[0], J9BuildFlags.J9VM_ENV_DATA64);
            UDATA uDATA = new UDATA(l2);
            if (uDATA.eq(0L)) {
                this.badOrMissingSearchValue(printStream);
                return;
            }
            if (this.searchValue == null || !this.searchValue.eq(uDATA)) {
                this.searchValue = uDATA;
            } else {
                printStream.println("Skip count now " + ++this.skipCount + ". Run !whatis 0 to reset it.");
            }
            this.resetFieldData();
            l = System.currentTimeMillis();
            J9JavaVMPointer j9JavaVMPointer = null;
            try {
                j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            }
            catch (CorruptDataException corruptDataException) {
                throw new DDRInteractiveCommandException("Couldn't get VM", corruptDataException);
            }
            bl = this.walkStructuresFrom(j9JavaVMPointer);
            if (!bl) {
                try {
                    object4 = j9JavaVMPointer.mainThread();
                    object3 = new LinkedList();
                    if (((AbstractPointer)object4).notNull()) {
                        J9VMThreadPointer j9VMThreadPointer;
                        object2 = j9JavaVMPointer.mainThread();
                        do {
                            object3.add(object2);
                        } while (!((AbstractPointer)(object2 = ((J9VMThreadPointer)object2).linkNext())).eq(object4) && !bl);
                        Collections.reverse(object3);
                        object = object3.iterator();
                        while (object.hasNext() && !(bl = this.walkStructuresFrom(j9VMThreadPointer = (J9VMThreadPointer)object.next()))) {
                        }
                    }
                }
                catch (CorruptDataException corruptDataException) {
                    printStream.println("CDE walking thread list.");
                    corruptDataException.printStackTrace(printStream);
                }
            }
            if (!bl) {
                try {
                    object4 = GCClassLoaderIterator.from();
                    while (((GCClassLoaderIterator)object4).hasNext()) {
                        object3 = ((GCClassLoaderIterator)object4).next();
                        object2 = ClassIterator.fromJ9Classloader((J9ClassLoaderPointer)object3);
                        while (object2.hasNext()) {
                            object = (J9ClassPointer)object2.next();
                            bl = this.walkStructuresFrom((StructurePointer)object);
                            if (!bl) continue;
                            break block24;
                        }
                    }
                }
                catch (CorruptDataException corruptDataException) {
                    printStream.println("CDE walking classes.");
                    corruptDataException.printStackTrace(printStream);
                }
            }
        }
        long l3 = System.currentTimeMillis();
        if (bl) {
            printStream.println("Match found");
        } else {
            printStream.println("No match found");
            if (this.closestAboveStack != null) {
                printStream.print("Closest above was: ");
                this.closestAboveStack.dump(printStream);
                printStream.print(" at " + this.closestAbove.getHexValue());
                printStream.println();
            } else {
                printStream.println("No values found above search value");
            }
            if (this.closestBelowStack != null) {
                printStream.print("Closest below was: ");
                this.closestBelowStack.dump(printStream);
                printStream.print(" at " + this.closestBelow.getHexValue());
                printStream.println();
            } else {
                printStream.println("No values found below search value");
            }
            if (this.shortestHammingDistanceStack != null) {
                printStream.print("Value with shortest hamming distance (fewest single-bit changes required) was: ");
                this.shortestHammingDistanceStack.dump(printStream);
                printStream.print(" at " + this.shortestHammingDistance.getHexValue());
                printStream.print(". Hamming distance = " + this.hammingDistance);
                printStream.println();
            }
            this.searchValue = null;
        }
        printStream.println("Searched " + this.fieldCount + " fields to a depth of " + this.maxDepth + " in " + (l3 - l) + " ms");
        this.resetFieldData();
    }

    private void resetFieldData() {
        this.foundCount = 0;
        this.fieldCount = 0L;
        this.closestAbove = new UDATA(-1L);
        this.closestAboveStack = null;
        this.closestBelow = new UDATA(0L);
        this.closestBelowStack = null;
        this.shortestHammingDistance = new UDATA(0L);
        this.shortestHammingDistanceStack = null;
        this.hammingDistance = Integer.MAX_VALUE;
        fieldAccessorMap.clear();
    }

    private boolean walkStructuresFrom(StructurePointer structurePointer) throws DDRInteractiveCommandException {
        HashSet<Object> hashSet = new HashSet<Object>();
        SearchStack searchStack = new SearchStack(this.maxDepth);
        if (UDATA.cast(structurePointer).eq(this.searchValue)) {
            this.out.println("Found " + this.searchValue.getHexValue() + " as " + structurePointer.formatShortInteractive());
            return true;
        }
        searchStack.push(new SearchFrame(structurePointer));
        hashSet.add(structurePointer);
        boolean bl = false;
        while (!searchStack.isEmpty() && !bl) {
            Object object;
            int n;
            SearchFrame searchFrame = searchStack.peek();
            ++searchFrame.fieldIndex;
            if (searchFrame.fieldAccessors.length <= n) {
                searchStack.pop();
                continue;
            }
            try {
                searchFrame.fieldName = searchFrame.fieldAccessors[n].getName();
                Object object2 = searchFrame.fieldAccessors[n].invoke((Object)searchFrame.ptr, new Object[0]);
                if (object2 == null) continue;
                ++this.fieldCount;
                if (object2 instanceof StructurePointer) {
                    object = (StructurePointer)object2;
                    bl = this.checkPointer(searchStack, (AbstractPointer)object);
                    if (searchStack.isFull() || hashSet.contains(object)) continue;
                    hashSet.add(object);
                    searchStack.push(new SearchFrame((StructurePointer)object));
                    continue;
                }
                if (object2 instanceof AbstractPointer) {
                    object = (AbstractPointer)object2;
                    bl = this.checkPointer(searchStack, (AbstractPointer)object);
                    continue;
                }
                if (object2 instanceof Scalar) {
                    object = (Scalar)object2;
                    bl = this.checkScalar(searchStack, (Scalar)object);
                    continue;
                }
                this.out.println("Unexpected type walked: " + object2.getClass().getName());
            }
            catch (InvocationTargetException invocationTargetException) {
                object = invocationTargetException.getCause();
                if (object instanceof CorruptDataException || object instanceof NoSuchFieldException || object instanceof NoSuchFieldError || object instanceof NoClassDefFoundError) continue;
                throw new DDRInteractiveCommandException("Unexpected exception during walk", (Throwable)object);
            }
            catch (Exception exception2) {
                throw new DDRInteractiveCommandException("Unexpected exception during !whatis walk", exception2);
            }
        }
        return bl;
    }

    private boolean checkPointer(SearchStack searchStack, AbstractPointer abstractPointer) {
        UDATA uDATA = UDATA.cast(abstractPointer);
        if (this.searchValue.eq(uDATA)) {
            if (++this.foundCount > this.skipCount) {
                this.out.print("Found " + this.searchValue.getHexValue() + " as " + abstractPointer.formatShortInteractive() + ": ");
                searchStack.dump(this.out);
                this.out.println();
                return true;
            }
        } else {
            this.updateClosest(searchStack, uDATA);
        }
        return false;
    }

    private boolean checkScalar(SearchStack searchStack, Scalar scalar) {
        UDATA uDATA = new UDATA(scalar);
        if (this.searchValue.eq(scalar)) {
            if (++this.foundCount > this.skipCount) {
                this.out.print("Found " + this.searchValue.getHexValue() + " as " + scalar + ": ");
                searchStack.dump(this.out);
                this.out.println();
                return true;
            }
        } else {
            this.updateClosest(searchStack, uDATA);
        }
        return false;
    }

    private void updateClosest(SearchStack searchStack, UDATA uDATA) {
        int n;
        if (uDATA.gt(this.searchValue)) {
            if (uDATA.lt(this.closestAbove)) {
                this.closestAbove = uDATA;
                this.closestAboveStack = searchStack.copy();
            }
        } else if (uDATA.gt(this.closestBelow)) {
            this.closestBelow = uDATA;
            this.closestBelowStack = searchStack.copy();
        }
        if ((n = WhatIsCommand.hammingDistance(this.searchValue, uDATA)) < this.hammingDistance) {
            this.shortestHammingDistance = uDATA;
            this.shortestHammingDistanceStack = searchStack.copy();
            this.hammingDistance = n;
        }
    }

    private static int hammingDistance(UDATA uDATA, UDATA uDATA2) {
        int n = 0;
        for (long i = uDATA.longValue() ^ uDATA2.longValue(); i != 0L; i >>>= 1) {
            if ((i & 1L) != 1L) continue;
            ++n;
        }
        return n;
    }

    private void badOrMissingSearchValue(PrintStream printStream) {
        printStream.println("Bad or missing search value. Skip count reset to 0.");
        this.skipCount = 0;
        this.searchValue = null;
    }

    static final class SearchStack {
        private final SearchFrame[] storage;
        private int stackTop;

        public SearchStack(int n) {
            this.storage = new SearchFrame[n];
            this.stackTop = 0;
        }

        private SearchStack(SearchFrame[] searchFrameArray, int n) {
            this.storage = searchFrameArray;
            this.stackTop = n;
        }

        public SearchFrame pop() {
            return this.storage[--this.stackTop];
        }

        public SearchFrame peek() {
            return this.storage[this.stackTop - 1];
        }

        public void push(SearchFrame searchFrame) {
            this.storage[this.stackTop++] = searchFrame;
        }

        public boolean isEmpty() {
            return this.stackTop <= 0;
        }

        public boolean isFull() {
            return this.stackTop >= this.storage.length;
        }

        public void dump(PrintStream printStream) {
            printStream.print(this.storage[0].ptr.formatShortInteractive());
            for (int i = 0; i < this.stackTop; ++i) {
                printStream.print("->");
                printStream.print(this.storage[i].fieldName);
            }
        }

        public SearchStack copy() {
            SearchFrame[] searchFrameArray = new SearchFrame[this.storage.length];
            for (int i = 0; i < searchFrameArray.length; ++i) {
                if (this.storage[i] == null) continue;
                searchFrameArray[i] = this.storage[i].copy();
            }
            return new SearchStack(searchFrameArray, this.stackTop);
        }
    }

    static final class SearchFrame {
        final StructurePointer ptr;
        final Method[] fieldAccessors;
        String fieldName = null;
        int fieldIndex = 0;

        SearchFrame(StructurePointer structurePointer) {
            this.ptr = structurePointer;
            this.fieldAccessors = this.getFieldAccessors();
        }

        private SearchFrame(StructurePointer structurePointer, Method[] methodArray, String string, int n) {
            this.ptr = structurePointer;
            this.fieldAccessors = methodArray;
            this.fieldName = string;
            this.fieldIndex = n;
        }

        private Method[] getFieldAccessors() {
            Class<?> clazz = this.ptr.getClass();
            if (fieldAccessorMap.containsKey(clazz)) {
                return (Method[])fieldAccessorMap.get(clazz);
            }
            Method[] methodArray = this.ptr.getClass().getMethods();
            LinkedList<Method> linkedList = new LinkedList<Method>();
            for (Method method : methodArray) {
                if (!method.isAnnotationPresent(GeneratedFieldAccessor.class)) continue;
                linkedList.add(method);
            }
            Method[] methodArray2 = linkedList.toArray(new Method[linkedList.size()]);
            fieldAccessorMap.put(clazz, methodArray2);
            return methodArray2;
        }

        public SearchFrame copy() {
            return new SearchFrame(this.ptr, this.fieldAccessors, this.fieldName, this.fieldIndex);
        }
    }
}

