/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.J9ConstantHelper;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModronThreadLocalHeapPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_CopyScanCachePointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_EnvironmentStandardPointer;
import com.ibm.j9ddr.vm29.structure.J9ModronThreadLocalHeap;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;

class GCObjectHeapIteratorAddressOrderedList_V1
extends GCObjectHeapIterator {
    private static final int realHeapAllocOffset = J9ConstantHelper.getInt(J9ModronThreadLocalHeap.class, "_realHeapAllocOffset_", -1);
    protected J9ObjectPointer currentObject = null;
    protected U8Pointer scanPtr;
    protected U8Pointer scanPtrTop;
    protected U8Pointer[][] excludedRanges;
    protected int currentExcludedRange;

    protected GCObjectHeapIteratorAddressOrderedList_V1(U8Pointer u8Pointer, U8Pointer u8Pointer2, boolean bl, boolean bl2) throws CorruptDataException {
        super(bl, bl2);
        this.scanPtr = u8Pointer;
        this.scanPtrTop = u8Pointer2;
        ArrayList<U8Pointer[]> arrayList = new ArrayList<U8Pointer[]>();
        GCVMThreadListIterator gCVMThreadListIterator = new GCVMThreadListIterator();
        boolean bl3 = false;
        if (J9BuildFlags.J9VM_GC_MODRON_SCAVENGER && GCObjectHeapIteratorAddressOrderedList_V1.getExtensions().scavengerEnabled()) {
            bl3 = true;
        }
        while (gCVMThreadListIterator.hasNext()) {
            U8Pointer u8Pointer3;
            U8Pointer u8Pointer4;
            AbstractPointer abstractPointer;
            AbstractPointer abstractPointer2;
            AbstractPointer abstractPointer3;
            J9VMThreadPointer j9VMThreadPointer = gCVMThreadListIterator.next();
            if (J9BuildFlags.J9VM_GC_INLINED_ALLOC_FIELDS) {
                abstractPointer3 = this.adjustedToRange(j9VMThreadPointer.heapTop(), u8Pointer, u8Pointer2);
                if (abstractPointer3.notNull()) {
                    abstractPointer2 = this.adjustedToRange(j9VMThreadPointer.heapAlloc(), u8Pointer, u8Pointer2);
                    if (this.isSomethingToAdd((U8Pointer)abstractPointer2, (U8Pointer)abstractPointer3)) {
                        arrayList.add(new U8Pointer[]{abstractPointer2, abstractPointer3});
                    } else {
                        abstractPointer = this.adjustedToRange(this.getRealHeapAlloc(j9VMThreadPointer.allocateThreadLocalHeap(), (U8Pointer)abstractPointer2), u8Pointer, u8Pointer2);
                        u8Pointer4 = this.adjustedToRange(this.getRealHeapTop(j9VMThreadPointer.allocateThreadLocalHeap(), (U8Pointer)abstractPointer3), u8Pointer, u8Pointer2);
                        if (abstractPointer.notNull() && u8Pointer4.notNull() && this.isSomethingToAdd((U8Pointer)abstractPointer, u8Pointer4)) {
                            arrayList.add(new U8Pointer[]{abstractPointer, u8Pointer4});
                        }
                    }
                }
                if (J9BuildFlags.J9VM_GC_NON_ZERO_TLH && (abstractPointer3 = this.adjustedToRange(j9VMThreadPointer.nonZeroHeapTop(), u8Pointer, u8Pointer2)).notNull()) {
                    abstractPointer2 = this.adjustedToRange(j9VMThreadPointer.nonZeroHeapAlloc(), u8Pointer, u8Pointer2);
                    if (this.isSomethingToAdd((U8Pointer)abstractPointer2, (U8Pointer)abstractPointer3)) {
                        arrayList.add(new U8Pointer[]{abstractPointer2, abstractPointer3});
                    } else {
                        abstractPointer = this.adjustedToRange(this.getRealHeapAlloc(j9VMThreadPointer.nonZeroAllocateThreadLocalHeap(), (U8Pointer)abstractPointer2), u8Pointer, u8Pointer2);
                        u8Pointer4 = this.adjustedToRange(this.getRealHeapTop(j9VMThreadPointer.nonZeroAllocateThreadLocalHeap(), (U8Pointer)abstractPointer3), u8Pointer, u8Pointer2);
                        if (abstractPointer.notNull() && u8Pointer4.notNull() && this.isSomethingToAdd((U8Pointer)abstractPointer, u8Pointer4)) {
                            arrayList.add(new U8Pointer[]{abstractPointer, u8Pointer4});
                        }
                    }
                }
            } else {
                throw new UnsupportedOperationException("No support for non-gc_inlinedAllocFields VMs");
            }
            if (!bl3) continue;
            abstractPointer3 = MM_EnvironmentStandardPointer.cast(j9VMThreadPointer.gcExtensions());
            abstractPointer2 = ((MM_EnvironmentStandardPointer)abstractPointer3)._survivorCopyScanCache();
            if (abstractPointer2.notNull() && this.isSomethingToAdd((U8Pointer)(abstractPointer = this.adjustedToRange(U8Pointer.cast(((MM_CopyScanCachePointer)abstractPointer2).cacheAlloc()), u8Pointer, u8Pointer2)), u8Pointer4 = this.adjustedToRange(U8Pointer.cast(((MM_CopyScanCachePointer)abstractPointer2).cacheTop()), u8Pointer, u8Pointer2))) {
                arrayList.add(new U8Pointer[]{abstractPointer, u8Pointer4});
            }
            if (!(abstractPointer = ((MM_EnvironmentStandardPointer)abstractPointer3)._tenureCopyScanCache()).notNull() || !this.isSomethingToAdd(u8Pointer4 = this.adjustedToRange(U8Pointer.cast(((MM_CopyScanCachePointer)abstractPointer).cacheAlloc()), u8Pointer, u8Pointer2), u8Pointer3 = this.adjustedToRange(U8Pointer.cast(((MM_CopyScanCachePointer)abstractPointer).cacheTop()), u8Pointer, u8Pointer2))) continue;
            arrayList.add(new U8Pointer[]{u8Pointer4, u8Pointer3});
        }
        arrayList.add(new U8Pointer[]{this.scanPtrTop, this.scanPtrTop});
        Collections.sort(arrayList, new Comparator<U8Pointer[]>(){

            @Override
            public int compare(U8Pointer[] u8PointerArray, U8Pointer[] u8PointerArray2) {
                return u8PointerArray[0].compare(u8PointerArray2[0]);
            }
        });
        this.excludedRanges = new U8Pointer[arrayList.size()][];
        arrayList.toArray((T[])this.excludedRanges);
        this.currentExcludedRange = 0;
    }

    protected U8Pointer getRealHeapTop(J9ModronThreadLocalHeapPointer j9ModronThreadLocalHeapPointer, U8Pointer u8Pointer) throws CorruptDataException {
        return u8Pointer;
    }

    protected U8Pointer getRealHeapAlloc(J9ModronThreadLocalHeapPointer j9ModronThreadLocalHeapPointer, U8Pointer u8Pointer) throws CorruptDataException {
        if (realHeapAllocOffset < 0) {
            throw new CorruptDataException("No such field: realHeapAlloc");
        }
        PointerPointer pointerPointer = PointerPointer.cast(j9ModronThreadLocalHeapPointer).addOffset(realHeapAllocOffset);
        return U8Pointer.cast(pointerPointer.at(0L));
    }

    private U8Pointer adjustedToRange(U8Pointer u8Pointer, U8Pointer u8Pointer2, U8Pointer u8Pointer3) {
        U8Pointer u8Pointer4 = u8Pointer;
        if (u8Pointer4.notNull()) {
            if (u8Pointer4.lt(u8Pointer2)) {
                u8Pointer4 = u8Pointer2;
            } else if (u8Pointer4.gt(u8Pointer3)) {
                u8Pointer4 = u8Pointer3;
            }
        }
        return u8Pointer4;
    }

    private boolean isSomethingToAdd(U8Pointer u8Pointer, U8Pointer u8Pointer2) throws CorruptDataException {
        boolean bl = false;
        if (u8Pointer.lt(u8Pointer2)) {
            bl = true;
        } else if (u8Pointer.gt(u8Pointer2)) {
            throw new CorruptDataException("Memory range: Start address is higher then end address");
        }
        return bl;
    }

    protected void advanceScanPointer() {
        try {
            while (this.scanPtr.lt(this.scanPtrTop)) {
                if (null != this.currentObject) {
                    if (ObjectModel.isHoleObject(this.currentObject)) {
                        UDATA uDATA = ObjectModel.getSizeInBytesHoleObject(this.currentObject);
                        if (uDATA.eq(0L)) {
                            throw new CorruptDataException("Hole object at " + this.currentObject.getHexAddress() + " has an invalid size of 0");
                        }
                        this.scanPtr = this.scanPtr.add(uDATA);
                    } else {
                        this.scanPtr = this.scanPtr.add(ObjectModel.getConsumedSizeInBytesWithHeader(this.currentObject));
                    }
                    this.currentObject = null;
                }
                if (this.scanPtr.gte(this.scanPtrTop)) {
                    return;
                }
                while (this.scanPtr.gt(this.excludedRanges[this.currentExcludedRange][1])) {
                    ++this.currentExcludedRange;
                }
                if (this.scanPtr.gte(this.excludedRanges[this.currentExcludedRange][0])) {
                    this.scanPtr = U8Pointer.cast(this.excludedRanges[this.currentExcludedRange][1]);
                    ++this.currentExcludedRange;
                    continue;
                }
                if (this.scanPtr.gte(this.scanPtrTop)) {
                    return;
                }
                this.currentObject = J9ObjectPointer.cast(this.scanPtr);
                if (!this.includeLiveObjects || !this.includeDeadObjects) {
                    boolean bl;
                    boolean bl2 = bl = ObjectModel.isHoleObject(this.currentObject) || ObjectModel.isDarkMatterObject(this.currentObject);
                    if (!this.includeLiveObjects && !bl || !this.includeDeadObjects && bl) continue;
                }
                return;
            }
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, false);
            this.currentObject = null;
            this.scanPtr = this.scanPtrTop;
        }
    }

    @Override
    public boolean hasNext() {
        if (null == this.currentObject) {
            this.advanceScanPointer();
        }
        return null != this.currentObject;
    }

    @Override
    public void advance(UDATA uDATA) {
        U8Pointer u8Pointer = this.scanPtr.addOffset(uDATA);
        if (!u8Pointer.gte(this.scanPtr) || !u8Pointer.lte(this.scanPtrTop)) {
            throw new NoSuchElementException("An address to advance is out of range");
        }
        this.scanPtr = u8Pointer;
        this.currentObject = null;
    }

    @Override
    public J9ObjectPointer next() {
        if (this.hasNext()) {
            J9ObjectPointer j9ObjectPointer = this.currentObject;
            this.advanceScanPointer();
            return j9ObjectPointer;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public J9ObjectPointer peek() {
        if (this.hasNext()) {
            return this.currentObject;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }
}

