/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.RootSet;
import com.ibm.j9ddr.vm29.j9.gc.GCClassIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCClassIteratorClassSlots;
import com.ibm.j9ddr.vm29.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import java.util.HashSet;

public class LiveSetWalker {
    public static void walkLiveSet(ObjectVisitor objectVisitor, RootSet.RootSetType rootSetType) throws CorruptDataException {
        HashSet<J9ObjectPointer> hashSet = new HashSet<J9ObjectPointer>();
        RootSet rootSet = RootSet.from(rootSetType, false);
        GCIterator gCIterator = rootSet.gcIterator(rootSetType);
        GCIterator gCIterator2 = rootSet.gcIterator(rootSetType);
        while (gCIterator.hasNext()) {
            J9ObjectPointer j9ObjectPointer = (J9ObjectPointer)gCIterator.next();
            VoidPointer voidPointer = gCIterator2.nextAddress();
            if (!j9ObjectPointer.notNull()) continue;
            LiveSetWalker.scanObject(hashSet, objectVisitor, j9ObjectPointer, voidPointer);
        }
    }

    public static void walkLiveSet(ObjectVisitor objectVisitor) throws CorruptDataException {
        LiveSetWalker.walkLiveSet(objectVisitor, RootSet.RootSetType.STRONG_REACHABLE);
    }

    private static void scanObject(HashSet<J9ObjectPointer> hashSet, ObjectVisitor objectVisitor, J9ObjectPointer j9ObjectPointer, VoidPointer voidPointer) {
        if (hashSet.contains(j9ObjectPointer)) {
            return;
        }
        if (!objectVisitor.visit(j9ObjectPointer, voidPointer)) {
            return;
        }
        hashSet.add(j9ObjectPointer);
        try {
            Object object;
            StructurePointer structurePointer;
            GCObjectIterator gCObjectIterator = GCObjectIterator.fromJ9Object(j9ObjectPointer, true);
            GCObjectIterator gCObjectIterator2 = GCObjectIterator.fromJ9Object(j9ObjectPointer, true);
            while (gCObjectIterator.hasNext()) {
                structurePointer = gCObjectIterator.next();
                object = gCObjectIterator2.nextAddress();
                if (!structurePointer.notNull()) continue;
                LiveSetWalker.scanObject(hashSet, objectVisitor, structurePointer, (VoidPointer)object);
            }
            if (J9ObjectHelper.getClassName(j9ObjectPointer).equals("java/lang/Class")) {
                Object object2;
                Object object3;
                structurePointer = ConstantPoolHelpers.J9VM_J9CLASS_FROM_HEAPCLASS(j9ObjectPointer);
                object = GCClassIterator.fromJ9Class((J9ClassPointer)structurePointer);
                GCClassIterator gCClassIterator = GCClassIterator.fromJ9Class((J9ClassPointer)structurePointer);
                while (((GCClassIterator)object).hasNext()) {
                    object3 = ((GCClassIterator)object).next();
                    object2 = gCClassIterator.nextAddress();
                    if (!((AbstractPointer)object3).notNull()) continue;
                    LiveSetWalker.scanObject(hashSet, objectVisitor, (J9ObjectPointer)object3, (VoidPointer)object2);
                }
                object3 = GCClassIteratorClassSlots.fromJ9Class((J9ClassPointer)structurePointer);
                object2 = GCClassIteratorClassSlots.fromJ9Class((J9ClassPointer)structurePointer);
                while (((GCClassIteratorClassSlots)object3).hasNext()) {
                    J9ClassPointer j9ClassPointer = ((GCClassIteratorClassSlots)object3).next();
                    VoidPointer voidPointer2 = ((GCClassIteratorClassSlots)object2).nextAddress();
                    J9ObjectPointer j9ObjectPointer2 = ConstantPoolHelpers.J9VM_J9CLASS_TO_HEAPCLASS(j9ClassPointer);
                    if (!j9ObjectPointer2.notNull()) continue;
                    LiveSetWalker.scanObject(hashSet, objectVisitor, j9ObjectPointer2, voidPointer2);
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Corruption found while walking the live set, object: " + j9ObjectPointer.getHexAddress(), corruptDataException, false);
        }
        objectVisitor.finishVisit(j9ObjectPointer, voidPointer);
    }

    public static interface ObjectVisitor {
        public boolean visit(J9ObjectPointer var1, VoidPointer var2);

        public void finishVisit(J9ObjectPointer var1, VoidPointer var2);
    }
}

