/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.VMDataFactory;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

public class J9RASImageDataFactory {
    public static ProcessData getProcessData(IProcess iProcess) {
        return (ProcessData)J9RASImageDataFactory.getRasData(iProcess);
    }

    public static MachineData getMachineData(ICore iCore) {
        Collection<? extends IAddressSpace> collection = iCore.getAddressSpaces();
        for (IAddressSpace iAddressSpace : collection) {
            MachineData machineData = J9RASImageDataFactory.getMachineData(iAddressSpace);
            if (machineData == null) continue;
            return machineData;
        }
        return null;
    }

    public static MachineData getMachineData(IAddressSpace iAddressSpace) {
        Collection<? extends IProcess> collection = iAddressSpace.getProcesses();
        for (IProcess iProcess : collection) {
            MachineData machineData = J9RASImageDataFactory.getMachineData(iProcess);
            if (machineData == null) continue;
            return machineData;
        }
        return null;
    }

    public static MachineData getMachineData(IProcess iProcess) {
        return (MachineData)J9RASImageDataFactory.getRasData(iProcess);
    }

    private static Object getRasData(IProcess iProcess) {
        block6: {
            try {
                IVMData iVMData = VMDataFactory.getVMData(iProcess);
                if (iVMData == null) break block6;
                Object[] objectArray = new Object[1];
                try {
                    iVMData.bootstrapRelative("view.dtfj.J9RASInfoBootstrapShim", new Object[]{objectArray});
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
                return objectArray[0];
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static interface ProcessData {
        public int version() throws CorruptDataException;

        public long pid() throws CorruptDataException, DataUnavailable;

        public long tid() throws CorruptDataException, DataUnavailable;

        public String gpInfo() throws CorruptDataException;

        public IProcess getProcess();

        public long getEnvironment() throws CorruptDataException;
    }

    public static interface MachineData {
        public long memoryBytes() throws CorruptDataException;

        public String osVersion() throws CorruptDataException;

        public String osArch() throws CorruptDataException;

        public String osName() throws CorruptDataException;

        public String hostName() throws DataUnavailableException, CorruptDataException;

        public Iterator<Object> ipaddresses() throws DataUnavailableException, CorruptDataException;

        public int cpus() throws CorruptDataException;

        public IProcess getProcess();

        public Properties systemInfo() throws DataUnavailableException, CorruptDataException;

        public long dumpTimeMillis() throws DataUnavailableException, CorruptDataException;

        public long dumpTimeNanos() throws DataUnavailableException, CorruptDataException;
    }
}

