/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class TraceFileHeaderWriter {
    private static final int UT_VERSION = 5;
    private static final int UT_MODIFICATION = 0;
    private ByteBuffer headerBytes = null;
    private final int bufferSize;
    private final boolean bigEndian;
    private final int cpuCount;
    private final int wordSize;
    private int arch = 0;
    private int subtype = 0;
    private static final int traceCounter = 7;
    private String serviceLevel = "";
    private String startupOptions = "";
    private String traceConfig = "";
    private long startPlatform = 0L;
    private long startSystem = 0L;
    private int type = 0;
    private int generations = 0;
    private static final String[] Archs = new String[]{"Unknown", "x86", "S390", "Power", "IA64", "S390X", "AMD64", "RISCV", "AArch64"};
    private static final String[] SubTypes = new String[]{"i486", "i586", "Pentium II", "Pentium III", "Merced", "McKinley", "PowerRS", "PowerPC", "GigaProcessor", "ESA", "Pentium IV", "T-Rex", "Opteron", "RV64G", "Armv8-A"};
    private static final String[] trCounter = new String[]{"Sequence Counter", "Special", "RDTSC Timer", "AIX Timer", "MFSPR Timer", "MFTB Timer", "STCK Timer", "J9 timer"};

    public TraceFileHeaderWriter(String string, boolean bl, int n, int n2, int n3, String string2, String string3, String string4, String string5, String string6, long l, long l2, int n4, int n5) throws IOException {
        int n6;
        try {
            this.headerBytes = ByteBuffer.allocate(163840);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException();
        }
        this.bigEndian = bl;
        this.cpuCount = n;
        this.wordSize = n2;
        this.bufferSize = n3;
        if (!this.bigEndian) {
            this.headerBytes.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.headerBytes.order(ByteOrder.BIG_ENDIAN);
        }
        for (n6 = 0; n6 < Archs.length; ++n6) {
            if (!Archs[n6].equalsIgnoreCase(string2)) continue;
            this.arch = n6;
        }
        for (n6 = 0; n6 < SubTypes.length; ++n6) {
            if (!SubTypes[n6].equalsIgnoreCase(string3)) continue;
            this.subtype = n6;
        }
        this.serviceLevel = string4;
        this.startupOptions = string5;
        this.traceConfig = string6;
        this.startPlatform = l;
        this.startSystem = l2;
        this.type = n4;
        this.generations = n5;
    }

    public byte[] createAndWriteTraceFileHeader() throws IOException {
        int n = this.writeTraceFileHeader();
        byte[] byArray = new byte[n];
        this.headerBytes.position(0);
        this.headerBytes.get(byArray);
        return byArray;
    }

    private int writeTraceFileHeader() {
        int n = this.headerBytes.position();
        int n2 = this.writeUtDataHeader("UTTH", -559038737);
        this.headerBytes.putInt(this.bufferSize);
        n2 += 4;
        this.headerBytes.putInt(305419896);
        n2 += 4;
        int n3 = this.headerBytes.position();
        this.headerBytes.putInt(-559038737);
        n2 += 4;
        int n4 = this.headerBytes.position();
        this.headerBytes.putInt(-559038737);
        n2 += 4;
        int n5 = this.headerBytes.position();
        this.headerBytes.putInt(-559038737);
        n2 += 4;
        int n6 = this.headerBytes.position();
        this.headerBytes.putInt(-559038737);
        n2 += 4;
        int n7 = this.headerBytes.position();
        this.headerBytes.putInt(-559038737);
        this.headerBytes.putInt(n3, n2 += 4);
        this.headerBytes.putInt(n4, n2 += this.writeTraceSection());
        this.headerBytes.putInt(n5, n2 += this.writeServiceSection());
        this.headerBytes.putInt(n6, n2 += this.writeStartupSection());
        this.headerBytes.putInt(n7, n2 += this.writeActiveSection());
        int n8 = this.headerBytes.position() - n;
        this.headerBytes.position(n);
        this.writeUtDataHeader("UTTH", n2 += this.writeProcSection());
        return n8;
    }

    private int writeProcSection() {
        int n = this.headerBytes.position();
        int n2 = this.writeUtDataHeader("XXXX", -559038737);
        this.writeUtProcessorInfo();
        int n3 = this.headerBytes.position() - n;
        this.headerBytes.position(n);
        this.writeUtDataHeader("UTPR", n3);
        this.headerBytes.position(n + n3);
        return n3;
    }

    private int writeUtProcessorInfo() {
        int n = this.headerBytes.position();
        int n2 = this.writeUtDataHeader("XXXX", -559038737);
        this.headerBytes.putInt(this.arch);
        this.headerBytes.putInt(this.bigEndian ? 1 : 0);
        this.headerBytes.putInt(this.wordSize);
        this.headerBytes.putInt(this.cpuCount);
        this.writeUtProcInfo();
        this.headerBytes.putInt(4096);
        this.headerBytes.putInt(0);
        int n3 = this.headerBytes.position() - n;
        this.headerBytes.position(n);
        this.writeUtDataHeader("PINF", n3);
        this.headerBytes.position(n + n3);
        return n3;
    }

    private int writeUtProcInfo() {
        int n = this.headerBytes.position();
        int n2 = this.writeUtDataHeader("XXXX", -559038737);
        this.headerBytes.putInt(this.subtype);
        this.headerBytes.putInt(7);
        int n3 = this.headerBytes.position() - n;
        this.headerBytes.position(n);
        this.writeUtDataHeader("PIN", n3);
        this.headerBytes.position(n + n3);
        return n3;
    }

    private int writeActiveSection() {
        int n = this.headerBytes.position();
        int n2 = this.writeUtDataHeader("XXXX", -559038737);
        try {
            this.headerBytes.put(this.traceConfig.getBytes("UTF-8"));
            this.headerBytes.put(new byte[]{0});
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int n3 = this.headerBytes.position() - n;
        this.headerBytes.position(n);
        this.writeUtDataHeader("UTTA", n3);
        this.headerBytes.position(n + n3);
        return n3;
    }

    private int writeStartupSection() {
        int n = this.headerBytes.position();
        int n2 = this.writeUtDataHeader("XXXX", -559038737);
        try {
            this.headerBytes.put(this.startupOptions.getBytes("UTF-8"));
            this.headerBytes.put(new byte[]{0});
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int n3 = this.headerBytes.position() - n;
        this.headerBytes.position(n);
        this.writeUtDataHeader("UTSO", n3);
        this.headerBytes.position(n + n3);
        return n3;
    }

    private int writeServiceSection() {
        int n = this.headerBytes.position();
        int n2 = this.writeUtDataHeader("XXXX", -559038737);
        try {
            this.headerBytes.put(this.serviceLevel.getBytes("UTF-8"));
            this.headerBytes.put(new byte[]{0});
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int n3 = this.headerBytes.position() - n;
        this.headerBytes.position(n);
        this.writeUtDataHeader("UTSS", n3);
        this.headerBytes.position(n + n3);
        return n3;
    }

    private int writeTraceSection() {
        int n = this.headerBytes.position();
        int n2 = this.writeUtDataHeader("XXXX", -559038737);
        this.headerBytes.putLong(this.startPlatform);
        this.headerBytes.putLong(this.startSystem);
        this.headerBytes.putInt(this.type);
        this.headerBytes.putInt(this.generations);
        this.headerBytes.putInt(this.wordSize / 8);
        int n3 = this.headerBytes.position() - n;
        this.headerBytes.position(n);
        this.writeUtDataHeader("UTTS", n2);
        this.headerBytes.position(n + n3);
        return n3;
    }

    private int writeUtDataHeader(String string, int n) {
        int n2 = this.headerBytes.position();
        try {
            byte[] byArray = new byte[4];
            System.arraycopy(string.getBytes("US-ASCII"), 0, byArray, 0, string.length());
            this.headerBytes.put(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.headerBytes.putInt(n);
        this.headerBytes.putInt(5);
        this.headerBytes.putInt(0);
        return this.headerBytes.position() - n2;
    }
}

