/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.command.CommandParser;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.ICommand;
import com.ibm.j9ddr.tools.ddrinteractive.StructureCommandUtil;
import com.ibm.j9ddr.tools.ddrinteractive.plugins.DDRInteractiveClassLoader;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Context {
    public static final String TASK_FINDVM = "tools.ddrinteractive.FindVMTask";
    public static final String TASK_GETCOMMANDS = "tools.ddrinteractive.GetCommandsTask";
    public final IProcess process;
    public final IVMData vmData;
    public final long vmAddress;
    public List<ICommand> nonVMCommands;
    public List<ICommand> commands;
    public final Logger logger = Logger.getLogger("j9ddr.interactive.context");
    private DDRInteractiveClassLoader loader;

    public Context(IProcess iProcess, IVMData iVMData, List<ICommand> list) {
        this.vmData = iVMData;
        this.process = iProcess;
        this.nonVMCommands = list;
        this.vmAddress = this.getVMAddress();
        this.refreshCommandList();
    }

    public DDRInteractiveClassLoader getPluginClassloader() {
        return this.loader;
    }

    public void refreshCommandList() {
        try {
            this.loader = this.vmData.getClassLoader() == null ? new DDRInteractiveClassLoader(this.vmData, this.getClass().getClassLoader()) : new DDRInteractiveClassLoader(this.vmData);
        }
        catch (DDRInteractiveCommandException dDRInteractiveCommandException) {
            this.logger.log(Level.FINE, "Problem loading DDR plugins: ", dDRInteractiveCommandException);
            System.err.println("Problem loading DDR plugins:");
            System.err.println(dDRInteractiveCommandException.getMessage());
        }
        this.commands = this.getContextCommands();
    }

    private List<ICommand> getContextCommands() {
        Object[] objectArray = new Object[2];
        objectArray[1] = this.loader;
        try {
            this.vmData.bootstrapRelative(TASK_GETCOMMANDS, new Object[]{objectArray});
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error(classNotFoundException);
        }
        return Collections.unmodifiableList((List)objectArray[0]);
    }

    public String toString() {
        long l;
        try {
            l = this.process.getProcessId();
        }
        catch (CorruptDataException corruptDataException) {
            l = -1L;
        }
        if (this.process.getPlatform() == Platform.ZOS) {
            if (l == -1L) {
                return "ASID: " + Long.toHexString(this.process.getAddressSpace().getAddressSpaceId()) + " : No JRE";
            }
            return "ASID: " + Long.toHexString(this.process.getAddressSpace().getAddressSpaceId()) + " EDB: " + Long.toHexString(l) + " " + this.vmString();
        }
        String string = l == -1L ? "<error>" : Long.toString(l);
        return "PID: " + string + "; " + this.vmString();
    }

    public String toString(boolean bl) {
        long l;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            l = this.process.getProcessId();
        }
        catch (CorruptDataException corruptDataException) {
            l = -1L;
        }
        if (this.process.getPlatform() == Platform.ZOS) {
            stringBuilder.append("ASID: 0x" + Long.toHexString(this.process.getAddressSpace().getAddressSpaceId()));
            if (l == -1L) {
                stringBuilder.append(" : No JRE");
            } else {
                stringBuilder.append(" EDB: 0x" + Long.toHexString(l));
                if (!bl) {
                    stringBuilder.append(" " + this.vmString());
                }
            }
            return stringBuilder.toString();
        }
        if (bl) {
            String string = l == -1L ? "<error>" : Long.toString(l);
            return "PID: " + string;
        }
        String string = l == -1L ? "<error>" : Long.toString(l);
        return "PID: " + string + "; " + this.vmString();
    }

    private long getVMAddress() {
        long[] lArray = new long[1];
        try {
            this.vmData.bootstrapRelative(TASK_FINDVM, new Object[]{lArray});
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error(classNotFoundException);
        }
        return lArray[0];
    }

    private String vmString() {
        String string = "0x" + Long.toHexString(this.vmAddress);
        return " !j9javavm " + string;
    }

    public void execute(String string, String[] stringArray, PrintStream printStream) {
        try {
            this.execute(new CommandParser(string, stringArray), printStream);
        }
        catch (ParseException parseException) {
            printStream.println("Error executing command: " + parseException.getMessage());
        }
    }

    public void execute(CommandParser commandParser, PrintStream printStream) {
        for (ICommand iCommand : this.nonVMCommands) {
            if (!this.tryCommand(commandParser, iCommand, printStream)) continue;
            return;
        }
        for (ICommand iCommand : this.commands) {
            if (!this.tryCommand(commandParser, iCommand, printStream)) continue;
            return;
        }
        printStream.println("Unrecognised command: " + commandParser);
    }

    private boolean tryCommand(CommandParser commandParser, ICommand iCommand, PrintStream printStream) {
        String string = !commandParser.getCommand().startsWith("!") ? "!" + commandParser.getCommand() : commandParser.getCommand();
        if (iCommand.recognises(string, this)) {
            PrintStream printStream2 = null;
            try {
                if (commandParser.isRedirectedToFile()) {
                    printStream2 = commandParser.getOutputFile();
                    iCommand.run(string, commandParser.getArguments(), this, printStream2);
                    printStream2.flush();
                    printStream2.close();
                } else {
                    iCommand.run(string, commandParser.getArguments(), this, printStream);
                }
            }
            catch (Exception exception) {
                this.logger.log(Level.FINE, "Problem running command: ", exception);
                printStream.println("Problem running command:");
                exception.printStackTrace(printStream);
            }
            printStream.flush();
            if (printStream2 != null) {
                printStream2.flush();
                printStream2.close();
            }
            return true;
        }
        return false;
    }

    public Vector<String> getCommandNames() {
        Vector<String> vector = new Vector<String>();
        for (ICommand object : this.nonVMCommands) {
            if (object.getCommandNames() == null) continue;
            vector.addAll(object.getCommandNames());
        }
        for (ICommand iCommand : this.commands) {
            if (iCommand.getCommandNames() == null) continue;
            vector.addAll(iCommand.getCommandNames());
        }
        Map<String, StructureReader.StructureDescriptor> map = StructureCommandUtil.getStructureMap(this);
        for (String string : map.keySet()) {
            vector.add(string);
        }
        return vector;
    }
}

