/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools;

import com.ibm.j9ddr.CTypeParser;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.tools.FlagStructureList;
import com.ibm.j9ddr.tools.PointerGenerator;
import com.ibm.j9ddr.tools.store.J9DDRStructureStore;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class StructureStubGenerator {
    private String auxFieldInfoFileName;
    private String compatibilityConstantsFileName;
    private String compatibilityLimitFileName;
    private int errorCount;
    private boolean legacyMode;
    private File outputDir;
    private String outputDirectoryName;
    private String packageName;
    private StructureReader structureReader;
    private String supersetDirectoryName;
    private String supersetFileName;

    public static void main(String[] stringArray) throws Exception {
        StructureStubGenerator structureStubGenerator = new StructureStubGenerator();
        structureStubGenerator.parseArgs(stringArray);
        structureStubGenerator.generateClasses();
        if (structureStubGenerator.errorCount == 0) {
            System.out.println("Structure stub generation complete");
        } else {
            System.out.println("Structure stub generation failed");
            System.exit(1);
        }
    }

    private void generateClasses() {
        try {
            J9DDRStructureStore j9DDRStructureStore = new J9DDRStructureStore(this.supersetDirectoryName, this.supersetFileName);
            System.out.println("superset directory name: " + this.supersetDirectoryName);
            System.out.println("superset file name: " + j9DDRStructureStore.getSuperSetFileName());
            try (InputStream object = j9DDRStructureStore.getSuperset();){
                this.structureReader = new StructureReader(object);
            }
        }
        catch (IOException iOException) {
            System.err.println("Could not read: " + this.supersetDirectoryName + "/" + this.supersetFileName);
            ++this.errorCount;
            return;
        }
        this.adjustForCompatibility();
        this.adjustForOptionalFields();
        this.outputDir = this.getOutputDir();
        for (StructureReader.StructureDescriptor structureDescriptor : this.structureReader.getStructures()) {
            try {
                if (FlagStructureList.isFlagsStructure(structureDescriptor.getName())) continue;
                this.generateClass(structureDescriptor);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.format("File not found processing: %s: %s", structureDescriptor.getName(), fileNotFoundException.getMessage());
                ++this.errorCount;
            }
            catch (IOException iOException) {
                System.err.format("IOException processing: %s: %s", structureDescriptor.getName(), iOException.getMessage());
                ++this.errorCount;
            }
        }
    }

    private void adjustForCompatibility() {
        Iterator<StructureReader.StructureDescriptor> iterator;
        Object object;
        if (this.compatibilityLimitFileName != null) {
            HashSet<String> hashSet;
            object = new HashMap();
            try {
                iterator = new FileInputStream(this.compatibilityLimitFileName);
                Throwable object2 = null;
                try {
                    hashSet = new StructureReader((InputStream)((Object)iterator));
                    for (StructureReader.StructureDescriptor structureDescriptor : ((StructureReader)((Object)hashSet)).getStructures()) {
                        object.put(structureDescriptor.getName(), structureDescriptor);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    throw throwable;
                }
                finally {
                    if (iterator != null) {
                        if (object2 != null) {
                            try {
                                ((InputStream)((Object)iterator)).close();
                            }
                            catch (Throwable throwable) {
                                object2.addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)((Object)iterator)).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                System.err.println("Could not apply compatibility limits from: " + this.compatibilityLimitFileName);
                ++this.errorCount;
                return;
            }
            for (StructureReader.StructureDescriptor structureDescriptor : this.structureReader.getStructures()) {
                StructureReader.StructureDescriptor structureDescriptor2 = (StructureReader.StructureDescriptor)object.get(structureDescriptor.getName());
                if (structureDescriptor2 == null) {
                    hashSet = Collections.emptySet();
                } else {
                    hashSet = new HashSet<String>();
                    for (StructureReader.ConstantDescriptor constantDescriptor : structureDescriptor2.getConstants()) {
                        hashSet.add(constantDescriptor.getName());
                    }
                }
                Iterator<StructureReader.ConstantDescriptor> iterator2 = structureDescriptor.getConstants().iterator();
                while (iterator2.hasNext()) {
                    if (hashSet.contains(iterator2.next().getName())) continue;
                    iterator2.remove();
                }
            }
        }
        if (this.compatibilityConstantsFileName != null) {
            try {
                object = new FileInputStream(this.compatibilityConstantsFileName);
                iterator = null;
                try {
                    this.structureReader.addCompatibilityConstants((InputStream)object);
                }
                catch (Throwable throwable) {
                    iterator = throwable;
                    throw throwable;
                }
                finally {
                    if (object != null) {
                        if (iterator != null) {
                            try {
                                ((InputStream)object).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)((Object)iterator)).addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)object).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                System.err.println("Could not apply compatibility constants from: " + this.compatibilityConstantsFileName);
                ++this.errorCount;
            }
        }
    }

    private void adjustForOptionalFields() {
        if (this.auxFieldInfoFileName != null) {
            try (FileInputStream fileInputStream = new FileInputStream(this.auxFieldInfoFileName);){
                this.structureReader.loadAuxFieldInfo(fileInputStream);
            }
            catch (IOException iOException) {
                System.err.println("Could not load field information from: " + this.auxFieldInfoFileName);
                ++this.errorCount;
            }
        }
    }

    private void generateClass(StructureReader.StructureDescriptor structureDescriptor) throws IOException {
        Object object;
        Closeable closeable;
        File file = new File(this.outputDir, structureDescriptor.getName() + ".java");
        byte[] byArray = null;
        int n = 0;
        if (file.exists()) {
            n = (int)file.length();
            byArray = new byte[n];
            closeable = new FileInputStream(file);
            object = null;
            try {
                ((FileInputStream)closeable).read(byArray);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (closeable != null) {
                    if (object != null) {
                        try {
                            ((FileInputStream)closeable).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((FileInputStream)closeable).close();
                    }
                }
            }
        }
        closeable = new ByteArrayOutputStream(n);
        object = new PrintWriter((OutputStream)closeable);
        Object object2 = null;
        try {
            StructureStubGenerator.writeCopyright((PrintWriter)object);
            ((PrintWriter)object).format("package %s;%n", this.packageName);
            ((PrintWriter)object).println();
            StructureStubGenerator.writeClassComment((PrintWriter)object, structureDescriptor.getName());
            ((PrintWriter)object).format("public final class %s {%n", structureDescriptor.getName());
            ((PrintWriter)object).println();
            StructureStubGenerator.writeConstants((PrintWriter)object, structureDescriptor);
            ((PrintWriter)object).println();
            this.writeOffsetStubs((PrintWriter)object, structureDescriptor);
            ((PrintWriter)object).println();
            this.writeStaticInitializer((PrintWriter)object, structureDescriptor);
            ((PrintWriter)object).println("}");
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((PrintWriter)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((PrintWriter)object).close();
                }
            }
        }
        object = ((ByteArrayOutputStream)closeable).toByteArray();
        if (null == byArray || !Arrays.equals(byArray, (byte[])object)) {
            object2 = new FileOutputStream(file);
            Throwable throwable = null;
            try {
                ((FileOutputStream)object2).write((byte[])object);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object2 != null) {
                    if (throwable != null) {
                        try {
                            ((FileOutputStream)object2).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((FileOutputStream)object2).close();
                    }
                }
            }
        }
    }

    private static void writeConstants(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor) {
        printWriter.println("\t// VM Constants");
        printWriter.println();
        printWriter.format("\tpublic static final long %s;%n", "SIZEOF");
        Collections.sort(structureDescriptor.getConstants());
        for (StructureReader.ConstantDescriptor constantDescriptor : structureDescriptor.getConstants()) {
            printWriter.format("\tpublic static final long %s;%n", constantDescriptor.getName());
        }
    }

    private static void writeConstantInitializer(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor) {
        printWriter.format("\t\t%s = 0;%n", "SIZEOF");
        Collections.sort(structureDescriptor.getConstants());
        for (StructureReader.ConstantDescriptor constantDescriptor : structureDescriptor.getConstants()) {
            printWriter.format("\t\t%s = 0;%n", constantDescriptor.getName());
        }
    }

    private void writeStaticInitializer(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor) {
        printWriter.println("\t// Static Initializer");
        printWriter.println();
        printWriter.println("\tprivate static final boolean RUNTIME = false;");
        printWriter.println();
        printWriter.println("\tstatic {");
        printWriter.println("\t\tif (!RUNTIME) {");
        printWriter.println("\t\t\tthrow new IllegalArgumentException(\"This stub class should not be on your classpath\");");
        printWriter.println("\t\t}");
        printWriter.println();
        StructureStubGenerator.writeConstantInitializer(printWriter, structureDescriptor);
        this.writeOffsetInitializer(printWriter, structureDescriptor);
        printWriter.println("\t}");
        printWriter.println();
    }

    private static void writeClassComment(PrintWriter printWriter, String string) {
        printWriter.println("/**");
        printWriter.format(" * Structure: %s%n", string);
        printWriter.println(" *");
        printWriter.println(" * This stub class represents a class that can return in memory offsets");
        printWriter.println(" * to VM C and C++ structures.");
        printWriter.println(" *");
        printWriter.println(" * This particular implementation exists only to allow StructurePointer code to");
        printWriter.println(" * compile at development time.  This is never loaded at run time.");
        printWriter.println(" *");
        printWriter.println(" * At runtime generated byte codes returning actual offset values from the core file");
        printWriter.println(" * will be loaded by the StructureClassLoader.");
        printWriter.println(" */");
    }

    private String getOffsetConstant(StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getName();
        if (this.legacyMode) {
            return PointerGenerator.getOffsetConstant(string);
        }
        return string;
    }

    private void writeOffsetStubs(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor) {
        List<StructureReader.FieldDescriptor> list = structureDescriptor.getFields();
        boolean bl = false;
        Collections.sort(list);
        for (StructureReader.FieldDescriptor fieldDescriptor : list) {
            if (!this.getOffsetConstant(fieldDescriptor).equals(fieldDescriptor.getName()) || PointerGenerator.omitFieldImplementation(structureDescriptor, fieldDescriptor)) continue;
            if (!bl) {
                printWriter.println("\t// Offsets");
                printWriter.println();
                bl = true;
            }
            StructureStubGenerator.writeOffsetStub(printWriter, fieldDescriptor);
        }
    }

    private static void writeOffsetStub(PrintWriter printWriter, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getName();
        CTypeParser cTypeParser = new CTypeParser(fieldDescriptor.getType());
        if (cTypeParser.getSuffix().contains(":")) {
            printWriter.format("\tpublic static final int _%s_s_;%n", string);
            printWriter.format("\tpublic static final int _%s_b_;%n", string);
        } else {
            printWriter.format("\tpublic static final int _%sOffset_;%n", string);
        }
    }

    private void writeOffsetInitializer(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor) {
        List<StructureReader.FieldDescriptor> list = structureDescriptor.getFields();
        Collections.sort(list);
        for (StructureReader.FieldDescriptor fieldDescriptor : list) {
            String string = fieldDescriptor.getName();
            if (!this.getOffsetConstant(fieldDescriptor).equals(string) || PointerGenerator.omitFieldImplementation(structureDescriptor, fieldDescriptor)) continue;
            CTypeParser cTypeParser = new CTypeParser(fieldDescriptor.getType());
            if (cTypeParser.getSuffix().contains(":")) {
                String string2 = string;
                printWriter.format("\t\t_%s_s_ = 0;%n", string2);
                printWriter.format("\t\t_%s_b_ = 0;%n", string2);
                continue;
            }
            printWriter.format("\t\t_%sOffset_ = 0;%n", string);
        }
    }

    private void parseArgs(String[] stringArray) {
        if (stringArray.length == 0 || stringArray.length % 2 != 0) {
            StructureStubGenerator.printHelp();
            System.exit(1);
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("-f");
        hashSet.add("-o");
        hashSet.add("-p");
        for (int i = 0; i < stringArray.length; i += 2) {
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            switch (string) {
                case "-a": {
                    this.auxFieldInfoFileName = string2;
                    break;
                }
                case "-c": {
                    this.compatibilityConstantsFileName = string2;
                    break;
                }
                case "-f": {
                    this.supersetDirectoryName = string2;
                    break;
                }
                case "-l": {
                    this.legacyMode = Boolean.parseBoolean(string2);
                    break;
                }
                case "-o": {
                    this.outputDirectoryName = string2;
                    break;
                }
                case "-p": {
                    this.packageName = string2;
                    break;
                }
                case "-r": {
                    this.compatibilityLimitFileName = string2;
                    break;
                }
                case "-s": {
                    this.supersetFileName = string2;
                    break;
                }
                default: {
                    System.err.println("Invalid option: " + string);
                    StructureStubGenerator.printHelp();
                    System.exit(1);
                }
            }
            hashSet.remove(string);
        }
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                System.err.println("The option " + string + " has not been set.");
            }
            StructureStubGenerator.printHelp();
            System.exit(1);
        }
    }

    private static void printHelp() {
        System.out.println("Usage: StructureStubGenerator {option value} ...");
        System.out.println("  required:");
        System.out.println("    -p <package name>    : package name for generated classes, e.g. com.ibm.j9ddr.vm29.structures");
        System.out.println("    -o <output path>     : where to write class files (path to base of package hierarchy, e.g. C:\\src\\)");
        System.out.println("    -f <superset folder> : folder containing superset file");
        System.out.println("  optional:");
        System.out.println("    -s <superset file>   : superset file (default: superset.dat)");
        System.out.println("    -l <legacy mode>     : flag set to true or false indicating if legacy DDR is used");
        System.out.println("    -r <path>            : path to superset for restricting available constants");
        System.out.println("    -c <path>            : path to additional compatibility constants");
        System.out.println("    -a <path>            : path to auxiliary field information");
    }

    private File getOutputDir() {
        String string = this.outputDirectoryName.replace('\\', '/');
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        string = string + this.packageName.replace('.', '/');
        System.out.println("Writing generated classes to " + string);
        File file = new File(string);
        file.mkdirs();
        return file;
    }

    private static void writeCopyright(PrintWriter printWriter) {
        printWriter.println("/*");
        printWriter.println(" * Copyright IBM Corp. and others 1991");
        printWriter.println(" *");
        printWriter.println(" * This program and the accompanying materials are made available under");
        printWriter.println(" * the terms of the Eclipse Public License 2.0 which accompanies this");
        printWriter.println(" * distribution and is available at https://www.eclipse.org/legal/epl-2.0/");
        printWriter.println(" * or the Apache License, Version 2.0 which accompanies this distribution");
        printWriter.println(" * and is available at https://www.apache.org/licenses/LICENSE-2.0.");
        printWriter.println(" *");
        printWriter.println(" * This Source Code may also be made available under the following");
        printWriter.println(" * Secondary Licenses when the conditions for such availability set");
        printWriter.println(" * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU");
        printWriter.println(" * General Public License, version 2 with the GNU Classpath");
        printWriter.println(" * Exception [1] and GNU General Public License, version 2 with the");
        printWriter.println(" * OpenJDK Assembly Exception [2].");
        printWriter.println(" *");
        printWriter.println(" * [1] https://www.gnu.org/software/classpath/license.html");
        printWriter.println(" * [2] https://openjdk.org/legal/assembly-exception.html");
        printWriter.println(" *");
        printWriter.println(" * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0");
        printWriter.println(" */");
    }
}

