/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ICoreFileReader;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.MemoryRange;
import com.ibm.j9ddr.corereaders.memory.Module;
import com.ibm.j9ddr.corereaders.memory.ProtectedMemoryRange;
import com.ibm.j9ddr.corereaders.memory.SearchableMemory;
import com.ibm.j9ddr.corereaders.memory.Symbol;
import com.ibm.j9ddr.corereaders.osthread.IOSStackFrame;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.corereaders.osthread.IRegister;
import com.ibm.j9ddr.corereaders.osthread.Register;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressRange;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.Dump;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CaaNotFound;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Dll;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.DllFunction;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.DllVariable;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.DsaStackFrame;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Edb;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.RegisterSet;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.Tcb;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.FileFormatException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;

public class TDumpReader
implements ICoreFileReader {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    private static final int DR1 = -992349888;
    private static final int DR2 = -992349632;

    public boolean validDump(byte[] byArray, long l) {
        int n = 0xFF000000 & byArray[0] << 24 | 0xFF0000 & byArray[1] << 16 | 0xFF00 & byArray[2] << 8 | 0xFF & byArray[3];
        return n == -992349888 || n == -992349632;
    }

    @Override
    public ICore processDump(String string) throws InvalidDumpFormatException, IOException {
        return new DumpAdapter(new Dump(string));
    }

    @Override
    public ICore processDump(ImageInputStream imageInputStream) throws InvalidDumpFormatException, IOException {
        return new DumpAdapter(new Dump(imageInputStream));
    }

    @Override
    public ICoreFileReader.DumpTestResult testDump(String string) throws IOException {
        if (!new File(string).exists()) {
            return ICoreFileReader.DumpTestResult.FILE_NOT_FOUND;
        }
        try {
            new Dump(string, false).close();
            return ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT;
        }
        catch (FileFormatException fileFormatException) {
            return ICoreFileReader.DumpTestResult.UNRECOGNISED_FORMAT;
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
    }

    @Override
    public ICoreFileReader.DumpTestResult testDump(ImageInputStream imageInputStream) throws IOException {
        try {
            imageInputStream.seek(0L);
            int n = imageInputStream.readInt();
            if (n == -992349888 || n == -992349632) {
                ICoreFileReader.DumpTestResult dumpTestResult = ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT;
                return dumpTestResult;
            }
            ICoreFileReader.DumpTestResult dumpTestResult = ICoreFileReader.DumpTestResult.UNRECOGNISED_FORMAT;
            return dumpTestResult;
        }
        catch (FileFormatException fileFormatException) {
            ICoreFileReader.DumpTestResult dumpTestResult = ICoreFileReader.DumpTestResult.UNRECOGNISED_FORMAT;
            return dumpTestResult;
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException(iOException.getMessage());
            iOException2.initCause(iOException);
            throw iOException2;
        }
        finally {
            imageInputStream.seek(0L);
        }
    }

    private static String format(long l) {
        return "0x" + Long.toHexString(l);
    }

    private static class DSAAdapter
    implements IOSStackFrame {
        private final DsaStackFrame dsa;
        private final EdbAdapter edb;

        public DSAAdapter(DsaStackFrame dsaStackFrame, EdbAdapter edbAdapter) {
            this.dsa = dsaStackFrame;
            this.edb = edbAdapter;
        }

        public Symbol getSymbol() {
            return new Symbol(this.dsa.getEntryName(), this.dsa.getEntryPoint());
        }

        @Override
        public long getBasePointer() {
            return this.dsa.getDsaAddress();
        }

        @Override
        public long getInstructionPointer() {
            return this.dsa.getEntryPoint() + this.dsa.getEntryOffset();
        }

        @Override
        public long getStackPointer() {
            return this.dsa.getRegisterSet().getRegister(5);
        }
    }

    private static class TCBAdapter
    implements IOSThread {
        private static final int NUMBER_OF_GP_REGISTERS = 16;
        private final Tcb tcb;
        private final Caa caa;
        private final Properties props = new Properties();
        private final EdbAdapter edb;
        private List<DSAAdapter> stackFrames = new LinkedList<DSAAdapter>();
        private boolean stacksWalked = false;

        public TCBAdapter(Tcb tcb, Caa caa, EdbAdapter edbAdapter) {
            this.tcb = tcb;
            this.caa = caa;
            this.edb = edbAdapter;
            this.props.setProperty("TCB", TDumpReader.format(tcb.address()));
            this.props.setProperty("CAA", TDumpReader.format(caa.address()));
            this.props.setProperty("EDB", TDumpReader.format(caa.getEdb().address()));
            try {
                this.props.setProperty("PTHREADID", TDumpReader.format(caa.getPthreadId()));
            }
            catch (IOException iOException) {
                this.props.setProperty("PTHREADID", "unknown");
            }
            try {
                this.props.setProperty("Stack direction", caa.ceecaa_stackdirection() == 0 ? "up" : "down");
                this.props.setProperty("CAA CEL level", TDumpReader.format(caa.ceecaalevel()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                int n = tcb.space().readInt(tcb.address() + 16L);
                this.props.setProperty("Task Completion Code", TDumpReader.format(n));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                long l = tcb.getRegisters().getPSW();
                String string = null;
                switch ((int)(l >> 31) & 3) {
                    case 0: {
                        string = "PSW:24";
                        break;
                    }
                    case 1: {
                        string = "PSW:31";
                        break;
                    }
                    default: {
                        string = "PSW:64";
                    }
                }
                this.props.setProperty(string, TDumpReader.format(l));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (null != caa.getFailingRegisters()) {
                this.props.setProperty("FailingRegisters", "true");
            }
            try {
                this.props.setProperty("IFA Enabled", tcb.isIFAEnabled() ? "yes" : "no");
                this.props.setProperty("WEBFLAG2", String.format("0x%02x", tcb.getIFAFlags()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public Map<Long, String> getStackSymbols() {
            this.getStackFrames();
            HashMap<Long, String> hashMap = new HashMap<Long, String>();
            for (DSAAdapter dSAAdapter : this.getStackFrames()) {
                Symbol symbol = dSAAdapter.getSymbol();
                hashMap.put(symbol.getAddress(), symbol.getName());
            }
            return hashMap;
        }

        @Override
        public Collection<? extends IMemoryRange> getMemoryRanges() {
            List<DSAAdapter> list = this.getStackFrames();
            HashSet<MemoryRange> hashSet = new HashSet<MemoryRange>();
            for (IOSStackFrame iOSStackFrame : list) {
                IMemoryRange iMemoryRange = this.edb.getAddressSpace().getRangeForAddress(iOSStackFrame.getBasePointer());
                if (iMemoryRange == null) continue;
                hashSet.add(new MemoryRange(this.edb.getAddressSpace(), iMemoryRange, "Stack"));
            }
            return hashSet;
        }

        @Override
        public Properties getProperties() {
            return this.props;
        }

        public List<IRegister> getRegisters() {
            RegisterSet registerSet = new RegisterSet();
            DsaStackFrame dsaStackFrame = this.caa.getCurrentFrame();
            if (dsaStackFrame != null && dsaStackFrame.getRegisterSet() != null) {
                registerSet = dsaStackFrame.getRegisterSet();
            } else {
                try {
                    registerSet = this.tcb.getRegisters();
                }
                catch (IOException iOException) {
                    try {
                        registerSet = this.tcb.getRegistersFromBPXGMSTA();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
            }
            ArrayList<IRegister> arrayList = new ArrayList<IRegister>(17);
            long l = registerSet.getPSW();
            arrayList.add(new Register("PSW", l));
            for (int i = 0; i < 16; ++i) {
                arrayList.add(new Register("R" + i, registerSet.getRegister(i)));
            }
            return arrayList;
        }

        public List<DSAAdapter> getStackFrames() {
            if (!this.stacksWalked) {
                DsaStackFrame dsaStackFrame = null;
                try {
                    dsaStackFrame = this.caa.getCurrentFrame();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (dsaStackFrame != null) {
                    try {
                        while (dsaStackFrame != null) {
                            this.stackFrames.add(new DSAAdapter(dsaStackFrame, this.edb));
                            dsaStackFrame = dsaStackFrame.getParentFrame();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.stacksWalked = true;
            }
            return this.stackFrames;
        }

        @Override
        public long getThreadId() throws CorruptDataException {
            try {
                return this.caa.getPthreadId() >>> 32;
            }
            catch (IOException iOException) {
                throw new CorruptDataException(iOException);
            }
        }

        @Override
        public long getInstructionPointer() {
            DSAAdapter dSAAdapter = null;
            if (this.stacksWalked) {
                if (this.stackFrames.isEmpty()) {
                    logger.log(Level.FINE, "No stack frames for DSA");
                    return 0L;
                }
                dSAAdapter = this.stackFrames.get(0);
            } else {
                try {
                    dSAAdapter = new DSAAdapter(this.caa.getCurrentFrame(), null);
                }
                catch (Error error) {
                    logger.log(Level.FINE, "Failed to read dsa from core", error);
                    return 0L;
                }
            }
            return dSAAdapter.getInstructionPointer();
        }

        @Override
        public long getBasePointer() {
            DSAAdapter dSAAdapter = null;
            if (this.stacksWalked) {
                if (this.stackFrames.isEmpty()) {
                    logger.log(Level.FINE, "No stack frames for DSA");
                    return 0L;
                }
                dSAAdapter = this.stackFrames.get(0);
            } else {
                try {
                    dSAAdapter = new DSAAdapter(this.caa.getCurrentFrame(), null);
                }
                catch (Error error) {
                    logger.log(Level.FINE, "Failed to read dsa from core", error);
                    return 0L;
                }
            }
            return dSAAdapter.getBasePointer();
        }

        @Override
        public long getStackPointer() {
            DSAAdapter dSAAdapter = null;
            if (this.stacksWalked) {
                if (this.stackFrames.isEmpty()) {
                    logger.log(Level.FINE, "No stack frames for DSA");
                    return 0L;
                }
                dSAAdapter = this.stackFrames.get(0);
            } else {
                try {
                    dSAAdapter = new DSAAdapter(this.caa.getCurrentFrame(), null);
                }
                catch (Error error) {
                    logger.log(Level.FINE, "Failed to read dsa from core", error);
                    return 0L;
                }
            }
            return dSAAdapter.getStackPointer();
        }
    }

    private static class AddressRangeAdapter
    extends ProtectedMemoryRange {
        private final AddressSpace addressSpace;
        private final String name;

        public AddressRangeAdapter(AddressSpace addressSpace, AddressRange addressRange, String string) {
            super(addressRange.getStartAddress(), addressRange.getLength());
            this.addressSpace = addressSpace;
            this.name = string;
        }

        public AddressRangeAdapter(AddressSpace addressSpace, AddressRange addressRange) {
            this(addressSpace, addressRange, null);
        }

        @Override
        public int getAddressSpaceId() {
            return this.addressSpace.getAsid();
        }

        @Override
        public String toString() {
            return String.format("TDumpReader address range from 0x%X to 0x%X in address space %x", this.getBaseAddress(), this.getTopAddress(), this.getAddressSpaceId());
        }

        @Override
        public String getName() {
            return this.name;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.addressSpace == null ? 0 : this.addressSpace.hashCode());
            n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof AddressRangeAdapter)) {
                return false;
            }
            AddressRangeAdapter addressRangeAdapter = (AddressRangeAdapter)object;
            if (this.addressSpace == null ? addressRangeAdapter.addressSpace != null : !this.addressSpace.equals(addressRangeAdapter.addressSpace)) {
                return false;
            }
            return !(this.name == null ? addressRangeAdapter.name != null : !this.name.equals(addressRangeAdapter.name));
        }
    }

    private static class EdbAdapter
    implements IProcess {
        private final AddressSpaceAdapter as;
        private final Edb edb;
        private final Caa caa;
        private IModule executable;
        private List<IModule> modules = new LinkedList<IModule>();
        private boolean modulesLoaded = false;
        private List<TCBAdapter> threads = null;

        private EdbAdapter(AddressSpaceAdapter addressSpaceAdapter, Edb edb, Caa caa) {
            this.edb = edb;
            this.as = addressSpaceAdapter;
            this.caa = caa;
        }

        @Override
        public int bytesPerPointer() {
            return this.caa.is64bit() ? 8 : 4;
        }

        @Override
        public long getPointerAt(long l) throws MemoryFault {
            if (this.bytesPerPointer() == 8) {
                return this.getLongAt(l);
            }
            return this.getIntAt(l);
        }

        @Override
        public AddressSpaceAdapter getAddressSpace() {
            return this.as;
        }

        @Override
        public long findPattern(byte[] byArray, int n, long l) {
            return this.as.findPattern(byArray, n, l);
        }

        @Override
        public byte getByteAt(long l) throws MemoryFault {
            return this.as.getByteAt(l);
        }

        @Override
        public ByteOrder getByteOrder() {
            return this.as.getByteOrder();
        }

        @Override
        public int getBytesAt(long l, byte[] byArray) throws MemoryFault {
            return this.as.getBytesAt(l, byArray);
        }

        @Override
        public int getBytesAt(long l, byte[] byArray, int n, int n2) throws MemoryFault {
            return this.as.getBytesAt(l, byArray, n, n2);
        }

        @Override
        public int getIntAt(long l) throws MemoryFault {
            return this.as.getIntAt(l);
        }

        @Override
        public long getLongAt(long l) throws MemoryFault {
            return this.as.getLongAt(l);
        }

        @Override
        public Collection<? extends IMemoryRange> getMemoryRanges() {
            return this.as.getMemoryRanges();
        }

        @Override
        public short getShortAt(long l) throws MemoryFault {
            return this.as.getShortAt(l);
        }

        public String toString() {
            return "EdbAdapter for EDB 0x" + Long.toHexString(this.edb.address());
        }

        @Override
        public String getCommandLine() throws DataUnavailableException {
            throw new DataUnavailableException("Command line not available on this platform");
        }

        @Override
        public Properties getEnvironmentVariables() throws CorruptDataException {
            try {
                return this.edb.getEnvVars();
            }
            catch (IOException iOException) {
                throw new CorruptDataException(iOException);
            }
        }

        @Override
        public IModule getExecutable() throws CorruptDataException {
            this.loadModules();
            return this.executable;
        }

        public List<IModule> getModules() throws CorruptDataException {
            this.loadModules();
            return Collections.unmodifiableList(this.modules);
        }

        /*
         * WARNING - void declaration
         */
        private void loadModules() throws CorruptDataException {
            if (this.modulesLoaded) {
                return;
            }
            AddressRange[] addressRangeArray = this.as.addressSpace.getAddressRanges();
            Map<Long, String> map = this.getStackSymbols();
            try {
                long l;
                Object object;
                Object object2;
                void var5_9;
                ArrayList<Symbol> arrayList;
                long l2;
                HashMap<Long, Dll> hashMap = new HashMap<Long, Dll>();
                for (Long object3 : map.keySet()) {
                    l2 = object3;
                    arrayList = this.closestDll(this.edb, l2);
                    hashMap.put(object3, (Dll)((Object)arrayList));
                }
                boolean bl = true;
                Dll dll = this.edb.getFirstDll();
                while (var5_9 != null) {
                    long l3;
                    int module;
                    DllFunction[] dllFunctionArray = var5_9.getFunctions();
                    DllVariable[] dllVariableArray = var5_9.getVariables();
                    arrayList = var5_9.getName();
                    object2 = new ArrayList();
                    long[][] lArray = new long[addressRangeArray.length][2];
                    object = new long[addressRangeArray.length][2];
                    for (module = 0; module < addressRangeArray.length; ++module) {
                        lArray[module][0] = Long.MAX_VALUE;
                        object[module][0] = Long.MAX_VALUE;
                    }
                    for (module = 0; module < dllFunctionArray.length; ++module) {
                        object2.add(new Symbol(dllFunctionArray[module].name, dllFunctionArray[module].address));
                        this.findRange(dllFunctionArray[module].address, lArray, addressRangeArray);
                    }
                    for (module = 0; module < dllVariableArray.length; ++module) {
                        object2.add(new Symbol(dllVariableArray[module].getName(), dllVariableArray[module].getAddress()));
                        this.findRange(dllVariableArray[module].getAddress(), (long[][])object, addressRangeArray);
                    }
                    Object i = map.keySet().iterator();
                    while (i.hasNext()) {
                        int n;
                        Long l4 = i.next();
                        l3 = l4;
                        i = (Dll)hashMap.get(l4);
                        if (i == null || !var5_9.getName().equals(((Dll)i).getName()) || (n = this.findRange(l3, addressRangeArray)) < 0 || l3 <= lArray[n][0] || l3 >= lArray[n][1]) continue;
                        String string = map.get(l4);
                        object2.add(new Symbol(string, l3));
                        i.remove();
                    }
                    i = new ArrayList();
                    for (int j = 0; j < addressRangeArray.length; ++j) {
                        long l5;
                        if (lArray[j][1] != 0L) {
                            l3 = this.roundToPage(lArray[j][0], Direction.DOWN);
                            l5 = this.roundToPage(lArray[j][1], Direction.UP) - l3;
                            i.add(new MemoryRange(this.as, l3, l5, ".text"));
                        }
                        if (object[j][1] == 0L) continue;
                        l3 = this.roundToPage((long)object[j][0], Direction.DOWN);
                        l5 = this.roundToPage((long)object[j][1], Direction.UP) - l3;
                        i.add(new MemoryRange(this.as, l3, l5, ".data"));
                    }
                    try {
                        l = var5_9.getLoadAddress();
                    }
                    catch (Error error) {
                        l = Long.MAX_VALUE;
                        for (int j = 0; j < dllFunctionArray.length; ++j) {
                            l = Math.min(dllFunctionArray[j].address, l);
                        }
                        l = l == Long.MAX_VALUE ? 0L : this.roundToPage(l, Direction.DOWN);
                    }
                    Properties properties = new Properties();
                    properties.setProperty("Load address", TDumpReader.format(l));
                    properties.setProperty("Writable Static Area address", TDumpReader.format(var5_9.getWsa()));
                    i = new Module(this, (String)((Object)arrayList), (List<? extends ISymbol>)object2, (Collection<? extends IMemoryRange>)i, l, properties);
                    if (bl) {
                        this.executable = i;
                        bl = false;
                    } else {
                        this.modules.add((IModule)i);
                    }
                    Dll dll2 = var5_9.getNext();
                }
                if (map.size() > 0) {
                    l2 = Long.MAX_VALUE;
                    arrayList = new ArrayList<Symbol>();
                    object2 = new long[addressRangeArray.length][2];
                    for (int i = 0; i < addressRangeArray.length; ++i) {
                        object2[i][0] = Long.MAX_VALUE;
                    }
                    Object object3 = map.keySet().iterator();
                    while (object3.hasNext()) {
                        object = object3.next();
                        long l6 = (Long)object;
                        l2 = Math.min(l6, l2);
                        this.findRange(l6, (long[][])object2, addressRangeArray);
                        String string = map.get(object);
                        arrayList.add(new Symbol(string, l6));
                        object3.remove();
                    }
                    l2 = l2 == Long.MAX_VALUE ? 0L : this.roundToPage(l2, Direction.DOWN);
                    object3 = new Properties();
                    ((Properties)object3).setProperty("Load address", TDumpReader.format(l2));
                    object = new ArrayList();
                    for (int i = 0; i < addressRangeArray.length; ++i) {
                        if (object2[i][1] == 0L) continue;
                        l = this.roundToPage((long)object2[i][0], Direction.DOWN);
                        long l7 = this.roundToPage((long)object2[i][1], Direction.UP) - l;
                        object.add(new MemoryRange(this.as, l, l7, ".text"));
                    }
                    Module module = new Module(this, "ExtraSymbolsModule", arrayList, (Collection<? extends IMemoryRange>)object, l2, (Properties)object3);
                    this.modules.add(module);
                }
            }
            catch (IOException iOException) {
                logger.log(Level.FINE, "Problem for Zebedee finding module information", iOException);
            }
            this.modulesLoaded = true;
        }

        private Map<Long, String> getStackSymbols() throws CorruptDataException {
            HashMap<Long, String> hashMap = new HashMap<Long, String>();
            for (TCBAdapter tCBAdapter : this.getThreads()) {
                hashMap.putAll(tCBAdapter.getStackSymbols());
            }
            return hashMap;
        }

        private void findRange(long l, long[][] lArray, AddressRange[] addressRangeArray) {
            int n = this.findRange(l, addressRangeArray);
            if (n >= 0) {
                lArray[n][0] = Math.min(lArray[n][0], l);
                lArray[n][1] = Math.max(lArray[n][1], l);
            }
        }

        private int findRange(long l, AddressRange[] addressRangeArray) {
            for (int i = 0; i < addressRangeArray.length; ++i) {
                if (addressRangeArray[i].getStartAddress() > l || l > addressRangeArray[i].getEndAddress()) continue;
                logger.fine("Found address " + TDumpReader.format(l) + " at " + TDumpReader.format(addressRangeArray[i].getStartAddress()) + ":" + TDumpReader.format(addressRangeArray[i].getEndAddress()));
                return i;
            }
            logger.fine("Didn't find address " + TDumpReader.format(l));
            return -2;
        }

        private long roundToPage(long l, Direction direction) {
            if (direction == Direction.DOWN) {
                return l & 0xFFFFFFFFFFFFF000L;
            }
            return (l & 0xFFFFFFFFFFFFF000L) + 4096L;
        }

        private Dll closestDll(Edb edb, long l) throws IOException {
            Dll dll = null;
            long l2 = Long.MAX_VALUE;
            for (Dll dll2 = edb.getFirstDll(); dll2 != null; dll2 = dll2.getNext()) {
                try {
                    DllFunction[] dllFunctionArray = dll2.getFunctions();
                    for (int i = 0; i < dllFunctionArray.length; ++i) {
                        long l3 = Math.abs(dllFunctionArray[i].address - l);
                        if (l3 >= l2) continue;
                        dll = dll2;
                        l2 = l3;
                    }
                    DllVariable[] dllVariableArray = dll2.getVariables();
                    for (int i = 0; i < dllVariableArray.length; ++i) {
                        long l4 = Math.abs(dllVariableArray[i].getAddress() - l);
                        if (l4 >= l2) continue;
                        dll = dll2;
                        l2 = l4;
                    }
                    continue;
                }
                catch (IOException iOException) {
                    logger.log(Level.FINE, "Skipping DDL due to IOException ", iOException);
                }
            }
            return dll;
        }

        @Override
        public long getProcessId() throws CorruptDataException {
            return this.edb.address();
        }

        @Override
        public boolean isExecutable(long l) {
            return this.as.isExecutable(l);
        }

        @Override
        public boolean isReadOnly(long l) {
            return this.as.isReadOnly(l);
        }

        @Override
        public boolean isShared(long l) {
            return this.as.isShared(l);
        }

        @Override
        public Properties getProperties(long l) {
            return this.as.getProperties(l);
        }

        @Override
        public String getProcedureNameForAddress(long l) throws CorruptDataException, DataUnavailableException {
            return this.getProcedureNameForAddress(l, false);
        }

        @Override
        public String getProcedureNameForAddress(long l, boolean bl) throws CorruptDataException, DataUnavailableException {
            ISymbol iSymbol = null;
            IModule iModule = null;
            long l2 = Long.MAX_VALUE;
            for (IModule iModule2 : this.getModules()) {
                for (ISymbol iSymbol2 : iModule2.getSymbols()) {
                    long l3;
                    if (!Addresses.lessThan(iSymbol2.getAddress(), l) || (l3 = l - iSymbol2.getAddress()) >= l2) continue;
                    l2 = l3;
                    iSymbol = iSymbol2;
                    iModule = iModule2;
                }
            }
            if (iSymbol != null) {
                return iModule.getName() + "::" + iSymbol.getName() + "+0x" + Long.toHexString(l2);
            }
            return "<unknown>";
        }

        public List<TCBAdapter> getThreads() throws CorruptDataException {
            if (this.threads == null) {
                Tcb[] tcbArray;
                LinkedList<TCBAdapter> linkedList = new LinkedList<TCBAdapter>();
                for (Tcb tcb : tcbArray = Tcb.getTcbs(this.as.addressSpace)) {
                    if (null == tcb) continue;
                    Caa caa = null;
                    try {
                        caa = new Caa(tcb);
                    }
                    catch (CaaNotFound caaNotFound) {
                        continue;
                    }
                    if (caa.getEdb().address() != this.edb.address()) continue;
                    linkedList.add(new TCBAdapter(tcb, caa, this));
                }
                this.threads = Collections.unmodifiableList(linkedList);
            }
            return this.threads;
        }

        @Override
        public Platform getPlatform() {
            return Platform.ZOS;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.caa == null ? 0 : this.caa.hashCode());
            n = 31 * n + (this.edb == null ? 0 : this.edb.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof EdbAdapter)) {
                return false;
            }
            EdbAdapter edbAdapter = (EdbAdapter)object;
            if (this.caa == null ? edbAdapter.caa != null : !this.caa.equals(edbAdapter.caa)) {
                return false;
            }
            return !(this.edb == null ? edbAdapter.edb != null : !this.edb.equals(edbAdapter.edb));
        }

        @Override
        public int getSignalNumber() throws DataUnavailableException {
            throw new DataUnavailableException("Signal number not available on z/OS");
        }

        @Override
        public boolean isFailingProcess() throws DataUnavailableException {
            try {
                return this.caa.getTcb().tcbcmp() != 0L;
            }
            catch (IOException iOException) {
                throw new DataUnavailableException("Couldn't determine TCB CMP status", iOException);
            }
        }

        private static enum Direction {
            DOWN,
            UP;

        }
    }

    private static class AddressSpaceAdapter
    extends SearchableMemory
    implements IAddressSpace {
        private final AddressSpace addressSpace;
        private final ICore reader;
        private Set<IProcess> processes;

        private AddressSpaceAdapter(AddressSpace addressSpace, ICore iCore) {
            this.addressSpace = addressSpace;
            this.reader = iCore;
        }

        @Override
        public ICore getCore() {
            return this.reader;
        }

        public Collection<IProcess> getProcesses() {
            this.initializeProcesses();
            if (this.processes != null) {
                return Collections.unmodifiableList(new ArrayList<IProcess>(this.processes));
            }
            return Collections.emptyList();
        }

        private void initializeProcesses() {
            if (this.processes != null) {
                return;
            }
            Tcb[] tcbArray = Tcb.getTcbs(this.addressSpace);
            if (tcbArray != null) {
                this.processes = new HashSet<IProcess>();
                HashSet<Edb> hashSet = new HashSet<Edb>();
                for (int i = 0; i < tcbArray.length; ++i) {
                    try {
                        Caa caa = new Caa(tcbArray[i]);
                        Edb edb = caa.getEdb();
                        if (hashSet.contains(edb)) continue;
                        hashSet.add(edb);
                        if (edb.getFirstDll() == null) continue;
                        this.processes.add(new EdbAdapter(this, edb, caa));
                        continue;
                    }
                    catch (CaaNotFound caaNotFound) {
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public int getAddressSpaceId() {
            return this.addressSpace.getAsid();
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.addressSpace == null ? 0 : this.addressSpace.hashCode());
            n = 31 * n + (this.processes == null ? 0 : this.processes.hashCode());
            n = 31 * n + (this.reader == null ? 0 : this.reader.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof AddressSpaceAdapter)) {
                return false;
            }
            AddressSpaceAdapter addressSpaceAdapter = (AddressSpaceAdapter)object;
            if (this.addressSpace == null ? addressSpaceAdapter.addressSpace != null : !this.addressSpace.equals(addressSpaceAdapter.addressSpace)) {
                return false;
            }
            if (this.processes == null ? addressSpaceAdapter.processes != null : !this.processes.equals(addressSpaceAdapter.processes)) {
                return false;
            }
            return !(this.reader == null ? addressSpaceAdapter.reader != null : !this.reader.equals(addressSpaceAdapter.reader));
        }

        @Override
        public Platform getPlatform() {
            return Platform.ZOS;
        }

        @Override
        public byte getByteAt(long l) throws MemoryFault {
            try {
                return this.addressSpace.readByte(l);
            }
            catch (IOException iOException) {
                throw new MemoryFault(l, (Throwable)iOException);
            }
        }

        @Override
        public ByteOrder getByteOrder() {
            return ByteOrder.BIG_ENDIAN;
        }

        @Override
        public int getBytesAt(long l, byte[] byArray) throws MemoryFault {
            return this.getBytesAt(l, byArray, 0, byArray.length);
        }

        @Override
        public int getBytesAt(long l, byte[] byArray, int n, int n2) throws MemoryFault {
            try {
                this.addressSpace.read(l, byArray, n, n2);
            }
            catch (IOException iOException) {
                throw new MemoryFault(l, (Throwable)iOException);
            }
            return n2;
        }

        @Override
        public int getIntAt(long l) throws MemoryFault {
            try {
                return this.addressSpace.readInt(l);
            }
            catch (IOException iOException) {
                throw new MemoryFault(l, (Throwable)iOException);
            }
        }

        @Override
        public long getLongAt(long l) throws MemoryFault {
            try {
                return this.addressSpace.readLong(l);
            }
            catch (IOException iOException) {
                throw new MemoryFault(l, (Throwable)iOException);
            }
        }

        @Override
        public Collection<? extends IMemoryRange> getMemoryRanges() {
            AddressRange[] addressRangeArray = this.addressSpace.getAddressRanges();
            ArrayList<AddressRangeAdapter> arrayList = new ArrayList<AddressRangeAdapter>(addressRangeArray.length);
            for (AddressRange addressRange : addressRangeArray) {
                arrayList.add(new AddressRangeAdapter(this.addressSpace, addressRange));
            }
            return arrayList;
        }

        @Override
        public short getShortAt(long l) throws MemoryFault {
            try {
                return this.addressSpace.readShort(l);
            }
            catch (IOException iOException) {
                throw new MemoryFault(l, (Throwable)iOException);
            }
        }

        @Override
        public boolean isExecutable(long l) {
            return false;
        }

        @Override
        public boolean isReadOnly(long l) {
            return false;
        }

        @Override
        public boolean isShared(long l) {
            return false;
        }

        @Override
        public Properties getProperties(long l) {
            return new Properties();
        }

        public IMemoryRange getRangeForAddress(long l) {
            for (IMemoryRange iMemoryRange : this.getMemoryRanges()) {
                if (!iMemoryRange.contains(l)) continue;
                return iMemoryRange;
            }
            return null;
        }
    }

    private static class DumpAdapter
    implements ICore {
        private final Dump _dump;
        private List<IAddressSpace> addressSpaces = null;

        public DumpAdapter(Dump dump) {
            this._dump = dump;
        }

        @Override
        public void close() throws IOException {
            this._dump.close();
        }

        public List<IAddressSpace> getAddressSpaces() {
            if (null == this.addressSpaces) {
                AddressSpace[] addressSpaceArray = this._dump.getAddressSpaces();
                this.addressSpaces = new ArrayList<IAddressSpace>(addressSpaceArray.length);
                for (AddressSpace addressSpace : addressSpaceArray) {
                    if (addressSpace.getAsid() == 0) continue;
                    this.addressSpaces.add(new AddressSpaceAdapter(addressSpace, this));
                }
            }
            return this.addressSpaces;
        }

        @Override
        public String getDumpFormat() {
            return "tdump";
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof DumpAdapter)) {
                return false;
            }
            DumpAdapter dumpAdapter = (DumpAdapter)object;
            return !(this._dump == null ? dumpAdapter._dump != null : !this._dump.equals(dumpAdapter._dump));
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this._dump == null ? 0 : this._dump.hashCode());
            return n;
        }

        @Override
        public Properties getProperties() {
            Properties properties = new Properties();
            properties.setProperty("core.creation.time", Long.toString(this._dump.getCreationDate().getTime()));
            properties.setProperty("cpu.type", "s390");
            properties.setProperty("cpu.subtype", "");
            properties.setProperty("system.type", "z/OS");
            return properties;
        }

        @Override
        public Platform getPlatform() {
            return Platform.ZOS;
        }
    }
}

