/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.minidump;

import com.ibm.j9ddr.corereaders.memory.DetailedDumpMemorySource;
import com.ibm.j9ddr.corereaders.memory.DumpMemorySource;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.UnbackedMemorySource;
import com.ibm.j9ddr.corereaders.minidump.MiniDumpReader;
import com.ibm.j9ddr.corereaders.minidump.Stream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class MemoryInfoStream
extends Stream {
    private static final int STATE_MEM_COMMIT = 4096;
    private static final int STATE_MEM_FREE = 65536;
    private static final int STATE_MEM_RESERVE = 8192;
    private static final int TYPE_MEM_IMAGE = 0x1000000;
    private static final int TYPE_MEM_MAPPED = 262144;
    private static final int TYPE_MEM_PRIVATE = 131072;
    private static final int PROTECT_PAGE_NOACCESS = 1;
    private static final int PROTECT_PAGE_READONLY = 2;
    private static final int PROTECT_PAGE_READWRITE = 4;
    private static final int PROTECT_PAGE_WRITECOPY = 8;
    private static final int PROTECT_PAGE_EXECUTE = 16;
    private static final int PROTECT_PAGE_EXECUTE_READ = 32;
    private static final int PROTECT_PAGE_EXECUTE_READWRITE = 64;
    private static final int PROTECT_PAGE_EXECUTE_WRITECOPY = 128;
    private static final int PROTECT_PAGE_GUARD = 256;
    private static final int PROTECT_PAGE_NOCACHE = 512;
    private static final int PROTECT_PAGE_WRITECOMBINE = 1024;
    private final String TRUE = Boolean.TRUE.toString();
    private final String FALSE = Boolean.FALSE.toString();

    protected MemoryInfoStream(int n, long l) {
        super(n, l);
    }

    public void readFrom(MiniDumpReader miniDumpReader, boolean bl, Collection<? extends IMemorySource> collection) throws IOException {
        Cloneable cloneable;
        miniDumpReader.seek(this.getLocation());
        int n = 0;
        int n2 = 0;
        long l = 0L;
        HashMap<Long, Cloneable> hashMap = new HashMap<Long, Cloneable>();
        n = miniDumpReader.readInt();
        n2 = miniDumpReader.readInt();
        l = miniDumpReader.readLong();
        miniDumpReader.seek(this.getLocation() + (long)n);
        int n3 = 0;
        while ((long)n3 < l) {
            cloneable = new Properties();
            long l2 = miniDumpReader.readLong();
            long l3 = miniDumpReader.readLong();
            int n4 = miniDumpReader.readInt();
            miniDumpReader.readInt();
            long l4 = miniDumpReader.readLong();
            int n5 = miniDumpReader.readInt();
            int n6 = miniDumpReader.readInt();
            int n7 = miniDumpReader.readInt();
            miniDumpReader.readInt();
            ((Properties)cloneable).put("state", this.decodeStateFlags(n5));
            ((Properties)cloneable).put("state_flags", String.format("0x%X", n5));
            ((Properties)cloneable).put("size", String.format(bl ? "0x%016X" : "0x%08X", l4));
            if (n5 != 65536) {
                ((Properties)cloneable).put("allocationBase", String.format(bl ? "0x%016X" : "0x%08X", l3));
                ((Properties)cloneable).put("allocationProtect", this.decodeProtectFlags(n4));
                ((Properties)cloneable).put("allocationProtect_flags", String.format("0x%X", n4));
                ((Properties)cloneable).put("protect", this.decodeProtectFlags(n6));
                this.setReadWriteExecProperties(n6, (Properties)cloneable);
                ((Properties)cloneable).put("protect_flags", String.format("0x%X", n6));
                ((Properties)cloneable).put("type", this.decodeTypeFlags(n7));
                ((Properties)cloneable).put("type_flags", String.format("0x%X", n4));
            } else {
                ((Properties)cloneable).setProperty("readable", this.FALSE);
                ((Properties)cloneable).setProperty("writable", this.FALSE);
                ((Properties)cloneable).setProperty("executable", this.FALSE);
            }
            hashMap.put(l2, cloneable);
            ++n3;
        }
        Iterator<? extends IMemorySource> iterator = collection.iterator();
        cloneable = new ArrayList(hashMap.size());
        while (iterator.hasNext()) {
            IMemorySource iMemorySource = iterator.next();
            Properties object = (Properties)hashMap.remove(iMemorySource.getBaseAddress());
            if (object != null && iMemorySource instanceof DumpMemorySource) {
                DetailedDumpMemorySource detailedDumpMemorySource = new DetailedDumpMemorySource((DumpMemorySource)iMemorySource, object);
                detailedDumpMemorySource.getProperties().putAll((Map<?, ?>)object);
                cloneable.add(detailedDumpMemorySource);
                continue;
            }
            cloneable.add(iMemorySource);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            long l5 = Long.parseLong(((String)((Properties)entry.getValue()).get("size")).substring(2), 16);
            String string = "Windows MINIDUMP_MEMORY_INFO entry included but data not included in dump";
            if ("MEM_FREE".equals(((Properties)entry.getValue()).get("state"))) {
                string = "Free memory, unallocated";
            }
            UnbackedMemorySource unbackedMemorySource = new UnbackedMemorySource((Long)entry.getKey(), l5, string);
            unbackedMemorySource.getProperties().putAll((Map<?, ?>)((Map)entry.getValue()));
            cloneable.add(unbackedMemorySource);
        }
        Collections.sort(cloneable, new Comparator<IMemorySource>(){

            @Override
            public int compare(IMemorySource iMemorySource, IMemorySource iMemorySource2) {
                if (iMemorySource.getBaseAddress() > iMemorySource2.getBaseAddress()) {
                    return 1;
                }
                if (iMemorySource.getBaseAddress() < iMemorySource2.getBaseAddress()) {
                    return -1;
                }
                return 0;
            }
        });
        miniDumpReader.setMemorySources((Collection<? extends IMemorySource>)((Object)cloneable));
    }

    private void setReadWriteExecProperties(int n, Properties properties) {
        if ((n & 1) != 0) {
            properties.setProperty("readable", this.FALSE);
            properties.setProperty("writable", this.FALSE);
            properties.setProperty("executable", this.FALSE);
        } else if ((n & 2) != 0) {
            properties.setProperty("readable", this.TRUE);
            properties.setProperty("writable", this.FALSE);
            properties.setProperty("executable", this.FALSE);
        } else if ((n & 4) != 0) {
            properties.setProperty("readable", this.TRUE);
            properties.setProperty("writable", this.TRUE);
            properties.setProperty("executable", this.FALSE);
        } else if ((n & 8) != 0) {
            properties.setProperty("readable", this.TRUE);
            properties.setProperty("writable", this.TRUE);
            properties.setProperty("executable", this.FALSE);
        } else if ((n & 0x10) != 0) {
            properties.setProperty("readable", this.FALSE);
            properties.setProperty("writable", this.FALSE);
            properties.setProperty("executable", this.TRUE);
        } else if ((n & 0x20) != 0) {
            properties.setProperty("readable", this.TRUE);
            properties.setProperty("writable", this.FALSE);
            properties.setProperty("executable", this.TRUE);
        } else if ((n & 0x40) != 0) {
            properties.setProperty("readable", this.TRUE);
            properties.setProperty("writable", this.TRUE);
            properties.setProperty("executable", this.TRUE);
        } else if ((n & 0x80) != 0) {
            properties.setProperty("readable", this.TRUE);
            properties.setProperty("writable", this.TRUE);
            properties.setProperty("executable", this.TRUE);
        }
    }

    private String decodeProtectFlags(int n) {
        String string = "";
        if ((n & 1) != 0) {
            string = string + "PAGE_NOACCESS|";
        }
        if ((n & 2) != 0) {
            string = string + "PAGE_READONLY|";
        }
        if ((n & 4) != 0) {
            string = string + "PAGE_READWRITE|";
        }
        if ((n & 8) != 0) {
            string = string + "PAGE_WRITECOPY|";
        }
        if ((n & 0x10) != 0) {
            string = string + "PAGE_EXECUTE|";
        }
        if ((n & 0x20) != 0) {
            string = string + "PAGE_EXECUTE_READ|";
        }
        if ((n & 0x40) != 0) {
            string = string + "PAGE_EXECUTE_READWRITE|";
        }
        if ((n & 0x80) != 0) {
            string = string + "PAGE_EXECUTE_WRITECOPY|";
        }
        if ((n & 0x100) != 0) {
            string = string + "PAGE_GUARD";
        }
        if ((n & 0x200) != 0) {
            string = string + "PAGE_NOCACHE";
        }
        if ((n & 0x400) != 0) {
            string = string + "PAGE_WRITECOMBINE";
        }
        if (string.endsWith("|")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String decodeStateFlags(int n) {
        switch (n) {
            case 4096: {
                return "MEM_COMMIT";
            }
            case 65536: {
                return "MEM_FREE";
            }
            case 8192: {
                return "MEM_RESERVE";
            }
        }
        return "UNKNOWN";
    }

    private String decodeTypeFlags(int n) {
        switch (n) {
            case 0x1000000: {
                return "MEM_IMAGE";
            }
            case 262144: {
                return "MEM_MAPPED";
            }
            case 131072: {
                return "MEM_PRIVATE";
            }
        }
        return "UNKNOWN";
    }
}

