/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.macho;

import com.ibm.j9ddr.corereaders.macho.LoadCommand;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.stream.ImageInputStream;

public class ThreadCommand
extends LoadCommand {
    private final int cpuType;
    final List<ThreadState> states = new ArrayList<ThreadState>();

    public ThreadCommand(int n) {
        this.cpuType = n;
    }

    @Override
    public ThreadCommand readCommand(ImageInputStream imageInputStream, long l) throws IOException {
        int n;
        super.readCommand(imageInputStream, l);
        block4: for (long i = 8L; i < this.cmdSize; i += (long)(n * 4 + 8)) {
            int n2 = imageInputStream.readInt();
            n = imageInputStream.readInt();
            byte[] byArray = new byte[n * 4];
            imageInputStream.readFully(byArray);
            switch (this.cpuType) {
                case 0x1000007: {
                    this.states.add(new OSXAMD64ThreadState(n2, n, byArray, imageInputStream.getByteOrder()));
                    continue block4;
                }
                case 0x100000C: {
                    this.states.add(new OSXAArch64ThreadState(n2, n, byArray, imageInputStream.getByteOrder()));
                    continue block4;
                }
            }
        }
        return this;
    }

    public static final class OSXAArch64ThreadState
    extends ThreadState {
        public static final int THREAD_STATE_NONE = 5;
        public static final int ARM_THREAD_STATE64 = 6;
        public static final int ARM_EXCEPTION_STATE64 = 7;
        public static final int ARM_NEON_STATE64 = 17;

        public OSXAArch64ThreadState(int n, int n2, byte[] byArray, ByteOrder byteOrder) {
            super(n, n2, byArray, byteOrder);
            switch (n) {
                case 6: {
                    this.fillThreadRegisters();
                    break;
                }
                case 7: {
                    this.fillExceptionData();
                    break;
                }
            }
        }

        @Override
        public void fillThreadRegisters() {
            for (int i = 0; i < 29; ++i) {
                this.registers.put("x" + i, this.readLong(i * 8));
            }
            this.registers.put("fp", this.readLong(232));
            this.registers.put("lr", this.readLong(240));
            this.registers.put("sp", this.readLong(248));
            this.registers.put("pc", this.readLong(256));
            this.registers.put("cpsr", this.readInt(264));
        }

        @Override
        public void fillExceptionData() {
            this.registers.put("faultaddr", this.readLong(0));
            this.registers.put("esr", this.readInt(8));
            this.registers.put("exception", this.readInt(12));
        }
    }

    public static final class OSXAMD64ThreadState
    extends ThreadState {
        public static final int x86_THREAD_STATE32 = 1;
        public static final int x86_FLOAT_STATE32 = 2;
        public static final int x86_EXCEPTION_STATE32 = 3;
        public static final int x86_THREAD_STATE64 = 4;
        public static final int x86_FLOAT_STATE64 = 5;
        public static final int x86_EXCEPTION_STATE64 = 6;
        public static final int x86_THREAD_STATE = 7;
        public static final int x86_FLOAT_STATE = 8;
        public static final int x86_EXCEPTION_STATE = 9;
        public static final int x86_DEBUG_STATE32 = 10;
        public static final int x86_DEBUG_STATE64 = 11;
        public static final int x86_DEBUG_STATE = 12;
        public static final int THREAD_STATE_NONE = 13;
        public static final int x86_AVX_STATE32 = 16;
        public static final int x86_AVX_STATE64 = 17;
        public static final int x86_AVX_STATE = 18;
        public static final int x86_AVX512_STATE32 = 19;
        public static final int x86_AVX512_STATE64 = 20;
        public static final int x86_AVX512_STATE = 21;

        public OSXAMD64ThreadState(int n, int n2, byte[] byArray, ByteOrder byteOrder) {
            super(n, n2, byArray, byteOrder);
            switch (n) {
                case 4: {
                    this.fillThreadRegisters();
                    break;
                }
                case 6: {
                    this.fillExceptionData();
                    break;
                }
            }
        }

        @Override
        public void fillThreadRegisters() {
            this.registers.put("rax", this.readLong(0));
            this.registers.put("rbx", this.readLong(8));
            this.registers.put("rcx", this.readLong(16));
            this.registers.put("rdx", this.readLong(24));
            this.registers.put("rdi", this.readLong(32));
            this.registers.put("rsi", this.readLong(40));
            this.registers.put("rbp", this.readLong(48));
            this.registers.put("rsp", this.readLong(56));
            this.registers.put("r8", this.readLong(64));
            this.registers.put("r9", this.readLong(72));
            this.registers.put("r10", this.readLong(80));
            this.registers.put("r11", this.readLong(88));
            this.registers.put("r12", this.readLong(96));
            this.registers.put("r13", this.readLong(104));
            this.registers.put("r14", this.readLong(112));
            this.registers.put("r15", this.readLong(120));
            this.registers.put("rip", this.readLong(128));
            this.registers.put("rflags", this.readLong(136));
            this.registers.put("cs", this.readLong(144));
            this.registers.put("fs", this.readLong(152));
            this.registers.put("gs", this.readLong(160));
        }

        @Override
        public void fillExceptionData() {
            this.registers.put("trapno", this.readShort(0));
            this.registers.put("cpu", this.readShort(2));
            this.registers.put("err", this.readInt(4));
            this.registers.put("faultvaddr", this.readLong(8));
        }
    }

    public static abstract class ThreadState {
        final int flavor;
        final int sizeInUInts;
        final byte[] stateBytes;
        final ByteOrder endianness;
        final Map<String, Number> registers;

        public ThreadState(int n, int n2, byte[] byArray, ByteOrder byteOrder) {
            this.flavor = n;
            this.sizeInUInts = n2;
            this.stateBytes = byArray;
            this.endianness = byteOrder;
            this.registers = new TreeMap<String, Number>();
        }

        public long readLong(int n) {
            long l = 0xFF00000000000000L & (long)this.stateBytes[n + 7] << 56 | 0xFF000000000000L & (long)this.stateBytes[n + 6] << 48 | 0xFF0000000000L & (long)this.stateBytes[n + 5] << 40 | 0xFF00000000L & (long)this.stateBytes[n + 4] << 32 | 0xFF000000L & (long)this.stateBytes[n + 3] << 24 | 0xFF0000L & (long)this.stateBytes[n + 2] << 16 | 0xFF00L & (long)this.stateBytes[n + 1] << 8 | 0xFFL & (long)this.stateBytes[n + 0];
            return this.endianness == ByteOrder.LITTLE_ENDIAN ? l : Long.reverseBytes(l);
        }

        public int readInt(int n) {
            int n2 = 0xFF000000 & this.stateBytes[n + 3] << 24 | 0xFF0000 & this.stateBytes[n + 2] << 16 | 0xFF00 & this.stateBytes[n + 1] << 8 | 0xFF & this.stateBytes[n + 0];
            return this.endianness == ByteOrder.LITTLE_ENDIAN ? n2 : Integer.reverseBytes(n2);
        }

        public short readShort(int n) {
            short s = (short)(0xFF00 & this.stateBytes[n + 1] << 8 | 0xFF & (short)this.stateBytes[n + 0]);
            return this.endianness == ByteOrder.LITTLE_ENDIAN ? s : Short.reverseBytes(s);
        }

        public abstract void fillThreadRegisters();

        public abstract void fillExceptionData();
    }
}

