/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.elf.ELFDumpReader;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.ProcessAddressSpace;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Properties;

public class LinuxProcessAddressSpace
extends ProcessAddressSpace {
    private final ELFDumpReader reader;

    public LinuxProcessAddressSpace(int n, ByteOrder byteOrder, ELFDumpReader eLFDumpReader) {
        super(n, byteOrder, eLFDumpReader);
        this.reader = eLFDumpReader;
    }

    @Override
    public ICore getCore() {
        return this.reader;
    }

    @Override
    public String getCommandLine() throws CorruptDataException {
        return this.reader.getCommandLine();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof LinuxProcessAddressSpace)) {
            return false;
        }
        LinuxProcessAddressSpace linuxProcessAddressSpace = (LinuxProcessAddressSpace)object;
        return this.reader.equals(linuxProcessAddressSpace.reader);
    }

    public int hashCode() {
        return this.reader.hashCode();
    }

    @Override
    public Properties getEnvironmentVariables() throws CorruptDataException, DataUnavailableException {
        throw new DataUnavailableException("Can't get environment from an ELF core dump");
    }

    @Override
    public IModule getExecutable() throws CorruptDataException {
        return this.reader.getExecutable();
    }

    public List<? extends IModule> getModules() throws CorruptDataException {
        return this.reader.getModules();
    }

    @Override
    public long getProcessId() throws CorruptDataException {
        return this.reader.getProcessId();
    }

    public List<? extends IOSThread> getThreads() throws CorruptDataException {
        return this.reader.getThreads();
    }

    @Override
    public Platform getPlatform() {
        return Platform.LINUX;
    }

    @Override
    public int getSignalNumber() throws DataUnavailableException {
        return this.reader.getSignalNumber();
    }

    public String readStringAt(long l) throws MemoryFault {
        long l2 = l;
        while (this.getByteAt(l2) != 0) {
            ++l2;
        }
        int n = (int)(l2 - l);
        byte[] byArray = new byte[n];
        this.getBytesAt(l, byArray);
        try {
            return new String(byArray, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    IMemorySource getRangeForAddress(long l) {
        return this.memorySources.getRangeForAddress(l);
    }

    @Override
    public boolean isFailingProcess() throws DataUnavailableException {
        throw new DataUnavailableException("Not available on this platform");
    }
}

