/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.HelperBase;
import com.ibm.j9ddr.StructureReader;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;

final class StructureHelper
extends HelperBase {
    private final String className;
    private final ClassWriter clazz;
    private final MethodVisitor clinit;
    private final StructureReader.StructureDescriptor structure;

    static byte[] getClassBytes(StructureReader.StructureDescriptor structureDescriptor, String string) {
        StructureHelper structureHelper = new StructureHelper(structureDescriptor, string);
        return structureHelper.generate();
    }

    private StructureHelper(StructureReader.StructureDescriptor structureDescriptor, String string) {
        this.className = string;
        this.clazz = new ClassWriter(0);
        this.clazz.visit(52, 49, string, null, "java/lang/Object", null);
        this.clinit = this.clazz.visitMethod(8, "<clinit>", voidMethod, null, null);
        this.clinit.visitCode();
        this.structure = structureDescriptor;
    }

    private void defineField(String string, Type type, long l) {
        String string2 = type.getDescriptor();
        this.clazz.visitField(25, string, string2, null, null).visitEnd();
        if (type.getSort() == 5) {
            StructureHelper.loadInt(this.clinit, (int)l);
        } else {
            StructureHelper.loadLong(this.clinit, l);
        }
        this.clinit.visitFieldInsn(179, this.className, string, string2);
    }

    private void defineFields() {
        this.defineField("SIZEOF", Type.LONG_TYPE, this.structure.getSizeOf());
        for (StructureReader.ConstantDescriptor object : this.structure.getConstants()) {
            this.defineField(object.getName(), Type.LONG_TYPE, object.getValue());
        }
        int n = 0;
        for (StructureReader.FieldDescriptor fieldDescriptor : this.structure.getFields()) {
            if (!fieldDescriptor.isPresent()) continue;
            String string = fieldDescriptor.getName();
            int n2 = fieldDescriptor.getOffset();
            String string2 = fieldDescriptor.getType();
            int n3 = string2.lastIndexOf(58);
            if (n3 <= 0 || string2.charAt(n3 - 1) == ':') {
                this.defineField(String.format("_%sOffset_", string), Type.INT_TYPE, n2);
                continue;
            }
            int n4 = Integer.parseInt(string2.substring(n3 + 1).trim());
            if (n4 > 32 - (n = Math.max(n, n2 * 8)) % 32) {
                throw new InternalError(String.format("Bitfield %s->%s must not span cells", this.structure.getName(), string));
            }
            this.defineField(String.format("_%s_s_", string), Type.INT_TYPE, n);
            this.defineField(String.format("_%s_b_", string), Type.INT_TYPE, n4);
            n += n4;
        }
        this.clinit.visitInsn(177);
        this.clinit.visitMaxs(2, 0);
        this.clinit.visitEnd();
    }

    private byte[] generate() {
        this.defineFields();
        MethodVisitor methodVisitor = this.clazz.visitMethod(1, "<init>", voidMethod, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, "java/lang/Object", "<init>", voidMethod, false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        this.clazz.visitEnd();
        return this.clazz.toByteArray();
    }
}

