/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.FlagsHelper;
import com.ibm.j9ddr.PointerHelper;
import com.ibm.j9ddr.StructureHelper;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.StructureTypeManager;
import com.ibm.j9ddr.tools.FlagStructureList;

public class BytecodeGenerator {
    private static final String[] knownNames = new String[]{"AOT", "Arg0EA", "INL", "JIT", "JNI"};

    public static boolean shouldUseCNameFor(String string) {
        return string.equals("J9BuildFlags");
    }

    public static String getFlagCName(String string) {
        switch (string) {
            case "EsVersionMajor": 
            case "EsVersionMajor_DEFINED": 
            case "EsVersionMinor": 
            case "EsVersionMinor_DEFINED": 
            case "JAVA_SPEC_VERSION": 
            case "JAVA_SPEC_VERSION_DEFINED": {
                return string;
            }
        }
        if (string.startsWith("J9VM_")) {
            return string;
        }
        CharSequence charSequence = new StringBuilder("J9VM_");
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        block11: while (n3 < n2) {
            if (n != 0) {
                ((StringBuilder)charSequence).append('_');
                n = 0;
            }
            for (String string2 : knownNames) {
                int n4 = string2.length();
                if (!string.regionMatches(n3, string2, 0, n4)) continue;
                ((StringBuilder)charSequence).append(string2.toUpperCase());
                n = 1;
                n3 += n4;
                continue block11;
            }
            char c = string.charAt(n3);
            ((StringBuilder)charSequence).append(Character.toUpperCase(c));
            if (Character.isUpperCase(c) || ++n3 >= n2 || !Character.isUpperCase(string.charAt(n3))) continue;
            n = 1;
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static byte[] getPointerClassBytes(StructureReader structureReader, StructureTypeManager structureTypeManager, StructureReader.StructureDescriptor structureDescriptor, String string) {
        if (FlagStructureList.isFlagsStructure(structureDescriptor.getName())) {
            return FlagsHelper.getClassBytes(structureDescriptor, string);
        }
        return PointerHelper.getClassBytes(structureReader, structureTypeManager, structureDescriptor, string);
    }

    public static byte[] getStructureClassBytes(StructureReader.StructureDescriptor structureDescriptor, String string) {
        return StructureHelper.getClassBytes(structureDescriptor, string);
    }
}

