/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import sun.security.util.SecurityConstants;

public final class AccessControlContext {
    static final int STATE_NOT_AUTHORIZED = 0;
    static final int STATE_AUTHORIZED = 1;
    static final int STATE_UNKNOWN = 2;
    private static int debugSetting = -1;
    private static ArrayList<String> debugPermClassArray;
    private static ArrayList<String> debugPermNameArray;
    private static ArrayList<String> debugPermActionsArray;
    static ArrayList<URL> debugCodeBaseArray;
    private static final int DEBUG_UNINITIALIZED_HASCODEBASE = 0;
    private static final int DEBUG_NO_CODEBASE = 1;
    private static final int DEBUG_HAS_CODEBASE = 2;
    static final int DEBUG_DISABLED = 0;
    static final int DEBUG_ACCESS_DENIED = 1;
    static final int DEBUG_ENABLED = 2;
    DomainCombiner domainCombiner;
    ProtectionDomain[] context;
    int authorizeState = 2;
    private boolean containPrivilegedContext = false;
    private ProtectionDomain callerPD;
    AccessControlContext doPrivilegedAcc;
    boolean isLimitedContext = false;
    Permission[] limitedPerms;
    AccessControlContext nextStackAcc;
    private int debugHasCodebase;
    static final int DEBUG_ACCESS = 1;
    static final int DEBUG_ACCESS_STACK = 2;
    static final int DEBUG_ACCESS_DOMAIN = 4;
    static final int DEBUG_ACCESS_FAILURE = 8;
    static final int DEBUG_ACCESS_THREAD = 16;
    static final int DEBUG_ALL = 255;

    static int debugSetting() {
        if (debugSetting != -1) {
            return debugSetting;
        }
        debugSetting = 0;
        String string = VM.internalGetProperties().getProperty("java.security.debug");
        if (string == null) {
            return debugSetting;
        }
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(0, 0x10FFFF);
        streamTokenizer.quoteChar(34);
        streamTokenizer.whitespaceChars(44, 44);
        try {
            while (streamTokenizer.nextToken() != -1) {
                String string2;
                String string3 = streamTokenizer.sval;
                if (string3.equals("all")) {
                    debugSetting = 255;
                    return debugSetting;
                }
                if (string3.startsWith("access:")) {
                    debugSetting |= 1;
                    string3 = string3.substring(7);
                }
                if (string3.equals("access")) {
                    debugSetting |= 1;
                    continue;
                }
                if (string3.equals("stack")) {
                    debugSetting |= 2;
                    continue;
                }
                if (string3.equals("domain")) {
                    debugSetting |= 4;
                    continue;
                }
                if (string3.equals("failure")) {
                    debugSetting |= 8;
                    continue;
                }
                if (string3.equals("thread")) {
                    debugSetting |= 0x10;
                    continue;
                }
                if (string3.startsWith("permission=")) {
                    string2 = string3.substring(11);
                    if (string2.isEmpty() && streamTokenizer.nextToken() != -1) {
                        string2 = streamTokenizer.sval;
                    }
                    if (null == debugPermClassArray) {
                        debugPermClassArray = new ArrayList();
                    }
                    debugPermClassArray.add(string2);
                    continue;
                }
                if (string3.startsWith("codebase=")) {
                    string2 = string3.substring(9);
                    if (string2.isEmpty() && streamTokenizer.nextToken() != -1) {
                        string2 = streamTokenizer.sval;
                    }
                    URL uRL = null;
                    try {
                        uRL = new URL(string2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        System.err.println("Error setting -Djava.security.debug=access:codebase - " + malformedURLException);
                    }
                    if (null == uRL) continue;
                    if (null == debugCodeBaseArray) {
                        debugCodeBaseArray = new ArrayList();
                    }
                    debugCodeBaseArray.add(uRL);
                    continue;
                }
                if (string3.startsWith("permname=")) {
                    string2 = string3.substring(9);
                    if (string2.isEmpty() && streamTokenizer.nextToken() != -1) {
                        string2 = streamTokenizer.sval;
                    }
                    if (null == debugPermNameArray) {
                        debugPermNameArray = new ArrayList();
                    }
                    debugPermNameArray.add(string2);
                    continue;
                }
                if (!string3.startsWith("permactions=")) continue;
                string2 = string3.substring(12);
                if (string2.isEmpty() && streamTokenizer.nextToken() != -1) {
                    string2 = streamTokenizer.sval;
                }
                if (null == debugPermActionsArray) {
                    debugPermActionsArray = new ArrayList();
                }
                debugPermActionsArray.add(string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (0 == (debugSetting & 1)) {
            debugSetting = 0;
        }
        return debugSetting;
    }

    static boolean debugPermission(Permission permission) {
        String string;
        boolean bl = true;
        if (debugPermClassArray != null) {
            bl = false;
            string = permission.getClass().getName();
            for (String string2 : debugPermClassArray) {
                if (!string2.equals(string)) continue;
                return true;
            }
        }
        if (debugPermNameArray != null) {
            bl = false;
            string = permission.getName();
            for (String string2 : debugPermNameArray) {
                if (!string2.equals(string)) continue;
                return true;
            }
        }
        if (debugPermActionsArray != null) {
            bl = false;
            string = permission.getActions();
            for (String string2 : debugPermActionsArray) {
                if (!string2.equals(string)) continue;
                return true;
            }
        }
        return bl;
    }

    boolean hasDebugCodeBase() {
        if (this.debugHasCodebase != 0) {
            return this.debugHasCodebase == 2;
        }
        ProtectionDomain[] protectionDomainArray = this.context;
        if (protectionDomainArray != null) {
            for (int i = 0; i < protectionDomainArray.length; ++i) {
                CodeSource codeSource;
                ProtectionDomain protectionDomain = this.context[i];
                CodeSource codeSource2 = codeSource = null == protectionDomain ? null : protectionDomain.getCodeSource();
                if (codeSource == null || !AccessControlContext.debugCodeBase(codeSource.getLocation())) continue;
                this.debugHasCodebase = 2;
                return true;
            }
            if (this.doPrivilegedAcc != null && this.doPrivilegedAcc.hasDebugCodeBase()) {
                this.debugHasCodebase = 2;
                return true;
            }
            if (this.nextStackAcc != null && this.nextStackAcc.hasDebugCodeBase()) {
                this.debugHasCodebase = 2;
                return true;
            }
        }
        this.debugHasCodebase = 1;
        return false;
    }

    static boolean debugCodeBase(URL uRL) {
        if (uRL != null) {
            for (URL uRL2 : debugCodeBaseArray) {
                if (!uRL2.equals(uRL)) continue;
                return true;
            }
        }
        return false;
    }

    static void debugPrintAccess() {
        System.err.print("access: ");
        if ((AccessControlContext.debugSetting() & 0x10) == 16) {
            System.err.print("(" + Thread.currentThread() + ")");
        }
    }

    public AccessControlContext(ProtectionDomain[] protectionDomainArray) {
        int n = protectionDomainArray.length;
        if (n == 0) {
            this.context = null;
        } else {
            int n2 = 0;
            this.context = new ProtectionDomain[n];
            block0: for (int i = 0; i < n; ++i) {
                ProtectionDomain protectionDomain = protectionDomainArray[i];
                if (protectionDomain == null) continue;
                for (int j = 0; j < i; ++j) {
                    if (protectionDomain == this.context[j]) continue block0;
                }
                this.context[n2++] = protectionDomain;
            }
            if (n2 == 0) {
                this.context = null;
            } else if (n2 != n) {
                ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[n2];
                System.arraycopy((Object)this.context, 0, (Object)protectionDomainArray2, 0, n2);
                this.context = protectionDomainArray2;
            }
        }
    }

    AccessControlContext(ProtectionDomain[] protectionDomainArray, int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: 
            case 1: 
        }
        this.context = protectionDomainArray;
        this.authorizeState = n;
        this.containPrivilegedContext = true;
    }

    AccessControlContext(AccessControlContext accessControlContext, ProtectionDomain[] protectionDomainArray, int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException();
            }
            case 1: {
                if (null == accessControlContext) break;
                this.domainCombiner = accessControlContext.domainCombiner;
            }
            case 0: 
        }
        this.doPrivilegedAcc = accessControlContext;
        this.context = protectionDomainArray;
        this.authorizeState = n;
        this.containPrivilegedContext = true;
    }

    public AccessControlContext(AccessControlContext accessControlContext, DomainCombiner domainCombiner) {
        this(accessControlContext, domainCombiner, false);
    }

    AccessControlContext(AccessControlContext accessControlContext, DomainCombiner domainCombiner, boolean bl) {
        SecurityManager securityManager;
        if (!bl && null != (securityManager = System.getSecurityManager())) {
            securityManager.checkPermission(SecurityConstants.CREATE_ACC_PERMISSION);
        }
        this.authorizeState = 1;
        this.context = accessControlContext.context;
        this.domainCombiner = domainCombiner;
        this.containPrivilegedContext = accessControlContext.containPrivilegedContext;
        this.isLimitedContext = accessControlContext.isLimitedContext;
        this.limitedPerms = accessControlContext.limitedPerms;
        this.nextStackAcc = accessControlContext.nextStackAcc;
        this.doPrivilegedAcc = accessControlContext.doPrivilegedAcc;
    }

    private static Object[] combineObjs(boolean bl, Object[] objectArray, Object[] objectArray2, int n, int n2, boolean bl2) {
        if (null == objectArray2) {
            return objectArray;
        }
        int n3 = Math.min(n2, objectArray2.length - n);
        if (0 == n3) {
            return objectArray;
        }
        int n4 = null == objectArray ? 0 : objectArray.length;
        Object[] objectArray3 = bl ? new ProtectionDomain[n4 + n3] : new Permission[n4 + n3];
        if (0 != n4) {
            System.arraycopy((Object)objectArray, 0, (Object)objectArray3, 0, n4);
        }
        if (bl2) {
            System.arraycopy((Object)objectArray2, n, (Object)objectArray3, n4, n3);
        } else {
            int n5 = n4;
            block0: for (int i = 0; i < n3; ++i) {
                Object object = objectArray2[n + i];
                if (null == object) continue;
                int n6 = n5;
                do {
                    if (--n6 >= 0) continue;
                    objectArray3[n5] = object;
                    ++n5;
                    continue block0;
                } while (object != objectArray3[n6]);
            }
            if (n5 < objectArray3.length) {
                Object[] objectArray4 = bl ? new ProtectionDomain[n5] : new Permission[n5];
                System.arraycopy((Object)objectArray3, 0, (Object)objectArray4, 0, n5);
                objectArray3 = objectArray4;
            }
        }
        return objectArray3;
    }

    static ProtectionDomain[] combinePDObjs(ProtectionDomain[] protectionDomainArray, Object[] objectArray) {
        return (ProtectionDomain[])AccessControlContext.combineObjs(true, protectionDomainArray, objectArray, 0, null != objectArray ? objectArray.length : 0, false);
    }

    static Permission[] combinePermObjs(Permission[] permissionArray, Permission[] permissionArray2, int n, int n2, boolean bl) {
        return (Permission[])AccessControlContext.combineObjs(false, permissionArray, permissionArray2, n, n2, bl);
    }

    static int checkPermWithCachedPDsImplied(Permission permission, Object[] objectArray, AccessCache accessCache) {
        if (null == objectArray) {
            return -1;
        }
        ProtectionDomain[] protectionDomainArray = null == accessCache ? null : accessCache.pdsImplied;
        int n = objectArray.length;
        block0: while (n > 0) {
            Object object;
            if (null == (object = objectArray[--n])) continue;
            if (null != protectionDomainArray) {
                for (int i = 0; i < protectionDomainArray.length; ++i) {
                    if (object == protectionDomainArray[i]) continue block0;
                }
            }
            if (((ProtectionDomain)object).implies(permission)) continue;
            return n;
        }
        if (null != accessCache) {
            accessCache.pdsImplied = AccessControlContext.combinePDObjs(protectionDomainArray, objectArray);
        }
        return -1;
    }

    static boolean checkPermWithCachedPermImplied(Permission permission, Permission[] permissionArray, AccessCache accessCache) {
        if (null == permissionArray) {
            return false;
        }
        Permission[] permissionArray2 = null;
        Permission[] permissionArray3 = null;
        if (null != accessCache) {
            permissionArray2 = accessCache.permsImplied;
            permissionArray3 = accessCache.permsNotImplied;
        }
        boolean bl = false;
        int n = permissionArray.length;
        for (int i = 0; i < permissionArray.length; ++i) {
            int n2;
            if (null == permissionArray[i]) continue;
            if (null != permissionArray2) {
                for (n2 = 0; n2 < permissionArray2.length; ++n2) {
                    if (permissionArray[i] != permissionArray2[n2]) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    n = i;
                    break;
                }
            }
            n2 = 0;
            if (null != permissionArray3) {
                for (int j = 0; j < permissionArray3.length; ++j) {
                    if (permissionArray[i] != permissionArray3[j]) continue;
                    n2 = 1;
                    n = i;
                    break;
                }
            }
            if (n2 != 0 || !permissionArray[i].implies(permission)) continue;
            bl = true;
            if (null != accessCache) {
                accessCache.permsImplied = AccessControlContext.combinePermObjs(permissionArray2, permissionArray, i, 1, true);
            }
            n = i;
            break;
        }
        if (0 < n && null != accessCache) {
            accessCache.permsNotImplied = AccessControlContext.combinePermObjs(permissionArray3, permissionArray, 0, n, false);
        }
        return bl;
    }

    static boolean checkPermissionWithCache(Permission permission, DomainCombiner domainCombiner, Object[] objectArray, int n, AccessControlContext accessControlContext, boolean bl, Permission[] permissionArray, AccessControlContext accessControlContext2, AccessCache accessCache) throws AccessControlException {
        int n2;
        if ((n & 2) != 0 && (AccessControlContext.debugSetting() & 4) != 0) {
            AccessControlContext.debugPrintAccess();
            if (objectArray == null || objectArray.length == 0) {
                System.err.println("domain (context is null)");
            } else {
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    System.err.println("domain " + n2 + " " + objectArray[n2]);
                }
            }
        }
        if (null != objectArray && 0 <= (n2 = AccessControlContext.checkPermWithCachedPDsImplied(permission, objectArray, accessCache))) {
            if ((n & 1) != 0) {
                if ((AccessControlContext.debugSetting() & 1) != 0) {
                    AccessControlContext.debugPrintAccess();
                    System.err.println("access denied " + permission);
                }
                if ((AccessControlContext.debugSetting() & 8) != 0) {
                    new Exception("Stack trace").printStackTrace();
                    System.err.println("domain that failed " + objectArray[n2]);
                }
            }
            throw new AccessControlException(Msg.getString("K002c", permission), permission);
        }
        if (null != accessControlContext && (null != accessControlContext.context || null != accessControlContext.doPrivilegedAcc || null != accessControlContext.limitedPerms || null != accessControlContext.nextStackAcc)) {
            Object[] objectArray2 = domainCombiner == null ? accessControlContext.context : domainCombiner.combine((ProtectionDomain[])objectArray, accessControlContext.context);
            AccessControlContext.checkPermissionWithCache(permission, domainCombiner, objectArray2, n, accessControlContext.doPrivilegedAcc, accessControlContext.isLimitedContext, accessControlContext.limitedPerms, accessControlContext.nextStackAcc, accessCache);
        }
        if (bl && null != permissionArray) {
            if (AccessControlContext.checkPermWithCachedPermImplied(permission, permissionArray, accessCache)) {
                return true;
            }
            if (null != accessControlContext2) {
                Object[] objectArray3 = domainCombiner == null ? accessControlContext2.context : domainCombiner.combine((ProtectionDomain[])objectArray, accessControlContext2.context);
                AccessControlContext.checkPermissionWithCache(permission, domainCombiner, objectArray3, n, accessControlContext2.doPrivilegedAcc, accessControlContext2.isLimitedContext, accessControlContext2.limitedPerms, accessControlContext2.nextStackAcc, accessCache);
            }
            return false;
        }
        if ((n & 2) != 0) {
            AccessControlContext.debugPrintAccess();
            System.err.println("access allowed " + permission);
        }
        return true;
    }

    private boolean debugHelper(Permission permission) {
        boolean bl = true;
        if (debugCodeBaseArray != null) {
            bl = this.hasDebugCodeBase();
        }
        if (bl) {
            bl = AccessControlContext.debugPermission(permission);
        }
        if (bl && (AccessControlContext.debugSetting() & 2) != 0) {
            new Exception("Stack trace for " + permission).printStackTrace();
        }
        return bl;
    }

    public void checkPermission(Permission permission) throws AccessControlException {
        boolean bl;
        if (permission == null) {
            throw new NullPointerException();
        }
        if (null != this.context && 1 != this.authorizeState && this.containPrivilegedContext && null != System.getSecurityManager()) {
            if (2 == this.authorizeState) {
                this.authorizeState = null == this.callerPD || this.callerPD.implies(SecurityConstants.CREATE_ACC_PERMISSION) ? 1 : 0;
                this.callerPD = null;
            }
            if (0 == this.authorizeState) {
                throw new AccessControlException(Msg.getString("K002d", permission, SecurityConstants.CREATE_ACC_PERMISSION), permission);
            }
        }
        boolean bl2 = bl = (AccessControlContext.debugSetting() & 1) != 0;
        if (bl) {
            bl = this.debugHelper(permission);
        }
        AccessControlContext.checkPermissionWithCache(permission, null, this.context, bl ? 3 : 0, this.doPrivilegedAcc, this.isLimitedContext, this.limitedPerms, this.nextStackAcc, new AccessCache());
    }

    private static boolean equalSets(Object[] objectArray, Object[] objectArray2) {
        int n;
        if (objectArray == null || (n = objectArray.length) == 0) {
            return objectArray2 == null || objectArray2.length == 0;
        }
        if (objectArray2 == null || n != objectArray2.length) {
            return false;
        }
        block0: for (int i = 0; i < n; ++i) {
            int n2;
            Object object = objectArray[i];
            if (object == null) {
                for (n2 = 0; n2 < n; ++n2) {
                    if (objectArray2[n2] == null) continue block0;
                }
            } else {
                for (n2 = 0; n2 < n; ++n2) {
                    if (object.equals(objectArray2[n2])) continue block0;
                }
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AccessControlContext accessControlContext = (AccessControlContext)object;
        if (null != this.domainCombiner ? !this.domainCombiner.equals(accessControlContext.domainCombiner) : null != accessControlContext.domainCombiner) {
            return false;
        }
        if (this.isLimitedContext != accessControlContext.isLimitedContext) {
            return false;
        }
        if (!AccessControlContext.equalSets(this.context, accessControlContext.context)) {
            return false;
        }
        if (null != this.doPrivilegedAcc && !this.doPrivilegedAcc.equals(accessControlContext.doPrivilegedAcc)) {
            return false;
        }
        if (this.isLimitedContext) {
            if (!AccessControlContext.equalSets(this.limitedPerms, accessControlContext.limitedPerms)) {
                return false;
            }
            if (null != this.nextStackAcc) {
                return this.nextStackAcc.equals(accessControlContext.nextStackAcc);
            }
        }
        return true;
    }

    public int hashCode() {
        int n;
        int n2 = 0;
        int n3 = n = this.context == null ? 0 : this.context.length;
        while (--n >= 0 && this.context[n] != null) {
            n2 ^= this.context[n].hashCode();
        }
        if (null != this.doPrivilegedAcc) {
            n2 ^= this.doPrivilegedAcc.hashCode();
        }
        if (this.isLimitedContext) {
            int n4 = n = this.limitedPerms == null ? 0 : this.limitedPerms.length;
            while (--n >= 0) {
                if (null == this.limitedPerms[n]) continue;
                n2 ^= this.limitedPerms[n].hashCode();
            }
            if (null != this.nextStackAcc) {
                n2 ^= this.nextStackAcc.hashCode();
            }
        }
        return n2;
    }

    public DomainCombiner getDomainCombiner() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.GET_COMBINER_PERMISSION);
        }
        return this.domainCombiner;
    }

    DomainCombiner getCombiner() {
        return this.domainCombiner;
    }

    ProtectionDomain[] getContext() {
        return this.context;
    }

    AccessControlContext(ProtectionDomain[] protectionDomainArray, AccessControlContext accessControlContext) {
        this.context = AccessController.toArrayOfProtectionDomains(protectionDomainArray, accessControlContext, 0);
        this.authorizeState = 1;
        this.containPrivilegedContext = true;
        if (null != accessControlContext && 1 == accessControlContext.authorizeState) {
            this.domainCombiner = accessControlContext.domainCombiner;
        }
    }

    AccessControlContext optimize() {
        return this;
    }

    static final class AccessCache {
        ProtectionDomain[] pdsImplied;
        Permission[] permsImplied;
        Permission[] permsNotImplied;

        AccessCache() {
        }
    }
}

