/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import com.ibm.oti.util.Msg;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.JavaLangRefAccess;
import sun.misc.SharedSecrets;

public abstract class Reference<T> {
    private static final int STATE_INITIAL = 0;
    private static final int STATE_CLEARED = 1;
    private static final int STATE_ENQUEUED = 2;
    private T referent;
    private ReferenceQueue queue;
    private int state;

    private static native boolean waitForReferenceProcessingImpl();

    public void clear() {
        this.clearImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearImpl() {
        Reference reference = this;
        synchronized (reference) {
            this.referent = null;
            if (0 == this.state) {
                this.state = 1;
            }
        }
    }

    public boolean enqueue() {
        if (ClearBeforeEnqueue.ENABLED) {
            this.clearImpl();
        }
        return this.enqueueImpl();
    }

    public T get() {
        return this.getImpl();
    }

    private native T getImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnqueued() {
        Reference reference = this;
        synchronized (reference) {
            return this.state == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enqueueImpl() {
        T t = this.referent;
        Reference reference = this;
        synchronized (reference) {
            ReferenceQueue referenceQueue = this.queue;
            this.queue = null;
            if (this.state == 2 || referenceQueue == null) {
                return false;
            }
            boolean bl = referenceQueue.enqueue(this);
            if (bl) {
                this.state = 2;
                if (null != t) {
                    this.reprocess();
                }
            }
            return bl;
        }
    }

    private native void reprocess();

    Reference() {
    }

    void initReference(T t) {
        this.state = 0;
        this.referent = t;
    }

    void initReference(T t, ReferenceQueue referenceQueue) {
        this.queue = referenceQueue;
        this.state = 0;
        this.referent = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dequeue() {
        Reference reference = this;
        synchronized (reference) {
            this.state = 1;
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException(Msg.getString("K0900"));
    }

    static {
        SharedSecrets.setJavaLangRefAccess(new JavaLangRefAccess(){

            @Override
            public boolean tryHandlePendingReference() {
                return Reference.waitForReferenceProcessingImpl();
            }
        });
    }

    static class ClearBeforeEnqueue {
        static final boolean ENABLED = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return !Boolean.getBoolean("jdk.lang.ref.disableClearBeforeEnqueue");
            }
        });

        ClearBeforeEnqueue() {
        }
    }
}

