/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.Util;
import java.io.Serializable;

public final class StackTraceElement
implements Serializable {
    private static final long serialVersionUID = 6992337162326171013L;
    private final String declaringClass;
    private final String methodName;
    private final String fileName;
    private final int lineNumber;
    transient Object source;

    public StackTraceElement(String string, String string2, String string3, int n) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        this.declaringClass = string;
        this.methodName = string2;
        this.fileName = string3;
        this.lineNumber = n;
    }

    private StackTraceElement() {
        this.declaringClass = null;
        this.methodName = null;
        this.fileName = null;
        this.lineNumber = 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof StackTraceElement)) {
            return false;
        }
        StackTraceElement stackTraceElement = (StackTraceElement)object;
        if (this.methodName == null || stackTraceElement.methodName == null) {
            return false;
        }
        if (!this.getMethodName().equals(stackTraceElement.getMethodName())) {
            return false;
        }
        if (!this.getClassName().equals(stackTraceElement.getClassName())) {
            return false;
        }
        String string = this.getFileName();
        if (string == null ? stackTraceElement.getFileName() != null : !string.equals(stackTraceElement.getFileName())) {
            return false;
        }
        return this.getLineNumber() == stackTraceElement.getLineNumber();
    }

    public String getClassName() {
        return this.declaringClass == null ? "<unknown class>" : this.declaringClass;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMethodName() {
        return this.methodName == null ? "<unknown method>" : this.methodName;
    }

    public int hashCode() {
        if (this.methodName == null) {
            return 0;
        }
        int n = this.methodName.hashCode() ^ this.declaringClass.hashCode();
        return n;
    }

    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        boolean bl = false;
        Util.printStackTraceElement(this, this.source, stringBuilder, bl);
        return stringBuilder.toString();
    }
}

