/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedClassPermission;
import java.security.AccessControlException;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class SharedAbstractHelperFactory {
    private static final AtomicInteger idCount = new AtomicInteger(1);

    static boolean checkPermission(ClassLoader classLoader, String string) {
        boolean bl = true;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new SharedClassPermission(classLoader, string));
            }
            catch (AccessControlException accessControlException) {
                bl = false;
            }
        }
        return bl;
    }

    static boolean canFind(ClassLoader classLoader) {
        return SharedAbstractHelperFactory.checkPermission(classLoader, "read");
    }

    static boolean canStore(ClassLoader classLoader) {
        return SharedAbstractHelperFactory.checkPermission(classLoader, "write");
    }

    static int getNewID() {
        return idCount.getAndIncrement();
    }
}

